/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.scene.Cursor;
import javafx.scene.control.ScrollPane;
import javafx.scene.effect.Light;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import org.jpedal.PdfDecoderFX;
import org.jpedal.display.Display;
import org.jpedal.display.DisplayOffsets;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.javafx.JavaFXPageNavigator;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.JavaFxGUI;
import org.jpedal.examples.viewer.gui.MouseSelector;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMouseFunctionality;
import org.jpedal.external.AnnotationHandler;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class JavaFXMousePageTurn
extends MouseSelector
implements JavaFXMouseFunctionality {
    private final PdfDecoderFX decode_pdf;
    private final GUIFactory currentGUI;
    private final Values commonValues;
    private final Commands currentCommands;
    private long lastPress;
    private boolean drawingTurnover;
    private boolean previewTurnover;
    private double middleDragStartX;
    private double middleDragStartY;
    private double xVelocity;
    private double yVelocity;
    private Timer middleDragTimer;
    long timeOfLastPageChange;
    final DisplayOffsets offsets;

    public JavaFXMousePageTurn(PdfDecoderFX decode_pdf, GUIFactory currentGUI, Values commonValues, Commands currentCommands) {
        this.decode_pdf = decode_pdf;
        this.currentGUI = currentGUI;
        this.commonValues = commonValues;
        this.currentCommands = currentCommands;
        this.offsets = (DisplayOffsets)decode_pdf.getExternalHandler(37);
    }

    public void checkLinks(boolean mouseClicked, PdfObjectReader pdfObjectReader, double x, double y) {
        Map objs = this.currentGUI.getHotspots();
        if (objs != null) {
            ((AnnotationHandler)this.decode_pdf.getExternalHandler(25)).checkLinks(objs, mouseClicked, pdfObjectReader, (int)x, (int)y, this.currentGUI, this.commonValues);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.decode_pdf.getDisplayView() == 1 && e.getButton().equals((Object)MouseButton.PRIMARY) && this.decode_pdf.getExternalHandler(25) != null) {
            double mouseX = e.getX();
            double mouseY = e.getY();
            int[] pos = JavaFXMousePageTurn.updateXY((int)mouseX, (int)mouseY, this.decode_pdf, this.commonValues);
            this.checkLinks(true, this.decode_pdf.getIO(), pos[0], pos[1]);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.previewTurnover && this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4 && e.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.drawingTurnover = true;
            this.decode_pdf.setCursor(Cursor.CLOSED_HAND);
            this.lastPress = System.currentTimeMillis();
        }
        if (e.getButton().equals((Object)MouseButton.SECONDARY)) {
            this.middleDragStartX = e.getX() - this.decode_pdf.getLayoutX();
            this.middleDragStartY = e.getY() - this.decode_pdf.getLayoutY();
            this.decode_pdf.setCursor(Cursor.MOVE);
            if (this.middleDragTimer == null) {
                this.middleDragTimer = new Timer();
            }
            this.middleDragTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (JavaFXMousePageTurn.this.xVelocity < -2.0) {
                                if (JavaFXMousePageTurn.this.yVelocity < -2.0) {
                                    JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.NW_RESIZE);
                                } else if (JavaFXMousePageTurn.this.yVelocity > 2.0) {
                                    JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.SW_RESIZE);
                                } else {
                                    JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.E_RESIZE);
                                }
                            } else if (JavaFXMousePageTurn.this.xVelocity > 2.0) {
                                if (JavaFXMousePageTurn.this.yVelocity < -2.0) {
                                    JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.NE_RESIZE);
                                } else if (JavaFXMousePageTurn.this.yVelocity > 2.0) {
                                    JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.SE_RESIZE);
                                } else {
                                    JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.E_RESIZE);
                                }
                            } else if (JavaFXMousePageTurn.this.yVelocity < -2.0) {
                                JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.N_RESIZE);
                            } else if (JavaFXMousePageTurn.this.yVelocity > 2.0) {
                                JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.S_RESIZE);
                            } else {
                                JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.MOVE);
                            }
                        }
                    });
                }
            }, 100L);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
            this.drawingTurnover = false;
            boolean dragLeft = this.offsets.getDragLeft();
            boolean dragTop = this.offsets.getDragTop();
            if (this.lastPress + 200L > System.currentTimeMillis()) {
                if (dragLeft) {
                    this.currentCommands.executeCommand(52, null);
                } else {
                    this.currentCommands.executeCommand(53, null);
                }
                this.previewTurnover = false;
                this.decode_pdf.setCursor(Cursor.DEFAULT);
            } else {
                Light.Point corner = new Light.Point();
                corner.setY((double)this.decode_pdf.getInsetH());
                if (!dragTop) {
                    corner.setY(corner.getY() + (double)((float)this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * this.decode_pdf.getScaling()));
                }
                if (dragLeft) {
                    corner.setX(this.decode_pdf.getBoundsInLocal().getWidth() / 2.0 - (double)((float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling()));
                } else {
                    corner.setX(this.decode_pdf.getBoundsInLocal().getWidth() / 2.0 + (double)((float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling()));
                }
                Light.Point cursorPoint = new Light.Point();
                cursorPoint.setX(e.getX());
                cursorPoint.setY(e.getY());
                this.testFall(corner, cursorPoint, dragLeft);
            }
        }
        if (e.getButton().equals((Object)MouseButton.SECONDARY)) {
            this.xVelocity = 0.0;
            this.yVelocity = 0.0;
            this.decode_pdf.setCursor(Cursor.DEFAULT);
            this.middleDragTimer.cancel();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getButton().equals((Object)MouseButton.PRIMARY)) {
            if (this.decode_pdf.getExternalHandler(25) != null) {
                int[] pos = JavaFXMousePageTurn.updateXY((int)e.getX(), (int)e.getY(), this.decode_pdf, this.commonValues);
                this.checkLinks(true, this.decode_pdf.getIO(), pos[0], pos[1]);
            }
            if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && (this.drawingTurnover || this.previewTurnover) && this.decode_pdf.getDisplayView() == 4) {
                this.decode_pdf.setCursor(Cursor.CLOSED_HAND);
                if (this.offsets.getDragLeft()) {
                    if (this.offsets.getDragTop()) {
                        this.decode_pdf.setUserOffsets((int)e.getX(), (int)e.getY(), 996);
                    } else {
                        this.decode_pdf.setUserOffsets((int)e.getX(), (int)e.getY(), 998);
                    }
                } else if (this.offsets.getDragTop()) {
                    this.decode_pdf.setUserOffsets((int)e.getX(), (int)e.getY(), 997);
                } else {
                    this.decode_pdf.setUserOffsets((int)e.getX(), (int)e.getY(), 999);
                }
            }
        } else if (e.getButton().equals((Object)MouseButton.MIDDLE)) {
            this.xVelocity = (e.getX() - this.decode_pdf.getLayoutX() - this.middleDragStartX) / 4.0;
            this.yVelocity = (e.getY() - this.decode_pdf.getLayoutY() - this.middleDragStartY) / 4.0;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.decode_pdf.getDisplayView() == 4 && this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && ((JavaFxGUI)this.decode_pdf.getExternalHandler(11)).getPageTurnScalingAppropriate() && !this.decode_pdf.getPdfPageData().hasMultipleSizes() && !JavaFXPageNavigator.getPageTurnAnimating()) {
            Light.Point cursor;
            float pageH = (float)this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * this.decode_pdf.getScaling() - 1.0f;
            float pageW = (float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling() - 1.0f;
            if ((this.decode_pdf.getPdfPageData().getRotation(1) + this.currentGUI.getRotation()) % 180 == 90) {
                float temp = pageH;
                pageH = pageW + 1.0f;
                pageW = temp;
            }
            Light.Point corner = new Light.Point();
            if (this.commonValues.getCurrentPage() + 1 < this.commonValues.getPageCount()) {
                corner.setX(this.decode_pdf.getBoundsInLocal().getWidth() / 2.0 + (double)pageW);
                corner.setY((double)((float)this.decode_pdf.getInsetH() + pageH));
                cursor = new Light.Point();
                cursor.setX(e.getX());
                cursor.setY(e.getY());
                if (cursor.getX() > corner.getX() - 30.0 && cursor.getX() <= corner.getX() && cursor.getY() > corner.getY() - 30.0 && cursor.getY() <= corner.getY() || cursor.getY() >= corner.getY() - (double)pageH && cursor.getY() < corner.getY() - (double)pageH + 30.0) {
                    this.decode_pdf.setCursor(Cursor.OPEN_HAND);
                    this.previewTurnover = true;
                    if (cursor.getY() >= corner.getY() - (double)pageH && cursor.getY() < corner.getY() - (double)pageH + 30.0) {
                        corner.setY(corner.getY() - (double)pageH);
                        this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 997);
                    } else {
                        this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 999);
                    }
                } else {
                    if (this.offsets.getDragTop()) {
                        corner.setY(corner.getY() - (double)pageH);
                    }
                    this.testFall(corner, cursor, false);
                }
            }
            if (this.commonValues.getCurrentPage() != 1) {
                corner.setX(this.decode_pdf.getBoundsInLocal().getWidth() / 2.0 - (double)pageW);
                corner.setY((double)((float)this.decode_pdf.getInsetH() + pageH));
                cursor = new Light.Point();
                cursor.setX(e.getX());
                cursor.setY(e.getY());
                if (cursor.getX() < corner.getX() + 30.0 && cursor.getX() >= corner.getX() && (cursor.getY() > corner.getY() - 30.0 && cursor.getY() <= corner.getY() || cursor.getY() >= corner.getY() - (double)pageH && cursor.getY() < corner.getY() - (double)pageH + 30.0)) {
                    this.decode_pdf.setCursor(Cursor.OPEN_HAND);
                    this.previewTurnover = true;
                    if (cursor.getY() >= corner.getY() - (double)pageH && cursor.getY() < corner.getY() - (double)pageH + 30.0) {
                        corner.setX(corner.getY() - (double)pageH);
                        this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 996);
                    } else {
                        this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 998);
                    }
                } else {
                    if (this.offsets.getDragTop()) {
                        corner.setY(corner.getY() - (double)pageH);
                    }
                    this.testFall(corner, cursor, true);
                }
            }
        }
        if (this.decode_pdf.getExternalHandler(25) != null) {
            int[] pos = JavaFXMousePageTurn.updateXY((int)e.getX(), (int)e.getY(), this.decode_pdf, this.commonValues);
            this.checkLinks(false, this.decode_pdf.getIO(), pos[0], pos[1]);
        }
    }

    public void mouseWheelMoved(ScrollEvent e) {
        if (this.decode_pdf.getDisplayView() == 5) {
            return;
        }
        if (this.currentGUI.getProperties().getValue("allowScrollwheelZoom").equalsIgnoreCase("true") && e.isControlDown()) {
            int scaling;
            block17: {
                scaling = ((GUI)this.currentGUI).getSelectedComboIndex(252);
                if (scaling != -1) {
                    scaling = (int)this.decode_pdf.getDPIFactory().removeScaling(this.decode_pdf.getScaling() * 100.0f);
                } else {
                    String numberValue = ((GUI)this.currentGUI).getSelectedComboItem(252).toString();
                    try {
                        scaling = (int)Float.parseFloat(numberValue);
                    }
                    catch (Exception ex) {
                        char c;
                        int ii;
                        LogWriter.writeLog("Exception in handling scaling " + ex);
                        scaling = -1;
                        int length = numberValue.length();
                        for (ii = 0; ii < length && ((c = numberValue.charAt(ii)) >= '0' && c <= '9') | c == '.'; ++ii) {
                        }
                        if (ii > 0) {
                            numberValue = numberValue.substring(0, ii);
                        }
                        if (scaling != -1) break block17;
                        try {
                            scaling = (int)Float.parseFloat(numberValue);
                        }
                        catch (Exception e1) {
                            LogWriter.writeLog("Exception in handling scaling " + e1);
                            scaling = -1;
                        }
                    }
                }
            }
            float value = e.getTouchCount();
            if ((scaling != 1 || value < 0.0f) && !((float)scaling + (value = value < 0.0f ? 1.25f : 0.8f) < 0.0f)) {
                float currentScaling = (float)scaling * value;
                currentScaling = (int)currentScaling == scaling ? (float)(scaling + 1) : (float)((int)currentScaling);
                if (currentScaling < 1.0f) {
                    currentScaling = 1.0f;
                }
                if (currentScaling > 1000.0f) {
                    currentScaling = 1000.0f;
                }
                this.currentGUI.snapScalingToDefaults(currentScaling);
            }
        } else {
            final ScrollPane scroll = (ScrollPane)this.decode_pdf.getParent();
            if ((scroll.getVvalue() == scroll.getVmax() - scroll.getHeight() || scroll.getHeight() == 0.0) && this.timeOfLastPageChange + 700L < System.currentTimeMillis() && this.currentGUI.getValues().getCurrentPage() < this.decode_pdf.getPageCount()) {
                this.timeOfLastPageChange = System.currentTimeMillis();
                this.currentCommands.executeCommand(53, null);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        scroll.setVvalue(scroll.getVmin());
                    }
                });
            } else if (scroll.getVvalue() == scroll.getVmin() && this.timeOfLastPageChange + 700L < System.currentTimeMillis() && this.currentGUI.getValues().getCurrentPage() > 1) {
                this.timeOfLastPageChange = System.currentTimeMillis();
                this.currentCommands.executeCommand(52, null);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        scroll.setVvalue(scroll.getVmax());
                    }
                });
            }
        }
    }

    private void testFall(final Light.Point corner, final Light.Point cursor, boolean testLeft) {
        if (!this.previewTurnover) {
            return;
        }
        float width = (float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling() - 1.0f;
        if ((this.decode_pdf.getPdfPageData().getRotation(1) + this.currentGUI.getRotation()) % 180 == 90) {
            width = (float)this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * this.decode_pdf.getScaling();
        }
        final float pageW = width;
        if (!testLeft) {
            if (!this.offsets.getDragLeft()) {
                this.decode_pdf.setCursor(Cursor.DEFAULT);
                Thread animation = new Thread(){

                    @Override
                    public void run() {
                        corner.setX(JavaFXMousePageTurn.this.decode_pdf.getBoundsInLocal().getWidth() / 2.0 + (double)pageW);
                        boolean fallBack = true;
                        if (cursor.getX() < corner.getX() - (double)pageW) {
                            corner.setX(corner.getX() - (double)(2.0f * pageW));
                            fallBack = false;
                        }
                        int velocity = 1;
                        if (fallBack && cursor.getX() >= corner.getX()) {
                            cursor.setX(corner.getX() - 1.0);
                        }
                        if (!fallBack && cursor.getX() <= corner.getX()) {
                            cursor.setX(corner.getX() + 1.0);
                        }
                        if (!JavaFXMousePageTurn.this.offsets.getDragTop() && cursor.getY() >= corner.getY()) {
                            cursor.setY(corner.getY() - 1.0);
                        }
                        if (JavaFXMousePageTurn.this.offsets.getDragTop() && cursor.getY() <= corner.getY()) {
                            cursor.setY(corner.getY() + 1.0);
                        }
                        double distX = corner.getX() - cursor.getX();
                        double distY = corner.getY() - cursor.getY();
                        while (fallBack && cursor.getX() <= corner.getX() || !fallBack && cursor.getX() >= corner.getX() || !JavaFXMousePageTurn.this.offsets.getDragTop() && cursor.getY() <= corner.getY() || JavaFXMousePageTurn.this.offsets.getDragTop() && cursor.getY() >= corner.getY()) {
                            double xMove = (double)velocity * distX * 0.002;
                            double yMove = (double)velocity * distY * 0.002;
                            if (Math.abs(xMove) < 1.0) {
                                xMove /= Math.abs(xMove);
                            }
                            if (Math.abs(yMove) < 1.0) {
                                yMove /= Math.abs(yMove);
                            }
                            cursor.setX(cursor.getX() + xMove);
                            cursor.setY(cursor.getY() + yMove);
                            if (JavaFXMousePageTurn.this.offsets.getDragTop()) {
                                JavaFXMousePageTurn.this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 997);
                            } else {
                                JavaFXMousePageTurn.this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 999);
                            }
                            if (velocity < 32) {
                                velocity *= 2;
                            }
                            try {
                                Thread.sleep(50L);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (!fallBack) {
                            int forwardPage = JavaFXMousePageTurn.this.commonValues.getCurrentPage() + 1;
                            if (JavaFXMousePageTurn.this.decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) && forwardPage % 2 == 1) {
                                ++forwardPage;
                            } else if (!JavaFXMousePageTurn.this.decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) && forwardPage % 2 == 0) {
                                ++forwardPage;
                            }
                            JavaFXMousePageTurn.this.commonValues.setCurrentPage(forwardPage);
                            JavaFXMousePageTurn.this.currentGUI.setPageNumber();
                            JavaFXMousePageTurn.this.decode_pdf.setPageParameters(JavaFXMousePageTurn.this.currentGUI.getScaling(), JavaFXMousePageTurn.this.commonValues.getCurrentPage());
                            JavaFXMousePageTurn.this.currentGUI.decodePage();
                        }
                        JavaFXMousePageTurn.this.decode_pdf.setUserOffsets(0, 0, 995);
                        JavaFXPageNavigator.setPageTurnAnimating(false, JavaFXMousePageTurn.this.currentGUI);
                    }
                };
                animation.setDaemon(true);
                JavaFXPageNavigator.setPageTurnAnimating(true, this.currentGUI);
                animation.start();
                this.previewTurnover = false;
            }
        } else if (this.previewTurnover && this.offsets.getDragLeft()) {
            this.decode_pdf.setCursor(Cursor.DEFAULT);
            Thread animation = new Thread(){

                @Override
                public void run() {
                    corner.setX(JavaFXMousePageTurn.this.decode_pdf.getBoundsInLocal().getWidth() / 2.0 - (double)pageW);
                    boolean fallBack = true;
                    if (cursor.getX() > corner.getX() + (double)pageW) {
                        corner.setX(corner.getX() + (double)(2.0f * pageW));
                        fallBack = false;
                    }
                    int velocity = 1;
                    if (!fallBack && cursor.getX() >= corner.getX()) {
                        cursor.setX(corner.getX() - 1.0);
                    }
                    if (fallBack && cursor.getX() <= corner.getX()) {
                        cursor.setX(corner.getX() + 1.0);
                    }
                    if (!JavaFXMousePageTurn.this.offsets.getDragTop() && cursor.getY() >= corner.getY()) {
                        cursor.setY(corner.getY() - 1.0);
                    }
                    if (JavaFXMousePageTurn.this.offsets.getDragTop() && cursor.getY() <= corner.getY()) {
                        cursor.setY(corner.getY() + 1.0);
                    }
                    double distX = corner.getX() - cursor.getX();
                    double distY = corner.getY() - cursor.getY();
                    while (!fallBack && cursor.getX() <= corner.getX() || fallBack && cursor.getX() >= corner.getX() || !JavaFXMousePageTurn.this.offsets.getDragTop() && cursor.getY() <= corner.getY() || JavaFXMousePageTurn.this.offsets.getDragTop() && cursor.getY() >= corner.getY()) {
                        double xMove = (double)velocity * distX * 0.002;
                        double yMove = (double)velocity * distY * 0.002;
                        if (Math.abs(xMove) < 1.0) {
                            xMove /= Math.abs(xMove);
                        }
                        if (Math.abs(yMove) < 1.0) {
                            yMove /= Math.abs(yMove);
                        }
                        cursor.setX(cursor.getX() + xMove);
                        cursor.setY(cursor.getY() + yMove);
                        if (JavaFXMousePageTurn.this.offsets.getDragTop()) {
                            JavaFXMousePageTurn.this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 996);
                        } else {
                            JavaFXMousePageTurn.this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 998);
                        }
                        if (velocity < 32) {
                            velocity *= 2;
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!fallBack) {
                        int backPage = JavaFXMousePageTurn.this.commonValues.getCurrentPage() - 2;
                        if (backPage == 0) {
                            backPage = 1;
                        }
                        JavaFXMousePageTurn.this.commonValues.setCurrentPage(backPage);
                        JavaFXMousePageTurn.this.currentGUI.setPageNumber();
                        JavaFXMousePageTurn.this.decode_pdf.setPageParameters(JavaFXMousePageTurn.this.currentGUI.getScaling(), JavaFXMousePageTurn.this.commonValues.getCurrentPage());
                        JavaFXMousePageTurn.this.currentGUI.decodePage();
                    }
                    JavaFXMousePageTurn.this.decode_pdf.setUserOffsets(0, 0, 995);
                    JavaFXPageNavigator.setPageTurnAnimating(false, JavaFXMousePageTurn.this.currentGUI);
                }
            };
            animation.setDaemon(true);
            JavaFXPageNavigator.setPageTurnAnimating(true, this.currentGUI);
            animation.start();
            this.previewTurnover = false;
        }
    }
}

