/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jpedal.examples.viewer.gui.generic.GUIOutline;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JavaFXOutline
extends Tab
implements GUIOutline {
    private Map<String, String> pageLookupTableViaTitle = new HashMap<String, String>();
    private boolean hasDuplicateTitles = false;
    private final Map<Integer, String> nodeToRef = new HashMap<Integer, String>();
    private final TreeView<Label> list = new TreeView();

    public JavaFXOutline() {
        this.pageLookupTableViaTitle = new HashMap<String, String>();
        ScrollPane content = new ScrollPane();
        this.setContent((Node)content);
        content.setContent(this.list);
        this.list.prefWidthProperty().bind((ObservableValue)content.widthProperty());
        this.list.prefHeightProperty().bind((ObservableValue)content.heightProperty());
        this.list.setShowRoot(false);
    }

    @Override
    public Object getTree() {
        return this.list;
    }

    @Override
    public DefaultMutableTreeNode getLastSelectedPathComponent() {
        return null;
    }

    @Override
    public String getPage(String title) {
        if (this.hasDuplicateTitles) {
            return null;
        }
        return this.pageLookupTableViaTitle.get(title);
    }

    @Override
    public void reset(org.w3c.dom.Node rootNode) {
        TreeItem root = new TreeItem();
        this.nodeToRef.clear();
        this.pageLookupTableViaTitle.clear();
        this.hasDuplicateTitles = false;
        this.readChildNodes(rootNode, (TreeItem<Label>)root, 0);
        this.list.setRoot(root);
    }

    @Override
    public String convertNodeIDToRef(int index) {
        return this.nodeToRef.get(index);
    }

    private void readChildNodes(org.w3c.dom.Node rootData, TreeItem<Label> rootNode, int nodeIndex) {
        if (rootData == null) {
            return;
        }
        NodeList nl = rootData.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element currentElement = (Element)nl.item(i);
            String title = currentElement.getAttribute("title");
            String page = currentElement.getAttribute("page");
            String isClosed = currentElement.getAttribute("isClosed");
            String ref = currentElement.getAttribute("objectRef");
            OutlineNode currentNode = new OutlineNode(title, ref, isClosed);
            ((Label)currentNode.getValue()).setUserData((Object)currentNode);
            currentNode.setPage(page);
            if (this.pageLookupTableViaTitle.containsKey(title)) {
                this.hasDuplicateTitles = true;
            } else {
                this.pageLookupTableViaTitle.put(title, page);
            }
            this.nodeToRef.put(nodeIndex, ref);
            rootNode.getChildren().add((Object)currentNode);
            this.readChildNodes(nl.item(i), currentNode, ++nodeIndex);
        }
    }

    public class OutlineNode
    extends TreeItem<Label> {
        private final String objectRef;
        private String page;

        private OutlineNode() {
            this.objectRef = null;
        }

        private OutlineNode(String title, String objectRef, String isClosed) {
            this.objectRef = objectRef;
            Label titleLabel = new Label(title);
            titleLabel.prefWidthProperty().bind((ObservableValue)JavaFXOutline.this.list.prefWidthProperty().subtract(20));
            titleLabel.setTextFill((Paint)Color.BLACK);
            this.setValue(titleLabel);
            this.setExpanded(!isClosed.equals("true"));
            JavaFXOutline.this.setTooltip(new Tooltip(title));
        }

        public String getObjectRef() {
            return this.objectRef;
        }

        public String getPage() {
            return this.page;
        }

        private void setPage(String page) {
            this.page = page;
        }
    }
}

