/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIDisplay;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.JavaFxGUI;
import org.jpedal.examples.viewer.gui.generic.GUISearchList;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.gui.javafx.JavaFXSearchList;
import org.jpedal.grouping.DefaultSearchListener;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class JavaFXSearchWindow
extends Stage
implements GUISearchWindow {
    public boolean hasSearched;
    public boolean isSearch;
    int firstPageWithResults;
    int searchTypeParameters;
    private int style;
    Values commonValues;
    final GUIFactory currentGUI;
    PdfDecoderInt decode_pdf;
    private boolean isSetup;
    boolean usingMenuBarSearch;
    private boolean endSearch;
    private boolean backGroundSearch;
    private Map searchAreas;
    VBox contentVB = new VBox();
    private int searchKey;
    private Thread searchThread;
    private final Runnable searchRunner = new Runnable(){

        @Override
        public void run() {
            JavaFXSearchWindow.this.resultsList.setStatus(4);
            boolean searchingInBackground = JavaFXSearchWindow.this.backGroundSearch;
            JavaFXSearchWindow.this.backGroundSearch = false;
            int currentKey = JavaFXSearchWindow.this.searchKey;
            try {
                ObservableList resultListModel = JavaFXSearchWindow.this.updateListDuringSearch ? JavaFXSearchWindow.this.listModel : FXCollections.observableArrayList();
                int start = 1;
                int end = JavaFXSearchWindow.this.decode_pdf.getPageCount() + 1;
                if (JavaFXSearchWindow.this.singlePageSearch) {
                    start = JavaFXSearchWindow.this.decode_pdf.getPageNumber();
                    end = start + 1;
                }
                int currentPage = JavaFXSearchWindow.this.commonValues.getCurrentPage();
                boolean continueSearch = true;
                while (start != end) {
                    int page;
                    if (JavaFXSearchWindow.this.usingMenuBarSearch) {
                        if (JavaFXSearchWindow.this.resultsList.getResultCount() >= 1) break;
                        page = currentPage + (start - 1);
                        if (page > JavaFXSearchWindow.this.commonValues.getPageCount()) {
                            page -= JavaFXSearchWindow.this.commonValues.getPageCount();
                        }
                    } else {
                        page = start;
                    }
                    if (JavaFXSearchWindow.this.searchAreas != null) {
                        int[][] highlights = (int[][])JavaFXSearchWindow.this.searchAreas.get(page);
                        if (highlights != null) {
                            for (int i = highlights.length - 1; i > -1; --i) {
                                int[] a = highlights[i];
                                continueSearch = JavaFXSearchWindow.this.searchPage(page, a[0], a[1], a[0] + a[2], a[1] + a[3], currentKey, resultListModel);
                            }
                        }
                    } else {
                        continueSearch = JavaFXSearchWindow.this.searchPage(page, currentKey, resultListModel);
                    }
                    if (!continueSearch) break;
                    if (!searchingInBackground && !resultListModel.isEmpty() | page % 16 == 0) {
                        final int pp = page;
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                JavaFXSearchWindow.this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + JavaFXSearchWindow.this.itemFoundCount + ' ' + Messages.getMessage("PdfViewerSearch.Scanning") + pp);
                            }
                        });
                    }
                    ++start;
                }
                if (!searchingInBackground) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            JavaFXSearchWindow.this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + JavaFXSearchWindow.this.itemFoundCount + "  " + Messages.getMessage("PdfViewerSearch.Done"));
                        }
                    });
                }
                if (!JavaFXSearchWindow.this.usingMenuBarSearch) {
                    while (resultListModel.size() != JavaFXSearchWindow.this.itemFoundCount) {
                        Thread.sleep(200L);
                    }
                }
                JavaFXSearchWindow.this.listModel = resultListModel;
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (JavaFXSearchWindow.this.resultsList != null && JavaFXSearchWindow.this.listModel != null) {
                            JavaFXSearchWindow.this.resultsList.setItems(JavaFXSearchWindow.this.listModel);
                        }
                    }
                });
                if (continueSearch) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            JavaFXSearchWindow.this.currentGUI.setResults(JavaFXSearchWindow.this.resultsList);
                            JavaFXSearchWindow.this.resultsList.scrollTo(0);
                            JavaFXSearchWindow.this.resultsList.getSelectionModel().clearAndSelect(0);
                        }
                    });
                }
                if (JavaFXSearchWindow.this.itemFoundCount > 0) {
                    JavaFXSearchWindow.this.resultsList.setStatus(2);
                } else {
                    JavaFXSearchWindow.this.resultsList.setStatus(1);
                }
                if (!searchingInBackground) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            JavaFXSearchWindow.this.currentGUI.getButtons().getButton(19).setEnabled(true);
                            JavaFXSearchWindow.this.currentGUI.getButtons().getButton(18).setEnabled(true);
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!searchingInBackground) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            JavaFXSearchWindow.this.currentGUI.getButtons().getButton(19).setEnabled(true);
                            JavaFXSearchWindow.this.currentGUI.getButtons().getButton(18).setEnabled(true);
                        }
                    });
                }
                JavaFXSearchWindow.this.resultsList.setStatus(8);
            }
        }
    };
    int lastPage = -1;
    String defaultMessage = "Search PDF Here";
    public boolean requestInterupt;
    private boolean deleteOnClick;
    final ProgressBar progress = new ProgressBar(100.0);
    TextField searchText;
    Label searchCount;
    JavaFXSearchList resultsList;
    Button advOpts;
    private final VBox nav = new VBox();
    private VBox advancedPanel;
    private ComboBox searchType;
    private CheckBox wholeWordsOnlyBox;
    private CheckBox caseSensitiveBox;
    private CheckBox multiLineBox;
    private CheckBox highlightAll;
    private CheckBox searchAll;
    private CheckBox useRegEx;
    private CheckBox searchHighlightedOnly;
    Button searchButton;
    ObservableList listModel;
    boolean singlePageSearch;
    String[] searchTerms = new String[]{""};
    private int itemFoundCount;
    final Map textPages = new HashMap();
    final Map textRectangles = new HashMap();
    boolean updateListDuringSearch = true;

    public JavaFXSearchWindow(GUIFactory currentGUI) {
        this.currentGUI = currentGUI;
    }

    @Override
    public void find(PdfDecoderInt dec, Values values) {
        if (!this.backGroundSearch) {
            this.init(dec, values);
            if (this.style == 0) {
                this.show();
            }
        } else {
            try {
                this.searchText();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void findWithoutWindow(PdfDecoderInt dec, Values values, int searchType, boolean listOfTerms, boolean singlePageOnly, String searchValue) {
        if (!this.isSearch) {
            this.backGroundSearch = true;
            this.isSearch = true;
            this.decode_pdf = dec;
            this.commonValues = values;
            this.progress.setProgress(0.0);
            this.progress.setVisible(true);
            if (!listOfTerms) {
                this.searchTerms = new String[]{searchValue};
            } else {
                this.searchTerms = searchValue.split(" ");
                for (int i = 0; i < this.searchTerms.length; ++i) {
                    this.searchTerms[i] = this.searchTerms[i].trim();
                }
            }
            this.searchTypeParameters = searchType;
            this.singlePageSearch = singlePageOnly;
            this.find(dec, values);
        } else {
            this.currentGUI.showMessageDialog("Please wait for search to finish before starting another.");
        }
    }

    @Override
    public void grabFocusInInput() {
        this.searchText.requestFocus();
    }

    @Override
    public boolean isSearchVisible() {
        return this.isShowing();
    }

    @Override
    public void init(PdfDecoderInt dec, Values values) {
        this.decode_pdf = dec;
        this.commonValues = values;
        if (this.isSetup) {
            this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + this.itemFoundCount);
            this.searchText.selectAll();
        } else {
            this.isSetup = true;
            this.setTitle(Messages.getMessage("PdfViewerSearchGUITitle.DefaultMessage"));
            this.defaultMessage = Messages.getMessage("PdfViewerSearchGUI.DefaultMessage");
            this.searchText = new TextField();
            this.searchText.setText(this.defaultMessage);
            this.searchText.setId("searchText");
            this.searchButton = new Button(Messages.getMessage("PdfViewerSearch.Button"));
            this.advancedPanel = new VBox();
            ObservableList searchOptions = FXCollections.observableArrayList((Object[])new String[]{Messages.getMessage("PdfViewerSearch.MatchWhole"), Messages.getMessage("PdfViewerSearch.MatchAny")});
            this.searchType = new ComboBox(searchOptions);
            this.searchType.setValue(this.searchType.getItems().get(0));
            this.wholeWordsOnlyBox = new CheckBox(Messages.getMessage("PdfViewerSearch.WholeWords"));
            this.wholeWordsOnlyBox.setId("wholeWords");
            this.caseSensitiveBox = new CheckBox(Messages.getMessage("PdfViewerSearch.CaseSense"));
            this.caseSensitiveBox.setId("caseSensitive");
            this.multiLineBox = new CheckBox(Messages.getMessage("PdfViewerSearch.MultiLine"));
            this.multiLineBox.setId("multiLine");
            this.highlightAll = new CheckBox(Messages.getMessage("PdfViewerSearch.HighlightsCheckBox"));
            this.highlightAll.setId("highlightAll");
            this.useRegEx = new CheckBox(Messages.getMessage("PdfViewerSearch.RegExCheckBox"));
            this.useRegEx.setId("useregex");
            this.searchHighlightedOnly = new CheckBox(Messages.getMessage("PdfViewerSearch.HighlightsOnly"));
            this.searchHighlightedOnly.setId("highlightsOnly");
            this.searchType.setId("combo");
            this.advancedPanel.getChildren().add((Object)new Label(Messages.getMessage("PdfViewerSearch.ReturnResultsAs")));
            this.advancedPanel.getChildren().add((Object)this.searchType);
            this.advancedPanel.getChildren().add((Object)new Label(Messages.getMessage("PdfViewerSearch.AdditionalOptions")));
            this.advancedPanel.getChildren().add((Object)this.wholeWordsOnlyBox);
            this.advancedPanel.getChildren().add((Object)this.caseSensitiveBox);
            this.advancedPanel.getChildren().add((Object)this.multiLineBox);
            this.advancedPanel.getChildren().add((Object)this.highlightAll);
            this.advancedPanel.getChildren().add((Object)this.useRegEx);
            this.advancedPanel.getChildren().add((Object)this.searchHighlightedOnly);
            this.advancedPanel.setVisible(false);
            this.searchAll = new CheckBox();
            this.searchAll.setSelected(true);
            this.searchAll.setText(Messages.getMessage("PdfViewerSearch.CheckBox"));
            VBox topPanel = new VBox();
            topPanel.getChildren().add((Object)this.searchAll);
            this.advOpts = new Button(Messages.getMessage("PdfViewerSearch.ShowOptions"));
            this.advOpts.setId("advSearch");
            this.advOpts.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent me) {
                    if (GUIDisplay.allowChangeCursor) {
                        JavaFXSearchWindow.this.nav.setCursor(Cursor.HAND);
                    }
                }
            });
            this.advOpts.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent me) {
                    if (GUIDisplay.allowChangeCursor) {
                        JavaFXSearchWindow.this.nav.setCursor(Cursor.DEFAULT);
                    }
                }
            });
            this.advOpts.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){
                boolean isVisible;

                public void handle(MouseEvent me) {
                    if (this.isVisible) {
                        JavaFXSearchWindow.this.advOpts.setText(Messages.getMessage("PdfViewerSearch.ShowOptions"));
                        JavaFXSearchWindow.this.advancedPanel.setVisible(false);
                    } else {
                        JavaFXSearchWindow.this.advOpts.setText(Messages.getMessage("PdfViewerSearch.HideOptions"));
                        JavaFXSearchWindow.this.advancedPanel.setVisible(true);
                    }
                    this.isVisible = !this.isVisible;
                }
            });
            topPanel.getChildren().add((Object)this.advOpts);
            this.nav.getChildren().add((Object)topPanel);
            HBox navBox = new HBox();
            navBox.getChildren().addAll((Object[])new Node[]{this.searchText, this.searchButton});
            this.nav.getChildren().add((Object)navBox);
            this.itemFoundCount = 0;
            this.textPages.clear();
            this.textRectangles.clear();
            this.searchCount = new Label(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + this.itemFoundCount);
            this.nav.getChildren().add((Object)this.searchCount);
            this.listModel = FXCollections.observableArrayList();
            this.listModel = FXCollections.observableArrayList();
            this.resultsList = new JavaFXSearchList(this.listModel, this.textPages, this.textRectangles);
            this.resultsList.setId("results");
            this.resultsList.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
                    if (!Values.isProcessing()) {
                        Integer key;
                        Object newPage;
                        float scaling = JavaFXSearchWindow.this.currentGUI.getScaling();
                        int id = (Integer)t1;
                        JavaFXSearchWindow.this.decode_pdf.getTextLines().clearHighlights();
                        if (id != -1 && (newPage = JavaFXSearchWindow.this.textPages.get(key = Integer.valueOf(id))) != null) {
                            int nextPage = (Integer)newPage;
                            if (JavaFXSearchWindow.this.commonValues.getCurrentPage() != nextPage) {
                                JavaFXSearchWindow.this.commonValues.setCurrentPage(nextPage);
                                JavaFXSearchWindow.this.currentGUI.resetStatusMessage(Messages.getMessage("PdfViewer.LoadingPage") + ' ' + JavaFXSearchWindow.this.commonValues.getCurrentPage());
                                JavaFXSearchWindow.this.decode_pdf.setPageParameters(scaling, JavaFXSearchWindow.this.commonValues.getCurrentPage());
                                JavaFXSearchWindow.this.currentGUI.decodePage();
                            }
                            while (Values.isProcessing()) {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException ee) {
                                    ee.printStackTrace();
                                }
                            }
                            if ((JavaFXSearchWindow.this.searchTypeParameters & 0x10) == 16) {
                                int[][] showAllOnPage;
                                Vector_Rectangle_Int storageVector = new Vector_Rectangle_Int();
                                int lastPage = -1;
                                for (int k = 0; k != JavaFXSearchWindow.this.resultsList.getItems().size(); ++k) {
                                    Object highlight;
                                    Object page = JavaFXSearchWindow.this.textPages.get(k);
                                    if (page == null) continue;
                                    int currentPage = (Integer)page;
                                    if (currentPage != lastPage) {
                                        storageVector.trim();
                                        showAllOnPage = storageVector.get();
                                        for (int p = 0; p != showAllOnPage.length; ++p) {
                                            System.out.println(Arrays.toString(showAllOnPage[p]));
                                        }
                                        JavaFXSearchWindow.this.decode_pdf.getTextLines().addHighlights(showAllOnPage, true, lastPage);
                                        lastPage = currentPage;
                                        storageVector = new Vector_Rectangle_Int();
                                    }
                                    if ((highlight = JavaFXSearchWindow.this.textRectangles.get(k)) instanceof int[]) {
                                        storageVector.addElement((int[])highlight);
                                    }
                                    if (!(highlight instanceof int[][])) continue;
                                    int[][] areas = (int[][])highlight;
                                    for (int i = 0; i != areas.length; ++i) {
                                        storageVector.addElement(areas[i]);
                                    }
                                }
                                storageVector.trim();
                                showAllOnPage = storageVector.get();
                                JavaFXSearchWindow.this.decode_pdf.getTextLines().addHighlights(showAllOnPage, true, lastPage);
                            } else {
                                Object page = JavaFXSearchWindow.this.textPages.get(key);
                                int currentPage = (Integer)page;
                                Vector_Rectangle_Int storageVector = new Vector_Rectangle_Int();
                                Object highlight = JavaFXSearchWindow.this.textRectangles.get(key);
                                if (highlight instanceof int[]) {
                                    storageVector.addElement((int[])highlight);
                                }
                                if (highlight instanceof int[][]) {
                                    int[][] areas = (int[][])highlight;
                                    for (int i = 0; i != areas.length; ++i) {
                                        storageVector.addElement(areas[i]);
                                    }
                                }
                                storageVector.trim();
                                JavaFXSearchWindow.this.decode_pdf.getTextLines().addHighlights(storageVector.get(), true, currentPage);
                            }
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    JavaFXSearchWindow.this.decode_pdf.repaintPane(JavaFXSearchWindow.this.commonValues.getCurrentPage());
                                    JavaFXSearchWindow.this.currentGUI.scaleAndRotate();
                                }
                            });
                        }
                    }
                    if (JavaFXSearchWindow.this.commonValues.getCurrentPage() == 1) {
                        JavaFXSearchWindow.this.currentGUI.getButtons().setBackNavigationButtonsEnabled(false);
                    } else {
                        JavaFXSearchWindow.this.currentGUI.getButtons().setBackNavigationButtonsEnabled(true);
                    }
                    if (JavaFXSearchWindow.this.commonValues.getCurrentPage() == JavaFXSearchWindow.this.decode_pdf.getPageCount()) {
                        JavaFXSearchWindow.this.currentGUI.getButtons().setForwardNavigationButtonsEnabled(false);
                    } else {
                        JavaFXSearchWindow.this.currentGUI.getButtons().setForwardNavigationButtonsEnabled(true);
                    }
                }
            });
            this.searchButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    if (!JavaFXSearchWindow.this.isSearch) {
                        try {
                            JavaFXSearchWindow.this.searchTypeParameters = 0;
                            if (JavaFXSearchWindow.this.wholeWordsOnlyBox.isSelected()) {
                                JavaFXSearchWindow.this.searchTypeParameters |= 1;
                            }
                            if (JavaFXSearchWindow.this.caseSensitiveBox.isSelected()) {
                                JavaFXSearchWindow.this.searchTypeParameters |= 2;
                            }
                            if (JavaFXSearchWindow.this.multiLineBox.isSelected()) {
                                JavaFXSearchWindow.this.searchTypeParameters |= 8;
                            }
                            if (JavaFXSearchWindow.this.highlightAll.isSelected()) {
                                JavaFXSearchWindow.this.searchTypeParameters |= 0x10;
                            }
                            if (JavaFXSearchWindow.this.useRegEx.isSelected()) {
                                JavaFXSearchWindow.this.searchTypeParameters |= 0x20;
                            }
                            if (JavaFXSearchWindow.this.searchHighlightedOnly.isSelected()) {
                                JavaFXSearchWindow.this.searchTypeParameters |= 0x40;
                            }
                            String textToFind = JavaFXSearchWindow.this.searchText.getText().trim();
                            if (JavaFXSearchWindow.this.searchType.getValue() == JavaFXSearchWindow.this.searchType.getItems().get(0)) {
                                JavaFXSearchWindow.this.searchTerms = new String[]{textToFind};
                            } else {
                                JavaFXSearchWindow.this.searchTerms = textToFind.split(" ");
                                for (int i = 0; i < JavaFXSearchWindow.this.searchTerms.length; ++i) {
                                    JavaFXSearchWindow.this.searchTerms[i] = JavaFXSearchWindow.this.searchTerms[i].trim();
                                }
                            }
                            JavaFXSearchWindow.this.singlePageSearch = !JavaFXSearchWindow.this.searchAll.isSelected();
                            JavaFXSearchWindow.this.searchText();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    } else {
                        JavaFXSearchWindow.this.requestInterupt = true;
                        JavaFXSearchWindow.this.isSearch = false;
                        JavaFXSearchWindow.this.searchButton.setText(Messages.getMessage("PdfViewerSearch.Button"));
                    }
                    ((JavaFxGUI)JavaFXSearchWindow.this.currentGUI).getPdfDecoder().requestFocus();
                }
            });
            this.searchText.selectAll();
            this.deleteOnClick = true;
            this.searchText.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent e) {
                    JavaFXSearchWindow.this.currentGUI.getButtons().getButton(19).setEnabled(false);
                    JavaFXSearchWindow.this.currentGUI.getButtons().getButton(18).setEnabled(false);
                    if (e.getCode() == KeyCode.ENTER) {
                        if (!JavaFXSearchWindow.this.decode_pdf.isOpen()) {
                            JavaFXSearchWindow.this.currentGUI.showMessageDialog("File must be open before you can search.");
                        } else {
                            try {
                                JavaFXSearchWindow.this.isSearch = false;
                                JavaFXSearchWindow.this.searchTypeParameters = 0;
                                if (JavaFXSearchWindow.this.wholeWordsOnlyBox.isSelected()) {
                                    JavaFXSearchWindow.this.searchTypeParameters |= 1;
                                }
                                if (JavaFXSearchWindow.this.caseSensitiveBox.isSelected()) {
                                    JavaFXSearchWindow.this.searchTypeParameters |= 2;
                                }
                                if (JavaFXSearchWindow.this.multiLineBox.isSelected()) {
                                    JavaFXSearchWindow.this.searchTypeParameters |= 8;
                                }
                                if (JavaFXSearchWindow.this.highlightAll.isSelected()) {
                                    JavaFXSearchWindow.this.searchTypeParameters |= 0x10;
                                }
                                if (JavaFXSearchWindow.this.useRegEx.isSelected()) {
                                    JavaFXSearchWindow.this.searchTypeParameters |= 0x20;
                                }
                                if (JavaFXSearchWindow.this.searchHighlightedOnly.isSelected()) {
                                    JavaFXSearchWindow.this.searchTypeParameters |= 0x40;
                                }
                                String textToFind = JavaFXSearchWindow.this.searchText.getText().trim();
                                if (JavaFXSearchWindow.this.searchType.getValue() == JavaFXSearchWindow.this.searchType.getItems().get(0)) {
                                    JavaFXSearchWindow.this.searchTerms = new String[]{textToFind};
                                } else {
                                    JavaFXSearchWindow.this.searchTerms = textToFind.split(" ");
                                    for (int i = 0; i < JavaFXSearchWindow.this.searchTerms.length; ++i) {
                                        JavaFXSearchWindow.this.searchTerms[i] = JavaFXSearchWindow.this.searchTerms[i].trim();
                                    }
                                }
                                JavaFXSearchWindow.this.singlePageSearch = !JavaFXSearchWindow.this.searchAll.isSelected();
                                JavaFXSearchWindow.this.searchText();
                                ((JavaFxGUI)JavaFXSearchWindow.this.currentGUI).getPdfDecoder().requestFocus();
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }
            });
            this.searchText.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                    if (newPropertyValue.booleanValue() && JavaFXSearchWindow.this.deleteOnClick) {
                        JavaFXSearchWindow.this.deleteOnClick = false;
                        JavaFXSearchWindow.this.searchText.setText("");
                    } else if (JavaFXSearchWindow.this.searchText.getText().isEmpty()) {
                        JavaFXSearchWindow.this.searchText.setText(JavaFXSearchWindow.this.defaultMessage);
                        JavaFXSearchWindow.this.deleteOnClick = true;
                    }
                }
            });
            if (this.style == 0 || this.style == 1) {
                BorderPane bp = new BorderPane();
                this.contentVB = new VBox();
                this.contentVB.getChildren().addAll((Object[])new Node[]{this.nav, this.resultsList, this.advancedPanel});
                bp.setCenter((Node)this.contentVB);
                Scene scene = new Scene((Parent)bp);
                this.setScene(scene);
            } else {
                this.currentGUI.setSearchText(this.searchText);
            }
        }
    }

    public VBox getContentVB() {
        return this.contentVB;
    }

    @Override
    public void removeSearchWindow(boolean justHide) {
        this.close();
        if (this.isSetup && !justHide) {
            if (this.listModel != null) {
                this.listModel.clear();
            }
            this.itemFoundCount = 0;
            this.isSearch = false;
        }
        if (this.decode_pdf != null) {
            this.decode_pdf.getTextLines().clearHighlights();
            this.decode_pdf.repaintPane(this.commonValues.getCurrentPage());
        }
    }

    @Override
    public void resetSearchWindow() {
        if (this.isSetup) {
            this.searchText.setText(this.defaultMessage);
            this.deleteOnClick = true;
            if (this.hasSearched) {
                this.currentGUI.getButtons().getButton(19).setEnabled(false);
                this.currentGUI.getButtons().getButton(18).setEnabled(false);
                this.hasSearched = false;
            }
            this.decode_pdf.requestFocus();
        }
    }

    @Override
    public GUISearchList getResults() {
        return this.resultsList;
    }

    @Override
    public GUISearchList getResults(int page) {
        boolean bl = this.usingMenuBarSearch = this.style == 2;
        if (page != this.lastPage && this.usingMenuBarSearch) {
            try {
                ++this.searchKey;
                if (this.searchKey > 3000) {
                    this.searchKey = 0;
                }
                this.clearCurrentResults();
                this.searchPage(page, this.searchKey, this.listModel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.resultsList;
    }

    @Override
    public Map getTextRectangles() {
        return Collections.unmodifiableMap(this.textRectangles);
    }

    @Override
    public int getViewStyle() {
        return this.style;
    }

    @Override
    public void setViewStyle(int i) {
        this.style = i;
    }

    @Override
    public int getFirstPageWithResults() {
        return this.firstPageWithResults;
    }

    @Override
    public void setWholeWords(boolean wholeWords) {
        this.wholeWordsOnlyBox.setSelected(wholeWords);
    }

    @Override
    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitiveBox.setSelected(caseSensitive);
    }

    @Override
    public void setMultiLine(boolean multiLine) {
        this.multiLineBox.setSelected(multiLine);
    }

    @Override
    public void setSearchText(String s) {
        this.searchText.setText(s);
    }

    private void searchText() throws Exception {
        this.usingMenuBarSearch = this.style == 2;
        ++this.searchKey;
        this.lastPage = -1;
        if (this.searchKey > 3000) {
            this.searchKey = 0;
        }
        if (this.searchThread != null && this.searchThread.isAlive()) {
            this.endSearch = true;
            this.searchThread.interrupt();
            while (this.searchThread.isAlive()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    LogWriter.writeLog("Attempting to set propeties values " + e);
                }
            }
            this.endSearch = false;
        }
        this.searchAreas = !this.usingMenuBarSearch && (this.searchTypeParameters & 0x40) == 64 ? this.decode_pdf.getTextLines().getAllHighlights() : null;
        this.clearCurrentResults();
        this.searchThread = new Thread(this.searchRunner);
        this.searchThread.start();
    }

    private void clearCurrentResults() {
        this.listModel.clear();
        this.resultsList.getItems().clear();
        this.textPages.clear();
        this.textRectangles.clear();
        this.itemFoundCount = 0;
        this.decode_pdf.getTextLines().clearHighlights();
    }

    private boolean searchPage(int page, int currentKey, ObservableList resultListModel) throws Exception {
        PdfPageData currentPageData = this.decode_pdf.getPdfPageData();
        int x1 = currentPageData.getMediaBoxX(page);
        int x2 = currentPageData.getMediaBoxWidth(page) + x1;
        int y2 = currentPageData.getMediaBoxY(page);
        int y1 = currentPageData.getMediaBoxHeight(page) + y2;
        return this.searchPage(page, x1, y1, x2, y2, currentKey, resultListModel);
    }

    private boolean searchPage(int page, int x1, int y1, int x2, int y2, int currentKey, ObservableList resultListModel) throws Exception {
        PdfGroupingAlgorithms grouping;
        PdfPageData pageSize = this.decode_pdf.getPdfPageData();
        if (page == this.commonValues.getCurrentPage()) {
            grouping = this.decode_pdf.getGroupingObject();
        } else {
            this.decode_pdf.decodePageInBackground(page);
            grouping = this.decode_pdf.getBackgroundGroupingObject();
        }
        DefaultSearchListener listener = new DefaultSearchListener();
        grouping.generateTeasers();
        grouping.setIncludeHTML(false);
        this.resultsList.setSearchTerm(this.searchText.getText().trim());
        SortedMap highlightsWithTeasers = grouping.findTextWithinInAreaWithTeasers(x1, y1, x2, y2, pageSize.getRotation(page), page, this.searchTerms, this.searchTypeParameters, listener);
        if (!highlightsWithTeasers.isEmpty()) {
            this.itemFoundCount += highlightsWithTeasers.size();
            Iterator iterator = highlightsWithTeasers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry e = o = iterator.next();
                Object highlight = e.getKey();
                String teaser = (String)e.getValue();
                if (currentKey == this.searchKey) {
                    resultListModel.add((Object)teaser);
                }
                Integer key = this.textRectangles.size();
                this.textRectangles.put(key, highlight);
                this.textPages.put(key, page);
            }
        }
        this.lastPage = page;
        return !this.endSearch;
    }

    @Override
    public void setUpdateListDuringSearch(boolean updateListDuringSearch) {
        this.updateListDuringSearch = updateListDuringSearch;
    }

    @Override
    public void dispose() {
    }
}

