/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx.dialog;

import java.util.ArrayList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.stage.Stage;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXMessageDialog;

public class FXOptionDialog
extends FXMessageDialog {
    public static final int DEFAULT_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int CLOSED_OPTION = -1;
    public static final int YES_OPTION = 0;
    public static final int OK_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private int choice = -1;

    public FXOptionDialog(Stage parent, String message, String title, int optionType, Object[] options, Object initialValue) {
        super(parent, message);
        this.setTitle(title);
        this.setupButtons(optionType, options, initialValue);
    }

    public FXOptionDialog(Stage parent, Object message, String title, int optionType, Object[] options, Object initialValue) {
        super(parent, message.toString());
        this.setTitle(title);
        this.setupButtons(optionType, options, initialValue);
    }

    private void setupButtons(int optionType, Object[] options, Object initialValue) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        if (options == null) {
            if (optionType < -1 || optionType > 2) {
                throw new RuntimeException("Option type must be one of FXOptionDialog.DEFAULT_OPTION, FXOptionDialog.YES_NO_OPTION, FXOptionDialog.YES_NO_CANCEL_OPTION or FXOptionDialog.OK_CANCEL_OPTION");
            }
            Button yes = new Button("Yes");
            Button ok = new Button("Ok");
            Button no = new Button("No");
            Button cancel = new Button("Cancel");
            yes.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    FXOptionDialog.this.choice = 0;
                    FXOptionDialog.this.positiveClose();
                }
            });
            ok.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    FXOptionDialog.this.choice = 0;
                    FXOptionDialog.this.positiveClose();
                }
            });
            no.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    FXOptionDialog.this.choice = 1;
                    FXOptionDialog.this.positiveClose();
                }
            });
            cancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    FXOptionDialog.this.choice = 2;
                    FXOptionDialog.this.positiveClose();
                }
            });
            switch (optionType) {
                case -1: {
                    buttons.add(yes);
                    break;
                }
                case 0: {
                    buttons.add(yes);
                    buttons.add(no);
                    break;
                }
                case 1: {
                    buttons.add(yes);
                    buttons.add(no);
                    buttons.add(cancel);
                    break;
                }
                case 2: {
                    buttons.add(ok);
                    buttons.add(cancel);
                    break;
                }
            }
        } else {
            int i = 0;
            while (i < options.length) {
                Button btn = new Button(options[i].toString());
                if (options[i].equals(initialValue)) {
                    btn.requestFocus();
                }
                final int val = i++;
                btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent t) {
                        FXOptionDialog.this.choice = val;
                        FXOptionDialog.this.positiveClose();
                    }
                });
                buttons.add(btn);
            }
        }
        this.getButtonGroup().getChildren().clear();
        this.getButtonGroup().getChildren().addAll(buttons);
    }

    public int showOptionDialog() {
        this.showAndWait();
        return this.choice;
    }

    @Override
    protected void positiveClose() {
        super.positiveClose();
        if (this.choice == -1) {
            this.choice = 0;
        }
    }
}

