/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.text.DecimalFormat;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterResolution;
import org.jpedal.DevFlags;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXDialog;
import org.jpedal.examples.viewer.gui.popups.PrintPanelInt;
import org.jpedal.examples.viewer.paper.MarginPaper;
import org.jpedal.examples.viewer.paper.PaperSizes;
import org.jpedal.objects.PrinterOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class PrintPanelFX
extends Pane
implements PrintPanelInt {
    private FXDialog printPopup;
    private TabPane tabs;
    private final BorderPane border = new BorderPane();
    private final Tab printer = new Tab("Printer");
    private final Tab range = new Tab("Range");
    private final Tab handling = new Tab("Handling");
    private final float[] margins = new float[4];
    private final PdfDecoderInt pdf;
    Button ok;
    Button cancel;
    ComboBox<String> printers;
    ComboBox pagesOptions;
    ComboBox resolutionOptions;
    TextField leftT;
    TextField rightT;
    TextField topT;
    TextField bottomT;
    RadioButton all;
    RadioButton currentView;
    RadioButton currentPage;
    RadioButton pagesFrom;
    TextField numberFrom;
    TextField numberTo;
    ComboBox subSet;
    CheckBox reverse;
    TextField copies;
    ComboBox scaling;
    CheckBox autoRotateCenter;
    CheckBox paperSourceByPDF;
    CheckBox grayscale;
    private boolean debugPrinterChange;
    int pageCount;
    int currentPageNo;
    private boolean okClicked;
    private String[] printersList;
    private final PaperSizes paperDefinitions;
    private int defaultResolution;
    private static final double mmPerSubInch = 0.35277777777777775;
    final double[] minimumMargins = new double[]{0.0, 0.0, 0.0, 0.0};
    final DecimalFormat df = new DecimalFormat("#.###");

    public PrintPanelFX(String[] printersList, String defaultPrinter, PaperSizes paperDefinitions, int defaultResolution, int pageNumber, PdfDecoderInt decoder) {
        this.pdf = decoder;
        this.pageCount = this.pdf.getPageCount();
        this.currentPageNo = pageNumber;
        this.defaultResolution = defaultResolution;
        this.paperDefinitions = paperDefinitions;
        this.resetDefaults(printersList, defaultPrinter, this.pageCount, this.currentPageNo);
    }

    private void setupStage() {
        this.printPopup = new FXDialog(null, Modality.APPLICATION_MODAL, (Parent)this.border, 700.0, 300.0);
        this.printPopup.setTitle("Print");
        this.initPreview();
        this.bottomButtons();
        this.printPopup.show();
        this.printPopup.setResizeable(false);
    }

    private void bottomButtons() {
        HBox bottomButtons = new HBox(5.0);
        this.ok = new Button();
        this.ok.setText(Messages.getMessage("PdfMessage.Ok"));
        this.ok.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                PrintPanelFX.this.okEvent();
            }
        });
        this.cancel = new Button();
        this.cancel.setText(Messages.getMessage("PdfMessage.Cancel"));
        bottomButtons.getChildren().addAll((Object[])new Node[]{this.ok, this.cancel});
        this.cancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                PrintPanelFX.this.cancelEvent();
            }
        });
        bottomButtons.setAlignment(Pos.BOTTOM_RIGHT);
        bottomButtons.setPadding(new Insets(10.0, 10.0, 10.0, 0.0));
        this.border.setBottom((Node)bottomButtons);
    }

    private void initPreview() {
        VBox previewBox = new VBox();
        Label preview = new Label("Preview");
        preview.setPadding(new Insets(0.0, 0.0, 0.0, 75.0));
        Slider page = new Slider();
        page.setPadding(new Insets(190.0, 0.0, 0.0, 0.0));
        previewBox.setPrefWidth(50.0);
        previewBox.getChildren().addAll((Object[])new Node[]{preview, page});
        previewBox.setStyle("-fx-border-style: solid;-fx-border-width: 0.5;-fx-border-color: black");
        this.border.setCenter((Node)previewBox);
    }

    private void setupTabs() {
        HBox tabsList = new HBox();
        this.tabs = new TabPane();
        tabsList.getChildren().addAll((Object[])new Node[]{this.tabs});
        this.tabs.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.initprintTab();
        this.initRangeTab();
        this.initHandlingTab();
        this.border.setLeft((Node)tabsList);
        this.tabs.getStyleClass().add((Object)"floating");
    }

    private void initprintTab() {
        HBox pane = new HBox();
        GridPane grid = new GridPane();
        this.printers = new ComboBox(FXCollections.observableArrayList((Object[])this.printersList));
        this.printers.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                if (PrintPanelFX.this.debugPrinterChange) {
                    System.out.println("repainted preview component");
                }
                PrintPanelFX.this.ok.setDisable(true);
                PrintPanelFX.this.pagesOptions.setDisable(true);
                PrintPanelFX.this.pagesOptions.setItems(FXCollections.observableArrayList((Object[])new String[]{"Loading..."}));
                PrintPanelFX.this.resolutionOptions.setDisable(true);
                PrintPanelFX.this.resolutionOptions.setItems(FXCollections.observableArrayList((Object[])new String[]{"Loading..."}));
                if (PrintPanelFX.this.debugPrinterChange) {
                    System.out.println("GUI options disabled");
                }
                if (PrintPanelFX.this.debugPrinterChange) {
                    System.out.println("Thread invoked.");
                }
                PrintService[] ps = PrintServiceLookup.lookupPrintServices(null, null);
                if (PrintPanelFX.this.debugPrinterChange) {
                    System.out.println("Found print services.");
                }
                PrintService p = null;
                for (PrintService p1 : ps) {
                    if (PrintPanelFX.this.debugPrinterChange) {
                        System.out.println("checking " + p1.getName());
                    }
                    if (!p1.getName().equals(PrintPanelFX.this.printers.getSelectionModel().getSelectedItem())) continue;
                    p = p1;
                    if (!PrintPanelFX.this.debugPrinterChange) continue;
                    System.out.println("Match!");
                }
                if (p != null) {
                    if (PrintPanelFX.this.debugPrinterChange) {
                        System.out.println("Getting available resolutions...");
                    }
                    PrintPanelFX.this.resolutionOptions.setItems(FXCollections.observableArrayList((Object[])PrintPanelFX.getAvailableResolutions(p)));
                    if (PrintPanelFX.this.debugPrinterChange) {
                        System.out.println("Getting default resolution...");
                    }
                    int resInd = PrintPanelFX.this.getDefaultResolutionIndex();
                    if (PrintPanelFX.this.resolutionOptions.getItems().size() > resInd) {
                        PrintPanelFX.this.resolutionOptions.getSelectionModel().select(resInd);
                    }
                    PrintPanelFX.this.resolutionOptions.setDisable(false);
                    PrintPanelFX.this.paperDefinitions.setPrintService(p);
                    if (PrintPanelFX.this.debugPrinterChange) {
                        System.out.println("Getting available paper sizes...");
                    }
                    PrintPanelFX.this.pagesOptions.setItems(FXCollections.observableArrayList((Object[])PrintPanelFX.this.getAvailablePaperSizes()));
                    if (PrintPanelFX.this.debugPrinterChange) {
                        System.out.println("Getting default pagesize...");
                    }
                    int pageInd = PrintPanelFX.this.paperDefinitions.getDefaultPageIndex();
                    if (PrintPanelFX.this.pagesOptions.getItems().size() > pageInd) {
                        PrintPanelFX.this.pagesOptions.getSelectionModel().select(pageInd);
                    }
                    PrintPanelFX.this.pagesOptions.setDisable(false);
                    PrintPanelFX.this.ok.setDisable(false);
                    if (PrintPanelFX.this.debugPrinterChange) {
                        System.out.println("Reenabled GUI");
                    }
                }
                if (PrintPanelFX.this.debugPrinterChange) {
                    System.out.println("Updating margins");
                }
                PrintPanelFX.this.updateMargins();
            }
        });
        this.pagesOptions = new ComboBox();
        this.resolutionOptions = new ComboBox();
        this.leftT = new TextField();
        this.leftT.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue.matches("[0-9]*\\.?[0-9]*")) {
                    PrintPanelFX.this.leftT.setText(newValue);
                } else {
                    PrintPanelFX.this.leftT.setText(oldValue);
                }
            }
        });
        this.leftT.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (!arg2.booleanValue()) {
                    double page = 0.0;
                    if (!PrintPanelFX.this.leftT.getText().isEmpty()) {
                        page = Double.parseDouble(PrintPanelFX.this.leftT.getText());
                    }
                    if (page < PrintPanelFX.this.minimumMargins[0]) {
                        page = PrintPanelFX.this.minimumMargins[0];
                    }
                    PrintPanelFX.this.leftT.setText(PrintPanelFX.this.df.format(page));
                    ((PrintPanelFX)PrintPanelFX.this).margins[0] = Float.parseFloat(PrintPanelFX.this.leftT.getText());
                }
            }
        });
        this.rightT = new TextField();
        this.rightT.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue.matches("[0-9]*\\.?[0-9]*")) {
                    PrintPanelFX.this.rightT.setText(newValue);
                } else {
                    PrintPanelFX.this.rightT.setText(oldValue);
                }
            }
        });
        this.rightT.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (!arg2.booleanValue()) {
                    double page = 0.0;
                    if (!PrintPanelFX.this.rightT.getText().isEmpty()) {
                        page = Double.parseDouble(PrintPanelFX.this.rightT.getText());
                    }
                    if (page < PrintPanelFX.this.minimumMargins[2]) {
                        page = PrintPanelFX.this.minimumMargins[2];
                    }
                    PrintPanelFX.this.rightT.setText(PrintPanelFX.this.df.format(page));
                    ((PrintPanelFX)PrintPanelFX.this).margins[2] = Float.parseFloat(PrintPanelFX.this.rightT.getText());
                }
            }
        });
        this.topT = new TextField();
        this.topT.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue.matches("[0-9]*\\.?[0-9]*")) {
                    PrintPanelFX.this.topT.setText(newValue);
                } else {
                    PrintPanelFX.this.topT.setText(oldValue);
                }
            }
        });
        this.topT.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (!arg2.booleanValue()) {
                    double page = 0.0;
                    if (!PrintPanelFX.this.topT.getText().isEmpty()) {
                        page = Double.parseDouble(PrintPanelFX.this.topT.getText());
                    }
                    if (page < PrintPanelFX.this.minimumMargins[1]) {
                        page = PrintPanelFX.this.minimumMargins[1];
                    }
                    PrintPanelFX.this.topT.setText(PrintPanelFX.this.df.format(page));
                    ((PrintPanelFX)PrintPanelFX.this).margins[1] = Float.parseFloat(PrintPanelFX.this.topT.getText());
                }
            }
        });
        this.bottomT = new TextField();
        this.bottomT.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue.matches("[0-9]*\\.?[0-9]*")) {
                    PrintPanelFX.this.bottomT.setText(newValue);
                } else {
                    PrintPanelFX.this.bottomT.setText(oldValue);
                }
            }
        });
        this.bottomT.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (!arg2.booleanValue()) {
                    double page = 0.0;
                    if (!PrintPanelFX.this.bottomT.getText().isEmpty()) {
                        page = Double.parseDouble(PrintPanelFX.this.bottomT.getText());
                    }
                    if (page < PrintPanelFX.this.minimumMargins[3]) {
                        page = PrintPanelFX.this.minimumMargins[3];
                    }
                    PrintPanelFX.this.bottomT.setText(PrintPanelFX.this.df.format(page));
                    ((PrintPanelFX)PrintPanelFX.this).margins[3] = Float.parseFloat(PrintPanelFX.this.bottomT.getText());
                }
            }
        });
        Label name = new Label();
        name.setText(Messages.getMessage("PdfViewerPrint.Name"));
        Label pageSize = new Label();
        pageSize.setText(Messages.getMessage("PdfViewerPrint.PageSize"));
        Label margins = new Label();
        margins.setText(Messages.getMessage("PdfViewerPrintMargins.bottom"));
        Label left = new Label();
        left.setText(Messages.getMessage("PdfViewerPrintMargins.left"));
        Label right = new Label();
        right.setText(Messages.getMessage("PdfViewerPrintMargins.right"));
        Label top = new Label();
        top.setText(Messages.getMessage("PdfViewerPrintMargins.top"));
        Label bottom = new Label();
        bottom.setText(Messages.getMessage("PdfViewerPrintMargins.bottom"));
        Label resolution = new Label();
        resolution.setText(Messages.getMessage("PdfViewerPrintResolution.text"));
        grid.setPadding(new Insets(20.0, 0.0, 0.0, 0.0));
        grid.setVgap(6.0);
        grid.add((Node)name, 0, 0);
        grid.add(this.printers, 1, 0, 4, 1);
        grid.add((Node)pageSize, 0, 1);
        grid.add((Node)this.pagesOptions, 1, 1, 4, 1);
        grid.add((Node)margins, 0, 2);
        grid.add((Node)left, 1, 2);
        grid.add((Node)this.leftT, 2, 2);
        grid.add((Node)right, 3, 2);
        grid.add((Node)this.rightT, 4, 2);
        grid.add((Node)top, 1, 3);
        grid.add((Node)this.topT, 2, 3);
        grid.add((Node)bottom, 3, 3);
        grid.add((Node)this.bottomT, 4, 3);
        grid.add((Node)resolution, 0, 4);
        grid.add((Node)this.resolutionOptions, 1, 4, 4, 1);
        pane.getChildren().addAll((Object[])new Node[]{grid});
        this.tabs.getTabs().add((Object)this.printer);
        this.printer.setContent((Node)grid);
    }

    private void initRangeTab() {
        HBox rangeTab = new HBox();
        GridPane rangeGrid = new GridPane();
        rangeGrid.setPadding(new Insets(20.0, 0.0, 0.0, 0.0));
        ToggleGroup group = new ToggleGroup();
        this.all = new RadioButton("All");
        this.all.setSelected(true);
        this.all.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (arg2.booleanValue()) {
                    PrintPanelFX.this.allStateChanged();
                }
            }
        });
        this.all.setToggleGroup(group);
        this.currentView = new RadioButton("Current View");
        this.currentView.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (arg2.booleanValue()) {
                    PrintPanelFX.this.printRangeCurrentView();
                }
            }
        });
        this.currentView.setToggleGroup(group);
        this.currentPage = new RadioButton("Current Page");
        this.currentPage.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (arg2.booleanValue()) {
                    PrintPanelFX.this.currentPageStateChanged();
                }
            }
        });
        this.currentPage.setToggleGroup(group);
        this.pagesFrom = new RadioButton("Pages From:");
        this.pagesFrom.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (arg2.booleanValue()) {
                    PrintPanelFX.this.pagesFromStateChanged();
                }
            }
        });
        this.pagesFrom.setToggleGroup(group);
        this.numberFrom = new TextField();
        this.numberFrom.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue.matches("\\d*")) {
                    PrintPanelFX.this.numberFrom.setText(newValue);
                } else {
                    PrintPanelFX.this.numberFrom.setText(oldValue);
                }
            }
        });
        this.numberFrom.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (!arg2.booleanValue()) {
                    int page = 1;
                    if (!PrintPanelFX.this.numberFrom.getText().isEmpty()) {
                        page = Integer.parseInt(PrintPanelFX.this.numberFrom.getText());
                    }
                    if (page > PrintPanelFX.this.pdf.getPageCount()) {
                        page = PrintPanelFX.this.pdf.getPageCount();
                    }
                    PrintPanelFX.this.numberFrom.setText(String.valueOf(page));
                } else {
                    PrintPanelFX.this.pagesBoxPressed();
                }
            }
        });
        this.numberTo = new TextField();
        this.numberTo.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue.matches("\\d*")) {
                    PrintPanelFX.this.numberTo.setText(newValue);
                } else {
                    PrintPanelFX.this.numberTo.setText(oldValue);
                }
            }
        });
        this.numberTo.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (!arg2.booleanValue()) {
                    int page = PrintPanelFX.this.pdf.getPageCount();
                    if (!PrintPanelFX.this.numberTo.getText().isEmpty()) {
                        page = Integer.parseInt(PrintPanelFX.this.numberTo.getText());
                    }
                    if (page > PrintPanelFX.this.pdf.getPageCount()) {
                        page = PrintPanelFX.this.pdf.getPageCount();
                    }
                    PrintPanelFX.this.numberTo.setText(String.valueOf(page));
                } else {
                    PrintPanelFX.this.pagesBoxPressed();
                }
            }
        });
        this.subSet = new ComboBox();
        this.subSet.setItems(FXCollections.observableArrayList((Object[])new String[]{Messages.getMessage("PdfViewerPrint.AllPagesInRange"), Messages.getMessage("PdfViewerPrint.OddPagesOnly"), Messages.getMessage("PdfViewerPrint.EvenPagesOnly")}));
        this.reverse = new CheckBox();
        this.reverse.setText(Messages.getMessage("PdfViewerPrint.ReversePages"));
        Label subset = new Label();
        subset.setText(Messages.getMessage("PdfViewerPrint.Subset"));
        rangeGrid.setVgap(6.0);
        rangeGrid.add((Node)this.all, 0, 0);
        rangeGrid.add((Node)this.currentView, 0, 1);
        rangeGrid.add((Node)this.currentPage, 0, 2);
        rangeGrid.add((Node)this.pagesFrom, 0, 3);
        rangeGrid.add((Node)this.numberFrom, 1, 3);
        rangeGrid.add((Node)new Label(" to "), 2, 3);
        rangeGrid.add((Node)this.numberTo, 3, 3);
        rangeGrid.add((Node)subset, 0, 4);
        rangeGrid.add((Node)this.subSet, 1, 4);
        rangeGrid.add((Node)this.reverse, 0, 5);
        rangeTab.getChildren().add((Object)rangeGrid);
        this.tabs.getTabs().add((Object)this.range);
        this.range.setContent((Node)rangeTab);
    }

    private void initHandlingTab() {
        HBox handlingTab = new HBox();
        GridPane handlingGrid = new GridPane();
        handlingGrid.setPadding(new Insets(20.0, 0.0, 0.0, 0.0));
        this.copies = new TextField();
        this.copies.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue.matches("\\d*")) {
                    PrintPanelFX.this.copies.setText(newValue);
                } else {
                    PrintPanelFX.this.copies.setText(oldValue);
                }
            }
        });
        this.scaling = new ComboBox();
        this.scaling.setItems(FXCollections.observableArrayList((Object[])PrinterOptions.PRINT_SCALING_OPTIONS));
        this.scaling.getSelectionModel().select(PrinterOptions.LAST_SCALING_CHOICE);
        this.autoRotateCenter = new CheckBox();
        this.paperSourceByPDF = new CheckBox();
        this.grayscale = new CheckBox();
        Label copiesLabel = new Label();
        copiesLabel.setText(Messages.getMessage("PdfViewerPrint.Copies"));
        Label pageScaling = new Label();
        pageScaling.setText(Messages.getMessage("PdfViewerPrint.PageScaling"));
        this.autoRotateCenter.setText(Messages.getMessage("PdfViewerPrint.AutoRotateAndCenter"));
        this.paperSourceByPDF.setText(Messages.getMessage("PdfViewerPrint.ChoosePaperByPdfSize"));
        this.grayscale.setText(Messages.getMessage("PdfViewerPrint.Grayscale"));
        handlingGrid.setVgap(6.0);
        handlingGrid.add((Node)copiesLabel, 0, 0);
        handlingGrid.add((Node)this.copies, 1, 0);
        handlingGrid.add((Node)pageScaling, 0, 1);
        handlingGrid.add((Node)this.scaling, 1, 1);
        handlingGrid.add((Node)this.autoRotateCenter, 0, 2);
        handlingGrid.add((Node)this.paperSourceByPDF, 0, 3);
        handlingGrid.add((Node)this.grayscale, 0, 4);
        handlingTab.getChildren().add((Object)handlingGrid);
        this.tabs.getTabs().add((Object)this.handling);
        this.handling.setContent((Node)handlingTab);
    }

    @Override
    public void resetDefaults(String[] printersList, String defaultPrinter, int pageCount, int currentPage) {
        this.printersList = printersList;
        this.pageCount = pageCount;
        this.currentPageNo = currentPage;
        this.initComponents();
        String printerFlag = System.getProperty("org.jpedal.defaultPrinter");
        if (printerFlag != null) {
            for (String aPrintersList : printersList) {
                if (!printerFlag.equals(aPrintersList)) continue;
                this.printers.getSelectionModel().select((Object)aPrintersList);
            }
        } else {
            this.printers.getSelectionModel().select((Object)defaultPrinter);
        }
        if (this.pagesOptions.getItems().isEmpty()) {
            return;
        }
        int defaultPagesize = this.paperDefinitions.getDefaultPageIndex();
        if (defaultPagesize < this.pagesOptions.getItems().size()) {
            this.pagesOptions.getSelectionModel().select(defaultPagesize);
        }
        this.numberFrom.setText("1");
        this.numberTo.setText(String.valueOf(this.pdf.getPageCount()));
        this.subSet.getSelectionModel().select(0);
        this.copies.setText("1");
        if (DevFlags.testing) {
            this.printers.getSelectionModel().select((Object)"Zan Image Printer(color)");
        }
    }

    private void initComponents() {
        this.setupStage();
        this.setupTabs();
    }

    private static String[] getAvailableResolutions(PrintService p) {
        PrinterResolution[] resolutions = (PrinterResolution[])p.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (resolutions == null) {
            return new String[]{"Default"};
        }
        String[] names = new String[resolutions.length];
        for (int i = 0; i < resolutions.length; ++i) {
            PrinterResolution res = resolutions[i];
            names[i] = res.getCrossFeedResolution(100) + "x" + res.getFeedResolution(100) + " dpi";
        }
        return names;
    }

    @Override
    public PrinterResolution getResolution() {
        PrintService[] ps = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService p = null;
        for (PrintService p1 : ps) {
            if (!p1.getName().equals(this.printers.getSelectionModel().getSelectedItem())) continue;
            p = p1;
        }
        PrinterResolution[] resolutions = (PrinterResolution[])p.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (resolutions == null) {
            return null;
        }
        return resolutions[this.resolutionOptions.getSelectionModel().getSelectedIndex()];
    }

    private int getDefaultResolutionIndex() {
        PrintService[] ps = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService p = null;
        for (PrintService p1 : ps) {
            if (!p1.getName().equals(this.printers.getSelectionModel().getSelectedItem())) continue;
            p = p1;
        }
        PrinterResolution[] resolutions = (PrinterResolution[])p.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (resolutions == null) {
            return 0;
        }
        if (this.defaultResolution == -1) {
            this.defaultResolution = 600;
        }
        int minDiff = Integer.MAX_VALUE;
        int indexToUse = 0;
        for (int i = 0; i < resolutions.length; ++i) {
            int fDiff;
            PrinterResolution res = resolutions[i];
            int cfDiff = res.getCrossFeedResolution(100) - this.defaultResolution;
            if (cfDiff < 0) {
                cfDiff = -cfDiff;
            }
            if ((fDiff = res.getFeedResolution(100) - this.defaultResolution) < 0) {
                fDiff = -fDiff;
            }
            if (cfDiff + fDiff >= minDiff) continue;
            minDiff = cfDiff + fDiff;
            indexToUse = i;
        }
        return indexToUse;
    }

    private void updateMargins() {
        this.df.setMinimumFractionDigits(1);
        MarginPaper p = this.getSelectedPaper();
        if (p == null) {
            return;
        }
        this.minimumMargins[0] = p.getMinX() * 0.35277777777777775;
        this.minimumMargins[1] = p.getMinY() * 0.35277777777777775;
        this.minimumMargins[2] = (p.getWidth() - p.getMaxRX()) * 0.35277777777777775;
        this.minimumMargins[3] = (p.getHeight() - p.getMaxBY()) * 0.35277777777777775;
        this.leftT.setText(this.df.format(this.minimumMargins[0]));
        this.margins[0] = Float.parseFloat(this.leftT.getText());
        this.topT.setText(this.df.format(this.minimumMargins[1]));
        this.margins[1] = Float.parseFloat(this.topT.getText());
        this.rightT.setText(this.df.format(this.minimumMargins[2]));
        this.margins[2] = Float.parseFloat(this.rightT.getText());
        this.bottomT.setText(this.df.format(this.minimumMargins[3]));
        this.margins[3] = Float.parseFloat(this.bottomT.getText());
    }

    private void pagesBoxPressed() {
        this.pagesFrom.setSelected(true);
        this.subSet.setDisable(false);
        this.reverse.setDisable(false);
    }

    private void pagesFromStateChanged() {
        if (this.pagesFrom.isSelected()) {
            this.subSet.setDisable(false);
            this.reverse.setDisable(false);
        }
    }

    private void printRangeCurrentView() {
        if (this.currentView.isSelected()) {
            this.subSet.setDisable(true);
            this.reverse.setDisable(true);
        }
    }

    private void currentPageStateChanged() {
        if (this.currentPage.isSelected()) {
            this.subSet.setDisable(true);
            this.reverse.setDisable(true);
        }
    }

    private void allStateChanged() {
        if (this.all.isSelected()) {
            this.subSet.setDisable(false);
            this.reverse.setDisable(false);
        }
    }

    private void cancelEvent() {
        this.okClicked = false;
        this.setVisible(false);
        this.printPopup.close();
    }

    private void okEvent() {
        this.okClicked = true;
        this.setVisible(false);
        this.printPopup.close();
    }

    @Override
    public SetOfIntegerSyntax getPrintRange() {
        PageRanges pageRange = null;
        if (this.all.isSelected()) {
            pageRange = new PageRanges(1, this.pageCount);
            if (this.subSet.getSelectionModel().getSelectedIndex() == 0) {
                return pageRange;
            }
            if (this.subSet.getSelectionModel().getSelectedIndex() == 1) {
                StringBuilder membersStr = new StringBuilder();
                int i = -1;
                while ((i = pageRange.next(i)) != -1) {
                    if (i % 2 != 1) continue;
                    membersStr.append(i).append(',');
                }
                String members = membersStr.toString();
                StringBuilder sb = new StringBuilder(members);
                sb.deleteCharAt(members.length() - 1);
                members = sb.toString();
                pageRange = new PageRanges(members);
            } else if (this.subSet.getSelectionModel().getSelectedIndex() == 2) {
                StringBuilder membersStr = new StringBuilder();
                int i = -1;
                while ((i = pageRange.next(i)) != -1) {
                    if (i % 2 != 0) continue;
                    membersStr.append(i).append(',');
                }
                String members = membersStr.toString();
                StringBuilder sb = new StringBuilder(members);
                sb.deleteCharAt(members.length() - 1);
                members = sb.toString();
                pageRange = new PageRanges(members);
            }
        } else if (this.currentPage.isSelected()) {
            pageRange = new PageRanges(this.currentPageNo);
        } else if (this.currentView.isSelected()) {
            pageRange = new PageRanges(this.currentPageNo);
        } else if (this.pagesFrom.isSelected()) {
            int end;
            int start;
            try {
                start = Integer.parseInt(this.numberFrom.getText());
            }
            catch (NumberFormatException e) {
                LogWriter.writeLog("Exception in setting page range " + e);
                this.numberFrom.setText("1");
                start = 1;
            }
            try {
                end = Integer.parseInt(this.numberTo.getText());
            }
            catch (NumberFormatException e) {
                LogWriter.writeLog("Exception in setting page range " + e);
                this.numberTo.setText(String.valueOf(this.pageCount));
                end = this.pageCount;
            }
            if (start < 0) {
                start = 1;
                this.pagesFrom.setText("1");
            } else if (start > this.pageCount) {
                start = this.pageCount;
                this.pagesFrom.setText(String.valueOf(this.pageCount));
            }
            if (end < 0) {
                end = 1;
                this.numberTo.setText("1");
            } else if (end > this.pageCount) {
                end = this.pageCount;
                this.numberTo.setText(String.valueOf(this.pageCount));
            }
            if (start > end) {
                int tmp = end;
                end = start;
                start = tmp;
            }
            pageRange = new PageRanges(start, end);
            if (this.subSet.getSelectionModel().getSelectedIndex() == 0) {
                return pageRange;
            }
            if (this.subSet.getSelectionModel().getSelectedIndex() == 1) {
                StringBuilder membersStr = new StringBuilder();
                int i = -1;
                while ((i = pageRange.next(i)) != -1) {
                    if (i % 2 != 1) continue;
                    membersStr.append(i).append(',');
                }
                String members = membersStr.toString();
                StringBuilder sb = new StringBuilder(members);
                if (members.isEmpty()) {
                    return null;
                }
                sb.deleteCharAt(members.length() - 1);
                members = sb.toString();
                pageRange = new PageRanges(members);
            } else if (this.subSet.getSelectionModel().getSelectedIndex() == 2) {
                StringBuilder membersStr = new StringBuilder();
                int i = -1;
                while ((i = pageRange.next(i)) != -1) {
                    if (i % 2 != 0) continue;
                    membersStr.append(i).append(',');
                }
                String members = membersStr.toString();
                StringBuilder sb = new StringBuilder(members);
                int length = members.length();
                if (length > 0) {
                    sb.deleteCharAt(length - 1);
                }
                pageRange = !(members = sb.toString()).isEmpty() ? new PageRanges(members) : null;
            }
        }
        return pageRange;
    }

    @Override
    public int getCopies() {
        String copies = this.copies.getText();
        return Integer.parseInt(copies);
    }

    @Override
    public int getPageScaling() {
        int option = this.scaling.getSelectionModel().getSelectedIndex();
        int value = 0;
        switch (option) {
            case 0: {
                value = 0;
                break;
            }
            case 1: {
                value = 1;
                break;
            }
            case 2: {
                value = 2;
            }
        }
        PrinterOptions.LAST_SCALING_CHOICE = value;
        return value;
    }

    @Override
    public String getPrinter() {
        if (this.printers == null) {
            return "";
        }
        if (this.printers.getSelectionModel().getSelectedItem() == null) {
            return "";
        }
        return (String)this.printers.getSelectionModel().getSelectedItem();
    }

    @Override
    public boolean okClicked() {
        return this.okClicked;
    }

    @Override
    public boolean isAutoRotateAndCenter() {
        return this.autoRotateCenter.isSelected();
    }

    @Override
    public boolean isPaperSourceByPDFSize() {
        return this.paperSourceByPDF.isSelected();
    }

    @Override
    public boolean isPrintingCurrentView() {
        return this.currentView.isSelected();
    }

    @Override
    public String[] getAvailablePaperSizes() {
        return this.paperDefinitions.getAvailablePaperSizes();
    }

    @Override
    public MarginPaper getSelectedPaper() {
        return this.paperDefinitions.getSelectedPaper(this.pagesOptions.getSelectionModel().getSelectedItem());
    }

    @Override
    public int getSelectedPrinterOrientation() {
        return this.paperDefinitions.getDefaultPageOrientation();
    }

    @Override
    public boolean isPagesReversed() {
        return this.reverse.isSelected();
    }

    @Override
    public boolean isOddPagesOnly() {
        return this.subSet.getSelectionModel().getSelectedIndex() == 1;
    }

    @Override
    public boolean isEvenPagesOnly() {
        return this.subSet.getSelectionModel().getSelectedIndex() == 2;
    }

    @Override
    public boolean isMonochrome() {
        return this.grayscale.isSelected();
    }

    public float[] getMargins() {
        return this.margins;
    }
}

