/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jpedal.display.GUIDisplay;
import org.jpedal.examples.viewer.gui.CheckNode;
import org.jpedal.examples.viewer.gui.CheckRenderer;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.utils.Printer;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.Speech;
import org.jpedal.objects.javascript.DefaultParser;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.JavaFXHelper;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;
import org.mozilla.javascript.ScriptRuntime;
import org.w3c.dom.NodeList;

public class SwingProperties
extends JPanel {
    private final int TRUE_HASH = "true".hashCode();
    final Speech speech;
    final Map reverseMessage = new HashMap();
    final String[] menuTabs = new String[]{"ShowMenubar", "ShowButtons", "ShowDisplayoptions", "ShowNavigationbar", "ShowSidetabbar"};
    String propertiesLocation = "";
    PropertiesFile properties;
    JDialog propertiesDialog;
    final JButton confirm = new JButton("OK");
    final JButton cancel = new JButton("Cancel");
    JTabbedPane tabs = new JTabbedPane();
    JTextField resolution;
    JComboBox searchStyle;
    JCheckBox liveSearchResuts;
    JCheckBox border;
    JCheckBox HiResPrint;
    JCheckBox constantTabs;
    JCheckBox enhancedViewer;
    JCheckBox enhanceFractionalLines;
    JCheckBox enhancedFacing;
    JCheckBox thumbnailScroll;
    JCheckBox rightClick;
    JCheckBox scrollwheelZoom;
    final JCheckBox update = new JCheckBox(Messages.getMessage("PdfPreferences.CheckForUpdate"));
    JTextField maxMultiViewers;
    JTextField pageInsets;
    JLabel pageInsetsText;
    JTextField windowTitle;
    JLabel windowTitleText;
    JTextField iconLocation;
    JLabel iconLocationText;
    JTextField printerBlacklist;
    JLabel printerBlacklistText;
    JComboBox defaultPrinter;
    JLabel defaultPrinterText;
    JComboBox defaultPagesize;
    JLabel defaultPagesizeText;
    JTextField defaultDPI;
    JLabel defaultDPIText;
    JTextField sideTabLength;
    JLabel sideTabLengthText;
    JCheckBox useHinting;
    JCheckBox autoScroll;
    JCheckBox confirmClose;
    JCheckBox openLastDoc;
    JComboBox pageLayout = new JComboBox<String>(new String[]{"Single Page", "Continuous", "Continuous Facing", "Facing", "PageFlow"});
    JComboBox voiceSelect;
    final JPanel highlightBoxColor = new JPanel();
    final JPanel viewBGColor = new JPanel();
    final JPanel pdfDecoderBackground = new JPanel();
    final JPanel foreGroundColor = new JPanel();
    final JCheckBox invertHighlight = new JCheckBox("Highlight Inverts Page");
    final JCheckBox replaceDocTextCol = new JCheckBox("Replace Document Text Colors");
    final JCheckBox replaceDisplayBGCol = new JCheckBox("Replace Display Background Color");
    final JCheckBox changeTextAndLineArt = new JCheckBox("Change Color of Text and Line art");
    final JCheckBox showMouseSelectionBox = new JCheckBox("Show Mouse Selection Box");
    final JTextField highlightComposite = new JTextField(String.valueOf(DecoderOptions.highlightComposite));
    private boolean preferencesSetup;
    private JButton clearHistory;
    private JLabel historyClearedLabel;
    final KeyListener numericalKeyListener = new KeyListener(){
        boolean consume;

        @Override
        public void keyPressed(KeyEvent e) {
            this.consume = !(e.getKeyChar() >= '0' && e.getKeyChar() <= '9' || e.getKeyCode() == 8 && e.getKeyCode() == 127);
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (this.consume) {
                e.consume();
            }
        }
    };

    private void loadBooleanValue(JCheckBox comp, String elementName) {
        String value = this.properties.getValue(elementName).toLowerCase();
        comp.setSelected(!value.isEmpty() && value.hashCode() == this.TRUE_HASH);
    }

    private void loadBooleanValue(CheckNode comp, String elementName) {
        String value = this.properties.getValue(elementName).toLowerCase();
        comp.setSelected(!value.isEmpty() && value.hashCode() == this.TRUE_HASH);
    }

    private void loadStringValue(JTextField comp, String elementName) {
        String propValue = this.properties.getValue(elementName);
        if (propValue != null && !propValue.isEmpty()) {
            comp.setText(propValue);
        }
    }

    private void loadStringValue(JTextField comp, String elementName, String defaultText) {
        String propValue = this.properties.getValue(elementName);
        if (propValue != null && !propValue.isEmpty()) {
            comp.setText(propValue);
        } else {
            comp.setText(defaultText);
        }
    }

    public SwingProperties(GUIFactory currentGUI) {
        this.speech = (Speech)currentGUI.getPdfDecoder().getExternalHandler(32);
        this.showPreferenceWindow(currentGUI);
    }

    private void showPreferenceWindow(GUIFactory currentGUI) {
        this.propertiesDialog = currentGUI.getFrame() instanceof JFrame ? new JDialog((JFrame)currentGUI.getFrame()) : new JDialog();
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setDefaultCloseOperation(2);
        if (!this.preferencesSetup) {
            this.preferencesSetup = true;
            this.createPreferenceWindow(currentGUI);
        }
        if (this.properties.getValue("readOnly").equalsIgnoreCase("true")) {
            JOptionPane.showMessageDialog(this, "You do not have permission alter jPedal properties.\nAccess to the properties window has therefore been disabled.", "Can not write to properties file", 1);
        }
        if (this.properties.isReadOnly()) {
            JOptionPane.showMessageDialog(this, "Current properties file is read only.\nAny alteration can only be saved as another properties file.", "Properties file is read only", 1);
            this.confirm.setEnabled(false);
        } else {
            this.confirm.setEnabled(true);
        }
        this.propertiesDialog.setLocationRelativeTo((Container)currentGUI.getFrame());
        this.propertiesDialog.setVisible(true);
    }

    private void saveGUIPreferences(GUIFactory gui) {
        Component[] components = this.tabs.getComponents();
        for (int i = 0; i != components.length; ++i) {
            if (!(components[i] instanceof JPanel)) continue;
            Component[] panelComponets = ((JPanel)components[i]).getComponents();
            for (int j = 0; j != panelComponets.length; ++j) {
                if (panelComponets[j] instanceof JScrollPane) {
                    Component[] scrollComponents = ((JScrollPane)panelComponets[j]).getComponents();
                    for (int k = 0; k != scrollComponents.length; ++k) {
                        if (!(scrollComponents[k] instanceof JViewport)) continue;
                        Component[] viewportComponents = ((JViewport)scrollComponents[k]).getComponents();
                        for (int l = 0; l != viewportComponents.length; ++l) {
                            JTree tree;
                            CheckNode root;
                            if (!(viewportComponents[l] instanceof JTree) || (root = (CheckNode)(tree = (JTree)viewportComponents[l]).getModel().getRoot()).getChildCount() <= 0) continue;
                            this.saveMenuPreferencesChildren(root, gui);
                        }
                    }
                }
                if (!(panelComponets[j] instanceof JButton)) continue;
                JButton tempButton = (JButton)panelComponets[j];
                String value = (String)this.reverseMessage.get(tempButton.getText().substring((Messages.getMessage("PdfCustomGui.HideGuiSection") + ' ').length()));
                if (tempButton.getText().startsWith(Messages.getMessage("PdfCustomGui.HideGuiSection") + ' ')) {
                    this.properties.setValue(value, "true");
                    gui.alterProperty(value, true);
                    continue;
                }
                this.properties.setValue(value, "false");
                gui.alterProperty(value, false);
            }
        }
    }

    private void saveMenuPreferencesChildren(CheckNode root, GUIFactory gui) {
        for (int i = 0; i != root.getChildCount(); ++i) {
            CheckNode node = (CheckNode)root.getChildAt(i);
            String value = (String)this.reverseMessage.get(node.getText());
            if (node.isSelected()) {
                this.properties.setValue(value, "true");
                gui.alterProperty(value, true);
            } else {
                this.properties.setValue(value, "false");
                gui.alterProperty(value, false);
            }
            if (node.getChildCount() <= 0) continue;
            this.saveMenuPreferencesChildren(node, gui);
        }
    }

    private void createPreferenceWindow(final GUIFactory gui) {
        this.properties = gui.getProperties();
        this.propertiesLocation = gui.getPropertiesFileLocation();
        this.propertiesDialog.setTitle(Messages.getMessage("PdfPreferences.windowTitle"));
        this.update.setToolTipText(Messages.getMessage("PdfPreferences.update.toolTip"));
        this.invertHighlight.setText(Messages.getMessage("PdfPreferences.InvertHighlight"));
        this.showMouseSelectionBox.setText(Messages.getMessage("PdfPreferences.ShowSelectionBow"));
        this.invertHighlight.setToolTipText(Messages.getMessage("PdfPreferences.invertHighlight.toolTip"));
        this.showMouseSelectionBox.setToolTipText(Messages.getMessage("PdfPreferences.showMouseSelection.toolTip"));
        this.highlightBoxColor.setToolTipText(Messages.getMessage("PdfPreferences.highlightBox.toolTip"));
        this.resolution = new JTextField();
        this.loadStringValue(this.resolution, "resolution", "72");
        this.resolution.setToolTipText(Messages.getMessage("PdfPreferences.resolutionInput.toolTip"));
        this.maxMultiViewers = new JTextField();
        this.loadStringValue(this.maxMultiViewers, "maxmultiviewers", "20");
        this.maxMultiViewers.setToolTipText(Messages.getMessage("PdfPreferences.maxMultiViewer.toolTip"));
        this.searchStyle = gui.isSingle() ? new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.WindowSearch"), Messages.getMessage("PageLayoutViewMenu.TabbedSearch"), Messages.getMessage("PageLayoutViewMenu.MenuSearch")}) : new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.WindowSearch"), Messages.getMessage("PageLayoutViewMenu.TabbedSearch")});
        this.searchStyle.setToolTipText(Messages.getMessage("PdfPreferences.searchStyle.toolTip"));
        this.liveSearchResuts = new JCheckBox(Messages.getMessage("PageLayoutViewMenu.LiveSearchResults"));
        this.liveSearchResuts.setToolTipText(Messages.getMessage("PdfPreferences.LiveSearchResults.toolTip"));
        this.pageLayout = new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.SinglePage"), Messages.getMessage("PageLayoutViewMenu.Continuous"), Messages.getMessage("PageLayoutViewMenu.ContinousFacing"), Messages.getMessage("PageLayoutViewMenu.Facing"), Messages.getMessage("PageLayoutViewMenu.PageFlow")});
        this.pageLayout.setToolTipText(Messages.getMessage("PdfPreferences.pageLayout.toolTip"));
        this.pageInsetsText = new JLabel(Messages.getMessage("PdfViewerViewMenu.pageInsets"));
        this.pageInsets = new JTextField();
        this.pageInsets.setToolTipText(Messages.getMessage("PdfPreferences.pageInsets.toolTip"));
        this.windowTitleText = new JLabel(Messages.getMessage("PdfCustomGui.windowTitle"));
        this.windowTitle = new JTextField();
        this.windowTitle.setToolTipText(Messages.getMessage("PdfPreferences.windowTitle.toolTip"));
        this.iconLocationText = new JLabel(Messages.getMessage("PdfViewerViewMenu.iconLocation"));
        this.iconLocation = new JTextField();
        this.iconLocation.setToolTipText(Messages.getMessage("PdfPreferences.iconLocation.toolTip"));
        this.printerBlacklistText = new JLabel(Messages.getMessage("PdfViewerPrint.blacklist"));
        this.printerBlacklist = new JTextField();
        this.printerBlacklist.setToolTipText(Messages.getMessage("PdfPreferences.printerBlackList.toolTip"));
        this.defaultPrinterText = new JLabel(Messages.getMessage("PdfViewerPrint.defaultPrinter"));
        this.defaultPrinter = new JComboBox<String>(Printer.getAvailablePrinters(this.properties.getValue("printerBlacklist")));
        PrintService defaultPrintService = PrintServiceLookup.lookupDefaultPrintService();
        if (defaultPrintService != null) {
            this.defaultPrinter.addItem(Messages.getMessage("PdfPreferences.systemDefault.text") + " (" + defaultPrintService.getName() + ')');
        } else {
            this.defaultPrinter.addItem(Messages.getMessage("PdfPreferences.systemDefault.text"));
        }
        this.defaultPrinter.setToolTipText(Messages.getMessage("PdfPreferences.defaultPrinter.toolTip"));
        this.defaultPagesizeText = new JLabel(Messages.getMessage("PdfViewerPrint.defaultPagesize"));
        this.defaultPagesize = new JComboBox();
        this.defaultPagesize.setModel(new DefaultComboBoxModel<String>(gui.getPaperSizes().getPaperSizes()));
        this.defaultPagesize.setSelectedIndex(gui.getPaperSizes().getDefaultPageIndex());
        this.defaultPagesize.setToolTipText(Messages.getMessage("PdfPreferences.defaultPageSize.toolTip"));
        this.defaultDPIText = new JLabel(Messages.getMessage("PdfViewerPrint.defaultDPI"));
        this.defaultDPI = new JTextField();
        this.defaultDPI.setToolTipText(Messages.getMessage("PdfPreferences.defaultDPI.toolTip"));
        this.sideTabLengthText = new JLabel(Messages.getMessage("PdfCustomGui.SideTabLength"));
        this.sideTabLength = new JTextField();
        this.sideTabLength.setToolTipText(Messages.getMessage("PdfPreferences.sideTabLength.toolTip"));
        this.useHinting = new JCheckBox(Messages.getMessage("PdfCustomGui.useHinting"));
        this.useHinting.setToolTipText(Messages.getMessage("PdfPreferences.useHinting.toolTip"));
        this.autoScroll = new JCheckBox(Messages.getMessage("PdfViewerViewMenuAutoscrollSet.text"));
        this.autoScroll.setToolTipText("Set if autoscroll should be enabled / disabled");
        this.confirmClose = new JCheckBox(Messages.getMessage("PfdViewerViewMenuConfirmClose.text"));
        this.confirmClose.setToolTipText("Set if we should confirm closing the viewer");
        this.openLastDoc = new JCheckBox(Messages.getMessage("PdfViewerViewMenuOpenLastDoc.text"));
        this.openLastDoc.setToolTipText("Set if last document should be opened upon start up");
        this.border = new JCheckBox(Messages.getMessage("PageLayoutViewMenu.Borders_Show"));
        this.border.setToolTipText("Set if we should display a border for the page");
        this.HiResPrint = new JCheckBox(Messages.getMessage("Printing.HiRes"));
        this.HiResPrint.setToolTipText("Set if hi res printing should be enabled / disabled");
        this.constantTabs = new JCheckBox(Messages.getMessage("PdfCustomGui.consistentTabs"));
        this.constantTabs.setToolTipText("Set to keep sidetabs consistant between files");
        this.enhancedViewer = new JCheckBox(Messages.getMessage("PdfCustomGui.enhancedViewer"));
        this.enhancedViewer.setToolTipText("Set to use enahnced viewer mode");
        this.enhanceFractionalLines = new JCheckBox(Messages.getMessage("PdfCustomGui.enhanceFractionalLines"));
        this.enhanceFractionalLines.setToolTipText("Set to widen thin lines to ensure visiblity at any scaling");
        this.enhancedFacing = new JCheckBox(Messages.getMessage("PdfCustomGui.enhancedFacing"));
        this.enhancedFacing.setToolTipText("Set to turn facing mode to page turn mode");
        this.thumbnailScroll = new JCheckBox(Messages.getMessage("PdfCustomGui.thumbnailScroll"));
        this.thumbnailScroll.setToolTipText("Set to show thumbnail whilst scrolling");
        this.rightClick = new JCheckBox(Messages.getMessage("PdfCustomGui.allowRightClick"));
        this.rightClick.setToolTipText("Set to enable / disable the right click functionality");
        this.scrollwheelZoom = new JCheckBox(Messages.getMessage("PdfCustomGui.allowScrollwheelZoom"));
        this.scrollwheelZoom.setToolTipText("Set to enable zooming when scrolling with ctrl pressed");
        this.historyClearedLabel = new JLabel(Messages.getMessage("PageLayoutViewMenu.HistoryCleared"));
        this.historyClearedLabel.setForeground(Color.red);
        this.historyClearedLabel.setVisible(false);
        this.clearHistory = new JButton(Messages.getMessage("PageLayoutViewMenu.ClearHistory"));
        this.clearHistory.setToolTipText("Clears the history of previous files");
        this.clearHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                gui.getRecentDocument().clearRecentDocuments(gui.getProperties());
                SwingWorker searcher = new SwingWorker(){

                    @Override
                    public Object construct() {
                        for (int i = 0; i < 6; ++i) {
                            SwingProperties.this.historyClearedLabel.setVisible(!SwingProperties.this.historyClearedLabel.isVisible());
                            try {
                                Thread.sleep(300L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                LogWriter.writeLog("Exception " + e);
                            }
                        }
                        return null;
                    }
                };
                searcher.start();
            }
        });
        JButton save = new JButton(Messages.getMessage("PdfPreferences.SaveAs"));
        save.setToolTipText("Save preferences in a new file");
        JButton reset = new JButton(Messages.getMessage("PdfPreferences.ResetToDefault"));
        reset.setToolTipText("Reset  and save preferences to program defaults");
        this.propertiesDialog.getContentPane().setLayout(new BorderLayout());
        this.propertiesDialog.getContentPane().add((Component)this, "Center");
        this.propertiesDialog.pack();
        if (DecoderOptions.isRunningOnMac) {
            this.propertiesDialog.setSize(600, 475);
        } else {
            this.propertiesDialog.setSize(550, 450);
        }
        this.confirm.setText(Messages.getMessage("PdfPreferences.OK"));
        this.cancel.setText(Messages.getMessage("PdfPreferences.Cancel"));
        this.confirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingProperties.this.setPreferences(gui);
                try {
                    SwingProperties.this.properties.writeDoc();
                }
                catch (Exception e) {
                    LogWriter.writeLog("Attempting to write properties " + e);
                }
                if (GUI.showMessages) {
                    JOptionPane.showMessageDialog(null, Messages.getMessage("PdfPreferences.savedTo") + SwingProperties.this.propertiesLocation + '\n' + Messages.getMessage("PdfPreferences.restart"), "Restart Jpedal", 1);
                }
                SwingProperties.this.propertiesDialog.setVisible(false);
            }
        });
        this.confirm.setToolTipText("Save the preferences in the current loaded preferences file");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingProperties.this.propertiesDialog.setVisible(false);
            }
        });
        this.cancel.setToolTipText("Leave preferences window without saving changes");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String lastProperties = gui.getPropertiesFileLocation();
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return ".xml";
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getAbsolutePath().endsWith(".xml");
                    }
                });
                int i = fileChooser.showSaveDialog(SwingProperties.this.propertiesDialog);
                if (i != 1 && i != -1 && i == 0) {
                    String ext = fileChooser.getFileFilter().getDescription();
                    File f = fileChooser.getSelectedFile();
                    String name = fileChooser.getName(f);
                    if (!ext.equals("All Files") && !name.endsWith(ext)) {
                        name = name + ext;
                        f = new File(f.getParent() + System.getProperty("file.separator") + name);
                    }
                    if (f.exists()) {
                        f.delete();
                    }
                    gui.setPropertiesFileLocation(f.getAbsolutePath());
                    SwingProperties.this.setPreferences(gui);
                    try {
                        SwingProperties.this.properties.writeDoc();
                    }
                    catch (Exception e1) {
                        LogWriter.writeLog("Attempting to write properties " + e1);
                    }
                }
                gui.setPropertiesFileLocation(lastProperties);
            }
        });
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(SwingProperties.this.propertiesDialog, Messages.getMessage("PdfPreferences.reset"), "Reset to Default", 0);
                if (result == 0) {
                    String lastProperties = gui.getPropertiesFileLocation();
                    File f = new File(lastProperties);
                    if (f.exists()) {
                        f.delete();
                    }
                    gui.getProperties().loadProperties(lastProperties);
                    try {
                        SwingProperties.this.properties.writeDoc();
                    }
                    catch (Exception e2) {
                        LogWriter.writeLog("Attempting to write properties " + e2);
                    }
                    if (GUI.showMessages) {
                        JOptionPane.showMessageDialog(SwingProperties.this.propertiesDialog, Messages.getMessage("PdfPreferences.restart"));
                    }
                    SwingProperties.this.propertiesDialog.setVisible(false);
                }
            }
        });
        this.highlightComposite.addKeyListener(new KeyListener(){
            boolean consume;

            @Override
            public void keyPressed(KeyEvent e) {
                this.consume = !(!((JTextField)e.getSource()).getText().contains(".") || e.getKeyChar() != '.' || e.getKeyChar() >= '0' && e.getKeyChar() <= '9' || e.getKeyCode() == 8 && e.getKeyCode() == 127);
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (this.consume) {
                    e.consume();
                }
            }
        });
        this.highlightComposite.setToolTipText("Set the transparency of the highlight");
        this.resolution.addKeyListener(this.numericalKeyListener);
        this.maxMultiViewers.addKeyListener(this.numericalKeyListener);
        this.setLayout(new BorderLayout());
        JPanel toolbar = new JPanel();
        BoxLayout layout = new BoxLayout(toolbar, 1);
        toolbar.setLayout(layout);
        this.add((Component)new ButtonBarPanel(toolbar), "Center");
        toolbar.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.gray));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        Dimension dimension = new Dimension(5, 40);
        Box.Filler filler = new Box.Filler(dimension, dimension, dimension);
        this.confirm.setPreferredSize(this.cancel.getPreferredSize());
        if (this.properties.isReadOnly()) {
            this.confirm.setEnabled(false);
        } else {
            this.confirm.setEnabled(true);
        }
        buttonPanel.add(Box.createHorizontalStrut(4));
        buttonPanel.add(reset);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.confirm);
        buttonPanel.add(save);
        this.getRootPane().setDefaultButton(this.confirm);
        buttonPanel.add(filler);
        buttonPanel.add(this.cancel);
        buttonPanel.add(filler);
        buttonPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
        this.add((Component)buttonPanel, "South");
    }

    private void setPreferences(GUIFactory gui) {
        int borderStyle = 0;
        int pageMode = this.pageLayout.getSelectedIndex() + 1;
        if (pageMode < 1 || pageMode > 5) {
            pageMode = 1;
        }
        if (this.border.isSelected()) {
            borderStyle = 1;
        }
        this.properties.setValue("borderType", String.valueOf(borderStyle));
        this.properties.setValue("useHinting", String.valueOf(this.useHinting.isSelected()));
        this.properties.setValue("startView", String.valueOf(pageMode));
        this.properties.setValue("pageInsets", String.valueOf(this.pageInsets.getText()));
        this.properties.setValue("windowTitle", String.valueOf(this.windowTitle.getText()));
        String loc = this.iconLocation.getText();
        if (!loc.endsWith("/") && !loc.endsWith("\\")) {
            loc = loc + '/';
        }
        this.properties.setValue("iconLocation", String.valueOf(loc));
        this.properties.setValue("sideTabBarCollapseLength", String.valueOf(this.sideTabLength.getText()));
        this.properties.setValue("autoScroll", String.valueOf(this.autoScroll.isSelected()));
        this.properties.setValue("confirmClose", String.valueOf(this.confirmClose.isSelected()));
        this.properties.setValue("openLastDocument", String.valueOf(this.openLastDoc.isSelected()));
        this.properties.setValue("resolution", String.valueOf(this.resolution.getText()));
        this.properties.setValue("searchWindowType", String.valueOf(this.searchStyle.getSelectedIndex()));
        this.properties.setValue("updateResultsDuringSearch", String.valueOf(this.liveSearchResuts.isSelected()));
        this.properties.setValue("automaticupdate", String.valueOf(this.update.isSelected()));
        this.properties.setValue("maxmultiviewers", String.valueOf(this.maxMultiViewers.getText()));
        this.properties.setValue("useHiResPrinting", String.valueOf(this.HiResPrint.isSelected()));
        this.properties.setValue("consistentTabBar", String.valueOf(this.constantTabs.isSelected()));
        this.properties.setValue("highlightComposite", String.valueOf(this.highlightComposite.getText()));
        this.properties.setValue("highlightBoxColor", String.valueOf(this.highlightBoxColor.getBackground().getRGB()));
        this.properties.setValue("vbgColor", String.valueOf(this.viewBGColor.getBackground().getRGB()));
        this.properties.setValue("pdfDisplayBackground", String.valueOf(this.pdfDecoderBackground.getBackground().getRGB()));
        this.properties.setValue("vfgColor", String.valueOf(this.foreGroundColor.getBackground().getRGB()));
        this.properties.setValue("replaceDocumentTextColors", String.valueOf(this.replaceDocTextCol.isSelected()));
        this.properties.setValue("replacePdfDisplayBackground", String.valueOf(this.replaceDisplayBGCol.isSelected()));
        this.properties.setValue("changeTextAndLineart", String.valueOf(this.changeTextAndLineArt.isSelected()));
        this.properties.setValue("invertHighlights", String.valueOf(this.invertHighlight.isSelected()));
        this.properties.setValue("showMouseSelectionBox", String.valueOf(this.showMouseSelectionBox.isSelected()));
        this.properties.setValue("allowRightClick", String.valueOf(this.rightClick.isSelected()));
        this.properties.setValue("allowScrollwheelZoom", String.valueOf(this.scrollwheelZoom.isSelected()));
        this.properties.setValue("enhancedViewerMode", String.valueOf(this.enhancedViewer.isSelected()));
        this.properties.setValue("enhanceFractionalLines", String.valueOf(this.enhanceFractionalLines.isSelected()));
        this.properties.setValue("enhancedFacingMode", String.valueOf(this.enhancedFacing.isSelected()));
        this.properties.setValue("previewOnSingleScroll", String.valueOf(this.thumbnailScroll.isSelected()));
        this.properties.setValue("printerBlacklist", String.valueOf(this.printerBlacklist.getText()));
        if (((String)this.defaultPrinter.getSelectedItem()).startsWith("System Default")) {
            this.properties.setValue("defaultPrinter", "");
        } else {
            this.properties.setValue("defaultPrinter", String.valueOf(this.defaultPrinter.getSelectedItem()));
        }
        this.properties.setValue("defaultDPI", String.valueOf(this.defaultDPI.getText()));
        this.properties.setValue("defaultPagesize", String.valueOf(this.defaultPagesize.getSelectedItem()));
        if (this.speech != null) {
            this.properties.setValue("voice", String.valueOf(this.voiceSelect.getSelectedItem()));
        }
        this.saveGUIPreferences(gui);
    }

    class ButtonBarPanel
    extends JPanel {
        private Component currentComponent;

        ButtonBarPanel(JPanel toolbar) {
            this.setLayout(new BorderLayout());
            JScrollPane jsp = new JScrollPane();
            jsp.getViewport().add(toolbar);
            jsp.setHorizontalScrollBarPolicy(31);
            jsp.setVerticalScrollBarPolicy(22);
            this.add((Component)jsp, "West");
            ButtonGroup group = new ButtonGroup();
            this.addButton(Messages.getMessage("PdfPreferences.GeneralTitle"), "/org/jpedal/examples/viewer/res/display.png", this.createGeneralSettings(), toolbar, group);
            this.addButton(Messages.getMessage("PdfPreferences.PageDisplayTitle"), "/org/jpedal/examples/viewer/res/pagedisplay.png", this.createPageDisplaySettings(), toolbar, group);
            this.addButton(Messages.getMessage("PdfPreferences.InterfaceTitle"), "/org/jpedal/examples/viewer/res/interface.png", this.createInterfaceSettings(), toolbar, group);
            this.addButton(Messages.getMessage("PdfPreferences.ColorTitle"), "/org/jpedal/examples/viewer/res/color.png", this.createColorSettings(), toolbar, group);
            this.addButton(Messages.getMessage("PdfPreferences.MenuTitle"), "/org/jpedal/examples/viewer/res/menu.png", this.createMenuSettings(), toolbar, group);
            this.addButton(Messages.getMessage("PdfPreferences.PrintingTitle"), "/org/jpedal/examples/viewer/res/printing.png", this.createPrintingSettings(), toolbar, group);
            this.addButton(Messages.getMessage("PdfPreferences.ExtensionsTitle"), "/org/jpedal/examples/viewer/res/extensions.png", this.createExtensionsPane(), toolbar, group);
        }

        private JPanel makePanel(String title) {
            JPanel panel = new JPanel(new BorderLayout());
            JLabel topLeft = new JLabel(title);
            topLeft.setFont(topLeft.getFont().deriveFont(1));
            topLeft.setOpaque(true);
            topLeft.setBackground(panel.getBackground().brighter());
            JPanel topbar = new JPanel(new BorderLayout());
            topbar.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            topbar.setFont(topbar.getFont().deriveFont(1));
            topbar.setOpaque(true);
            topbar.setBackground(panel.getBackground().brighter());
            topbar.add((Component)topLeft, "West");
            panel.add((Component)topbar, "North");
            panel.setPreferredSize(new Dimension(400, 300));
            panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            return panel;
        }

        private JPanel createGeneralSettings() {
            SwingProperties.this.loadStringValue(SwingProperties.this.resolution, "resolution");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.useHinting, "useHinting");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.autoScroll, "autoScroll");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.confirmClose, "confirmClose");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.update, "automaticupdate");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.openLastDoc, "openLastDocument");
            JPanel panel = this.makePanel(Messages.getMessage("PdfPreferences.GeneralTitle"));
            JPanel pane = new JPanel();
            JScrollPane scroll = new JScrollPane(pane);
            scroll.setBorder(BorderFactory.createEmptyBorder());
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.insets = new Insets(5, 0, 0, 5);
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            c.gridy = 0;
            JLabel label = new JLabel(Messages.getMessage("PdfPreferences.GeneralSection"));
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label.setFont(label.getFont().deriveFont(1));
            pane.add((Component)label, c);
            ++c.gridy;
            c.insets = new Insets(10, 0, 0, 5);
            c.gridx = 0;
            JLabel label2 = new JLabel(Messages.getMessage("PdfViewerViewMenu.Resolution"));
            label2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)label2, c);
            c.insets = new Insets(10, 0, 0, 0);
            c.weightx = 1.0;
            c.gridx = 1;
            pane.add((Component)SwingProperties.this.resolution, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.useHinting.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.useHinting.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.useHinting, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.autoScroll.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.autoScroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.autoScroll, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.confirmClose.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.confirmClose.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.confirmClose, c);
            ++c.gridy;
            c.insets = new Insets(15, 0, 0, 5);
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            JLabel label3 = new JLabel(Messages.getMessage("PdfPreferences.StartUp"));
            label3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label3.setFont(label3.getFont().deriveFont(1));
            pane.add((Component)label3, c);
            ++c.gridy;
            c.insets = new Insets(10, 0, 0, 0);
            c.weighty = 0.0;
            c.weightx = 1.0;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.update.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.update.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.update, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.openLastDoc.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.openLastDoc.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.openLastDoc, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            JPanel clearHistoryPanel = new JPanel();
            clearHistoryPanel.setLayout(new BoxLayout(clearHistoryPanel, 0));
            clearHistoryPanel.add(SwingProperties.this.clearHistory);
            clearHistoryPanel.add(Box.createHorizontalGlue());
            clearHistoryPanel.add(SwingProperties.this.historyClearedLabel);
            clearHistoryPanel.add(Box.createHorizontalGlue());
            pane.add((Component)clearHistoryPanel, c);
            ++c.gridy;
            c.weighty = 1.0;
            c.gridx = 0;
            pane.add(Box.createVerticalGlue(), c);
            panel.add((Component)scroll, "Center");
            return panel;
        }

        private JPanel createPageDisplaySettings() {
            SwingProperties.this.loadBooleanValue(SwingProperties.this.enhancedViewer, "enhancedViewerMode");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.enhanceFractionalLines, "enhanceFractionalLines");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.border, "borderType");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.enhancedFacing, "enhancedFacingMode");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.thumbnailScroll, "previewOnSingleScroll");
            SwingProperties.this.loadStringValue(SwingProperties.this.pageInsets, "pageInsets", "25");
            String propValue = SwingProperties.this.properties.getValue("startView");
            if (!propValue.isEmpty()) {
                int mode = Integer.parseInt(propValue);
                if (mode < 1 || mode > 5) {
                    mode = 1;
                }
                SwingProperties.this.pageLayout.setSelectedIndex(mode - 1);
            }
            JPanel panel = this.makePanel(Messages.getMessage("PdfPreferences.PageDisplayTitle"));
            JPanel pane = new JPanel();
            JScrollPane scroll = new JScrollPane(pane);
            scroll.setBorder(BorderFactory.createEmptyBorder());
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.insets = new Insets(5, 0, 0, 5);
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            c.gridy = 0;
            JLabel label = new JLabel(Messages.getMessage("PdfPreferences.GeneralSection"));
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label.setFont(label.getFont().deriveFont(1));
            pane.add((Component)label, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.enhancedViewer.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.enhancedViewer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.enhancedViewer, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.enhanceFractionalLines.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.enhanceFractionalLines.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.enhanceFractionalLines, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.border.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.border.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.border, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 2;
            c.gridx = 0;
            pane.add((Component)SwingProperties.this.pageInsetsText, c);
            c.gridwidth = 2;
            c.gridx = 1;
            pane.add((Component)SwingProperties.this.pageInsets, c);
            ++c.gridy;
            c.insets = new Insets(15, 0, 0, 5);
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            JLabel label2 = new JLabel(Messages.getMessage("PdfPreferences.DisplayModes"));
            label2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label2.setFont(label2.getFont().deriveFont(1));
            pane.add((Component)label2, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 5);
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            JLabel label1 = new JLabel(Messages.getMessage("PageLayoutViewMenu.PageLayout"));
            label1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)label1, c);
            c.insets = new Insets(5, 0, 0, 0);
            c.weightx = 1.0;
            c.gridx = 1;
            pane.add((Component)SwingProperties.this.pageLayout, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.enhancedFacing.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.enhancedFacing.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.enhancedFacing, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.thumbnailScroll.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.thumbnailScroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.thumbnailScroll, c);
            ++c.gridy;
            c.weighty = 1.0;
            c.gridx = 0;
            pane.add(Box.createVerticalGlue(), c);
            panel.add((Component)scroll, "Center");
            return panel;
        }

        private void loadCreateInterfaceSettings() {
            SwingProperties.this.loadBooleanValue(SwingProperties.this.rightClick, "allowRightClick");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.scrollwheelZoom, "allowScrollwheelZoom");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.liveSearchResuts, "updateResultsDuringSearch");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.constantTabs, "consistentTabBar");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.showMouseSelectionBox, "showMouseSelectionBox");
            SwingProperties.this.loadStringValue(SwingProperties.this.windowTitle, "windowTitle");
            SwingProperties.this.loadStringValue(SwingProperties.this.maxMultiViewers, "maxmultiviewers");
            SwingProperties.this.loadStringValue(SwingProperties.this.iconLocation, "iconLocation", "/org/jpedal/examples/viewer/res/");
            SwingProperties.this.loadStringValue(SwingProperties.this.sideTabLength, "sideTabBarCollapseLength", "30");
            String propValue = SwingProperties.this.properties.getValue("searchWindowType");
            int index = 0;
            if (!propValue.isEmpty() && (index = Integer.parseInt(propValue)) >= SwingProperties.this.searchStyle.getItemCount()) {
                index = 0;
            }
            SwingProperties.this.searchStyle.setSelectedIndex(index);
        }

        private void setLayoutConstraints(GridBagConstraints constraints, Insets insets, int gridX, int gridY, int gridW, int gridH, int weightX, int weightY) {
            constraints.insets = insets;
            constraints.gridx = gridX;
            constraints.gridy = gridY;
            constraints.gridwidth = gridW;
            constraints.gridheight = gridH;
            constraints.weightx = weightX;
            constraints.weighty = weightY;
        }

        private JScrollPane createAppearanceTab() {
            JPanel contentPane = new JPanel();
            JScrollPane scrollPane = new JScrollPane(contentPane);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            contentPane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            int gridY = 0;
            this.setLayoutConstraints(c, new Insets(5, 5, 5, 5), 0, gridY, 1, 1, 0, 0);
            JLabel label = new JLabel(Messages.getMessage("PdfPreferences.GeneralTitle"));
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label.setFont(label.getFont().deriveFont(1));
            contentPane.add((Component)label, c);
            this.setLayoutConstraints(c, new Insets(3, 5, 0, 5), 0, ++gridY, 1, 1, 0, 0);
            contentPane.add((Component)SwingProperties.this.windowTitleText, c);
            this.setLayoutConstraints(c, new Insets(3, 5, 0, 5), 1, gridY, 1, 1, 0, 0);
            contentPane.add((Component)SwingProperties.this.windowTitle, c);
            this.setLayoutConstraints(c, new Insets(5, 5, 5, 5), 0, ++gridY, 1, 1, 0, 0);
            contentPane.add((Component)SwingProperties.this.iconLocationText, c);
            this.setLayoutConstraints(c, new Insets(5, 5, 5, 5), 1, gridY, 1, 1, 0, 0);
            contentPane.add((Component)SwingProperties.this.iconLocation, c);
            this.setLayoutConstraints(c, new Insets(5, 5, 5, 5), 0, ++gridY, 1, 1, 0, 0);
            JLabel label5 = new JLabel(Messages.getMessage("PageLayoutViewMenu.SearchLayout"));
            label5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            contentPane.add((Component)label5, c);
            this.setLayoutConstraints(c, new Insets(5, 5, 5, 5), 1, gridY, 1, 1, 1, 0);
            contentPane.add((Component)SwingProperties.this.searchStyle, c);
            this.setLayoutConstraints(c, new Insets(5, 0, 0, 5), 0, ++gridY, 1, 1, 1, 0);
            contentPane.add((Component)SwingProperties.this.liveSearchResuts, c);
            this.setLayoutConstraints(c, new Insets(10, 5, 5, 5), 0, ++gridY, 1, 1, 0, 0);
            JLabel label4 = new JLabel(Messages.getMessage("PdfPreferences.MaxMultiViewers"));
            label4.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            contentPane.add((Component)label4, c);
            this.setLayoutConstraints(c, new Insets(5, 5, 5, 5), 1, gridY, 1, 1, 1, 0);
            contentPane.add((Component)SwingProperties.this.maxMultiViewers, c);
            this.setLayoutConstraints(c, new Insets(15, 5, 5, 5), 0, ++gridY, 1, 1, 0, 0);
            JLabel label1 = new JLabel(Messages.getMessage("PdfPreferences.SideTab"));
            label1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label1.setFont(label1.getFont().deriveFont(1));
            contentPane.add((Component)label1, c);
            this.setLayoutConstraints(c, new Insets(5, 5, 5, 5), 0, ++gridY, 1, 1, 0, 0);
            SwingProperties.this.sideTabLengthText.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            contentPane.add((Component)SwingProperties.this.sideTabLengthText, c);
            this.setLayoutConstraints(c, new Insets(5, 5, 5, 5), 1, gridY, 1, 1, 1, 0);
            contentPane.add((Component)SwingProperties.this.sideTabLength, c);
            this.setLayoutConstraints(c, new Insets(5, 5, 5, 5), 0, ++gridY, 2, 1, 1, 0);
            SwingProperties.this.constantTabs.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.constantTabs.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            contentPane.add((Component)SwingProperties.this.constantTabs, c);
            this.setLayoutConstraints(c, new Insets(5, 5, 5, 5), 0, ++gridY, 2, 1, 1, 1);
            contentPane.add(Box.createVerticalGlue(), c);
            return scrollPane;
        }

        private JScrollPane createMouseTab() {
            JPanel contentPane = new JPanel();
            JScrollPane scrollPane = new JScrollPane(contentPane);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            contentPane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            int gridY = 0;
            this.setLayoutConstraints(c, new Insets(5, 5, 5, 5), 0, gridY, 1, 1, 0, 0);
            JLabel label3 = new JLabel(Messages.getMessage("PdfPreferences.GeneralTitle"));
            label3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label3.setFont(label3.getFont().deriveFont(1));
            contentPane.add((Component)label3, c);
            this.setLayoutConstraints(c, new Insets(5, 5, 5, 5), 0, ++gridY, 2, 1, 0, 0);
            SwingProperties.this.rightClick.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.rightClick.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            contentPane.add((Component)SwingProperties.this.rightClick, c);
            this.setLayoutConstraints(c, new Insets(5, 5, 5, 5), 0, ++gridY, 2, 1, 0, 0);
            SwingProperties.this.scrollwheelZoom.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.scrollwheelZoom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            contentPane.add((Component)SwingProperties.this.scrollwheelZoom, c);
            this.setLayoutConstraints(c, new Insets(0, 0, 0, 5), 0, ++gridY, 1, 1, 0, 0);
            contentPane.add((Component)SwingProperties.this.showMouseSelectionBox, c);
            this.setLayoutConstraints(c, new Insets(0, 0, 0, 5), 0, ++gridY, 1, 1, 1, 0);
            contentPane.add(Box.createVerticalGlue(), c);
            return scrollPane;
        }

        private JScrollPane createSpeechTab() {
            JPanel contentPane = new JPanel();
            JScrollPane scrollPane = new JScrollPane(contentPane);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            contentPane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            int gridY = 0;
            this.setLayoutConstraints(c, new Insets(5, 0, 0, 5), 0, gridY, 1, 1, 0, 0);
            JLabel label6 = new JLabel(Messages.getMessage("PdfPreferences.GeneralTitle"));
            label6.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label6.setFont(label6.getFont().deriveFont(1));
            contentPane.add((Component)label6, c);
            SwingProperties.this.voiceSelect = new JComboBox<String>(SwingProperties.this.speech.listVoices());
            this.setLayoutConstraints(c, new Insets(5, 0, 0, 5), 0, ++gridY, 1, 1, 0, 0);
            JLabel label7 = new JLabel(Messages.getMessage("PdfPreferences.Voice"));
            label7.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            contentPane.add((Component)label7, c);
            SwingProperties.this.voiceSelect.setSelectedItem(SwingProperties.this.properties.getValue("voice"));
            this.setLayoutConstraints(c, new Insets(5, 0, 0, 0), 1, gridY, 1, 1, 1, 0);
            contentPane.add((Component)SwingProperties.this.voiceSelect, c);
            this.setLayoutConstraints(c, new Insets(5, 0, 0, 0), 0, ++gridY, 1, 1, 1, 1);
            contentPane.add(Box.createVerticalGlue(), c);
            return scrollPane;
        }

        private JPanel createInterfaceSettings() {
            this.loadCreateInterfaceSettings();
            JPanel panel = this.makePanel(Messages.getMessage("PdfPreferences.InterfaceTitle"));
            JTabbedPane tabs = new JTabbedPane();
            tabs.add(Messages.getMessage("PdfPreferences.AppearanceTab"), this.createAppearanceTab());
            tabs.add(Messages.getMessage("PdfPreferences.Mouse"), this.createMouseTab());
            if (SwingProperties.this.speech != null) {
                tabs.add(Messages.getMessage("PdfPreferences.Speech"), this.createSpeechTab());
            }
            panel.add((Component)tabs, "Center");
            return panel;
        }

        private JPanel createPrintingSettings() {
            SwingProperties.this.loadBooleanValue(SwingProperties.this.HiResPrint, "useHiResPrinting");
            SwingProperties.this.loadStringValue(SwingProperties.this.printerBlacklist, "printerBlacklist");
            String propValue = SwingProperties.this.properties.getValue("defaultPrinter");
            if (propValue != null && !propValue.isEmpty()) {
                SwingProperties.this.defaultPrinter.setSelectedItem(propValue);
            } else {
                PrintService defaultPrintService = PrintServiceLookup.lookupDefaultPrintService();
                if (defaultPrintService != null) {
                    SwingProperties.this.defaultPrinter.setSelectedItem("System Default (" + defaultPrintService.getName() + ')');
                } else {
                    SwingProperties.this.defaultPrinter.setSelectedItem("System Default");
                }
            }
            propValue = SwingProperties.this.properties.getValue("defaultDPI");
            if (propValue != null && !propValue.isEmpty()) {
                try {
                    propValue = propValue.replaceAll("[^0-9]", "");
                    SwingProperties.this.defaultDPI.setText(Integer.parseInt(propValue) + "dpi");
                }
                catch (Exception e) {
                    LogWriter.writeLog("Attempting to get Properties values " + e);
                }
            }
            JPanel panel = this.makePanel(Messages.getMessage("PdfPreferences.PrintingTitle"));
            JPanel pane = new JPanel();
            JScrollPane scroll = new JScrollPane(pane);
            scroll.setBorder(BorderFactory.createEmptyBorder());
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.insets = new Insets(5, 0, 0, 5);
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            c.gridy = 0;
            JLabel label = new JLabel(Messages.getMessage("PdfPreferences.GeneralSection"));
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label.setFont(label.getFont().deriveFont(1));
            pane.add((Component)label, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.HiResPrint.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.HiResPrint.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.HiResPrint, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 1;
            c.gridx = 0;
            pane.add((Component)SwingProperties.this.defaultPrinterText, c);
            c.gridx = 1;
            pane.add((Component)SwingProperties.this.defaultPrinter, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 1;
            c.gridx = 0;
            pane.add((Component)SwingProperties.this.defaultPagesizeText, c);
            c.gridx = 1;
            pane.add((Component)SwingProperties.this.defaultPagesize, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 1;
            c.gridx = 0;
            pane.add((Component)SwingProperties.this.defaultDPIText, c);
            c.gridx = 1;
            pane.add((Component)SwingProperties.this.defaultDPI, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 1;
            c.gridx = 0;
            pane.add((Component)SwingProperties.this.printerBlacklistText, c);
            c.gridx = 1;
            c.weightx = 1.0;
            pane.add((Component)SwingProperties.this.printerBlacklist, c);
            c.weightx = 0.0;
            ++c.gridy;
            c.weighty = 1.0;
            c.gridx = 0;
            pane.add(Box.createVerticalGlue(), c);
            panel.add(scroll);
            return panel;
        }

        private JPanel createColorSettings() {
            JPanel panel = this.makePanel(Messages.getMessage("PdfPreferences.MenuTitle"));
            JPanel pane = new JPanel();
            JScrollPane scroll = new JScrollPane(pane);
            scroll.setBorder(BorderFactory.createEmptyBorder());
            pane.setLayout(new GridBagLayout());
            String propValue = SwingProperties.this.properties.getValue("highlightBoxColor");
            int hBoxColor = !propValue.isEmpty() ? Integer.parseInt(propValue) : DecoderOptions.highlightColor.getRGB();
            final Color currentBox = new Color(hBoxColor);
            SwingProperties.this.highlightBoxColor.setBackground(currentBox);
            final JButton hBoxButton = new JButton(Messages.getMessage("PdfPreferences.ChangeHighlightColor"));
            hBoxButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color c = JColorChooser.showDialog(null, "Highlight Color", currentBox);
                    SwingProperties.this.highlightBoxColor.setBackground(c);
                }
            });
            SwingProperties.this.loadStringValue(SwingProperties.this.highlightComposite, "highlightComposite");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.invertHighlight, "invertHighlights");
            final JLabel hCompLabel = new JLabel(Messages.getMessage("PdfPreferences.ChangeHighlightTransparency"));
            if (SwingProperties.this.invertHighlight.isSelected()) {
                SwingProperties.this.highlightBoxColor.setEnabled(false);
                SwingProperties.this.highlightComposite.setEnabled(false);
                hBoxButton.setEnabled(false);
                hCompLabel.setEnabled(false);
            } else {
                SwingProperties.this.highlightBoxColor.setEnabled(true);
                SwingProperties.this.highlightComposite.setEnabled(true);
                hBoxButton.setEnabled(true);
                hCompLabel.setEnabled(true);
            }
            SwingProperties.this.invertHighlight.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((JCheckBox)e.getSource()).isSelected()) {
                        SwingProperties.this.highlightBoxColor.setEnabled(false);
                        SwingProperties.this.highlightComposite.setEnabled(false);
                        hBoxButton.setEnabled(false);
                        hCompLabel.setEnabled(false);
                    } else {
                        SwingProperties.this.highlightBoxColor.setEnabled(true);
                        SwingProperties.this.highlightComposite.setEnabled(true);
                        hBoxButton.setEnabled(true);
                        hCompLabel.setEnabled(true);
                    }
                }
            });
            propValue = SwingProperties.this.properties.getValue("vbgColor");
            int vbgColor = 0;
            if (!propValue.isEmpty()) {
                vbgColor = Integer.parseInt(propValue);
            } else if (DecoderOptions.backgroundColor != null) {
                vbgColor = DecoderOptions.backgroundColor.getRGB();
            }
            final Color ViewerBackgroundColor = new Color(vbgColor);
            SwingProperties.this.viewBGColor.setBackground(ViewerBackgroundColor);
            JButton viewerBackgroundButton = new JButton(Messages.getMessage("PdfPreferences.ChangeBackgroundColor"));
            viewerBackgroundButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color c = JColorChooser.showDialog(null, "BackGround Color", ViewerBackgroundColor);
                    SwingProperties.this.viewBGColor.setBackground(c);
                }
            });
            propValue = SwingProperties.this.properties.getValue("vfgColor");
            int vfgColor = 0;
            if (!propValue.isEmpty()) {
                vfgColor = Integer.parseInt(propValue);
            }
            final Color FGColor = new Color(vfgColor);
            SwingProperties.this.foreGroundColor.setBackground(FGColor);
            final JButton FGButton = new JButton(Messages.getMessage("PdfPreferences.ChangeForegroundColor"));
            FGButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color c = JColorChooser.showDialog(null, "Foreground Color", FGColor);
                    SwingProperties.this.foreGroundColor.setBackground(c);
                }
            });
            SwingProperties.this.loadBooleanValue(SwingProperties.this.changeTextAndLineArt, "changeTextAndLineart");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.replaceDocTextCol, "replaceDocumentTextColors");
            if (SwingProperties.this.replaceDocTextCol.isSelected()) {
                FGButton.setEnabled(true);
                SwingProperties.this.foreGroundColor.setEnabled(true);
                SwingProperties.this.changeTextAndLineArt.setEnabled(true);
            } else {
                FGButton.setEnabled(false);
                SwingProperties.this.foreGroundColor.setEnabled(false);
                SwingProperties.this.changeTextAndLineArt.setEnabled(false);
            }
            SwingProperties.this.replaceDocTextCol.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((JCheckBox)e.getSource()).isSelected()) {
                        FGButton.setEnabled(true);
                        SwingProperties.this.foreGroundColor.setEnabled(true);
                        SwingProperties.this.changeTextAndLineArt.setEnabled(true);
                    } else {
                        FGButton.setEnabled(false);
                        SwingProperties.this.foreGroundColor.setEnabled(false);
                        SwingProperties.this.changeTextAndLineArt.setEnabled(false);
                    }
                }
            });
            propValue = SwingProperties.this.properties.getValue("pdfDisplayBackground");
            int pdbColor = 0;
            if (!propValue.isEmpty()) {
                pdbColor = Integer.parseInt(propValue);
            }
            final Color PDBColor = new Color(pdbColor);
            SwingProperties.this.pdfDecoderBackground.setBackground(PDBColor);
            final JButton PDBButton = new JButton(Messages.getMessage("PdfPreferences.ChangeDisplayBackgroundColor"));
            PDBButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color c = JColorChooser.showDialog(null, "Display Background Color", PDBColor);
                    SwingProperties.this.pdfDecoderBackground.setBackground(c);
                }
            });
            SwingProperties.this.loadBooleanValue(SwingProperties.this.replaceDisplayBGCol, "replacePdfDisplayBackground");
            if (SwingProperties.this.replaceDisplayBGCol.isSelected()) {
                PDBButton.setEnabled(true);
                SwingProperties.this.pdfDecoderBackground.setEnabled(true);
            } else {
                PDBButton.setEnabled(false);
                SwingProperties.this.pdfDecoderBackground.setEnabled(false);
            }
            SwingProperties.this.replaceDisplayBGCol.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((JCheckBox)e.getSource()).isSelected()) {
                        PDBButton.setEnabled(true);
                        SwingProperties.this.pdfDecoderBackground.setEnabled(true);
                    } else {
                        PDBButton.setEnabled(false);
                        SwingProperties.this.pdfDecoderBackground.setEnabled(false);
                    }
                }
            });
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.insets = new Insets(5, 0, 0, 5);
            c.gridwidth = 1;
            c.gridy = 0;
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            JLabel label2 = new JLabel("Highlights");
            label2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label2.setFont(label2.getFont().deriveFont(1));
            pane.add((Component)label2, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 5);
            c.gridx = 0;
            SwingProperties.this.highlightBoxColor.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            pane.add((Component)SwingProperties.this.highlightBoxColor, c);
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 1;
            c.gridx = 1;
            c.weightx = 1.0;
            pane.add((Component)hBoxButton, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 5);
            c.gridwidth = 1;
            c.gridx = 0;
            pane.add((Component)SwingProperties.this.highlightComposite, c);
            c.insets = new Insets(5, 25, 0, 0);
            c.gridwidth = 1;
            c.gridx = 1;
            pane.add((Component)hCompLabel, c);
            ++c.gridy;
            c.insets = new Insets(0, 0, 0, 5);
            c.gridwidth = 1;
            c.gridx = 0;
            pane.add((Component)SwingProperties.this.invertHighlight, c);
            ++c.gridy;
            c.insets = new Insets(15, 0, 0, 5);
            c.gridwidth = 1;
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            JLabel label3 = new JLabel("Dispaly Colors");
            label3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label3.setFont(label3.getFont().deriveFont(1));
            pane.add((Component)label3, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 5);
            c.gridx = 0;
            SwingProperties.this.viewBGColor.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            pane.add((Component)SwingProperties.this.viewBGColor, c);
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 1;
            c.gridx = 1;
            c.weightx = 1.0;
            pane.add((Component)viewerBackgroundButton, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 1;
            c.gridx = 0;
            c.weightx = 1.0;
            pane.add((Component)SwingProperties.this.replaceDocTextCol, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 5);
            c.gridx = 0;
            SwingProperties.this.foreGroundColor.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            pane.add((Component)SwingProperties.this.foreGroundColor, c);
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 1;
            c.gridx = 1;
            c.weightx = 1.0;
            pane.add((Component)FGButton, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 5);
            c.gridwidth = 1;
            c.gridx = 0;
            pane.add((Component)SwingProperties.this.changeTextAndLineArt, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 1;
            c.gridx = 0;
            c.weightx = 1.0;
            pane.add((Component)SwingProperties.this.replaceDisplayBGCol, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 5);
            c.gridx = 0;
            SwingProperties.this.pdfDecoderBackground.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            pane.add((Component)SwingProperties.this.pdfDecoderBackground, c);
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 1;
            c.gridx = 1;
            c.weightx = 1.0;
            pane.add((Component)PDBButton, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            JPanel clearHistoryPanel = new JPanel();
            clearHistoryPanel.setLayout(new BoxLayout(clearHistoryPanel, 0));
            clearHistoryPanel.add(Box.createHorizontalGlue());
            clearHistoryPanel.add(Box.createHorizontalGlue());
            pane.add((Component)clearHistoryPanel, c);
            ++c.gridy;
            c.weighty = 1.0;
            c.gridx = 0;
            pane.add(Box.createVerticalGlue(), c);
            panel.add((Component)scroll, "Center");
            return panel;
        }

        private JPanel createMenuSettings() {
            JPanel panel = this.makePanel(Messages.getMessage("PdfPreferences.MenuTitle"));
            JPanel pane = new JPanel(new BorderLayout());
            SwingProperties.this.tabs = new JTabbedPane();
            for (int t = 0; t != SwingProperties.this.menuTabs.length; ++t) {
                SwingProperties.this.reverseMessage.put(Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[t]), SwingProperties.this.menuTabs[t]);
                CheckNode top = new CheckNode(Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[t]));
                top.setEnabled(true);
                top.setSelected(true);
                ArrayList<CheckNode> last = new ArrayList<CheckNode>();
                last.add(top);
                NodeList nodes = SwingProperties.this.properties.getChildren(Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[t]) + "Menu");
                this.addMenuToTree(t, nodes, top, last);
                final JTree tree = new JTree(top);
                JScrollPane scroll = new JScrollPane(tree);
                tree.setCellRenderer(new CheckRenderer());
                tree.getSelectionModel().setSelectionMode(1);
                tree.addTreeSelectionListener(new TreeSelectionListener(){

                    private void setChildrenValue(CheckNode checkNode, boolean status) {
                        for (int i = 0; i != checkNode.getChildCount(); ++i) {
                            ((CheckNode)checkNode.getChildAt(i)).setSelected(status);
                            if (checkNode.getChildAt(i).getChildCount() <= 0) continue;
                            this.setChildrenValue((CheckNode)checkNode.getChildAt(i), status);
                        }
                    }

                    private void setParentValue(CheckNode checkNode, boolean status) {
                        checkNode.setSelected(status);
                        if (checkNode.getParent() != null) {
                            this.setParentValue((CheckNode)checkNode.getParent(), status);
                        }
                    }

                    @Override
                    public void valueChanged(TreeSelectionEvent e) {
                        final DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                        Runnable updateAComponent = new Runnable(){

                            @Override
                            public void run() {
                                CheckNode checkNode = (CheckNode)node;
                                if (checkNode != null) {
                                    int result;
                                    boolean reversedStatus;
                                    boolean bl = reversedStatus = !checkNode.isSelected();
                                    if (SwingProperties.this.reverseMessage.get(checkNode.getText()).equals("Preferences") && !reversedStatus && (result = JOptionPane.showConfirmDialog(SwingProperties.this.propertiesDialog, "Disabling this option will mean you can not acces this menu using this properties file. Do you want to continue?", "Preferences Access", 0)) == 1) {
                                        boolean bl2 = reversedStatus = !reversedStatus;
                                    }
                                    if (checkNode.getChildCount() > 0) {
                                        this.setChildrenValue(checkNode, reversedStatus);
                                    }
                                    if (checkNode.getParent() != null && reversedStatus) {
                                        this.setParentValue((CheckNode)checkNode.getParent(), reversedStatus);
                                    }
                                    checkNode.setSelected(reversedStatus);
                                    tree.invalidate();
                                    tree.clearSelection();
                                    tree.repaint();
                                }
                            }
                        };
                        SwingUtilities.invokeLater(updateAComponent);
                    }
                });
                JPanel display = new JPanel(new BorderLayout());
                final JButton hideGuiSection = new JButton();
                String propValue = SwingProperties.this.properties.getValue(SwingProperties.this.menuTabs[t]);
                if (propValue.equalsIgnoreCase("true")) {
                    hideGuiSection.setText(Messages.getMessage("PdfCustomGui.HideGuiSection") + ' ' + Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[t]));
                } else {
                    hideGuiSection.setText(Messages.getMessage("PdfCustomGui.ShowGuiSection") + ' ' + Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[t]));
                }
                final int currentTab = t;
                hideGuiSection.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (hideGuiSection.getText().startsWith("Click here to show ")) {
                            hideGuiSection.setText(Messages.getMessage("PdfCustomGui.HideGuiSection") + ' ' + Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[currentTab]));
                        } else {
                            hideGuiSection.setText(Messages.getMessage("PdfCustomGui.ShowGuiSection") + ' ' + Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[currentTab]));
                        }
                    }
                });
                display.add((Component)scroll, "Center");
                display.add((Component)hideGuiSection, "South");
                SwingProperties.this.tabs.add((Component)display, Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[t]));
            }
            pane.add((Component)SwingProperties.this.tabs, "Center");
            panel.add((Component)pane, "Center");
            return panel;
        }

        private void addMenuToTree(int tab, NodeList nodes, CheckNode top, List previous) {
            for (int i = 0; i != nodes.getLength(); ++i) {
                String name;
                if (i >= nodes.getLength() || (name = nodes.item(i).getNodeName()).startsWith("#")) continue;
                CheckNode newLeaf = new CheckNode(Messages.getMessage("PdfCustomGui." + name));
                newLeaf.setEnabled(true);
                SwingProperties.this.reverseMessage.put(Messages.getMessage("PdfCustomGui." + name), name);
                SwingProperties.this.loadBooleanValue(newLeaf, name);
                if (nodes.item(i).hasChildNodes()) {
                    previous.add(top);
                    top.add(newLeaf);
                    this.addMenuToTree(tab, nodes.item(i).getChildNodes(), newLeaf, previous);
                    continue;
                }
                top.add(newLeaf);
            }
        }

        private JPanel createExtensionsPane() {
            class Link
            extends MouseAdapter {
                private final String url;

                Link(String url) {
                    this.url = url;
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (GUIDisplay.allowChangeCursor) {
                        pane.setCursor(Cursor.getPredefinedCursor(12));
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (GUIDisplay.allowChangeCursor) {
                        pane.setCursor(Cursor.getDefaultCursor());
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        BrowserLauncher.openURL(this.url);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(pane, ex.getMessage() + ' ' + Messages.getMessage("PdfViewer.ErrorWebsite"));
                    }
                }
            }
            JLabel rhino;
            JLabel jce;
            JLabel javaFX;
            JLabel bcmail;
            JPanel panel = this.makePanel(Messages.getMessage("PdfPreferences.ExtensionsTitle"));
            final JPanel pane = new JPanel();
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.gridy = 0;
            c.insets = new Insets(12, 2, 5, 2);
            JLabel title = new JLabel(Messages.getMessage("PdfPreferences.ExtensionName"));
            Font titleFont = title.getFont().deriveFont(1, title.getFont().getSize2D());
            title.setFont(titleFont);
            c.weightx = 0.0;
            c.gridx = 0;
            pane.add((Component)title, c);
            JLabel title2 = new JLabel(Messages.getMessage("PdfPreferences.ExtensionDescription"));
            title2.setFont(titleFont);
            c.weightx = 1.0;
            c.gridx = 1;
            pane.add((Component)title2, c);
            JLabel title3 = new JLabel(Messages.getMessage("PdfPreferences.ExtensionVersion"));
            title3.setFont(titleFont);
            c.weightx = 0.0;
            c.gridx = 2;
            pane.add((Component)title3, c);
            c.insets = new Insets(2, 2, 2, 2);
            String details = "java: " + System.getProperty("java.vendor") + ' ' + System.getProperty("java.version") + '\n';
            details = details + "os: " + System.getProperty("os.name") + ' ' + System.getProperty("os.version") + ' ' + System.getProperty("os.arch") + '\n';
            details = details + "jpedal: 6.9b21\n";
            ++c.gridy;
            c.gridx = 0;
            pane.add((Component)new JLabel("BCMail"), c);
            c.gridx = 1;
            pane.add((Component)new JLabel("<html>" + Messages.getMessage("PdfExtensions.BCMail.text")), c);
            c.gridx = 2;
            String version = "Unknown version";
            try {
                Class<?> bcmailc = Class.forName("org.bouncycastle.jcajce.JcaJceHelper");
                String className = bcmailc.getName().replace('.', '/');
                String[] paths = bcmailc.getResource('/' + className + ".class").getPath().split("!");
                URL file = new URL(paths[0]);
                JarFile jar = new JarFile(file.getFile());
                if (!jar.getManifest().getMainAttributes().getValue("Implementation-Version").isEmpty()) {
                    version = jar.getManifest().getMainAttributes().getValue("Implementation-Version");
                }
                bcmail = new JLabel("<html>" + version);
                details = details + "bcmail: " + version + '\n';
            }
            catch (Exception e) {
                bcmail = new JLabel("<html><u>" + Messages.getMessage("PdfExtensions.getText") + ' ' + e + "</u></html>");
                bcmail.setForeground(Color.BLUE);
                bcmail.addMouseListener(new Link(Messages.getMessage("PdfExtensions.BCMail.link")));
            }
            catch (Error e) {
                bcmail = new JLabel("<html><u>" + Messages.getMessage("PdfExtensions.getText") + ' ' + e + "</u></html>");
                bcmail.setForeground(Color.BLUE);
                bcmail.addMouseListener(new Link(Messages.getMessage("PdfExtensions.BCMail.link")));
            }
            pane.add((Component)bcmail, c);
            ++c.gridy;
            c.gridx = 0;
            pane.add((Component)new JLabel("CID"), c);
            c.gridx = 1;
            pane.add((Component)new JLabel("<html>" + Messages.getMessage("PdfExtensions.CID.text")), c);
            c.gridx = 2;
            try {
                JLabel cid;
                if (SwingProperties.class.getResourceAsStream("/org/jpedal/res/cid/00_ReadMe.pdf") != null) {
                    cid = new JLabel("<html>1.0");
                    details = details + "cid: 1.0\n";
                } else {
                    cid = new JLabel("<html><u>" + Messages.getMessage("PdfExtensions.getText") + "</u></html>");
                    cid.setForeground(Color.BLUE);
                    cid.addMouseListener(new Link(Messages.getMessage("PdfExtensions.CID.link")));
                }
                pane.add((Component)cid, c);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            ++c.gridy;
            c.gridx = 0;
            pane.add((Component)new JLabel("JavaFX"), c);
            c.gridx = 1;
            pane.add((Component)new JLabel("<html>" + Messages.getMessage("PdfExtensions.JavaFX.text")), c);
            c.gridx = 2;
            if (JavaFXHelper.isJavaFXAvailable()) {
                version = JavaFXHelper.getVersion();
                javaFX = new JLabel("<html>" + version.replaceAll("build", "b").replaceAll("[(|)]", ""));
                details = details + "javafx: " + version + '\n';
            } else {
                javaFX = new JLabel("<html><u>" + Messages.getMessage("PdfExtensions.getText") + "</u></html>");
                javaFX.setForeground(Color.BLUE);
                javaFX.addMouseListener(new Link(Messages.getMessage("PdfExtensions.JavaFX.link")));
            }
            pane.add((Component)javaFX, c);
            ++c.gridy;
            c.gridx = 0;
            pane.add((Component)new JLabel("JCE"), c);
            c.gridx = 1;
            pane.add((Component)new JLabel("<html>" + Messages.getMessage("PdfExtensions.JCE.text")), c);
            c.gridx = 2;
            version = "Unknown version";
            try {
                Class<?> jcec = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                String className = jcec.getName().replace('.', '/');
                String[] paths = jcec.getResource('/' + className + ".class").getPath().split("!");
                URL file = new URL(paths[0]);
                JarFile jar = new JarFile(file.getFile());
                if (!jar.getManifest().getMainAttributes().getValue("Implementation-Version").isEmpty()) {
                    version = jar.getManifest().getMainAttributes().getValue("Implementation-Version");
                }
                jce = new JLabel("<html>" + version);
                details = details + "jce: " + version + '\n';
            }
            catch (Exception e) {
                jce = new JLabel("<html><u>" + Messages.getMessage("PdfExtensions.getText") + ' ' + e + "</u></html>");
                jce.setForeground(Color.BLUE);
                jce.addMouseListener(new Link(Messages.getMessage("PdfExtensions.JCE.link")));
            }
            pane.add((Component)jce, c);
            ++c.gridy;
            c.gridx = 0;
            pane.add((Component)new JLabel("Rhino"), c);
            c.gridx = 1;
            pane.add((Component)new JLabel("<html>" + Messages.getMessage("PdfExtensions.Rhino.text")), c);
            c.gridx = 2;
            InputStream in = DefaultParser.class.getClassLoader().getResourceAsStream("org/mozilla/javascript/Context.class");
            if (in != null) {
                version = ScriptRuntime.getMessage0((String)"implementation.version");
                details = details + "rhino: " + version + '\n';
                String release = "";
                if (!version.replaceAll("release 1", "").equals(version)) {
                    release = " R1";
                }
                if (!version.replaceAll("release 2", "").equals(version)) {
                    release = " R2";
                }
                version = version.substring(0, 12).replaceAll("[^0-9|.]", "");
                rhino = new JLabel("<html>" + version + release);
            } else {
                rhino = new JLabel("<html><u>" + Messages.getMessage("PdfExtensions.getText") + "</u></html>");
                rhino.setForeground(Color.BLUE);
                rhino.addMouseListener(new Link(Messages.getMessage("PdfExtensions.Rhino.link")));
            }
            pane.add((Component)rhino, c);
            ++c.gridy;
            c.weighty = 1.0;
            pane.add(Box.createVerticalGlue(), c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 3;
            c.anchor = 26;
            c.weighty = 0.0;
            c.fill = 13;
            JButton copy = new JButton(Messages.getMessage("PdfPreferences.CopyToClipboard"));
            final String finalDetails = details;
            copy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(finalDetails), null);
                    JOptionPane.showMessageDialog(pane, Messages.getMessage("PdfExtensions.clipboard"));
                }
            });
            pane.add((Component)copy, c);
            panel.add((Component)pane, "Center");
            return panel;
        }

        private void show(Component component) {
            if (this.currentComponent != null) {
                this.remove(this.currentComponent);
            }
            this.currentComponent = component;
            this.add("Center", this.currentComponent);
            this.revalidate();
            this.repaint();
        }

        private void addButton(String title, String iconUrl, final Component component, JPanel bar, ButtonGroup group) {
            AbstractAction action = new AbstractAction(title, new ImageIcon(this.getClass().getResource(iconUrl))){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonBarPanel.this.show(component);
                }
            };
            JToggleButton button = new JToggleButton(action);
            button.setVerticalTextPosition(3);
            button.setHorizontalTextPosition(0);
            button.setContentAreaFilled(false);
            if (DecoderOptions.isRunningOnMac) {
                button.setHorizontalAlignment(2);
            }
            button.setAlignmentX(0.5f);
            bar.add(button);
            group.add(button);
            if (group.getSelection() == null) {
                button.setSelected(true);
                this.show(component);
            }
        }
    }
}

