/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class FontMappings {
    public static boolean fontsInitialised;
    public static String defaultFont;
    public static boolean enforceFontSubstitution;
    public static Map fontSubstitutionTable;
    public static Map fontPropertiesTable;
    public static Map fontPossDuplicates;
    public static Map fontSubstitutionFontID;
    public static Map fontSubstitutionLocation;
    public static Map fontSubstitutionAliasTable;
    private static boolean fontsSet;
    private static final String separator;
    public static String[] defaultFontDirs;
    private static int fontSubstitutionMode;

    private FontMappings() {
    }

    public static void initFonts() {
        try {
            String fontMaps = System.getProperty("org.jpedal.fontmaps");
            if (fontMaps != null) {
                StringTokenizer fontPaths = new StringTokenizer(fontMaps, ",");
                while (fontPaths.hasMoreTokens()) {
                    String fontPath = fontPaths.nextToken();
                    StringTokenizer values = new StringTokenizer(fontPath, "=:");
                    int count = values.countTokens() - 1;
                    String[] nameInPDF = new String[count];
                    String key = values.nextToken();
                    for (int i = 0; i < count; ++i) {
                        nameInPDF[i] = values.nextToken();
                    }
                    FontMappings.setSubstitutedFontAliases(key, nameInPDF);
                }
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Unable to read org.jpedal.fontmaps " + e.getMessage());
        }
        try {
            String fontDirs = System.getProperty("org.jpedal.fontdirs");
            String failed = null;
            if (fontDirs != null) {
                failed = FontMappings.addFonts(fontDirs, failed);
            }
            if (failed != null) {
                LogWriter.writeLog("Could not find " + failed);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Unable to read FontDirs " + e.getMessage());
        }
    }

    public static void setFontSubstitutionMode(int mode) {
        fontSubstitutionMode = mode;
    }

    public static int getFontSubstitutionMode() {
        return fontSubstitutionMode;
    }

    public static void setSubstitutedFontAliases(String fontFileName, String[] aliases) {
        if (aliases != null) {
            String name = fontFileName.toLowerCase();
            for (String aliase : aliases) {
                String alias = aliase.toLowerCase();
                if (alias.equals(name)) continue;
                fontSubstitutionAliasTable.put(alias, name);
            }
        }
    }

    public static String addFonts(String fontDirs, String failed) {
        StringTokenizer fontPaths = new StringTokenizer(fontDirs, ",");
        while (fontPaths.hasMoreTokens()) {
            String fontPath = fontPaths.nextToken();
            if (!fontPath.endsWith("/") && !fontPath.endsWith("\\")) {
                fontPath = fontPath + separator;
            }
            FontMappings.addTTDir(fontPath, failed);
        }
        return failed;
    }

    public static void dispose() {
        fontSubstitutionTable = null;
        fontPropertiesTable = null;
        fontPossDuplicates = null;
        fontSubstitutionFontID = null;
        fontSubstitutionLocation = null;
        fontSubstitutionAliasTable = null;
    }

    public static String addTTDir(String fontPath, String failed) {
        File currentDir;
        if (fontSubstitutionTable == null) {
            fontSubstitutionTable = new ConcurrentHashMap();
            fontSubstitutionFontID = new ConcurrentHashMap();
            fontPossDuplicates = new ConcurrentHashMap();
            fontPropertiesTable = new ConcurrentHashMap();
        }
        if ((currentDir = new File(fontPath)).exists() && currentDir.isDirectory()) {
            String[] files = currentDir.list();
            if (files != null) {
                for (String currentFont : files) {
                    FontMappings.addFontFile(currentFont, fontPath);
                }
            }
        } else {
            failed = failed == null ? fontPath : failed + ',' + fontPath;
        }
        return failed;
    }

    public static void setFontReplacements() {
        String[] aliases6 = new String[]{"acarialunicodems__cn"};
        FontMappings.setSubstitutedFontAliases("adobeheitistd-regular", aliases6);
        if (DecoderOptions.isRunningOnMac) {
            FontMappings.setSubstitutedFontAliases("Courier italic", new String[]{"Courier-Oblique"});
            FontMappings.setSubstitutedFontAliases("Courier bold", new String[]{"Courier-Bold"});
            FontMappings.setSubstitutedFontAliases("Courier bold italic", new String[]{"Courier-BoldOblique"});
            FontMappings.setSubstitutedFontAliases("Courier new italic", new String[]{"CourierNew,italic", "CourierStd-Oblique", "CourierNewPS-ItalicMT"});
            FontMappings.setSubstitutedFontAliases("Courier new bold", new String[]{"CourierNew,Bold", "Courier-Bold", "CourierStd-Bold", "CourierNewPS-BoldMT"});
            FontMappings.setSubstitutedFontAliases("Courier new bold italic", new String[]{"CourierNew-BoldOblique", "CourierStd-BoldOblique", "CourierNewPS-BoldItalicMT"});
            FontMappings.setSubstitutedFontAliases("Courier new", new String[]{"CourierNew", "Courier", "CourierStd", "CourierNewPSMT"});
            FontMappings.setSubstitutedFontAliases("arial", new String[]{"Helvetica", "arialmt"});
            FontMappings.setSubstitutedFontAliases("arial italic", new String[]{"arial-italic", "arial-italicmt", "Helvetica-Oblique", "Arial,Italic"});
            FontMappings.setSubstitutedFontAliases("arial bold", new String[]{"arial-boldmt,bold", "arial-boldmt", "Helvetica-Bold", "Arial,bold"});
            FontMappings.setSubstitutedFontAliases("arial bold italic", new String[]{"Arial-BoldItalicMT", "Helvetica-BoldOblique"});
            FontMappings.setSubstitutedFontAliases("arial Narrow", new String[]{"ArialNarrow"});
            FontMappings.setSubstitutedFontAliases("arial Narrow italic", new String[]{"ArialNarrow-italic"});
            FontMappings.setSubstitutedFontAliases("arial Narrow bold", new String[]{"ArialNarrow-bold", "ArialNarrow,Bold"});
            FontMappings.setSubstitutedFontAliases("arial Narrow bold italic", new String[]{"ArialNarrow-bolditalic"});
            FontMappings.setSubstitutedFontAliases("times new roman bold", new String[]{"Times-Bold", "TimesNewRoman,Bold", "TimesNewRomanPS-BoldMT"});
            FontMappings.setSubstitutedFontAliases("times new roman bold italic", new String[]{"Times-BoldItalic", "TimesNewRoman,BoldItalic", "TimesNewRomanPS-BoldItalicMT"});
            FontMappings.setSubstitutedFontAliases("times new roman italic", new String[]{"Times-Italic", "TimesNewRoman,Italic", "TimesNewRomanPS-ItalicMT"});
            FontMappings.setSubstitutedFontAliases("times new roman", new String[]{"Times-Roman", "TimesNewRoman", "Times", "TimesNewRomanPSMT"});
            FontMappings.setSubstitutedFontAliases("wingdings", new String[]{"ZapfDingbats", "ZaDb"});
        } else {
            FontMappings.setSubstitutedFontAliases("Couri", new String[]{"Courier-Oblique", "CourierNew,italic", "CourierStd-Oblique", "CourierNewPS-ItalicMT"});
            FontMappings.setSubstitutedFontAliases("Courbd", new String[]{"Courier-Bold", "CourierNew,Bold", "CourierStd-Bold", "CourierNewPS-BoldMT"});
            FontMappings.setSubstitutedFontAliases("Courbi", new String[]{"Courier-BoldOblique", "CourierNew-BoldOblique", "CourierStd-BoldOblique", "CourierNewPS-BoldItalicMT"});
            FontMappings.setSubstitutedFontAliases("Cour", new String[]{"CourierNew", "Courier", "CourierStd", "CourierNewPSMT", "CourierNewPSMT"});
            FontMappings.setSubstitutedFontAliases("arial", new String[]{"Helvetica", "arialmt", "ArialNarrow"});
            FontMappings.setSubstitutedFontAliases("ariali", new String[]{"arial-italic", "arial-italicmt", "Helvetica-Oblique", "Arial,Italic", "ArialNarrow-Italic"});
            FontMappings.setSubstitutedFontAliases("arialbd", new String[]{"arial-boldmt,bold", "arial-boldmt", "Helvetica-Bold", "Arial,bold", "arial bold", "ArialNarrow-Bold"});
            FontMappings.setSubstitutedFontAliases("arialbi", new String[]{"Arial-BoldItalicMT", "Helvetica-BoldOblique", "ArialNarrow-BoldItalic"});
            FontMappings.setSubstitutedFontAliases("timesbd", new String[]{"Times-Bold", "TimesNewRoman,Bold", "TimesNewRomanPS-BoldMT"});
            FontMappings.setSubstitutedFontAliases("timesi", new String[]{"Times-BoldItalic", "TimesNewRoman,BoldItalic"});
            FontMappings.setSubstitutedFontAliases("timesbi", new String[]{"Times-Italic", "TimesNewRoman,Italic"});
            FontMappings.setSubstitutedFontAliases("times", new String[]{"Times-Roman", "TimesNewRoman", "Times", "TimesNewRomanPSMT"});
            FontMappings.setSubstitutedFontAliases("wingdings", new String[]{"ZapfDingbats", "ZaDb"});
        }
        FontMappings.setSubstitutedFontAliases("AdobeSongStd-Light", new String[]{"STSong-Light"});
        if (!fontsSet) {
            File adobeFonts;
            fontsSet = true;
            FontMappings.setFontDirs(defaultFontDirs);
            if (DecoderOptions.isRunningOnWindows && (adobeFonts = new File("C:\\Program Files\\Adobe\\")).exists()) {
                String[] subdirs;
                for (String path : subdirs = adobeFonts.list()) {
                    String adobePath = "C:\\Program Files\\Adobe\\" + path + "\\Resource\\CIDFont";
                    File testAdobe = new File(adobePath);
                    if (!testAdobe.exists()) continue;
                    FontMappings.addTTDir(adobePath, "");
                }
            }
        }
    }

    public static String setFontDirs(String[] fontDirs) {
        String failed = null;
        if (fontSubstitutionTable == null) {
            fontSubstitutionTable = new ConcurrentHashMap();
            fontSubstitutionFontID = new ConcurrentHashMap();
            fontPossDuplicates = new ConcurrentHashMap();
            fontPropertiesTable = new ConcurrentHashMap();
        }
        try {
            if (fontDirs == null) {
                LogWriter.writeLog("Null font parameter passed");
                fontSubstitutionAliasTable.clear();
                fontSubstitutionLocation.clear();
                fontSubstitutionTable.clear();
                fontSubstitutionFontID.clear();
                fontPossDuplicates.clear();
                fontPropertiesTable.clear();
                fontsSet = false;
            } else {
                for (String fontDir : fontDirs) {
                    String fontPath = fontDir;
                    if (!fontPath.endsWith("/") && !fontPath.endsWith("\\")) {
                        fontPath = fontPath + separator;
                    }
                    failed = FontMappings.addTTDir(fontPath, failed);
                }
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Unable to run setFontDirs " + e.getMessage());
        }
        return failed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addSubstituteFonts(String fontPath, boolean enforceMapping) {
        boolean hasFonts;
        block36: {
            hasFonts = false;
            InputStream in = null;
            InputStream dir = null;
            try {
                String[] dirs = new String[]{"tt", "t1c", "t1"};
                String[] types = new String[]{"/TrueType", "/Type1C", "/Type1"};
                enforceFontSubstitution = enforceMapping;
                ClassLoader loader = FontMappings.class.getClass().getClassLoader();
                dir = loader.getResourceAsStream(fontPath);
                LogWriter.writeLog("Looking for root " + fontPath);
                if (in != null) {
                    LogWriter.writeLog("Adding fonts fonts found in  tt,t1c,t1 sub-directories of " + fontPath);
                    hasFonts = true;
                    block28: for (int i = 0; i < dirs.length; ++i) {
                        String path;
                        if (!fontPath.endsWith("/")) {
                            fontPath = fontPath + '/';
                        }
                        if ((in = loader.getResourceAsStream(path = fontPath + dirs[i] + '/')) == null) continue;
                        System.out.println("Found  " + path + ' ' + in);
                        try {
                            ArrayList fonts = in instanceof ByteArrayInputStream ? FontMappings.readIndirectValues(in) : FontMappings.getDirectoryMatches(path);
                            for (Object font : fonts) {
                                String value = (String)font;
                                if (value == null) {
                                    continue block28;
                                }
                                int pointer = value.indexOf(46);
                                String fontName = pointer == -1 ? value.toLowerCase() : value.substring(0, pointer).toLowerCase();
                                fontSubstitutionTable.put(fontName, types[i]);
                                fontSubstitutionLocation.put(fontName, path + value);
                            }
                            continue;
                        }
                        catch (Exception e) {
                            LogWriter.writeLog("Exception " + e + " reading substitute fonts");
                            continue;
                        }
                        finally {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {
                                    LogWriter.writeLog("Exception: " + e.getMessage());
                                }
                            }
                        }
                    }
                    break block36;
                }
                LogWriter.writeLog("No fonts found at " + fontPath);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception adding substitute fonts " + e.getMessage());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
                if (dir != null) {
                    try {
                        dir.close();
                    }
                    catch (IOException e) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
            }
        }
        return hasFonts;
    }

    public static void addFontFile(String currentFont, String fontPath) {
        if (fontSubstitutionTable == null) {
            fontSubstitutionTable = new ConcurrentHashMap();
            fontSubstitutionFontID = new ConcurrentHashMap();
            fontPossDuplicates = new ConcurrentHashMap();
            fontPropertiesTable = new ConcurrentHashMap();
        }
        if (fontPath != null && !fontPath.endsWith("/") && !fontPath.endsWith("\\")) {
            fontPath = fontPath + separator;
        }
        String name = currentFont.toLowerCase();
        int type = StandardFonts.getFontType(name);
        InputStream in = null;
        if (type != 8 && new File(fontPath + currentFont).exists()) {
            boolean failed = false;
            try {
                in = new FileInputStream(fontPath + currentFont);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
                failed = true;
            }
            catch (Error err) {
                LogWriter.writeLog("Error: " + err.getMessage());
                failed = true;
            }
            if (!failed) {
                int pointer = currentFont.indexOf(46);
                String fontName = pointer == -1 ? currentFont.toLowerCase() : currentFont.substring(0, pointer).toLowerCase();
                if (fontSubstitutionMode == 1 || type == 6) {
                    if (type == 1228944677) {
                        fontSubstitutionTable.put(fontName, "/Type1");
                    } else {
                        fontSubstitutionTable.put(fontName, "/TrueType");
                    }
                    fontSubstitutionLocation.put(fontName, fontPath + currentFont);
                    fontPropertiesTable.put(fontName + "_type", type);
                    fontPropertiesTable.put(fontName + "_path", fontPath + currentFont);
                } else if (type == 7 || type == 1217103210) {
                    if (fontSubstitutionMode == 5) {
                        String[] postscriptNames = null;
                        try {
                            postscriptNames = StandardFonts.readNamesFromFont(type, fontPath + currentFont, 2);
                        }
                        catch (Exception e) {
                            LogWriter.writeLog("Exception: " + e.getMessage());
                        }
                        String[] familyNames = null;
                        try {
                            familyNames = StandardFonts.readNamesFromFont(type, fontPath + currentFont, 3);
                        }
                        catch (Exception e) {
                            LogWriter.writeLog("Exception: " + e.getMessage());
                        }
                        int fontCount = 0;
                        if (postscriptNames != null) {
                            fontCount = postscriptNames.length;
                        }
                        for (int ii = 0; ii < fontCount; ++ii) {
                            if (postscriptNames[ii] == null) {
                                postscriptNames[ii] = Strip.stripAllSpaces(fontName);
                            }
                            if (familyNames[ii] == null) {
                                familyNames[ii] = Strip.stripAllSpaces(fontName);
                            }
                            Object fontSubValue = fontSubstitutionTable.get(postscriptNames[ii]);
                            Object possDuplicate = fontPossDuplicates.get(postscriptNames[ii]);
                            if (fontSubValue == null && possDuplicate == null) {
                                fontSubstitutionTable.put(postscriptNames[ii], "/TrueType");
                                fontSubstitutionLocation.put(postscriptNames[ii], fontPath + currentFont);
                                fontSubstitutionFontID.put(postscriptNames[ii], ii);
                                fontPossDuplicates.put(postscriptNames[ii], familyNames[ii]);
                                continue;
                            }
                            if (familyNames[ii].equals(postscriptNames[ii])) continue;
                            fontSubstitutionTable.put(postscriptNames[ii], "/TrueType");
                            fontSubstitutionLocation.put(postscriptNames[ii], fontPath + currentFont);
                            fontSubstitutionFontID.put(postscriptNames[ii], ii);
                            fontPropertiesTable.put(postscriptNames[ii] + "_type", type);
                            fontPropertiesTable.put(postscriptNames[ii] + "_path", fontPath + currentFont);
                            if (possDuplicate.equals("DONE")) continue;
                            fontPossDuplicates.put(postscriptNames[ii], "DONE");
                            fontSubstitutionTable.remove(postscriptNames[ii]);
                            fontSubstitutionTable.put(familyNames[ii], "/TrueType");
                            String font = (String)fontSubstitutionLocation.get(postscriptNames[ii]);
                            fontSubstitutionLocation.remove(postscriptNames[ii]);
                            fontSubstitutionLocation.put(familyNames[ii], font);
                            fontSubstitutionFontID.remove(postscriptNames[ii]);
                            fontSubstitutionFontID.put(familyNames[ii], ii);
                            fontPropertiesTable.remove(familyNames[ii] + "_path");
                            fontPropertiesTable.remove(familyNames[ii] + "_type");
                            fontPropertiesTable.put(familyNames[ii] + "_type", type);
                            fontPropertiesTable.put(familyNames[ii] + "_path", fontPath + currentFont);
                        }
                    } else {
                        String[] fontNames = null;
                        try {
                            fontNames = StandardFonts.readNamesFromFont(type, fontPath + currentFont, fontSubstitutionMode);
                        }
                        catch (Exception e) {
                            LogWriter.writeLog("Exception: " + e.getMessage());
                        }
                        if (fontNames != null) {
                            for (int i = 0; i < fontNames.length; ++i) {
                                if (fontNames[i] == null) {
                                    fontNames[i] = Strip.stripAllSpaces(fontName);
                                }
                                fontSubstitutionTable.put(fontNames[i], "/TrueType");
                                fontSubstitutionLocation.put(fontNames[i], fontPath + currentFont);
                                fontSubstitutionFontID.put(fontNames[i], i);
                                fontPropertiesTable.put(fontNames[i] + "_type", type);
                                fontPropertiesTable.put(fontNames[i] + "_path", fontPath + currentFont);
                            }
                        }
                    }
                } else if (type == 1228944677) {
                    String[] fontNames = null;
                    try {
                        fontNames = StandardFonts.readNamesFromFont(type, fontPath + currentFont, fontSubstitutionMode);
                    }
                    catch (Exception e) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                    if (fontNames != null) {
                        for (int i = 0; i < fontNames.length; ++i) {
                            if (fontNames[i] == null) {
                                fontNames[i] = Strip.stripAllSpaces(fontName);
                            }
                            fontSubstitutionTable.put(fontNames[i], "/Type1");
                            fontSubstitutionLocation.put(fontNames[i], fontPath + currentFont);
                            fontSubstitutionFontID.put(fontNames[i], i);
                            fontPropertiesTable.put(fontNames[i] + "_type", type);
                            fontPropertiesTable.put(fontNames[i] + "_path", fontPath + currentFont);
                        }
                    }
                }
            } else {
                LogWriter.writeLog("No fonts found at " + fontPath);
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    private static ArrayList getDirectoryMatches(String sDirectoryName) throws IOException {
        sDirectoryName = sDirectoryName.replaceAll("\\.", "/");
        URL u = Thread.currentThread().getContextClassLoader().getResource(sDirectoryName);
        ArrayList<String> retValue = new ArrayList<String>(0);
        String s = u.toString();
        System.out.println("scanning " + s);
        if (s.startsWith("jar:") && s.endsWith(sDirectoryName)) {
            int idx = s.lastIndexOf(sDirectoryName);
            s = s.substring(0, idx);
            System.out.println("entry= " + s);
            URL url = new URL(s);
            JarURLConnection conn = (JarURLConnection)url.openConnection();
            JarFile jar = conn.getJarFile();
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (entry.isDirectory() || !entry.getName().startsWith(sDirectoryName)) continue;
                String fontName = entry.getName();
                int i = fontName.lastIndexOf(47);
                retValue.add(fontName.substring(i + 1));
            }
        }
        return retValue;
    }

    private static ArrayList readIndirectValues(InputStream in) throws IOException {
        String nextValue;
        BufferedReader inpStream = new BufferedReader(new InputStreamReader(in));
        ArrayList<String> fonts = new ArrayList<String>(0);
        while ((nextValue = inpStream.readLine()) != null) {
            fonts.add(nextValue);
        }
        inpStream.close();
        return fonts;
    }

    public static void setDefaultDisplayFont(String fontName) throws PdfFontException {
        boolean isFontInstalled = false;
        String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int count = fontList.length;
        for (int i = 0; i < count; ++i) {
            if (!fontList[i].equalsIgnoreCase(fontName.toLowerCase())) continue;
            isFontInstalled = true;
            defaultFont = fontList[i];
            i = count;
        }
        if (!isFontInstalled) {
            throw new PdfFontException("Font " + fontName + " is not available.");
        }
    }

    static {
        fontSubstitutionLocation = new ConcurrentHashMap();
        fontSubstitutionAliasTable = new ConcurrentHashMap();
        separator = System.getProperty("file.separator");
        defaultFontDirs = new String[]{"C:/windows/fonts/", "C:/winNT/fonts/", "/Library/Fonts/", "/usr/share/fonts/truetype/msttcorefonts/", "usr/local/Fonts/"};
        fontSubstitutionMode = 1;
    }
}

