/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.fonts.glyph.T1Glyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.utils.LogWriter;

public class StandardFonts {
    private static Map unicode_name_mapping_table = new HashMap();
    private static String[][] unicode_char_decoding_table = new String[7][335];
    public static final int PDF = 6;
    public static final int ZAPF = 5;
    public static final int SYMBOL = 4;
    public static final int MACEXPERT = 3;
    public static final int WIN = 2;
    public static final int STD = 1;
    public static final int MAC = 0;
    public static final int TYPE0 = 1228944676;
    public static final int TYPE1 = 1228944677;
    public static final int TRUETYPE = 1217103210;
    public static final int TYPE3 = 1228944679;
    public static final int CIDTYPE0 = -1684566726;
    public static final int CIDTYPE2 = -1684566724;
    public static final int OPENTYPE = 6;
    public static final int TRUETYPE_COLLECTION = 7;
    public static final int FONT_UNSUPPORTED = 8;
    private static final String ellipsis = String.valueOf((char)Integer.parseInt("2026", 16));
    private static final String enc = "Cp1252";
    private static Map[] glyphToChar = new HashMap[7];
    private static String[] MAC_char_encoding_table;
    private static String[] WIN_char_encoding_table;
    private static String[] STD_char_encoding_table;
    private static String[] PDF_char_encoding_table;
    private static String[] ZAPF_char_encoding_table;
    private static String[] SYMBOL_char_encoding_table;
    private static String[] MACEXPERT_char_encoding_table;
    private static final Map<String, String> unicodeToName;
    private static ClassLoader loader;
    private static Map standardFileList;
    private static Map standardFontLoaded;
    private static Map widthTableStandard;
    protected static Map javaFontList;
    protected static String[] javaFonts;
    protected static String[] files_names;
    protected static String[] files_names_bis;
    private static HashMap adobeMap;
    private static Map fontBounds;
    public static boolean usesGlyphlist;
    private static final HashMap<String, HashMap<Integer, Integer>> mappedCharacters;
    private static final HashMap<String, ArrayList<Integer>> takenChars;
    private static final int MAX_CHAR_CODE = 55296;
    public static String[] CMAP;

    public static void dispose() {
        unicode_name_mapping_table = null;
        unicode_char_decoding_table = null;
        glyphToChar = null;
        MAC_char_encoding_table = null;
        WIN_char_encoding_table = null;
        STD_char_encoding_table = null;
        PDF_char_encoding_table = null;
        ZAPF_char_encoding_table = null;
        SYMBOL_char_encoding_table = null;
        MACEXPERT_char_encoding_table = null;
        loader = null;
        standardFileList = null;
        standardFontLoaded = null;
        widthTableStandard = null;
        javaFontList = null;
        javaFonts = null;
        files_names = null;
        files_names_bis = null;
        adobeMap = null;
        fontBounds = null;
    }

    public static int getFontType(String name) {
        int type = 8;
        if (name.endsWith(".ttf")) {
            type = 1217103210;
        } else if (name.endsWith(".otf")) {
            type = 6;
        } else if (name.endsWith(".ttc")) {
            type = 7;
        } else if (name.endsWith(".pfb")) {
            type = 1228944677;
        }
        return type;
    }

    public static float[] getFontBounds(String fontName) {
        return (float[])fontBounds.get(fontName);
    }

    public static String getUnicodeName(String key) {
        return (String)unicode_name_mapping_table.get(key);
    }

    public static String getUnicodeChar(int i, int key) {
        return unicode_char_decoding_table[i][key];
    }

    public static Float getStandardWidth(String font, String key) {
        String altfont;
        int p;
        Object value = widthTableStandard.get((font = font.toLowerCase()) + key);
        if (value == null && (p = (altfont = font).indexOf(44)) != -1) {
            altfont = altfont.substring(0, p);
            value = widthTableStandard.get(altfont + key);
        }
        return (Float)value;
    }

    private static void readStandardMappingTable(int key, String file_name) {
        BufferedReader input_stream = null;
        StandardFonts.glyphToChar[key] = new HashMap();
        try {
            String line;
            BufferedReader bufferedReader = input_stream = file_name.equals("symbol.cfg") ? new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/" + file_name), enc)) : new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/" + file_name), "UTF-16"));
            if (input_stream == null) {
                LogWriter.writeLog("Unable to open " + file_name + " to read standard encoding");
            }
            while ((line = input_stream.readLine()) != null) {
                String VAL;
                String NAME;
                String char_value;
                StringTokenizer values = new StringTokenizer(line);
                if (line.contains("space") || values.countTokens() <= 1) continue;
                if (values.countTokens() == 3) {
                    char_value = values.nextToken();
                    NAME = values.nextToken();
                    VAL = values.nextToken();
                } else if (values.countTokens() == 4) {
                    String hexVal = values.nextToken();
                    values.nextToken();
                    NAME = values.nextToken();
                    VAL = values.nextToken();
                    char_value = Character.toString((char)Integer.parseInt(hexVal, 16));
                } else if (values.countTokens() == 2) {
                    char_value = " ";
                    NAME = values.nextToken();
                    VAL = values.nextToken();
                } else {
                    char_value = values.nextToken();
                    NAME = values.nextToken();
                    VAL = values.nextToken();
                }
                unicode_name_mapping_table.put(key + NAME, char_value);
                glyphToChar[key].put(NAME, Integer.parseInt(VAL));
                unicode_name_mapping_table.put(NAME, char_value);
                if (!Character.isDigit(VAL.charAt(0))) continue;
                int value = Integer.parseInt(VAL, 8);
                if (key == 5) {
                    StandardFonts.ZAPF_char_encoding_table[value] = char_value;
                } else if (key == 4) {
                    StandardFonts.SYMBOL_char_encoding_table[value] = char_value;
                } else if (key == 3) {
                    StandardFonts.MACEXPERT_char_encoding_table[value] = char_value;
                }
                StandardFonts.unicode_char_decoding_table[key][value] = NAME;
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " reading lookup table for pdf");
        }
        if (input_stream != null) {
            try {
                input_stream.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    private static void readStandardMappingTable(int idx) {
        BufferedReader input_stream = null;
        if (idx == 0) {
            StandardFonts.checkLoaded(2);
        }
        try {
            String line;
            StandardFonts.glyphToChar[idx] = new HashMap();
            input_stream = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/standard_encoding.cfg"), enc));
            usesGlyphlist = true;
            if (input_stream == null) {
                LogWriter.writeLog("Unable to open standard_encoding.cfg from jar");
            }
            while ((line = input_stream.readLine()) != null) {
                int std_value;
                StringTokenizer values = new StringTokenizer(line);
                int count = values.countTokens();
                String NAME = values.nextToken();
                String STD_value = values.nextToken();
                String MAC_value = values.nextToken();
                String WIN_value = values.nextToken();
                String PDF_value = values.nextToken();
                String raw = values.nextToken();
                String char_value = count == 7 ? Character.toString((char)Integer.parseInt(raw, 16)) : raw;
                unicodeToName.put(char_value, NAME);
                if (idx == 0 && Character.isDigit(MAC_value.charAt(0))) {
                    int mac_value = Integer.parseInt(MAC_value, 8);
                    if (mac_value == 201) {
                        char_value = ellipsis;
                    }
                    StandardFonts.MAC_char_encoding_table[mac_value] = char_value;
                    StandardFonts.unicode_char_decoding_table[0][mac_value] = NAME;
                    glyphToChar[0].put(NAME, mac_value);
                } else if (idx == 1 && Character.isDigit(STD_value.charAt(0))) {
                    std_value = Integer.parseInt(STD_value, 8);
                    if (std_value == 188) {
                        char_value = ellipsis;
                    }
                    StandardFonts.STD_char_encoding_table[std_value] = char_value;
                    StandardFonts.unicode_char_decoding_table[1][std_value] = NAME;
                    glyphToChar[1].put(NAME, std_value);
                } else if (idx == 6 && Character.isDigit(PDF_value.charAt(0))) {
                    std_value = Integer.parseInt(PDF_value, 8);
                    if (std_value == 131) {
                        char_value = ellipsis;
                    }
                    StandardFonts.PDF_char_encoding_table[std_value] = char_value;
                    StandardFonts.unicode_char_decoding_table[6][std_value] = NAME;
                } else if (idx == 2 && Character.isDigit(WIN_value.charAt(0))) {
                    int win_value = Integer.parseInt(WIN_value, 8);
                    if (win_value == 133) {
                        char_value = ellipsis;
                    }
                    StandardFonts.WIN_char_encoding_table[win_value] = char_value;
                    StandardFonts.unicode_char_decoding_table[2][win_value] = NAME;
                    glyphToChar[2].put(NAME, win_value);
                }
                unicode_name_mapping_table.put(NAME, char_value);
            }
            if (idx == 0) {
                StandardFonts.MAC_char_encoding_table[202] = " ";
            }
            if (idx == 2) {
                StandardFonts.WIN_char_encoding_table[160] = " ";
                StandardFonts.WIN_char_encoding_table[255] = "-";
                StandardFonts.unicode_char_decoding_table[2][160] = "space";
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " reading lookup table for pdf  for " + idx);
        }
        if (input_stream != null) {
            try {
                input_stream.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    public static String getNameFromUnicode(String unicode) {
        return unicodeToName.get(unicode);
    }

    public static String getEncodedChar(int font_encoding, int char_int) {
        String return_character = null;
        switch (font_encoding) {
            case 2: {
                return_character = WIN_char_encoding_table[char_int];
                break;
            }
            case 1: {
                return_character = STD_char_encoding_table[char_int];
                break;
            }
            case 0: {
                return_character = MAC_char_encoding_table[char_int];
                break;
            }
            case 6: {
                return_character = PDF_char_encoding_table[char_int];
                break;
            }
            case 5: {
                return_character = ZAPF_char_encoding_table[char_int];
                break;
            }
            case 4: {
                return_character = SYMBOL_char_encoding_table[char_int];
                break;
            }
            case 3: {
                return_character = MACEXPERT_char_encoding_table[char_int];
                break;
            }
        }
        if (return_character == null) {
            return_character = "&#" + char_int + ';';
        }
        return return_character;
    }

    public static void checkLoaded(int enc) {
        if (enc == 0 && MAC_char_encoding_table == null) {
            MAC_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(enc);
        } else if (enc == 2 && WIN_char_encoding_table == null) {
            WIN_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(enc);
        } else if (enc == 1 && STD_char_encoding_table == null) {
            STD_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(enc);
        } else if (enc == 6 && PDF_char_encoding_table == null) {
            PDF_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(enc);
        } else if (enc == 4 && SYMBOL_char_encoding_table == null) {
            SYMBOL_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(4, "symbol.cfg");
        } else if (enc == 5 && ZAPF_char_encoding_table == null) {
            ZAPF_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(5, "zapf.cfg");
        } else if (enc == 3 && MACEXPERT_char_encoding_table == null) {
            MACEXPERT_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(3, "mac_expert.cfg");
        }
    }

    static final synchronized void loadStandardFont(int i) throws IOException {
        String line;
        String char_name = "";
        float width = 200.0f;
        if (standardFontLoaded.get(i) != null) {
            return;
        }
        BufferedReader input_stream = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/defaults/" + files_names[i] + ".afm"), enc));
        boolean char_mapping_table = false;
        while ((line = input_stream.readLine()) != null) {
            if (line.startsWith("EndCharMetrics")) {
                char_mapping_table = false;
            }
            if (line.startsWith("FontBBox")) {
                float[] fontBBox = new float[4];
                StringTokenizer values = new StringTokenizer(line);
                values.nextToken();
                for (int a = 0; a < 4; ++a) {
                    fontBBox[a] = Integer.parseInt(values.nextToken());
                }
                fontBounds.put(files_names[i], fontBBox);
            }
            if (char_mapping_table) {
                StringTokenizer values = new StringTokenizer(line, " ;");
                while (values.hasMoreTokens()) {
                    String next_command = values.nextToken();
                    if (next_command.equals("WX")) {
                        width = Float.parseFloat(values.nextToken()) / 1000.0f;
                        continue;
                    }
                    if (!next_command.equals("N")) continue;
                    char_name = values.nextToken();
                }
                widthTableStandard.put(files_names_bis[i].toLowerCase() + char_name, Float.valueOf(width));
                widthTableStandard.put(files_names[i].toLowerCase() + char_name, Float.valueOf(width));
            }
            if (!line.startsWith("StartCharMetrics")) continue;
            char_mapping_table = true;
        }
        if (input_stream != null) {
            try {
                input_stream.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " reading lookup table for pdf  for abobe map");
            }
        }
        standardFontLoaded.put(i, "x");
    }

    protected static void loadStandardFontWidth(String fontName) {
        Integer fileNumber = (Integer)standardFileList.get(fontName);
        if (fileNumber != null && standardFontLoaded.get(fileNumber) == null) {
            try {
                StandardFonts.loadStandardFont(fileNumber);
            }
            catch (Exception e) {
                LogWriter.writeLog("[PDF] " + e + " problem reading lookup table for pdf font " + fontName + ' ' + fontName);
            }
        }
    }

    public static int lookupCharacterIndex(String glyph, int idx) {
        Object value = glyphToChar[idx].get(glyph);
        if (value == null) {
            return 0;
        }
        return (Integer)value;
    }

    private static void loadAdobeMap() {
        BufferedReader input_stream = null;
        if (adobeMap == null) {
            try {
                String line;
                adobeMap = new HashMap();
                input_stream = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/glyphlist.cfg"), enc));
                if (input_stream == null) {
                    LogWriter.writeLog("Unable to open glyphlist.cfg from jar");
                }
                while ((line = input_stream.readLine()) != null) {
                    if (line.startsWith("#") || line.indexOf(59) == -1) continue;
                    StringTokenizer vals = new StringTokenizer(line, ";");
                    String key = vals.nextToken();
                    String operand = vals.nextToken();
                    int space = operand.indexOf(32);
                    if (space != -1) {
                        operand = operand.substring(0, space);
                    }
                    int opVal = Integer.parseInt(operand, 16);
                    adobeMap.put(key, opVal);
                    unicode_name_mapping_table.put(key, Character.toString((char)opVal));
                }
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " reading lookup table for pdf  for abobe map");
            }
        }
        if (input_stream != null) {
            try {
                input_stream.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    public static int getAdobeMap(String key) {
        Object value = adobeMap.get(key);
        if (value == null) {
            return -1;
        }
        return (Integer)value;
    }

    public static boolean isValidGlyphName(String key) {
        if (key == null) {
            return false;
        }
        return adobeMap.get(key) != null;
    }

    public static boolean isStandardFont(String fontName, boolean includeWeights) {
        int ptr;
        boolean isStandard;
        boolean bl = isStandard = standardFileList.get(fontName) != null;
        if (!isStandard && includeWeights && (ptr = fontName.indexOf(45)) != -1) {
            String rawName = fontName.substring(0, ptr);
            isStandard = standardFileList.get(rawName) != null;
        }
        return isStandard;
    }

    public static Map getFontDetails(int type, String subFont) {
        HashMap fontDetails = new HashMap();
        if (type == 1217103210 || type == 7) {
            TTGlyphs.addStringValues(new FontData(subFont), fontDetails);
        }
        return fontDetails;
    }

    public static String[] readNamesFromFont(int type, String subFont, int mode) throws Exception {
        String[] fontNames = new String[]{""};
        if (type == 1217103210 || type == 7) {
            fontNames = TTGlyphs.readFontNames(new FontData(subFont), mode);
        } else if (type == 1228944677) {
            fontNames = T1Glyphs.readFontNames(new FontData(subFont));
        }
        return fontNames;
    }

    public static String convertNumberToGlyph(String mappedChar, boolean containsHexNumbers, boolean allowSingleValue) {
        int charCount = mappedChar.length();
        boolean isNumber = true;
        boolean hasHex = false;
        if (charCount == 2 || charCount == 3 || allowSingleValue && charCount == 1) {
            for (int ii = 0; ii < charCount; ++ii) {
                char c = mappedChar.charAt(ii);
                if (c >= '0' && c <= '9') continue;
                if (containsHexNumbers && c >= 'A' && c <= 'F') {
                    hasHex = true;
                    continue;
                }
                isNumber = false;
                ii = charCount;
            }
            if (isNumber) {
                if (charCount == 3 || !containsHexNumbers) {
                    if (!hasHex) {
                        mappedChar = String.valueOf((char)Integer.parseInt(mappedChar));
                    }
                } else {
                    mappedChar = String.valueOf((char)Integer.parseInt(mappedChar, 16));
                }
            }
        } else {
            boolean hasHash = false;
            boolean hasText = false;
            for (int ii = 0; ii < charCount; ++ii) {
                char c = mappedChar.charAt(ii);
                if (c == '#') {
                    hasHash = true;
                }
                if (c < 'A' || c > 'Z') continue;
                hasText = true;
            }
            if (hasHash) {
                int ii;
                StringBuilder buf = new StringBuilder(mappedChar);
                if (hasText) {
                    try {
                        for (ii = 0; ii < charCount; ++ii) {
                            char c = buf.charAt(ii);
                            if (c != '#' || ii >= charCount) continue;
                            for (int aa = 0; aa < 2; ++aa) {
                                buf.deleteCharAt(ii + 1);
                                --charCount;
                            }
                        }
                    }
                    catch (Exception e) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                } else {
                    for (ii = 0; ii < charCount; ++ii) {
                        char c = buf.charAt(ii);
                        if (c != '#') continue;
                        if ((ii += 3) < charCount) {
                            char c2 = buf.charAt(ii);
                            while (c2 >= '0' && c2 <= '9') {
                                buf.deleteCharAt(ii);
                                if (ii >= --charCount) break;
                                c2 = buf.charAt(ii);
                            }
                        }
                        --ii;
                    }
                }
                mappedChar = buf.toString();
            }
        }
        return mappedChar;
    }

    public static String getFontypeAsString(int fontType) {
        switch (fontType) {
            case 1217103210: {
                return "TrueType";
            }
            case 1228944677: {
                return "Type1";
            }
            case 1228944679: {
                return "Type3";
            }
            case -1684566726: {
                return "CIDFontType0";
            }
            case -1684566724: {
                return "CIDFontType2";
            }
        }
        return "Unknown";
    }

    private static void blockForbiddenRanges(ArrayList<Integer> ids) {
        int i;
        for (i = 0; i <= 31; ++i) {
            ids.add(i);
        }
        for (i = 127; i <= 160; ++i) {
            ids.add(i);
        }
        for (i = 8204; i <= 8207; ++i) {
            ids.add(i);
        }
    }

    public static int mapCIDToValidUnicode(String fontName, int cid) {
        Integer result;
        HashMap<Integer, Integer> cidMap = mappedCharacters.get(fontName);
        ArrayList<Integer> taken = takenChars.get(fontName);
        if (cidMap == null) {
            cidMap = new HashMap();
            mappedCharacters.put(fontName, cidMap);
            taken = new ArrayList();
            takenChars.put(fontName, taken);
            StandardFonts.blockForbiddenRanges(taken);
        }
        if ((result = cidMap.get(cid)) != null) {
            return result;
        }
        int newCid = cid;
        if (cid < 32) {
            newCid += 32;
        }
        while (taken.contains(newCid) && taken.size() < 55296) {
            newCid = (newCid + 1) % 55296;
        }
        cidMap.put(cid, newCid);
        taken.add(newCid);
        return newCid;
    }

    public static int getIDForGlyphName(String fontName, String glyphName) {
        boolean base10 = false;
        int uc = StandardFonts.getAdobeMap(glyphName);
        if (uc >= 0) {
            return uc;
        }
        if (glyphName.startsWith("uni")) {
            glyphName = glyphName.substring(3);
        } else if (glyphName.charAt(0) == 'u' || glyphName.charAt(0) == 'G') {
            glyphName = glyphName.substring(1);
        } else {
            base10 = true;
        }
        try {
            int num;
            if (base10) {
                num = Integer.parseInt(glyphName, 10);
                num = StandardFonts.mapCIDToValidUnicode(fontName, num);
            } else {
                num = Integer.parseInt(glyphName, 16);
            }
            return num;
        }
        catch (NumberFormatException e) {
            LogWriter.writeLog("Exception in handling cid id " + e);
            return -1;
        }
    }

    public static String expandName(String name) {
        String testName = name.toLowerCase();
        if (testName.equals("cour")) {
            name = "Courier";
        } else if (testName.equals("helv")) {
            name = "Helvetica";
        } else if (testName.equals("hebo")) {
            name = "Helvetica-BOLD";
        } else if (testName.equals("zadb")) {
            name = "ZapfDingbats";
        } else if (testName.equals("tiro")) {
            name = "Times";
        }
        return name;
    }

    public static void readCMAP() {
        CMAP = new String[65536];
        try {
            String line;
            BufferedReader input_stream = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/jis.cfg")));
            while ((line = input_stream.readLine()) != null) {
                if (!line.startsWith("0") || !line.contains("#")) continue;
                StringTokenizer values = new StringTokenizer(line);
                String xx = values.nextToken().substring(2);
                int rawVal = Integer.parseInt(xx, 16);
                int unicodeVal = Integer.parseInt(values.nextToken().substring(2), 16);
                StandardFonts.CMAP[rawVal] = String.valueOf((char)unicodeVal);
            }
            input_stream.close();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }

    static {
        unicodeToName = new HashMap<String, String>();
        loader = StandardFonts.class.getClassLoader();
        standardFileList = new HashMap();
        standardFontLoaded = new HashMap();
        widthTableStandard = new Hashtable();
        javaFontList = new HashMap();
        javaFonts = new String[]{"Courier", "Courier-Bold", "Courier", "Courier-Bold", "Arial", "Arial-Bold", "Arial", "Arial-Italic", "Symbol", "Times New Roman", "Times New Roman", "Times New Roman", "Times New Roman", "Wingdings"};
        files_names = new String[]{"Courier", "Courier-Bold", "Courier-BoldOblique", "Courier-Oblique", "Helvetica", "Helvetica-Bold", "Helvetica-BoldOblique", "Helvetica-Oblique", "Symbol", "Times-Bold", "Times-BoldItalic", "Times-Italic", "Times-Roman", "ZapfDingbats"};
        files_names_bis = new String[]{"CourierNew", "CourierNew,Bold", "CourierNew,BoldItalic", "CourierNew,Italic", "Arial", "Arial,Bold", "Arial,BoldItalic", "Arial,Italic", "Symbol", "TimesNewRoman,Bold", "TimesNewRoman,BoldItalic", "TimesNewRoman,Italic", "TimesNewRoman", "ZapfDingbats"};
        fontBounds = new Hashtable();
        for (int i = 0; i < files_names.length; ++i) {
            standardFileList.put(files_names_bis[i], i);
            standardFileList.put(files_names[i], i);
        }
        StandardFonts.loadAdobeMap();
        mappedCharacters = new HashMap();
        takenChars = new HashMap();
    }
}

