/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.fonts.glyph.T3Glyphs;
import org.jpedal.fonts.glyph.T3Size;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.T3StreamDecoder;
import org.jpedal.render.T3Display;
import org.jpedal.utils.LogWriter;

public class Type3
extends PdfFont {
    private final GraphicsState currentGraphicsState = new GraphicsState();
    private final boolean isPrinting;

    public Type3(PdfObjectReader current_pdf_file, boolean isPrinting) {
        this.glyphs = new T3Glyphs();
        this.isPrinting = isPrinting;
        this.init(current_pdf_file);
    }

    @Override
    public final void createFont(PdfObject pdfObject, String fontID, boolean renderPage, ObjectStore objectStore, Map substitutedFonts) throws Exception {
        this.fontTypes = 1228944679;
        this.init(fontID, renderPage);
        PdfObject pdfFontDescriptor = pdfObject.getDictionary(-1044665361);
        this.setBoundsAndMatrix(pdfObject);
        this.setName(pdfObject);
        this.setEncoding(pdfObject, pdfFontDescriptor);
        this.readWidths(pdfObject, false);
        this.readEmbeddedFont(pdfObject, objectStore);
        if (renderPage) {
            this.setFont(this.getBaseFontName(), 1);
        }
    }

    private void readEmbeddedFont(PdfObject pdfObject, ObjectStore objectStore) {
        boolean hires = true;
        PdfObject CharProcs = pdfObject.getDictionary(2054190454);
        if (CharProcs != null) {
            T3StreamDecoder glyphDecoder = new T3StreamDecoder(this.currentPdfFile, true, this.isPrinting);
            glyphDecoder.setParameters(false, true, 7, 0, false, false);
            glyphDecoder.setObjectValue(-8, objectStore);
            PdfObject Resources = pdfObject.getDictionary(2004251818);
            if (Resources != null) {
                try {
                    glyphDecoder.readResources(Resources, false);
                }
                catch (PdfException e) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            PdfKeyPairsIterator keyPairs = CharProcs.getKeyPairsIterator();
            while (keyPairs.hasMorePairs()) {
                String glyphKey = keyPairs.getNextKeyAsString();
                PdfObject glyphObj = keyPairs.getNextValueAsDictionary();
                if (glyphObj != null && this.renderPage && !glyphKey.equals(".notdef") && !glyphKey.equals(".")) {
                    T3Display glyphDisplay = new T3Display(0, false, 20, objectStore);
                    glyphDisplay.setHiResImageForDisplayMode(true);
                    glyphDisplay.setType3Glyph(glyphKey);
                    try {
                        glyphDecoder.setRenderer(glyphDisplay);
                        glyphDecoder.setDefaultColors(this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getNonstrokeColor());
                        int factor = 1;
                        double[] fontMatrix = pdfObject.getDoubleArray(-2105119560);
                        if (fontMatrix != null && fontMatrix[0] == 1.0 && (fontMatrix[3] == 1.0 || fontMatrix[3] == -1.0)) {
                            factor = 10;
                        }
                        GraphicsState gs = new GraphicsState(0, 0);
                        gs.CTM = new float[][]{{factor, 0.0f, 0.0f}, {0.0f, factor, 0.0f}, {0.0f, 0.0f, 1.0f}};
                        T3Size t3 = glyphDecoder.decodePageContent(glyphObj, gs);
                        int renderX = t3.x;
                        int renderY = t3.y;
                        if (renderX == 0 && renderY != 0) {
                            renderX = t3.y;
                            renderY = t3.x;
                        }
                        T3Glyph glyph = new T3Glyph(glyphDisplay, renderX, renderY, glyphDecoder.ignoreColors);
                        glyph.setScaling(1.0f / (float)factor);
                        int otherKey = -1;
                        int key = ((Number)this.rawDiffKeys.get(keyPairs.getNextKeyAsString())).intValue();
                        this.glyphs.setT3Glyph(key, otherKey, glyph);
                    }
                    catch (Exception e) {
                        LogWriter.writeLog("Exception " + e + " is Type3 font code");
                    }
                }
                keyPairs.nextPair();
            }
            this.isFontEmbedded = true;
        }
    }
}

