/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import org.jpedal.utils.LogWriter;

class UnicodeReader {
    private static final int[] powers = new int[]{1, 16, 256, 4096};
    int ptr;
    final byte[] data;
    boolean hasDoubleBytes;

    UnicodeReader(byte[] data) {
        this.data = data;
    }

    public String[] readUnicode() {
        if (this.data == null) {
            return null;
        }
        int defType = 0;
        String[] unicodeMappings = new String[65536];
        int length = this.data.length;
        boolean inDef = false;
        try {
            while (true) {
                if (this.ptr < length && this.data[this.ptr] == 9) {
                    ++this.ptr;
                    continue;
                }
                if (this.ptr < length) {
                    if (this.ptr + 4 < length && this.data[this.ptr] == 101 && this.data[this.ptr + 1] == 110 && this.data[this.ptr + 2] == 100 && this.data[this.ptr + 3] == 98 && this.data[this.ptr + 4] == 102) {
                        defType = 0;
                        inDef = false;
                    } else if (inDef) {
                        this.readLineValue(unicodeMappings, defType);
                    }
                    if (this.ptr < length) {
                        if (this.data[this.ptr] == 98 && this.data[this.ptr + 1] == 101 && this.data[this.ptr + 2] == 103 && this.data[this.ptr + 3] == 105 && this.data[this.ptr + 4] == 110 && this.data[this.ptr + 5] == 98 && this.data[this.ptr + 6] == 102 && this.data[this.ptr + 7] == 99 && this.data[this.ptr + 8] == 104 && this.data[this.ptr + 9] == 97 && this.data[this.ptr + 10] == 114) {
                            defType = 1;
                            this.ptr += 10;
                            inDef = true;
                        } else if (this.data[this.ptr] == 98 && this.data[this.ptr + 1] == 101 && this.data[this.ptr + 2] == 103 && this.data[this.ptr + 3] == 105 && this.data[this.ptr + 4] == 110 && this.data[this.ptr + 5] == 98 && this.data[this.ptr + 6] == 102 && this.data[this.ptr + 7] == 114 && this.data[this.ptr + 8] == 97 && this.data[this.ptr + 9] == 110 && this.data[this.ptr + 10] == 103 && this.data[this.ptr + 11] == 101) {
                            defType = 2;
                            this.ptr += 11;
                            inDef = true;
                        }
                        ++this.ptr;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception setting up text object " + e);
        }
        return unicodeMappings;
    }

    private void readLineValue(String[] unicodeMappings, int type) {
        int entryCount = type + 1;
        int dataLen = this.data.length;
        int[] value = new int[2000];
        boolean isMultipleValues = false;
        for (int vals = 0; vals < entryCount; ++vals) {
            if (!isMultipleValues) {
                while (this.ptr < this.data.length && this.data[this.ptr] != 60) {
                    if (vals == 2 && entryCount == 3 && this.data[this.ptr] == 91) {
                        type = 4;
                        int ii = this.ptr;
                        while (this.data[ii] != 93) {
                            if (this.data[ii] == 60) {
                                ++entryCount;
                            }
                            ++ii;
                        }
                        --entryCount;
                    }
                    ++this.ptr;
                }
                ++this.ptr;
            }
            int count = 0;
            int charsFound = 0;
            while (this.ptr < dataLen && this.data[this.ptr] != 62) {
                if (this.data[this.ptr] != 10 && this.data[this.ptr] != 13 && this.data[this.ptr] != 32) {
                    ++charsFound;
                }
                ++this.ptr;
                ++count;
                if (charsFound != 5) continue;
                count = 4;
                --this.ptr;
                ++entryCount;
                isMultipleValues = true;
                break;
            }
            int pos = 0;
            for (int jj = 0; jj < count; ++jj) {
                int raw;
                while ((raw = this.data[this.ptr - 1 - jj]) == 10 || raw == 13 || raw == 32) {
                    ++jj;
                }
                if (raw >= 65 && raw <= 70) {
                    raw -= 55;
                } else if (raw >= 97 && raw <= 102) {
                    raw -= 87;
                } else if (raw >= 48 && raw <= 57) {
                    raw -= 48;
                } else {
                    throw new RuntimeException("Unexpected number " + (char)raw);
                }
                int n = vals;
                value[n] = value[n] + raw * powers[pos];
                ++pos;
            }
        }
        while (this.ptr < dataLen && (this.data[this.ptr] == 62 || this.data[this.ptr] == 32 || this.data[this.ptr] == 10 || this.data[this.ptr] == 13 || this.data[this.ptr] == 93)) {
            ++this.ptr;
        }
        --this.ptr;
        this.fillValues(unicodeMappings, entryCount, value, type);
    }

    private void fillValues(String[] unicodeMappings, int entryCount, int[] value, int type) {
        switch (type) {
            case 1: {
                if (entryCount == 2) {
                    if (value[type] <= 0) break;
                    unicodeMappings[value[0]] = String.valueOf((char)value[type]);
                    if (value[0] <= 255) break;
                    this.hasDoubleBytes = true;
                    break;
                }
                char[] str = new char[entryCount - 1];
                for (int aa = 0; aa < entryCount - 1; ++aa) {
                    str[aa] = (char)value[type + aa];
                }
                unicodeMappings[value[0]] = new String(str);
                if (value[0] <= 255) break;
                this.hasDoubleBytes = true;
                break;
            }
            case 4: {
                int j = 2;
                for (int i = value[0]; i < value[1] + 1; ++i) {
                    if (entryCount > 1 && value[0] == value[1]) {
                        unicodeMappings[i] = String.valueOf((char)value[2]);
                        if (i > 255) {
                            this.hasDoubleBytes = true;
                        }
                        for (int jj = 1; jj < entryCount; ++jj) {
                            int n = i;
                            unicodeMappings[n] = unicodeMappings[n] + String.valueOf((char)value[2 + jj]);
                            if (i <= 255) continue;
                            this.hasDoubleBytes = true;
                        }
                        continue;
                    }
                    int intValue = value[j];
                    ++j;
                    if (intValue <= 0) continue;
                    unicodeMappings[i] = String.valueOf((char)intValue);
                    if (i <= 255) continue;
                    this.hasDoubleBytes = true;
                }
                break;
            }
            default: {
                for (int i = value[0]; i < value[1] + 1; ++i) {
                    int intValue = value[type] + i - value[0];
                    if (intValue <= 0) continue;
                    unicodeMappings[i] = String.valueOf((char)intValue);
                    if (i <= 255) continue;
                    this.hasDoubleBytes = true;
                }
            }
        }
    }

    public boolean hasDoubleByteValues() {
        return this.hasDoubleBytes;
    }
}

