/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectOutput;
import javafx.collections.ObservableList;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import org.jpedal.color.PdfTexturePaint;
import org.jpedal.fonts.glyph.BaseT1Glyph;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.repositories.Vector_Path;

public class T1GlyphFX
extends BaseT1Glyph {
    private transient Vector_Path cached_current_path;
    private Paint strokePaint;
    float[] x;
    float[] y;
    float[] x2;
    float[] y2;
    float[] x3;
    float[] y3;
    float ymin;
    int end;
    int[] commands;
    Area glyphShape;
    int minX;
    int minY;
    int maxX;
    int maxY;

    public T1GlyphFX() {
    }

    public T1GlyphFX(float[] x, float[] y, float[] x2, float[] y2, float[] x3, float[] y3, float ymin, int end, int[] commands) {
        this.x = x;
        this.y = y;
        this.x2 = x2;
        this.y2 = y2;
        this.x3 = x3;
        this.y3 = y3;
        this.ymin = ymin;
        this.end = end;
        this.commands = commands;
    }

    @Override
    public void render(int text_fill_type, Graphics2D g2, float scaling, boolean isFormGlyph) {
        if (this.cached_current_path != null) {
            GeneralPath[] paths;
            for (GeneralPath path : paths = this.cached_current_path.get()) {
                if (path == null) break;
                if (text_fill_type == 2) {
                    Paint fillPaint;
                    if (this.isStroked && !((fillPaint = g2.getPaint()) instanceof PdfTexturePaint) && ((Color)this.strokePaint).getRGB() != ((Color)fillPaint).getRGB() && this.strokedPositions.containsKey(String.valueOf((int)g2.getTransform().getTranslateX()) + '-' + (int)g2.getTransform().getTranslateY())) {
                        Stroke fillStroke = g2.getStroke();
                        g2.setPaint(this.strokePaint);
                        float w = (float)((double)scaling / g2.getTransform().getScaleX());
                        if (w < 0.0f) {
                            w = -w;
                        }
                        g2.setStroke(new BasicStroke(w));
                        g2.draw(path);
                        g2.setPaint(fillPaint);
                        g2.setStroke(fillStroke);
                    }
                    g2.fill(path);
                }
                if (text_fill_type != 1) continue;
                if (text_fill_type != 2 && scaling > 1.0f) {
                    float w = (float)((double)scaling / g2.getTransform().getScaleX());
                    if (w < 0.0f) {
                        w = -w;
                    }
                    g2.setStroke(new BasicStroke(w));
                }
                g2.draw(path);
                this.strokePaint = g2.getPaint();
                this.strokedPositions.put(String.valueOf((int)g2.getTransform().getTranslateX()) + '-' + (int)g2.getTransform().getTranslateY(), "x");
            }
        }
    }

    @Override
    public Area getShape() {
        if (this.cached_current_path != null && this.glyphShape == null) {
            GeneralPath[] paths = this.cached_current_path.get();
            int cacheCount = paths.length;
            for (int i = 1; i < cacheCount && paths[i] != null; ++i) {
                paths[0].append(paths[i], false);
            }
            if (paths != null && paths[0] != null) {
                this.glyphShape = new Area(paths[0]);
            }
        }
        return this.glyphShape;
    }

    public void setPaths(Vector_Path vp) {
        this.cached_current_path = vp;
    }

    public void writePathsToStream(ObjectOutput os) throws IOException {
        if (this.cached_current_path != null) {
            int i;
            GeneralPath[] paths = this.cached_current_path.get();
            int count = 0;
            for (i = 0; i < paths.length; ++i) {
                if (paths[i] != null) continue;
                count = i;
                break;
            }
            os.writeObject(count);
            for (i = 0; i < count; ++i) {
                PathIterator pathIterator = paths[i].getPathIterator(new AffineTransform());
                PathSerializer.serializePath(os, pathIterator);
            }
        }
    }

    public void flushArea() {
        this.glyphShape = null;
    }

    @Override
    public int getFontBB(int type) {
        if (this.minX == 0 && this.minY == 0 && this.maxX == 0 && this.maxY == 0 && this.cached_current_path != null) {
            GeneralPath[] paths = this.cached_current_path.get();
            int cacheCount = paths.length;
            for (int i = 0; i < cacheCount && paths[i] != null; ++i) {
                Rectangle b = paths[i].getBounds();
                if (i == 0) {
                    this.minX = b.x;
                    this.minY = b.y;
                    this.maxX = b.width;
                    this.maxY = b.height;
                    continue;
                }
                if (this.minX > b.x) {
                    this.minX = b.x;
                }
                if (this.minY > b.y) {
                    this.minY = b.y;
                }
                if (this.maxX < b.width) {
                    this.maxX = b.width;
                }
                if (this.maxY >= b.height) continue;
                this.maxY = b.height;
            }
        }
        switch (type) {
            case 1: {
                return this.minX;
            }
            case 2: {
                return this.minY;
            }
            case 3: {
                return this.maxX;
            }
            case 4: {
                return this.minY;
            }
        }
        return 0;
    }

    public Path getPath() {
        Path currentPath = new Path();
        currentPath.setFillRule(FillRule.NON_ZERO);
        ObservableList elements = currentPath.getElements();
        elements.add((Object)new MoveTo(0.0, 0.0));
        block6: for (int i = 0; i < this.end; ++i) {
            switch (this.commands[i]) {
                case 2: {
                    elements.add((Object)new LineTo((double)this.x[i], (double)(this.y[i] - this.ymin)));
                    continue block6;
                }
                case 3: {
                    elements.add((Object)new ClosePath());
                    elements.add((Object)new MoveTo(0.0, 0.0));
                    continue block6;
                }
                case 1: {
                    elements.add((Object)new MoveTo((double)this.x[i], (double)(this.y[i] - this.ymin)));
                    continue block6;
                }
                case 5: {
                    elements.add((Object)new CubicCurveTo((double)this.x[i], (double)(this.y[i] - this.ymin), (double)this.x2[i], (double)(this.y2[i] - this.ymin), (double)this.x3[i], (double)(this.y3[i] - this.ymin)));
                    continue block6;
                }
            }
        }
        return currentPath;
    }
}

