/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.objects.T1GlyphNumber;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class T1Glyphs
extends PdfJavaGlyphs {
    private boolean is1C;
    private String[] charForGlyphIndex;
    private DynamicVectorRenderer dynamicVectorRenderer;
    private final Map<String, byte[]> charStrings = new HashMap<String, byte[]>();
    private final Map<String, Integer> glyphNumbers = new HashMap<String, Integer>();
    private static final int max = 100;
    private double[] operandsRead = new double[100];
    private int operandReached;
    private float[] pt;
    private double xs = -1.0;
    private double ys = -1.0;
    private double x;
    private double y;
    private int ptCount;
    private int currentOp;
    private int hintCount;
    private boolean allowAll;
    private double h;
    private boolean isCID;
    private int[] nominalWidthX = new int[]{0};
    private int[] defaultWidthX = new int[0];
    private boolean defaultWidthsPassed;
    private int[] fdSelect;

    public T1Glyphs(boolean isCID) {
        this.isCID = isCID;
    }

    public T1Glyphs(boolean isCID, boolean is1C) {
        this.charForGlyphIndex = new String[65536];
    }

    public static String[] readFontNames(FontData fontData) {
        BufferedReader br;
        String[] fontNames;
        block7: {
            int nameEnd;
            int nameStart;
            fontNames = new String[]{null};
            br = new BufferedReader(new StringReader(new String(fontData.getBytes(0, fontData.length()))));
            String line = null;
            do {
                try {
                    line = br.readLine();
                }
                catch (IOException e) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
                if (line == null) break block7;
            } while (!line.startsWith("/FontName") || (nameStart = line.indexOf(47, 9)) == -1 || (nameEnd = line.indexOf(32, nameStart)) == -1);
            String name = line.substring(nameStart + 1, nameEnd);
            fontNames[0] = name.toLowerCase();
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " closing stream");
            }
        }
        if (fontData != null) {
            fontData.close();
        }
        return fontNames;
    }

    private boolean processFlex(GlyphFactory factory, boolean isFlex, int routine) {
        if (isFlex && this.ptCount == 14 && routine == 0) {
            isFlex = false;
            for (int i = 0; i < 12; i += 6) {
                factory.curveTo(this.pt[i], this.pt[i + 1], this.pt[i + 2], this.pt[i + 3], this.pt[i + 4], this.pt[i + 5]);
            }
        } else if (!isFlex && routine >= 0 && routine <= 2) {
            isFlex = true;
            this.ptCount = 0;
            this.pt = new float[16];
        }
        return isFlex;
    }

    private void endchar(GlyphFactory factory, int rawInt) {
        if (this.operandReached == 5) {
            --this.operandReached;
            ++this.currentOp;
        }
        if (this.operandReached == 4) {
            StandardFonts.checkLoaded(1);
            float adx = (float)(this.x + this.operandsRead[this.currentOp]);
            float ady = (float)(this.y + this.operandsRead[this.currentOp + 1]);
            String bchar = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[this.currentOp + 2]);
            String achar = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[this.currentOp + 3]);
            this.x = 0.0;
            this.y = 0.0;
            this.decodeGlyph(null, factory, bchar, rawInt, "");
            factory.closePath();
            factory.moveTo(adx, ady);
            this.x = adx;
            this.y = ady;
            this.decodeGlyph(null, factory, achar, rawInt, "");
            if (this.xs == -1.0) {
                this.xs = this.x;
                this.ys = this.y;
            }
        } else {
            factory.closePath();
        }
    }

    private int mask(int p) {
        this.hintCount += this.operandReached / 2;
        for (int count = this.hintCount; count > 0; count -= 8) {
            ++p;
        }
        return p;
    }

    private double sbw() {
        double val;
        this.y = val = this.operandsRead[this.operandReached - 2];
        this.xs = this.x = (val = this.operandsRead[this.operandReached - 1]);
        this.ys = this.y;
        this.allowAll = true;
        double yy = this.y;
        this.h = this.operandsRead[this.operandReached - 3];
        return yy;
    }

    private void hmoveto(GlyphFactory factory, boolean isFirst) {
        if (isFirst && this.operandReached == 2) {
            ++this.currentOp;
        }
        double val = this.operandsRead[this.currentOp];
        this.x += val;
        factory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
    }

    private void rmoveto(GlyphFactory factory, boolean isFirst) {
        if (isFirst && this.operandReached == 3) {
            ++this.currentOp;
        }
        double val = this.operandsRead[this.currentOp + 1];
        this.y += val;
        val = this.operandsRead[this.currentOp];
        this.x += val;
        factory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
    }

    private void vhhvcurveto(GlyphFactory factory, int key) {
        boolean isHor;
        boolean bl = isHor = key == 31;
        while (this.operandReached >= 4) {
            this.operandReached -= 4;
            if (isHor) {
                this.x += this.operandsRead[this.currentOp];
            } else {
                this.y += this.operandsRead[this.currentOp];
            }
            this.pt[0] = (float)this.x;
            this.pt[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 1];
            this.y += this.operandsRead[this.currentOp + 2];
            this.pt[2] = (float)this.x;
            this.pt[3] = (float)this.y;
            if (isHor) {
                this.y += this.operandsRead[this.currentOp + 3];
                if (this.operandReached == 1) {
                    this.x += this.operandsRead[this.currentOp + 4];
                }
            } else {
                this.x += this.operandsRead[this.currentOp + 3];
                if (this.operandReached == 1) {
                    this.y += this.operandsRead[this.currentOp + 4];
                }
            }
            this.pt[4] = (float)this.x;
            this.pt[5] = (float)this.y;
            factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
            this.currentOp += 4;
            isHor = !isHor;
        }
    }

    private void vvhhcurveto(GlyphFactory factory, int key) {
        boolean isVV;
        boolean bl = isVV = key == 26;
        if ((this.operandReached & 1) == 1) {
            if (isVV) {
                this.x += this.operandsRead[0];
            } else {
                this.y += this.operandsRead[0];
            }
            ++this.currentOp;
        }
        while (this.currentOp < this.operandReached) {
            if (isVV) {
                this.y += this.operandsRead[this.currentOp];
            } else {
                this.x += this.operandsRead[this.currentOp];
            }
            this.pt[0] = (float)this.x;
            this.pt[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 1];
            this.y += this.operandsRead[this.currentOp + 2];
            this.pt[2] = (float)this.x;
            this.pt[3] = (float)this.y;
            if (isVV) {
                this.y += this.operandsRead[this.currentOp + 3];
            } else {
                this.x += this.operandsRead[this.currentOp + 3];
            }
            this.pt[4] = (float)this.x;
            this.pt[5] = (float)this.y;
            this.currentOp += 4;
            factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        }
    }

    private void rlinecurve(GlyphFactory factory) {
        for (int lineCount = (this.operandReached - 6) / 2; lineCount > 0; --lineCount) {
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            factory.lineTo((float)this.x, (float)this.y);
            this.currentOp += 2;
        }
        float[] coords = new float[6];
        this.x += this.operandsRead[this.currentOp];
        this.y += this.operandsRead[this.currentOp + 1];
        coords[0] = (float)this.x;
        coords[1] = (float)this.y;
        this.x += this.operandsRead[this.currentOp + 2];
        this.y += this.operandsRead[this.currentOp + 3];
        coords[2] = (float)this.x;
        coords[3] = (float)this.y;
        this.x += this.operandsRead[this.currentOp + 4];
        this.y += this.operandsRead[this.currentOp + 5];
        coords[4] = (float)this.x;
        coords[5] = (float)this.y;
        factory.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
        this.currentOp += 6;
    }

    private void closepath(GlyphFactory factory) {
        if (this.xs != -1.0) {
            factory.lineTo((float)this.xs, (float)this.ys);
        }
        this.xs = -1.0;
    }

    private void hsbw(GlyphFactory factory, String glyphName) {
        this.x += this.operandsRead[0];
        factory.moveTo((float)this.x, 0.0f);
        if (this.baseFontName != null && this.dynamicVectorRenderer != null && this.dynamicVectorRenderer.isHTMLorSVG()) {
            this.dynamicVectorRenderer.saveAdvanceWidth(this.baseFontName, glyphName, (int)this.ys);
        }
        this.allowAll = true;
    }

    private void pop() {
        if (this.operandReached > 0) {
            --this.operandReached;
        }
    }

    private void div() {
        double value = this.operandsRead[this.operandReached - 2] / this.operandsRead[this.operandReached - 1];
        if (this.operandReached > 0) {
            --this.operandReached;
        }
        this.operandsRead[this.operandReached - 1] = value;
    }

    private void vmoveto(GlyphFactory factory, boolean isFirst) {
        if (isFirst && this.operandReached == 2) {
            ++this.currentOp;
        }
        this.y += this.operandsRead[this.currentOp];
        factory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
    }

    private void rlineto(GlyphFactory factory) {
        for (int lineCount = this.operandReached / 2; lineCount > 0; --lineCount) {
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            factory.lineTo((float)this.x, (float)this.y);
            this.currentOp += 2;
        }
    }

    private void hvlineto(GlyphFactory factory, int key) {
        boolean isHor = key == 6;
        for (int start = 0; start < this.operandReached; ++start) {
            if (isHor) {
                this.x += this.operandsRead[start];
            } else {
                this.y += this.operandsRead[start];
            }
            factory.lineTo((float)this.x, (float)this.y);
            isHor = !isHor;
        }
    }

    private void rrcurveto(GlyphFactory factory) {
        for (int curveCount = this.operandReached / 6; curveCount > 0; --curveCount) {
            float[] coords = new float[6];
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            coords[0] = (float)this.x;
            coords[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 2];
            this.y += this.operandsRead[this.currentOp + 3];
            coords[2] = (float)this.x;
            coords[3] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 4];
            this.y += this.operandsRead[this.currentOp + 5];
            coords[4] = (float)this.x;
            coords[5] = (float)this.y;
            factory.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
            this.currentOp += 6;
        }
    }

    private void rcurveline(GlyphFactory factory) {
        for (int curveCount = (this.operandReached - 2) / 6; curveCount > 0; --curveCount) {
            float[] coords = new float[6];
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            coords[0] = (float)this.x;
            coords[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 2];
            this.y += this.operandsRead[this.currentOp + 3];
            coords[2] = (float)this.x;
            coords[3] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 4];
            this.y += this.operandsRead[this.currentOp + 5];
            coords[4] = (float)this.x;
            coords[5] = (float)this.y;
            factory.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
            this.currentOp += 6;
        }
        this.x += this.operandsRead[this.currentOp];
        this.y += this.operandsRead[this.currentOp + 1];
        factory.lineTo((float)this.x, (float)this.y);
        this.currentOp += 2;
    }

    private void seac(GlyphFactory factory, int rawInt, int currentOp) {
        StandardFonts.checkLoaded(1);
        float adx = (float)this.operandsRead[currentOp + 1];
        float ady = (float)this.operandsRead[currentOp + 2];
        String bchar = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[currentOp + 3]);
        String achar = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[currentOp + 4]);
        double preX = this.x;
        this.y = 0.0;
        this.decodeGlyph(null, factory, bchar, rawInt, "");
        factory.closePath();
        factory.moveTo(0.0f, 0.0f);
        this.x = (double)adx + preX;
        this.y = ady;
        this.decodeGlyph(null, factory, achar, rawInt, "");
    }

    private void flex1(GlyphFactory factory) {
        int points;
        double dx = 0.0;
        double dy = 0.0;
        double x1 = this.x;
        double y1 = this.y;
        for (int count = 0; count < 10; count += 2) {
            dx += this.operandsRead[count];
            dy += this.operandsRead[count + 1];
        }
        boolean isHorizontal = Math.abs(dx) > Math.abs(dy);
        for (points = 0; points < 6; points += 2) {
            this.x += this.operandsRead[points];
            this.y += this.operandsRead[points + 1];
            this.pt[points] = (float)this.x;
            this.pt[points + 1] = (float)this.y;
        }
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        for (points = 0; points < 4; points += 2) {
            this.x += this.operandsRead[points + 6];
            this.y += this.operandsRead[points + 7];
            this.pt[points] = (float)this.x;
            this.pt[points + 1] = (float)this.y;
        }
        if (isHorizontal) {
            this.x += this.operandsRead[10];
            this.y = y1;
        } else {
            this.x = x1;
            this.y += this.operandsRead[10];
        }
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
    }

    private void flex(GlyphFactory factory) {
        for (int curves = 0; curves < 12; curves += 6) {
            for (int points = 0; points < 6; points += 2) {
                this.x += this.operandsRead[curves + points];
                this.y += this.operandsRead[curves + points + 1];
                this.pt[points] = (float)this.x;
                this.pt[points + 1] = (float)this.y;
            }
            factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        }
    }

    private void hflex(GlyphFactory factory) {
        this.x += this.operandsRead[0];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[1];
        this.y += this.operandsRead[2];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[3];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        this.x += this.operandsRead[4];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[5];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[6];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
    }

    private void hflex1(GlyphFactory factory) {
        this.x += this.operandsRead[0];
        this.y += this.operandsRead[1];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[2];
        this.y += this.operandsRead[3];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[4];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        this.x += this.operandsRead[5];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[6];
        this.y += this.operandsRead[7];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[8];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
    }

    @Override
    public PdfGlyph getEmbeddedGlyph(GlyphFactory factory, String glyph, float[][] Trm, int rawInt, String displayValue, float currentWidth, String key) {
        Integer num;
        PdfGlyph transformedGlyph2;
        if (Trm != null && (this.lastTrm[0][0] != Trm[0][0] || this.lastTrm[1][0] != Trm[1][0] || this.lastTrm[0][1] != Trm[0][1] || this.lastTrm[1][1] != Trm[1][1])) {
            this.lastTrm = Trm;
            this.flush();
        }
        if ((transformedGlyph2 = this.getEmbeddedCachedShape(rawInt)) == null) {
            this.operandsRead = new double[100];
            this.operandReached = 0;
            this.x = -factory.getLSB();
            this.y = 0.0;
            this.decodeGlyph(key, factory, glyph, rawInt, displayValue);
            transformedGlyph2 = factory.getGlyph();
            this.setEmbeddedCachedShape(rawInt, transformedGlyph2);
        }
        if ((num = this.glyphNumbers.get(glyph)) == null) {
            num = this.glyphNumbers.get(Integer.toString(rawInt));
        }
        if (num == null) {
            num = this.glyphNumbers.get(key);
        }
        if (num != null) {
            transformedGlyph2.setGlyphNumber(num);
        }
        return transformedGlyph2;
    }

    void decodeGlyph(String embKey, GlyphFactory factory, String glyph, int rawInt, String displayValue) {
        byte[] glyphStream;
        this.allowAll = false;
        if (this.isCID) {
            glyphStream = this.charStrings.get(String.valueOf(rawInt));
        } else {
            if (glyph == null) {
                glyph = displayValue;
            }
            if (glyph == null && (glyph = embKey) == null) {
                glyph = ".notdef";
            }
            if ((glyphStream = this.charStrings.get(glyph)) == null) {
                if (embKey != null) {
                    glyphStream = this.charStrings.get(embKey);
                }
                if (glyphStream == null) {
                    glyphStream = this.charStrings.get(".notdef");
                }
            }
        }
        if (glyphStream != null) {
            this.decodeGlyphStream(factory, glyph, rawInt, glyphStream);
        }
    }

    private void decodeGlyphStream(GlyphFactory factory, String glyph, int rawInt, byte[] glyphStream) {
        boolean isFirst = true;
        this.ptCount = 0;
        int nonSubrCommandCount = 0;
        int p = 0;
        int lastNumberStart = 0;
        int key = 0;
        int dicEnd = glyphStream.length;
        int lastVal = 0;
        this.currentOp = 0;
        this.hintCount = 0;
        double ymin = 999999.0;
        double ymax = 0.0;
        double yy = 1000.0;
        boolean isFlex = false;
        this.pt = new float[6];
        int potentialWidth = 0;
        this.h = 100000.0;
        if (this.is1C) {
            this.operandsRead = new double[100];
            this.operandReached = 0;
            this.allowAll = true;
        }
        while (p < dicEnd) {
            int nextVal = glyphStream[p] & 0xFF;
            if (nextVal > 31 || nextVal == 28) {
                lastNumberStart = p;
                p = T1GlyphNumber.getNumber(glyphStream, p, this.operandsRead, this.operandReached, this.is1C);
                lastVal = (int)this.operandsRead[this.operandReached];
                ++this.operandReached;
                if (lastNumberStart != 0) continue;
                if (this.nominalWidthX.length == 1) {
                    potentialWidth = this.nominalWidthX[0] + lastVal;
                    continue;
                }
                int glyphNo = this.glyphNumbers.get(String.valueOf(rawInt)) - 1;
                if (glyphNo >= this.fdSelect.length) continue;
                potentialWidth = this.nominalWidthX[this.fdSelect[glyphNo]] + lastVal;
                continue;
            }
            if (this.is1C && nonSubrCommandCount == 0 && nextVal != 10 && nextVal != 11 && nextVal != 29) {
                boolean hasOddArgs = false;
                if (nextVal == 22 || nextVal == 4 || nextVal == 12 && (glyphStream[p + 1] == 9 || glyphStream[p + 1] == 14 || glyphStream[p + 1] == 26 || glyphStream[p + 1] == 18 || glyphStream[p + 1] == 27 || glyphStream[p + 1] == 21 || glyphStream[p + 1] == 5)) {
                    hasOddArgs = true;
                }
                if (!hasOddArgs && this.operandReached % 2 == 1 || hasOddArgs && this.operandReached % 2 == 0) {
                    this.saveWidth(glyph, rawInt, potentialWidth);
                }
            }
            ++nonSubrCommandCount;
            int lastKey = key;
            key = nextVal;
            ++p;
            this.currentOp = 0;
            if (key == 12) {
                key = glyphStream[p] & 0xFF;
                ++p;
                if (key == 7) {
                    yy = this.sbw();
                    this.operandReached = 0;
                } else if (key == 16 && this.allowAll || key != 16) {
                    isFlex = this.handle2ByteOp(factory, rawInt, key, lastVal, isFlex);
                }
            } else if (key == 13) {
                this.hsbw(factory, glyph);
                this.operandReached = 0;
            } else if (this.allowAll && key != 0) {
                if (key == 1 || key == 3 || key == 18 || key == 23) {
                    this.hintCount += this.operandReached / 2;
                    this.operandReached = 0;
                } else if (key == 4) {
                    if (isFlex) {
                        this.flex();
                    } else {
                        this.vmoveto(factory, isFirst);
                    }
                    this.operandReached = 0;
                } else if (key == 5) {
                    this.rlineto(factory);
                    this.operandReached = 0;
                } else if (key == 6 || key == 7) {
                    this.hvlineto(factory, key);
                    this.operandReached = 0;
                } else if (key == 8) {
                    this.rrcurveto(factory);
                    this.operandReached = 0;
                } else if (key == 9) {
                    this.closepath(factory);
                    this.operandReached = 0;
                } else if (key == 10 || key == 29) {
                    --nonSubrCommandCount;
                    if (!this.is1C && key == 10 && lastVal >= 0 && lastVal <= 2 && lastKey != 11 && this.operandReached > 5) {
                        isFlex = this.processFlex(factory, isFlex, lastVal);
                        this.operandReached = 0;
                    } else {
                        lastVal = key == 10 ? (lastVal += this.localBias) : (lastVal += this.globalBias);
                        byte[] newStream = key == 10 ? this.charStrings.get("subrs" + lastVal) : this.charStrings.get("global" + lastVal);
                        if (newStream != null) {
                            int newLength = newStream.length;
                            int oldLength = glyphStream.length;
                            int totalLength = newLength + oldLength - 2;
                            dicEnd = dicEnd + newLength - 2;
                            byte[] combinedStream = new byte[totalLength];
                            System.arraycopy(glyphStream, 0, combinedStream, 0, lastNumberStart);
                            System.arraycopy(newStream, 0, combinedStream, lastNumberStart, newLength);
                            System.arraycopy(glyphStream, p, combinedStream, lastNumberStart + newLength, oldLength - p);
                            glyphStream = combinedStream;
                            p = lastNumberStart;
                            if (this.operandReached > 0) {
                                --this.operandReached;
                            }
                        }
                    }
                } else if (key == 11) {
                    --nonSubrCommandCount;
                } else if (key == 14) {
                    this.endchar(factory, rawInt);
                    this.operandReached = 0;
                    p = dicEnd + 1;
                } else if (key == 16) {
                    this.operandReached = 0;
                } else if (key == 19 || key == 20) {
                    p = this.mask(p);
                    this.operandReached = 0;
                } else if (key == 21) {
                    if (isFlex) {
                        this.moveToAsFlex();
                    } else {
                        this.rmoveto(factory, isFirst);
                    }
                    this.operandReached = 0;
                } else if (key == 22) {
                    if (isFlex) {
                        double val = this.operandsRead[this.currentOp];
                        this.x += val;
                        this.pt[this.ptCount] = (float)this.x;
                        ++this.ptCount;
                        this.pt[this.ptCount] = (float)this.y;
                        ++this.ptCount;
                    } else {
                        this.hmoveto(factory, isFirst);
                    }
                    this.operandReached = 0;
                } else if (key == 24) {
                    this.rcurveline(factory);
                    this.operandReached = 0;
                } else if (key == 25) {
                    this.rlinecurve(factory);
                    this.operandReached = 0;
                } else if (key == 26 || key == 27) {
                    this.vvhhcurveto(factory, key);
                    this.operandReached = 0;
                } else if (key == 30 || key == 31) {
                    this.vhhvcurveto(factory, key);
                    this.operandReached = 0;
                }
            }
            if (ymin > this.y) {
                ymin = this.y;
            }
            if (ymax < this.y) {
                ymax = this.y;
            }
            if (key == 19 || key == 29 || key == 10) continue;
            isFirst = false;
        }
        if (yy > this.h) {
            ymin = yy - this.h;
        }
        if (ymax < yy) {
            ymin = 0.0;
        } else if (yy != ymax) {
            float dy = (float)(ymax - (yy - ymin));
            ymin = dy < 0.0f ? (yy - ymax <= (double)dy ? (double)dy : (ymin -= (double)dy)) : 0.0;
            if (ymin < 0.0) {
                ymin = 0.0;
            }
        }
        factory.setYMin((float)ymin);
    }

    private boolean handle2ByteOp(GlyphFactory factory, int rawInt, int key, int lastVal, boolean isFlex) {
        switch (key) {
            case 0: {
                this.operandReached = 0;
                break;
            }
            case 6: {
                this.seac(factory, rawInt, this.currentOp);
                this.operandReached = 0;
                break;
            }
            case 12: {
                this.div();
                break;
            }
            case 16: {
                isFlex = this.processFlex(factory, isFlex, lastVal);
                this.operandReached = 0;
                break;
            }
            case 17: {
                this.pop();
                break;
            }
            case 33: {
                this.operandReached = 0;
                break;
            }
            case 34: {
                this.hflex(factory);
                this.operandReached = 0;
                break;
            }
            case 35: {
                this.flex(factory);
                this.operandReached = 0;
                break;
            }
            case 36: {
                this.hflex1(factory);
                this.operandReached = 0;
                break;
            }
            case 37: {
                this.flex1(factory);
                this.operandReached = 0;
                break;
            }
            default: {
                this.operandReached = 0;
            }
        }
        return isFlex;
    }

    private void moveToAsFlex() {
        double val = this.operandsRead[this.currentOp + 1];
        this.y += val;
        val = this.operandsRead[this.currentOp];
        this.x += val;
        this.pt[this.ptCount] = (float)this.x;
        ++this.ptCount;
        this.pt[this.ptCount] = (float)this.y;
        ++this.ptCount;
    }

    private void flex() {
        double val = this.operandsRead[this.currentOp];
        this.y += val;
        this.pt[this.ptCount] = (float)this.x;
        ++this.ptCount;
        this.pt[this.ptCount] = (float)this.y;
        ++this.ptCount;
    }

    private void saveWidth(String glyph, int rawInt, int potentialWidth) {
        if (this.baseFontName != null && this.dynamicVectorRenderer != null && this.dynamicVectorRenderer.isHTMLorSVG()) {
            if ("notdef".equals(glyph)) {
                this.dynamicVectorRenderer.saveAdvanceWidth(this.baseFontName, String.valueOf(rawInt), potentialWidth);
            } else {
                this.dynamicVectorRenderer.saveAdvanceWidth(this.baseFontName, glyph, potentialWidth);
            }
            if (!this.defaultWidthsPassed) {
                for (int i = 0; i < this.defaultWidthX.length; ++i) {
                    this.dynamicVectorRenderer.saveAdvanceWidth(this.baseFontName, "JPedalDefaultWidth" + i, this.defaultWidthX[i]);
                }
                this.defaultWidthsPassed = true;
            }
        }
    }

    @Override
    public void setCharString(String glyph, byte[] stream, int glyphNo) {
        this.charStrings.put(glyph, stream);
        this.glyphNumbers.put(glyph, glyphNo);
    }

    @Override
    public void setIndexForCharString(int index, String charName) {
        if (this.charForGlyphIndex == null) {
            this.charForGlyphIndex = new String[65536];
        }
        if (index < this.charForGlyphIndex.length) {
            this.charForGlyphIndex[index] = charName;
        }
    }

    @Override
    public String getIndexForCharString(int index) {
        return this.charForGlyphIndex[index];
    }

    @Override
    public boolean is1C() {
        return this.is1C;
    }

    public void setWidthValues(int[] defaultWidthX, int[] nominalWidthX) {
        this.nominalWidthX = nominalWidthX;
        this.defaultWidthX = defaultWidthX;
    }

    @Override
    public void setis1C(boolean is1C) {
        this.is1C = is1C;
    }

    @Override
    public void setRenderer(DynamicVectorRenderer current) {
        this.dynamicVectorRenderer = current;
        if (this.baseFontName != null && this.dynamicVectorRenderer != null && this.dynamicVectorRenderer.isHTMLorSVG()) {
            for (int i = 0; i < this.defaultWidthX.length; ++i) {
                this.dynamicVectorRenderer.saveAdvanceWidth(this.baseFontName, "JPedalDefaultWidth" + i, this.defaultWidthX[i]);
            }
        }
    }

    public void setFDSelect(int[] fdSelect) {
        this.fdSelect = fdSelect;
    }

    @Override
    public Map getCharStrings() {
        return Collections.unmodifiableMap(this.charStrings);
    }

    public int getGlyphNumber(String glyphName) {
        return this.glyphNumbers.get(glyphName);
    }
}

