/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.io.Serializable;
import javafx.collections.ObservableList;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import org.jpedal.fonts.tt.BaseTTGlyph;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.hinting.TTVM;

public class TTGlyphFX
extends BaseTTGlyph
implements Serializable {
    transient Path pathsFX;

    public TTGlyphFX(Glyf currentGlyf, FontFile2 glyfTable, Hmtx currentHmtx, int idx, float unitsPerEm, String baseFontName) {
        super(currentGlyf, glyfTable, currentHmtx, idx, unitsPerEm, baseFontName);
    }

    public TTGlyphFX(Glyf currentGlyf, FontFile2 glyfTable, Hmtx currentHmtx, int idx, float unitsPerEm, TTVM vm) {
        super(currentGlyf, glyfTable, currentHmtx, idx, unitsPerEm, vm);
    }

    @Override
    public void createPaths(int[] pX, int[] pY, boolean[] onCurve, boolean[] endOfContour, int endIndex) {
        if (endOfContour == null) {
            return;
        }
        int ptCount = endOfContour.length;
        int start = 0;
        int firstPt = -1;
        for (int ii = 0; ii < ptCount; ++ii) {
            if (endOfContour[ii]) {
                if (!(firstPt == -1 || onCurve[start] && onCurve[ii])) {
                    int diff = firstPt - start;
                    int pXlength = pX.length;
                    int[] old_pX = new int[pXlength];
                    System.arraycopy(pX, 0, old_pX, 0, pXlength);
                    int[] old_pY = new int[pXlength];
                    System.arraycopy(pY, 0, old_pY, 0, pXlength);
                    boolean[] old_onCurve = new boolean[pXlength];
                    System.arraycopy(onCurve, 0, old_onCurve, 0, pXlength);
                    for (int oldPos = start; oldPos < ii + 1; ++oldPos) {
                        int newPos = oldPos + diff;
                        if (newPos > ii) {
                            newPos -= ii - start + 1;
                        }
                        pX[oldPos] = old_pX[newPos];
                        pY[oldPos] = old_pY[newPos];
                        onCurve[oldPos] = old_onCurve[newPos];
                    }
                }
                start = ii + 1;
                firstPt = -1;
                continue;
            }
            if (!onCurve[ii] || firstPt != -1) continue;
            firstPt = ii;
        }
        boolean isFirstDraw = true;
        if (this.pathsFX == null) {
            this.pathsFX = new Path();
            this.pathsFX.setFillRule(FillRule.NON_ZERO);
        }
        int c = pX.length;
        int fc = -1;
        for (int jj = 0; jj < c; ++jj) {
            if (!endOfContour[jj]) continue;
            fc = jj + 1;
            jj = c;
        }
        int x2 = 0;
        int y2 = 0;
        int x3 = 0;
        int y3 = 0;
        int x1 = pX[0];
        int y1 = pY[0];
        if (debug) {
            System.out.println(pX[0] + " " + pY[0] + " move to x1,y1=" + x1 + ' ' + y1);
        }
        ObservableList elements = this.pathsFX.getElements();
        elements.add((Object)new MoveTo((double)x1, (double)y1));
        if (debug) {
            System.out.println("first contour=" + fc + "====================================" + pX[0] + ' ' + pY[0]);
        }
        int xs = 0;
        int ys = 0;
        int lc = 0;
        boolean isEnd = false;
        for (int j = 0; j < endIndex; ++j) {
            int p = j % fc;
            int p1 = (j + 1) % fc;
            int p2 = (j + 2) % fc;
            int pm1 = (j - 1) % fc;
            if (j == 0) {
                pm1 = fc - 1;
            }
            if (p1 < lc) {
                p1 += lc;
            }
            if (p2 < lc) {
                p2 += lc;
            }
            if (debug) {
                System.out.println("points=" + lc + '/' + fc + ' ' + pm1 + ' ' + p + ' ' + p1 + ' ' + p2 + " j=" + j + " endOfContour[j]=" + endOfContour[j]);
            }
            if (endOfContour[j]) {
                isEnd = true;
                if (onCurve[fc]) {
                    xs = pX[fc];
                    ys = pY[fc];
                } else {
                    xs = pX[j + 1];
                    ys = pY[j + 1];
                }
                lc = fc;
                for (int jj = j + 1; jj < c; ++jj) {
                    if (!endOfContour[jj]) continue;
                    fc = jj + 1;
                    jj = c;
                }
                if (debug) {
                    System.out.println("End of contour. next=" + j + ' ' + fc + ' ' + lc);
                }
            }
            if (debug) {
                if (j > 0) {
                    System.out.println("curves=" + onCurve[p] + ' ' + onCurve[p1] + ' ' + onCurve[p2] + " EndOfContour j-1=" + endOfContour[j - 1] + " j=" + endOfContour[j] + " j+1=" + endOfContour[j + 1]);
                } else {
                    System.out.println("curves=" + onCurve[p] + ' ' + onCurve[p1] + ' ' + onCurve[p2] + " EndOfContour j=" + endOfContour[j] + " j+1=" + endOfContour[j + 1]);
                }
            }
            if (lc == fc && onCurve[p]) {
                j = c;
                if (!debug) continue;
                System.out.println("last 2 match");
                continue;
            }
            if (debug) {
                System.out.println(fc + " " + pm1 + ' ' + p + ' ' + p1 + ' ' + p2);
            }
            if (onCurve[p] && onCurve[p1]) {
                x3 = pX[p1];
                y3 = pY[p1];
                elements.add((Object)new LineTo((double)x3, (double)y3));
                if (debug) {
                    System.out.println(p + " pt,pt " + x3 + ' ' + y3 + " (lineTo)");
                }
                isFirstDraw = false;
            } else if (j < c - 3 && (fc - lc > 1 || fc == lc)) {
                boolean checkEnd = false;
                if (onCurve[p] && !onCurve[p1] && onCurve[p2]) {
                    x1 = pX[p];
                    y1 = pY[p];
                    x2 = pX[p1];
                    y2 = pY[p1];
                    x3 = pX[p2];
                    y3 = pY[p2];
                    ++j;
                    checkEnd = true;
                    if (debug) {
                        System.out.println(p + " pt,cv,pt " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                    }
                } else if (onCurve[p] && !onCurve[p1] && !onCurve[p2]) {
                    x1 = pX[p];
                    y1 = pY[p];
                    x2 = pX[p1];
                    y2 = pY[p1];
                    x3 = TTGlyphFX.midPt(pX[p1], pX[p2]);
                    y3 = TTGlyphFX.midPt(pY[p1], pY[p2]);
                    ++j;
                    checkEnd = true;
                    if (debug) {
                        System.out.println(p + " pt,cv,cv " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                    }
                } else if (!(onCurve[p] || onCurve[p1] || endOfContour[p2] && fc - p2 != 1)) {
                    x1 = TTGlyphFX.midPt(pX[pm1], pX[p]);
                    y1 = TTGlyphFX.midPt(pY[pm1], pY[p]);
                    x2 = pX[p];
                    y2 = pY[p];
                    x3 = TTGlyphFX.midPt(pX[p], pX[p1]);
                    y3 = TTGlyphFX.midPt(pY[p], pY[p1]);
                    if (debug) {
                        System.out.println(p + " cv,cv1 " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                    }
                } else if (!onCurve[p] && onCurve[p1]) {
                    x1 = TTGlyphFX.midPt(pX[pm1], pX[p]);
                    y1 = TTGlyphFX.midPt(pY[pm1], pY[p]);
                    x2 = pX[p];
                    y2 = pY[p];
                    x3 = pX[p1];
                    y3 = pY[p1];
                    if (debug) {
                        System.out.println(p + " cv,pt " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                    }
                }
                if (isFirstDraw) {
                    elements.add((Object)new MoveTo((double)x1, (double)y1));
                    isFirstDraw = false;
                    if (debug) {
                        System.out.println("first draw move to " + x1 + ' ' + y1);
                    }
                }
                if (!endOfContour[p] || p <= 0 || !endOfContour[p - 1]) {
                    elements.add((Object)new CubicCurveTo((double)x1, (double)y1, (double)x2, (double)y2, (double)x3, (double)y3));
                }
                if (debug) {
                    System.out.println("curveto " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                }
                if (checkEnd && endOfContour[j]) {
                    isEnd = true;
                    xs = pX[fc];
                    ys = pY[fc];
                    lc = fc;
                    for (int jj = j + 1; jj < c; ++jj) {
                        if (!endOfContour[jj]) continue;
                        fc = jj + 1;
                        jj = c;
                    }
                    if (debug) {
                        System.out.println("Curve");
                    }
                }
            }
            if (endOfContour[p]) {
                elements.add((Object)new ClosePath());
            }
            if (debug) {
                System.out.println("x2 " + xs + ' ' + ys + ' ' + isEnd);
            }
            if (!isEnd) continue;
            elements.add((Object)new MoveTo((double)xs, (double)ys));
            isEnd = false;
            if (!debug) continue;
            System.out.println("Move to " + xs + ' ' + ys);
        }
        if (debug) {
            System.out.println("Ends at " + x1 + ' ' + y1 + " x=" + this.minX + ',' + this.maxX + " y=" + this.minY + ',' + this.maxY + " glyph x=" + this.compMinX + ',' + this.compMaxX + " y=" + this.compMinY + ',' + this.compMaxY);
        }
    }

    public Path getPath() {
        this.pathsFX = null;
        this.createGlyph(false);
        return this.pathsFX;
    }
}

