/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;
import org.jpedal.function.PostscriptFactory;
import org.jpedal.utils.LogWriter;

public class PDFCalculator
extends PDFGenericFunction
implements PDFFunction {
    private final PostscriptFactory post;
    private final int n;

    public PDFCalculator(byte[] stream, float[] domain, float[] range) {
        super(domain, range);
        this.post = new PostscriptFactory(stream);
        this.n = range.length / 2;
    }

    @Override
    public float[] computeStitch(float[] subinput) {
        return this.compute(subinput);
    }

    @Override
    public float[] compute(float[] values) {
        float[] result = new float[this.n];
        try {
            this.post.resetStacks(values);
            double[] stack = this.post.executePostscript();
            for (int i = 0; i < this.n; ++i) {
                result[i] = PDFCalculator.min(PDFCalculator.max((float)stack[i], this.range[i * 2]), this.range[i * 2 + 1]);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return result;
    }
}

