/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFExponential
extends PDFGenericFunction
implements PDFFunction {
    private float[] C0 = new float[]{0.0f};
    private float[] C1 = new float[]{1.0f};
    private final float N;
    final int returnValues;
    private final float[] diffs;

    public PDFExponential(float N2, float[] C0, float[] C1, float[] domain, float[] range) {
        super(domain, range);
        this.N = N2;
        if (C0 != null) {
            this.C0 = C0;
        }
        if (C1 != null) {
            this.C1 = C1;
        }
        this.returnValues = this.C0.length;
        this.diffs = new float[this.returnValues];
        for (int i = 0; i < this.diffs.length; ++i) {
            this.diffs[i] = this.C1[i] - this.C0[i];
        }
    }

    @Override
    public float[] computeStitch(float[] subinput) {
        return this.compute(subinput);
    }

    @Override
    public float[] compute(float[] values) {
        float[] output = new float[this.returnValues];
        float x = PDFExponential.min(PDFExponential.max(values[0], this.domain[0]), this.domain[1]);
        if ((double)this.N != 1.0) {
            x = (float)Math.pow(x, this.N);
        }
        for (int j = 0; j < this.C0.length; ++j) {
            output[j] = this.C0[j] + x * this.diffs[j];
        }
        if (this.range != null) {
            for (int i = 0; i < this.C0.length; ++i) {
                output[i] = PDFExponential.min(PDFExponential.max(output[i], this.range[i * 2]), this.range[i * 2 + 1]);
            }
        }
        return output;
    }
}

