/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PostscriptUtils;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class PostscriptFactory {
    static final int[] scale = new int[]{1, 676, 17576, 456976};
    static final double toBase10 = Math.log(10.0);
    private int level;
    private static final byte START_BRACE = 123;
    private static final byte END_BRACE = 125;
    private final byte[] stream;
    private final int streamLength;
    private int ptr;
    private static final boolean debug = false;
    protected boolean testingFunction;
    protected double[] stack;
    private double[] safeStack;
    protected int[] stackType;
    private int[] safeStackType;
    protected int stkPtr;
    private int safeStkPtr;
    protected int stkTypePtr;
    private int safeStkTypePrt;
    protected int currentType;
    boolean cont;
    static final double radiansToDegrees = 57.29577951308232;
    protected static final double isTrue = 1.0;
    protected static final double isFalse = 0.0;
    protected static final int PS_INTEGER = 1;
    protected static final int PS_REAL = 2;
    protected static final int PS_BOOLEAN = 3;
    protected static final int PS_UNKNOWN = 0;
    protected static final int PS_abs = 317044;
    protected static final int PS_add = 54756;
    protected static final int PS_atan = 5953532;
    protected static final int PS_ceil = 5170050;
    protected static final int PS_cos = 325834;
    protected static final int PS_cvi = 154806;
    protected static final int PS_cvr = 312990;
    protected static final int PS_div = 374507;
    protected static final int PS_exp = 279192;
    protected static final int PS_floo = 6651169;
    protected static final int PS_idiv = 9739140;
    protected static final int PS_ln = 8799;
    protected static final int PS_log = 114931;
    protected static final int PS_mod = 62204;
    protected static final int PS_mul = 206868;
    protected static final int PS_neg = 108173;
    protected static final int PS_sin = 233914;
    protected static final int PS_sqrt = 8992170;
    protected static final int PS_sub = 31114;
    protected static final int PS_roun = 6301689;
    protected static final int PS_trun = 6303719;
    protected static final int PS_and = 61516;
    protected static final int PS_bits = 8564921;
    protected static final int PS_eq = 10820;
    protected static final int PS_fals = 8418909;
    protected static final int PS_ge = 2710;
    protected static final int PS_gt = 12850;
    protected static final int PS_le = 2715;
    protected static final int PS_lt = 12855;
    protected static final int PS_ne = 2717;
    protected static final int PS_not = 343421;
    protected static final int PS_or = 11506;
    protected static final int PS_true = 2190935;
    protected static final int PS_xor = 308279;
    protected static final int PS_if = 3388;
    protected static final int PS_ifel = 5100428;
    protected static final int PS_copy = 11240530;
    protected static final int PS_exch = 3249536;
    protected static final int PS_pop = 273119;
    protected static final int PS_dup = 277163;
    protected static final int PS_inde = 1889428;
    protected static final int PS_roll = 5229553;

    public PostscriptFactory(byte[] stream) {
        this.stream = stream;
        this.streamLength = stream.length;
    }

    protected static int getCommandID(byte[] cmds) {
        int id = -1;
        int key = 0;
        int keyLength = cmds.length;
        if (keyLength > 4) {
            keyLength = 4;
        }
        for (int j = 0; j < keyLength; ++j) {
            key += (cmds[j] - 97) * scale[j];
        }
        switch (key) {
            case 317044: {
                id = 317044;
                break;
            }
            case 54756: {
                id = 54756;
                break;
            }
            case 5953532: {
                id = 5953532;
                break;
            }
            case 5170050: {
                id = 5170050;
                break;
            }
            case 325834: {
                id = 325834;
                break;
            }
            case 154806: {
                id = 154806;
                break;
            }
            case 312990: {
                id = 312990;
                break;
            }
            case 374507: {
                id = 374507;
                break;
            }
            case 279192: {
                id = 279192;
                break;
            }
            case 6651169: {
                id = 6651169;
                break;
            }
            case 9739140: {
                id = 9739140;
                break;
            }
            case 8799: {
                id = 8799;
                break;
            }
            case 114931: {
                id = 114931;
                break;
            }
            case 62204: {
                id = 62204;
                break;
            }
            case 206868: {
                id = 206868;
                break;
            }
            case 108173: {
                id = 108173;
                break;
            }
            case 233914: {
                id = 233914;
                break;
            }
            case 8992170: {
                id = 8992170;
                break;
            }
            case 31114: {
                id = 31114;
                break;
            }
            case 6301689: {
                id = 6301689;
                break;
            }
            case 6303719: {
                id = 6303719;
                break;
            }
            case 61516: {
                id = 61516;
                break;
            }
            case 8564921: {
                id = 8564921;
                break;
            }
            case 10820: {
                id = 10820;
                break;
            }
            case 8418909: {
                id = 8418909;
                break;
            }
            case 2710: {
                id = 2710;
                break;
            }
            case 12850: {
                id = 12850;
                break;
            }
            case 2715: {
                id = 2715;
                break;
            }
            case 12855: {
                id = 12855;
                break;
            }
            case 2717: {
                id = 2717;
                break;
            }
            case 343421: {
                id = 343421;
                break;
            }
            case 11506: {
                id = 11506;
                break;
            }
            case 2190935: {
                id = 2190935;
                break;
            }
            case 308279: {
                id = 308279;
                break;
            }
            case 3388: {
                id = 3388;
                break;
            }
            case 5100428: {
                id = 5100428;
                break;
            }
            case 11240530: {
                id = 11240530;
                break;
            }
            case 3249536: {
                id = 3249536;
                break;
            }
            case 273119: {
                id = 273119;
                break;
            }
            case 277163: {
                id = 277163;
                break;
            }
            case 1889428: {
                id = 1889428;
                break;
            }
            case 5229553: {
                id = 5229553;
            }
        }
        return id;
    }

    protected int execute(int id) {
        int returnValue = 0;
        int fType = 0;
        int sType = 0;
        switch (id) {
            case 317044: {
                double first = this.pop();
                if (first < 0.0) {
                    this.push(-first, 1);
                    break;
                }
                this.push(first, 1);
                break;
            }
            case 54756: {
                if (this.stack.length < 2) {
                    throw new RuntimeException("ADD - not enough elements on the stack");
                }
                double first = this.pop();
                fType = this.currentType;
                double second = this.pop();
                sType = this.currentType;
                if (fType == 2 || sType == 2) {
                    this.push(first + second, 2);
                    break;
                }
                this.push(first + second, 1);
                break;
            }
            case 61516: {
                double first = this.pop();
                fType = this.currentType;
                double second = this.pop();
                sType = this.currentType;
                if (fType == 1 && sType == 1) {
                    this.push((int)first & (int)second, 1);
                    break;
                }
                if (fType == 3 && sType == 3) {
                    this.push((int)first & (int)second, 3);
                    break;
                }
                if (!LogWriter.isRunningFromIDE) break;
                throw new RuntimeException("Critical error in PS_and");
            }
            case 5953532: {
                this.calculateAtan();
                break;
            }
            case 8564921: {
                int shift = this.popInt();
                fType = this.currentType;
                int firstInt = this.popInt();
                sType = this.currentType;
                if ((fType != 1 || sType != 1) && LogWriter.isRunningFromIDE) {
                    throw new RuntimeException("Critical error in PS_bits");
                }
                if (shift > 0) {
                    firstInt <<= shift;
                }
                if (shift < 0) {
                    firstInt >>= -shift;
                }
                this.push(firstInt, 1);
                break;
            }
            case 5170050: {
                double first = this.pop();
                fType = this.currentType;
                if (first < 0.0) {
                    this.push((int)first, fType);
                    break;
                }
                int temp = (int)first;
                if (first > (double)temp) {
                    this.push(temp + 1, fType);
                    break;
                }
                this.push(first, fType);
                break;
            }
            case 11240530: {
                int firstInt = this.popInt();
                fType = this.currentType;
                if (fType == 1 && firstInt > 0) {
                    int ii;
                    double[] items = new double[firstInt];
                    int[] types = new int[firstInt];
                    for (int i = 0; i < items.length; ++i) {
                        items[i] = this.pop();
                        types[i] = this.currentType;
                    }
                    for (ii = items.length; ii > 0; --ii) {
                        this.push(items[ii - 1], types[ii - 1]);
                    }
                    for (ii = items.length; ii > 0; --ii) {
                        this.push(items[ii - 1], types[ii - 1]);
                    }
                    break;
                }
                if (fType == 1 && firstInt == 0 || !LogWriter.isRunningFromIDE) break;
                throw new RuntimeException("Critical error in PS_copy");
            }
            case 325834: {
                double first = this.pop();
                double rad = first / 57.29577951308232;
                double angle = Math.cos(rad);
                if (angle > 0.0 && angle < 1.0E-7) {
                    angle = 0.0;
                } else if (angle < 0.0 && angle > -1.0E-7) {
                    angle = 0.0;
                }
                this.push(angle, 2);
                break;
            }
            case 154806: {
                double first = this.pop();
                this.push((int)first, 1);
                break;
            }
            case 312990: {
                double first = this.pop();
                this.push(first, 2);
                break;
            }
            case 374507: {
                double first = this.pop();
                double second = this.pop();
                this.push(second / first, 2);
                break;
            }
            case 277163: {
                this.calculateDup();
                break;
            }
            case 10820: {
                double first = this.pop();
                double second = this.pop();
                if (first == second) {
                    this.push(1.0, 3);
                    break;
                }
                this.push(0.0, 3);
                break;
            }
            case 3249536: {
                if (this.stack.length < 2) {
                    throw new RuntimeException("EXCH - not enough elements on the stack");
                }
                double first = this.pop();
                fType = this.currentType;
                double second = this.pop();
                sType = this.currentType;
                this.push(first, fType);
                this.push(second, sType);
                break;
            }
            case 279192: {
                double first = this.pop();
                double second = this.pop();
                this.push(Math.pow(second, first), 2);
                break;
            }
            case 8418909: {
                this.push(0.0, 3);
                break;
            }
            case 6651169: {
                double first = this.pop();
                fType = this.currentType;
                if (first > 0.0) {
                    this.push((int)first, fType);
                    break;
                }
                int temp = (int)first;
                if ((double)temp > first) {
                    this.push(temp - 1, fType);
                    break;
                }
                this.push(first, fType);
                break;
            }
            case 2710: {
                double first = this.pop();
                fType = this.currentType;
                double second = this.pop();
                sType = this.currentType;
                if (!(fType != 1 && fType != 2 || sType != 1 && sType != 2)) {
                    if (second >= first) {
                        this.push(1.0, 3);
                        break;
                    }
                    this.push(0.0, 3);
                    break;
                }
                if (!LogWriter.isRunningFromIDE) break;
                throw new RuntimeException("Critical error in PS_ge");
            }
            case 12850: {
                double first = this.pop();
                fType = this.currentType;
                double second = this.pop();
                sType = this.currentType;
                if (!(fType != 1 && fType != 2 || sType != 1 && sType != 2)) {
                    if (second > first) {
                        this.push(1.0, 3);
                        break;
                    }
                    this.push(0.0, 3);
                    break;
                }
                if (!LogWriter.isRunningFromIDE) break;
                throw new RuntimeException("Critical error in PS_gt");
            }
            case 9739140: {
                int one = this.popInt();
                int two = this.popInt();
                this.push(two / one, 1);
                break;
            }
            case 3388: {
                if (!this.cont) {
                    System.arraycopy(this.safeStack, 0, this.stack, 0, 100);
                    System.arraycopy(this.safeStackType, 0, this.stackType, 0, 100);
                    this.stkPtr = this.safeStkPtr;
                    this.stkTypePtr = this.safeStkTypePrt;
                }
                this.cont = false;
                break;
            }
            case 1889428: {
                this.calculateIndex();
                break;
            }
            case 2715: {
                double first = this.pop();
                fType = this.currentType;
                double second = this.pop();
                sType = this.currentType;
                if (!(fType != 1 && fType != 2 || sType != 1 && sType != 2)) {
                    if (second <= first) {
                        this.push(1.0, 3);
                        break;
                    }
                    this.push(0.0, 3);
                    break;
                }
                if (!LogWriter.isRunningFromIDE) break;
                throw new RuntimeException("Critical error in PS_le");
            }
            case 12855: {
                double first = this.pop();
                fType = this.currentType;
                double second = this.pop();
                sType = this.currentType;
                if (!(fType != 1 && fType != 2 || sType != 1 && sType != 2)) {
                    if (second < first) {
                        this.push(1.0, 3);
                        break;
                    }
                    this.push(0.0, 3);
                    break;
                }
                if (!LogWriter.isRunningFromIDE) break;
                throw new RuntimeException("Critical error in PS_lt");
            }
            case 8799: {
                double first = this.pop();
                this.push(Math.log(first), 2);
                break;
            }
            case 114931: {
                double first = this.pop();
                this.push(Math.log(first) / toBase10, 2);
                break;
            }
            case 62204: {
                if (fType != 1 || sType != 1) {
                    System.err.println("PS_mod - both values must be integers!");
                }
                double first = this.pop();
                double second = this.pop();
                this.push(second % first, 1);
                break;
            }
            case 206868: {
                if (this.stack.length < 2) {
                    throw new RuntimeException("MUL - not enough elements on the stack");
                }
                double first = this.pop();
                double second = this.pop();
                this.push(first * second, 1);
                break;
            }
            case 2717: {
                double first = this.pop();
                double second = this.pop();
                if (first != second) {
                    this.push(1.0, 3);
                    break;
                }
                this.push(0.0, 3);
                break;
            }
            case 108173: {
                double temp = this.pop();
                fType = this.currentType;
                if (temp != 0.0) {
                    this.push(-temp, fType);
                    break;
                }
                this.push(temp, fType);
                break;
            }
            case 343421: {
                double first = this.pop();
                fType = this.currentType;
                if (first == 0.0 && fType == 3) {
                    this.push(1.0, 3);
                    break;
                }
                if (first == 1.0 && fType == 3) {
                    this.push(0.0, 3);
                    break;
                }
                this.push(~((int)first), 1);
                break;
            }
            case 11506: {
                double first = this.pop();
                double second = this.pop();
                if (fType == 3 && sType == 3) {
                    this.push((int)first | (int)second, 3);
                    break;
                }
                if (fType == 1 && sType == 1) {
                    this.push((int)first | (int)second, 1);
                    break;
                }
                if (!LogWriter.isRunningFromIDE) break;
                throw new RuntimeException("Critical error in PS_or");
            }
            case 273119: {
                this.pop();
                break;
            }
            case 5229553: {
                this.calculateRoll();
                break;
            }
            case 6301689: {
                double first = this.pop();
                fType = this.currentType;
                first += 0.5;
                if (first > 0.0) {
                    this.push((int)first, fType);
                    break;
                }
                int tem = (int)first;
                if ((double)tem > first) {
                    this.push(tem - 1, fType);
                    break;
                }
                this.push((int)first, fType);
                break;
            }
            case 233914: {
                double first = this.pop();
                this.push(Math.sin(first / 57.29577951308232), 2);
                break;
            }
            case 8992170: {
                double first = this.pop();
                if (first >= 0.0) {
                    this.push(Math.sqrt(first), 2);
                    break;
                }
                System.err.println("SQRT - cant sqrt a negative number!");
                break;
            }
            case 31114: {
                if (this.stack.length < 2) {
                    throw new RuntimeException("SUB - not enough elements on the stack");
                }
                double first = this.pop();
                fType = this.currentType;
                double second = this.pop();
                sType = this.currentType;
                if (fType == 2 || sType == 2) {
                    this.push(second - first, 2);
                    break;
                }
                this.push(second - first, 1);
                break;
            }
            case 6303719: {
                double first = this.pop();
                fType = this.currentType;
                this.push((int)first, fType);
                break;
            }
            case 2190935: {
                this.push(1.0, 3);
                break;
            }
            case 308279: {
                int firstInt = this.popInt();
                fType = this.currentType;
                int secondInt = this.popInt();
                sType = this.currentType;
                if (fType == 3 && sType == 3) {
                    this.push(firstInt ^ secondInt, 3);
                    break;
                }
                if (fType == 1 && sType == 1) {
                    this.push(firstInt ^ secondInt, 1);
                    break;
                }
                if (!LogWriter.isRunningFromIDE) break;
                throw new RuntimeException("Critical error in PS_xor");
            }
            default: {
                returnValue = -1;
            }
        }
        return returnValue;
    }

    private void calculateAtan() {
        double first = this.pop();
        double second = this.pop();
        if (first == 0.0 && second == 0.0) {
            System.err.println("ATAN - invalid parameters");
        }
        double tangent = second / first;
        if (first >= 0.0 && second >= 0.0) {
            this.push(Math.toDegrees(Math.atan(tangent)), 2);
        } else if (first > 0.0 && second <= 0.0) {
            double tmp = Math.toDegrees(Math.atan(tangent));
            if (tmp < 0.0) {
                tmp = -tmp;
            }
            this.push(tmp + 90.0, 2);
        } else if (first <= 0.0 && second <= 0.0) {
            double tmp = Math.toDegrees(Math.atan(tangent));
            if (tmp < 0.0) {
                tmp = -tmp;
            }
            this.push(tmp + 180.0, 2);
        } else if (first <= 0.0 && second >= 0.0) {
            double tmp = Math.toDegrees(Math.atan(tangent));
            if (tmp < 0.0) {
                tmp = -tmp;
            }
            this.push(tmp + 270.0, 2);
        }
    }

    private void calculateDup() {
        double value = this.pop();
        int type = this.currentType;
        this.push(value, type);
        this.push(value, type);
    }

    private void calculateIndex() {
        int n = this.popInt();
        if (n == 0) {
            this.calculateDup();
        } else if (n > 0) {
            double[] temp = new double[n];
            int[] types = new int[n];
            for (int i = 0; i < temp.length; ++i) {
                temp[i] = this.pop();
                types[i] = this.currentType;
            }
            double val = this.pop();
            int fType = this.currentType;
            this.push(val, fType);
            for (int ii = temp.length; ii > 0; --ii) {
                this.push(temp[ii - 1], types[ii - 1]);
            }
            this.push(val, fType);
        } else if (n < 0) {
            System.err.println("-> Index : critical error, n has to be nonnegative");
        }
    }

    private void calculateRoll() {
        block12: {
            int numberOfElements;
            int amount;
            block11: {
                amount = this.popInt();
                numberOfElements = this.popInt();
                if (numberOfElements < 0 && LogWriter.isRunningFromIDE) {
                    throw new RuntimeException("-> Roll : critical error");
                }
                if (numberOfElements > this.stkPtr) {
                    numberOfElements = this.stkPtr;
                }
                if (amount <= 0) break block11;
                double[] topTemp = new double[amount];
                int[] topTypes = new int[amount];
                if (numberOfElements - amount <= 0) {
                    return;
                }
                double[] bottomTemp = new double[numberOfElements - amount];
                int[] bottomTypes = new int[numberOfElements - amount];
                for (int i = 0; i < topTemp.length; ++i) {
                    topTemp[i] = this.pop();
                    topTypes[i] = this.currentType;
                }
                for (int y = 0; y < bottomTemp.length; ++y) {
                    bottomTemp[y] = this.pop();
                    bottomTypes[y] = this.currentType;
                }
                for (int ii = topTemp.length; ii > 0; --ii) {
                    this.push(topTemp[ii - 1], topTypes[ii - 1]);
                }
                for (int yy = bottomTemp.length; yy > 0; --yy) {
                    this.push(bottomTemp[yy - 1], bottomTypes[yy - 1]);
                }
                break block12;
            }
            if (amount >= 0) break block12;
            amount = -amount;
            double[] topTemp = new double[numberOfElements - amount];
            int[] topTypes = new int[numberOfElements - amount];
            double[] bottomTemp = new double[amount];
            int[] bottomTypes = new int[amount];
            for (int i = 0; i < topTemp.length; ++i) {
                topTemp[i] = this.pop();
                topTypes[i] = this.currentType;
            }
            for (int y = 0; y < bottomTemp.length; ++y) {
                bottomTemp[y] = this.pop();
                bottomTypes[y] = this.currentType;
            }
            for (int ii = topTemp.length; ii > 0; --ii) {
                this.push(topTemp[ii - 1], topTypes[ii - 1]);
            }
            for (int yy = bottomTemp.length; yy > 0; --yy) {
                this.push(bottomTemp[yy - 1], bottomTypes[yy - 1]);
            }
        }
    }

    public double[] executePostscript() {
        boolean firstBracket = false;
        this.ptr = 0;
        this.level = 0;
        while (this.ptr < this.streamLength) {
            block14: {
                byte[] nextVal = this.getNextValue();
                if (nextVal != null) {
                    if (nextVal.length == 1 && (nextVal[0] == 123 || nextVal[0] == 125)) {
                        if (firstBracket && nextVal[0] == 123) {
                            double i = this.pop();
                            int fType = this.currentType;
                            this.safeStack = new double[100];
                            this.safeStackType = new int[100];
                            System.arraycopy(this.stack, 0, this.safeStack, 0, 100);
                            System.arraycopy(this.stackType, 0, this.safeStackType, 0, 100);
                            this.safeStkPtr = this.stkPtr;
                            this.safeStkTypePrt = this.stkTypePtr;
                            if (fType == 3) {
                                if (i > 0.0) {
                                    this.cont = true;
                                }
                            } else {
                                throw new RuntimeException("Possible syntax error in PostScript stream!");
                            }
                        }
                        firstBracket = true;
                    } else {
                        int ID2 = PostscriptFactory.getCommandID(nextVal);
                        if (ID2 == -1) {
                            try {
                                double number = PostscriptFactory.convertToDouble(nextVal);
                                int numberInt = (int)number;
                                if ((double)numberInt == number) {
                                    this.push(number, 1);
                                    break block14;
                                }
                                this.push(number, 2);
                            }
                            catch (Exception e) {
                                LogWriter.writeLog("Exception " + e);
                            }
                        } else {
                            int result = this.execute(ID2);
                            if (result == -1 && LogWriter.isRunningFromIDE) {
                                throw new RuntimeException("Unsupported command with value " + PostscriptUtils.toString(ID2));
                            }
                        }
                    }
                }
            }
            if (this.level != 0 && this.ptr < this.streamLength) continue;
            break;
        }
        return this.stack;
    }

    private void push(double number, int type) {
        if (this.stkPtr > 99 || this.stkTypePtr > 99) {
            if (LogWriter.isRunningFromIDE) {
                throw new RuntimeException("Stack or stackType overflow");
            }
        } else {
            this.stack[this.stkPtr] = number;
            this.stackType[this.stkTypePtr] = type;
        }
        ++this.stkPtr;
        ++this.stkTypePtr;
    }

    private double pop() {
        double value = 0.0;
        --this.stkPtr;
        --this.stkTypePtr;
        if (this.stkTypePtr < 0) {
            if (LogWriter.isRunningFromIDE) {
                throw new RuntimeException("Stack type underflow");
            }
        } else {
            this.currentType = this.stackType[this.stkTypePtr];
        }
        if (this.stkPtr < 0) {
            if (LogWriter.isRunningFromIDE) {
                throw new RuntimeException("Stack underflow");
            }
        } else {
            value = this.stack[this.stkPtr];
        }
        return value;
    }

    private int popInt() {
        return (int)this.pop();
    }

    private static double convertToDouble(byte[] stream) {
        double d;
        int charCount;
        boolean start = false;
        int ptr = charCount = stream.length;
        int intStart = 0;
        boolean isMinus = false;
        for (int j = charCount - 1; j > -1; --j) {
            if (stream[0 + j] != 46) continue;
            ptr = j;
            break;
        }
        int intChars = ptr;
        if (stream[0] == 43) {
            --intChars;
            ++intStart;
        } else if (stream[0] == 45) {
            ++intStart;
            isMinus = true;
        }
        int intNumbers = intChars - intStart;
        int decNumbers = charCount - ptr;
        if (intNumbers > 3) {
            isMinus = false;
            d = Double.parseDouble(new String(stream));
        } else {
            if (decNumbers > 6) {
                decNumbers = 6;
            }
            d = NumberUtils.convertStreamFromDouble(stream, 0 + intStart, 0 + ptr, intNumbers, decNumbers);
        }
        if (isMinus) {
            return -d;
        }
        return d;
    }

    private byte[] getNextValue() {
        byte next;
        byte[] returnValue = null;
        while (this.ptr < this.streamLength && (this.stream[this.ptr] == 10 || this.stream[this.ptr] == 13 || this.stream[this.ptr] == 32)) {
            ++this.ptr;
        }
        int start = this.ptr;
        while (this.ptr < this.streamLength && (next = this.stream[this.ptr]) != 123) {
            ++this.ptr;
            if (this.ptr < this.streamLength && (next = this.stream[this.ptr]) != 32 && next != 13 && next != 10 && next != 123 && next != 125) continue;
        }
        if (this.stream[start] == 123) {
            ++this.ptr;
            ++this.level;
        } else if (this.stream[start] == 125) {
            --this.level;
        }
        int end = this.ptr;
        if (end >= start) {
            int len = end - start;
            returnValue = new byte[len];
            System.arraycopy(this.stream, start, returnValue, start - start, end - start);
        }
        return returnValue;
    }

    public void resetStacks(float[] values) {
        this.stack = new double[100];
        this.stackType = new int[100];
        this.stkPtr = 0;
        this.stkTypePtr = 0;
        for (int ii = 0; ii < 100; ++ii) {
            this.stack[ii] = 0.0;
        }
        for (int iii = 0; iii < 100; ++iii) {
            this.stackType[iii] = 0;
        }
        for (float value : values) {
            this.push(value, 2);
        }
    }
}

