/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.FastByteArrayOutputStream;

public class ImageInputStreamFileBuffer
implements RandomAccessBuffer {
    private static final String fileName = "";
    final ImageInputStream iis;

    public ImageInputStreamFileBuffer(ImageInputStream iis) {
        this.iis = iis;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.iis.getStreamPosition();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.iis.seek(pos);
    }

    @Override
    public int read() throws IOException {
        return this.iis.read();
    }

    @Override
    public String readLine() throws IOException {
        return this.iis.readLine();
    }

    @Override
    public long length() throws IOException {
        return this.iis.length();
    }

    @Override
    public void close() throws IOException {
        this.iis.close();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.iis.read(b);
    }

    @Override
    public byte[] getPdfBuffer() {
        byte[] pdfByteArray = null;
        try {
            int read;
            FastByteArrayOutputStream os = new FastByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((read = this.iis.read(buffer)) != -1) {
                os.write(buffer, 0, read);
            }
            pdfByteArray = os.toByteArray();
        }
        catch (IOException e) {
            LogWriter.writeLog("[PDF] Exception " + e + " getting byte[] for " + fileName);
        }
        return pdfByteArray;
    }
}

