/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class ObjectStore {
    private static final boolean debugAdobe = false;
    private static final Map undeletedFiles = new HashMap();
    public static boolean isMultiThreaded;
    private static final boolean debugCache = false;
    private static boolean checkedThisSession;
    private static final String separator;
    private String currentFilename = "";
    private String currentFilePath = "";
    public static String temp_dir;
    public static final String multiThreaded_root_dir;
    private static final String cmyk_dir;
    private String key = "jpedal" + Math.random() + '_';
    private final Map image_type = new HashMap();
    private final Map tempFileNames = new HashMap();
    public static final Integer IMAGE_WIDTH;
    public static final Integer IMAGE_HEIGHT;
    public static final Integer IMAGE_pX;
    public static final Integer IMAGE_pY;
    public static final Integer IMAGE_MASKCOL;
    public static final Integer IMAGE_COLORSPACE;
    public static final long time = 14400000L;
    public String fullFileName;
    private static final Map pagesOnDisk;
    private static final Map pagesOnDiskAsBytes;
    private final Map imagesOnDiskAsBytes = new HashMap();
    private final Map imagesOnDiskAsBytesW = new HashMap();
    private final Map imagesOnDiskAsBytesH = new HashMap();
    private final Map imagesOnDiskAsBytespX = new HashMap();
    private final Map imagesOnDiskAsBytespY = new HashMap();
    private final Map imagesOnDiskMask = new HashMap();
    private final Map imagesOnDiskColSpaceID = new HashMap();

    public ObjectStore() {
        ObjectStore.init();
    }

    private static void init() {
        try {
            if (temp_dir.isEmpty()) {
                temp_dir = System.getProperty("java.io.tmpdir");
            }
            if (isMultiThreaded) {
                temp_dir = multiThreaded_root_dir != null ? multiThreaded_root_dir + separator + "jpedal-" + System.currentTimeMillis() + separator : temp_dir + separator + "jpedal-" + System.currentTimeMillis() + separator;
            } else if (temp_dir.isEmpty()) {
                temp_dir = temp_dir + separator + "jpedal" + separator;
            } else if (!temp_dir.endsWith(separator)) {
                temp_dir = temp_dir + separator;
            }
            File f = new File(temp_dir);
            if (!f.exists()) {
                f.mkdirs();
            }
            if (isMultiThreaded) {
                f.deleteOnExit();
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Unable to create temp dir at " + temp_dir + ' ' + e);
        }
    }

    public String getCurrentFilename() {
        return this.currentFilename;
    }

    public String getCurrentFilepath() {
        return this.currentFilePath;
    }

    public final void storeFileName(String name) {
        this.fullFileName = name;
        int ptr = this.fullFileName.lastIndexOf(47);
        int ptr2 = this.fullFileName.lastIndexOf(92);
        if (ptr2 > ptr) {
            ptr = ptr2;
        }
        this.currentFilePath = ptr > 0 ? this.fullFileName.substring(0, ptr + 1) : "";
        int temp_pointer = name.indexOf(92);
        if (temp_pointer == -1) {
            temp_pointer = name.indexOf(47);
        }
        while (temp_pointer != -1) {
            if ((temp_pointer = (name = name.substring(temp_pointer + 1)).indexOf(92)) != -1) continue;
            temp_pointer = name.indexOf(47);
        }
        int pointer = name.lastIndexOf(46);
        if (pointer != -1) {
            name = name.substring(0, pointer);
        }
        name = Strip.stripAllSpaces(name);
        this.currentFilename = name.toLowerCase();
    }

    public boolean saveRawCMYKImage(byte[] image_data, String name) {
        boolean isSuccessful = true;
        name = ObjectStore.removeIllegalFileNameCharacters(name);
        File cmyk_d = new File(cmyk_dir);
        if (!cmyk_d.exists()) {
            cmyk_d.mkdirs();
        }
        try {
            FileOutputStream a = new FileOutputStream(cmyk_dir + name + ".jpg");
            this.tempFileNames.put(cmyk_dir + name + ".jpg", "#");
            a.write(image_data);
            a.flush();
            a.close();
        }
        catch (Exception e) {
            LogWriter.writeLog("Unable to save CMYK jpeg " + name + ' ' + e);
            isSuccessful = false;
        }
        return isSuccessful;
    }

    public final synchronized boolean saveStoredImage(String current_image, BufferedImage image, boolean file_name_is_path, boolean save_unclipped, String type) {
        boolean was_error = false;
        current_image = ObjectStore.removeIllegalFileNameCharacters(current_image);
        int type_id = image.getType();
        File checkDir = new File(temp_dir);
        if (!checkDir.exists()) {
            checkDir.mkdirs();
        }
        if (type.contains("tif")) {
            if (!(type_id != 1 && type_id != 2 || current_image.contains("HIRES_"))) {
                image = ColorSpaceConvertor.convertColorspace(image, 5);
            }
            if (!file_name_is_path) {
                this.image_type.put(current_image, "tif");
            }
            was_error = this.saveStoredImage("TIFF", ".tif", ".tiff", current_image, image, file_name_is_path, save_unclipped);
        } else if (type.contains("jpg")) {
            if (!file_name_is_path) {
                this.image_type.put(current_image, "jpg");
            }
            was_error = this.saveStoredJPEGImage(current_image, image, file_name_is_path, save_unclipped);
        } else if (type.contains("png")) {
            if (!file_name_is_path) {
                this.image_type.put(current_image, "png");
            }
            was_error = this.saveStoredImage("PNG", ".png", ".png", current_image, image, file_name_is_path, save_unclipped);
        }
        return was_error;
    }

    public final String getImageType(String current_image) {
        return (String)this.image_type.get(current_image);
    }

    public final void init(String current_key) {
        this.key = current_key + System.currentTimeMillis();
        File f = new File(temp_dir);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public final synchronized BufferedImage loadStoredImage(String current_image) {
        if (current_image == null) {
            return null;
        }
        current_image = ObjectStore.removeIllegalFileNameCharacters(current_image);
        String flag = (String)this.image_type.get(current_image);
        BufferedImage image = null;
        if (flag == null) {
            return null;
        }
        if (flag.equals("tif")) {
            image = this.loadStoredImage(current_image, ".tif");
        } else if (flag.equals("jpg")) {
            image = this.loadStoredJPEGImage(current_image);
        } else if (flag.equals("png")) {
            image = this.loadStoredImage(current_image, ".png");
        }
        return image;
    }

    public final synchronized void flush() {
        File delete_file;
        for (Object file : this.imagesOnDiskAsBytes.keySet()) {
            if (file == null || !(delete_file = new File((String)this.imagesOnDiskAsBytes.get(file))).exists()) continue;
            delete_file.delete();
        }
        this.imagesOnDiskAsBytes.clear();
        this.imagesOnDiskAsBytesW.clear();
        this.imagesOnDiskAsBytesH.clear();
        this.imagesOnDiskAsBytespX.clear();
        this.imagesOnDiskAsBytespY.clear();
        this.imagesOnDiskMask.clear();
        this.imagesOnDiskColSpaceID.clear();
        Iterator filesTodelete = this.tempFileNames.keySet().iterator();
        while (filesTodelete.hasNext()) {
            Object file;
            file = (String)filesTodelete.next();
            if (!((String)file).contains(this.key)) continue;
            delete_file = new File((String)file);
            if (delete_file.delete()) {
                filesTodelete.remove();
                continue;
            }
            undeletedFiles.put(this.key, "x");
        }
        try {
            File cmyk_d;
            if (!checkedThisSession && temp_dir.length() > 2) {
                checkedThisSession = true;
                File temp_files = new File(temp_dir);
                String[] file_list = temp_files.list();
                File[] to_be_del = temp_files.listFiles();
                if (file_list != null) {
                    for (int ii = 0; ii < file_list.length; ++ii) {
                        if (file_list[ii].contains(this.key)) {
                            File delete_file2 = new File(temp_dir + file_list[ii]);
                            delete_file2.delete();
                        }
                        boolean delOldFiles = true;
                        if (file_list[ii].endsWith(".pdf") || System.currentTimeMillis() - to_be_del[ii].lastModified() < 14400000L) continue;
                        to_be_del[ii].delete();
                    }
                }
            }
            if ((cmyk_d = new File(cmyk_dir)).exists()) {
                cmyk_d.delete();
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " flushing files");
        }
    }

    public static void copyCMYKimages(String target_dir) {
        File cmyk_d = new File(cmyk_dir);
        if (cmyk_d.exists()) {
            String[] file_list = cmyk_d.list();
            if (file_list.length > 0) {
                File test_d;
                if (!target_dir.endsWith(separator)) {
                    target_dir = target_dir + separator;
                }
                if (!(test_d = new File(target_dir)).exists()) {
                    test_d.mkdirs();
                }
            }
            for (String aFile_list : file_list) {
                File source = new File(cmyk_dir + aFile_list);
                File dest = new File(target_dir + aFile_list);
                source.renameTo(dest);
            }
        }
    }

    private synchronized boolean saveStoredJPEGImage(String current_image, BufferedImage image, boolean file_name_is_path, boolean save_unclipped) {
        boolean was_error = false;
        String file_name = current_image;
        String unclipped_file_name = "";
        if (!file_name_is_path) {
            file_name = temp_dir + this.key + current_image;
            unclipped_file_name = temp_dir + this.key + 'R' + current_image;
            this.image_type.put('R' + current_image, this.image_type.get(current_image));
        }
        if (!file_name.toLowerCase().endsWith(".jpg") && !file_name.toLowerCase().endsWith(".jpeg")) {
            file_name = file_name + ".jpg";
            unclipped_file_name = unclipped_file_name + ".jpg";
        }
        try {
            DefaultImageHelper.write(image, "jpg", file_name);
            this.tempFileNames.put(file_name, "#");
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " writing image " + image + " as " + file_name);
        }
        if (save_unclipped) {
            ObjectStore.saveCopy(file_name, unclipped_file_name);
            this.tempFileNames.put(unclipped_file_name, "#");
        }
        return false;
    }

    public String getFileForCachedImage(String current_image) {
        return temp_dir + this.key + current_image + '.' + this.image_type.get(current_image);
    }

    private synchronized BufferedImage loadStoredImage(String current_image, String ending) {
        current_image = ObjectStore.removeIllegalFileNameCharacters(current_image);
        String file_name = temp_dir + this.key + current_image + ending;
        return DefaultImageHelper.read(file_name);
    }

    private static void saveCopy(String source, String destination) {
        BufferedInputStream from = null;
        BufferedOutputStream to = null;
        try {
            int bytes_read;
            from = new BufferedInputStream(new FileInputStream(source));
            to = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] buffer = new byte[65535];
            while ((bytes_read = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytes_read);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " copying file");
        }
        try {
            to.close();
            from.close();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " closing files");
        }
    }

    public final void saveAsCopy(String current_image, String destination) {
        BufferedInputStream from = null;
        BufferedOutputStream to = null;
        current_image = ObjectStore.removeIllegalFileNameCharacters(current_image);
        String source = temp_dir + this.key + current_image;
        try {
            int bytes_read;
            from = new BufferedInputStream(new FileInputStream(source));
            to = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] buffer = new byte[65535];
            while ((bytes_read = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytes_read);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " copying file");
        }
        try {
            to.close();
            from.close();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " closing files");
        }
    }

    public static void copy(String source, String destination) {
        BufferedInputStream from = null;
        BufferedOutputStream to = null;
        try {
            from = new BufferedInputStream(new FileInputStream(source));
            to = new BufferedOutputStream(new FileOutputStream(destination));
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " copying file");
        }
        ObjectStore.copy(from, to);
    }

    public static void copy(BufferedInputStream from, BufferedOutputStream to) {
        try {
            int bytes_read;
            byte[] buffer = new byte[65535];
            while ((bytes_read = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytes_read);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " copying file");
        }
        try {
            to.close();
            from.close();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " closing files");
        }
    }

    private synchronized BufferedImage loadStoredJPEGImage(String current_image) {
        String file_name = temp_dir + this.key + current_image + ".jpg";
        BufferedImage image = null;
        File a = new File(file_name);
        if (a.exists()) {
            try {
                image = DefaultImageHelper.read(file_name);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " loading " + current_image);
            }
        } else {
            image = new BufferedImage(100, 100, 1);
        }
        return image;
    }

    private synchronized boolean saveStoredImage(String format, String ending1, String ending2, String current_image, BufferedImage image, boolean file_name_is_path, boolean save_unclipped) {
        boolean was_error = false;
        String file_name = current_image = ObjectStore.removeIllegalFileNameCharacters(current_image);
        String unclipped_file_name = "";
        if (!file_name_is_path) {
            file_name = temp_dir + this.key + current_image;
            unclipped_file_name = temp_dir + this.key + 'R' + current_image;
            this.image_type.put('R' + current_image, this.image_type.get(current_image));
        }
        if (!file_name.toLowerCase().endsWith(ending1) && !file_name.toLowerCase().endsWith(ending2)) {
            file_name = file_name + ending1;
            unclipped_file_name = unclipped_file_name + ending1;
        }
        try {
            if (format.equals("TIFF")) {
                DefaultImageHelper.write(image, "png", file_name);
            } else {
                DefaultImageHelper.write(image, format, file_name);
            }
            File f = new File(file_name);
            if (f.length() == 0L) {
                image = ColorSpaceConvertor.convertToRGB(image);
                if (format.equals("TIFF")) {
                    DefaultImageHelper.write(image, "png", file_name);
                } else {
                    DefaultImageHelper.write(image, format, file_name);
                }
            }
            this.tempFileNames.put(file_name, "#");
        }
        catch (Exception e) {
            LogWriter.writeLog(" Exception " + e + " writing image " + image + " with type " + image.getType());
            was_error = true;
        }
        catch (Error ee) {
            LogWriter.writeLog("Error " + ee + " writing image " + image + " with type " + image.getType());
            was_error = true;
        }
        if (save_unclipped) {
            ObjectStore.saveCopy(file_name, unclipped_file_name);
            this.tempFileNames.put(unclipped_file_name, "#");
        }
        return was_error;
    }

    public static synchronized void flushPages() {
        try {
            File delete_file;
            for (Object file : pagesOnDisk.keySet()) {
                if (file == null || !(delete_file = new File((String)pagesOnDisk.get(file))).exists()) continue;
                delete_file.delete();
            }
            pagesOnDisk.clear();
            for (Object file : pagesOnDiskAsBytes.keySet()) {
                if (file == null || !(delete_file = new File((String)pagesOnDiskAsBytes.get(file))).exists()) continue;
                delete_file.delete();
            }
            pagesOnDiskAsBytes.clear();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " flushing files");
        }
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        this.flush();
        for (Object o : undeletedFiles.keySet()) {
            String file = (String)o;
            File delete_file = new File(file);
            if (!delete_file.delete()) continue;
            undeletedFiles.remove(file);
        }
    }

    public static byte[] getCachedPageAsBytes(String key) {
        byte[] data = null;
        Object cachedFile = pagesOnDiskAsBytes.get(key);
        if (cachedFile != null) {
            try {
                File fis = new File((String)cachedFile);
                BufferedInputStream from = new BufferedInputStream(new FileInputStream(fis));
                data = new byte[(int)fis.length()];
                from.read(data);
                from.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return data;
    }

    public static void cachePageAsBytes(String key, byte[] bytes) {
        try {
            File delete_file;
            if (pagesOnDiskAsBytes.containsKey(key) && (delete_file = new File((String)pagesOnDiskAsBytes.get(key))).exists()) {
                delete_file.delete();
            }
            File ff = File.createTempFile("bytes", ".bin", new File(temp_dir));
            BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(ff));
            to.write(bytes);
            to.flush();
            to.close();
            pagesOnDiskAsBytes.put(key, ff.getAbsolutePath());
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }

    public void saveRawImageData(String pageImgCount, byte[] bytes, int w, int h, int pX, int pY, byte[] maskCol, int colorSpaceID) {
        try {
            File ff = File.createTempFile("image", ".bin", new File(temp_dir));
            BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(ff));
            to.write(bytes);
            to.flush();
            to.close();
            Integer key = Integer.valueOf(pageImgCount);
            this.imagesOnDiskAsBytes.put(key, ff.getAbsolutePath());
            this.imagesOnDiskAsBytesW.put(key, w);
            this.imagesOnDiskAsBytesH.put(key, h);
            this.imagesOnDiskAsBytespX.put(key, pX);
            this.imagesOnDiskAsBytespY.put(key, pY);
            this.imagesOnDiskMask.put(key, maskCol);
            this.imagesOnDiskColSpaceID.put(key, colorSpaceID);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }

    public boolean isRawImageDataSaved(String number) {
        return this.imagesOnDiskAsBytes.get(Integer.valueOf(number)) != null;
    }

    public byte[] getRawImageData(String i) {
        byte[] data = null;
        Object cachedFile = this.imagesOnDiskAsBytes.get(Integer.valueOf(i));
        if (cachedFile != null) {
            try {
                File fis = new File((String)cachedFile);
                BufferedInputStream from = new BufferedInputStream(new FileInputStream(fis));
                data = new byte[(int)fis.length()];
                from.read(data);
                from.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return data;
    }

    public Object getRawImageDataParameter(String imageID, Integer key) {
        if (key.equals(IMAGE_WIDTH)) {
            return this.imagesOnDiskAsBytesW.get(Integer.valueOf(imageID));
        }
        if (key.equals(IMAGE_HEIGHT)) {
            return this.imagesOnDiskAsBytesH.get(Integer.valueOf(imageID));
        }
        if (key.equals(IMAGE_pX)) {
            return this.imagesOnDiskAsBytespX.get(Integer.valueOf(imageID));
        }
        if (key.equals(IMAGE_pY)) {
            return this.imagesOnDiskAsBytespY.get(Integer.valueOf(imageID));
        }
        if (key.equals(IMAGE_MASKCOL)) {
            return this.imagesOnDiskMask.get(Integer.valueOf(imageID));
        }
        if (key.equals(IMAGE_COLORSPACE)) {
            return this.imagesOnDiskColSpaceID.get(Integer.valueOf(imageID));
        }
        return null;
    }

    public static File createTempFile(String filename) throws IOException {
        StringBuilder prefix = new StringBuilder(filename.substring(0, filename.lastIndexOf(46)));
        while (prefix.length() < 3) {
            prefix.append('a');
        }
        String suffix = filename.substring(filename.lastIndexOf(46));
        if (suffix.length() < 3) {
            suffix = "pdf";
        }
        File tempURLFile = File.createTempFile(prefix.toString(), suffix, new File(temp_dir));
        return tempURLFile;
    }

    public static String removeIllegalFileNameCharacters(String s) {
        return s;
    }

    public void setFileToDeleteOnFlush(String rawFileName) {
        this.tempFileNames.put(rawFileName, "#");
    }

    public String getKey() {
        return this.key;
    }

    static {
        separator = System.getProperty("file.separator");
        temp_dir = "";
        multiThreaded_root_dir = null;
        cmyk_dir = temp_dir + "cmyk" + separator;
        IMAGE_WIDTH = 1;
        IMAGE_HEIGHT = 2;
        IMAGE_pX = 3;
        IMAGE_pY = 4;
        IMAGE_MASKCOL = 5;
        IMAGE_COLORSPACE = 6;
        pagesOnDisk = new HashMap();
        pagesOnDiskAsBytes = new HashMap();
    }
}

