/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.filter.ASCII85;
import org.jpedal.io.filter.ASCIIHex;
import org.jpedal.io.filter.BaseFilter;
import org.jpedal.io.filter.CCITT;
import org.jpedal.io.filter.Flate;
import org.jpedal.io.filter.LZW;
import org.jpedal.io.filter.RunLength;
import org.jpedal.jbig2.io.JBIG2;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class PdfFilteredReader {
    private static final int A85 = 1116165;
    private static final int AHx = 0x111848;
    private static final int ASCII85Decode = 1582784916;
    private static final int ASCIIHexDecode = 2074112677;
    public static final int CCITTFaxDecode = 2108391315;
    private static final int CCF = 0x131316;
    private static final int Crypt = 1112096855;
    public static final int DCTDecode = 1180911742;
    public static final int Fl = 5692;
    public static final int FlateDecode = 2005566619;
    public static final int JBIG2Decode = 1247500931;
    public static final int JPXDecode = 1399277700;
    private static final int LZW = 1845799;
    private static final int LZWDecode = 1566984326;
    private static final int RL = 8732;
    private static final int RunLengthDecode = -1815163937;
    private final Map<String, String> cachedObjects = new HashMap<String, String>();
    private BufferedOutputStream streamCache;
    private BufferedInputStream bis;
    private boolean hasError;

    public byte[] decodeFilters(PdfObject[] DecodeParmsArray, byte[] data, PdfArrayIterator filters, int width, int height, String cacheName) throws Exception {
        PdfObject Globals;
        this.streamCache = null;
        this.bis = null;
        boolean debug = false;
        int parmsCount = DecodeParmsArray.length;
        PdfObject DecodeParms = DecodeParmsArray[0];
        byte[] globalData = null;
        if (DecodeParms != null && (Globals = DecodeParms.getDictionary(1314558361)) != null) {
            globalData = Globals.getDecodedStream();
        }
        boolean isCached = cacheName != null;
        int filterCount = filters.getTokenCount();
        int counter = 0;
        if (filterCount > 0) {
            while (filters.hasMoreTokens()) {
                block32: {
                    BaseFilter filter;
                    int filterType = filters.getNextValueAsConstant(true);
                    boolean resetDataToNull = false;
                    if (parmsCount > 1) {
                        PdfObject Globals2;
                        DecodeParms = DecodeParmsArray[counter];
                        globalData = null;
                        if (DecodeParms != null && (Globals2 = DecodeParms.getDictionary(1314558361)) != null) {
                            globalData = Globals2.getDecodedStream();
                        }
                    }
                    if (isCached && cacheName != null && (filterType == 1112096855 || filterType == 1180911742 || filterType == 1399277700)) {
                        ++counter;
                        continue;
                    }
                    if (isCached && cacheName != null) {
                        this.setupCachedObjectForDecoding(cacheName);
                    }
                    switch (filterType) {
                        case 5692: 
                        case 2005566619: {
                            filter = new Flate(DecodeParms);
                            break;
                        }
                        case 1116165: 
                        case 1582784916: {
                            filter = new ASCII85(DecodeParms);
                            break;
                        }
                        case 0x131316: 
                        case 2108391315: {
                            filter = new CCITT(DecodeParms, width, height);
                            break;
                        }
                        case 1845799: 
                        case 1566984326: {
                            filter = new LZW(DecodeParms, width, height);
                            resetDataToNull = true;
                            break;
                        }
                        case -1815163937: 
                        case 8732: {
                            filter = new RunLength(DecodeParms);
                            break;
                        }
                        case 1247500931: {
                            if (data == null) {
                                System.err.println("should not come here");
                                data = new byte[this.bis.available()];
                                this.bis.read(data);
                                int ptr = -1;
                                for (int ii = data.length - 1; ii > 9; --ii) {
                                    if (data[ii] != 101 || data[ii + 1] != 110 || data[ii + 2] != 100 || data[ii + 3] != 115 || data[ii + 4] != 116 || data[ii + 5] != 114 || data[ii + 6] != 101 || data[ii + 7] != 97 || data[ii + 8] != 109) continue;
                                    ptr = ii - 1;
                                    ii = -1;
                                }
                                if (ptr != -1) {
                                    if (data[ptr] == 10 && data[ptr - 1] == 13) {
                                        --ptr;
                                    }
                                    byte[] tmp = data;
                                    data = new byte[ptr];
                                    System.arraycopy(tmp, 0, data, 0, ptr);
                                }
                                data = JBIG2.JBIGDecode(data, globalData, ObjectStore.temp_dir);
                                this.streamCache.write(data);
                                data = null;
                            } else {
                                data = JBIG2.JBIGDecode(data, globalData, ObjectStore.temp_dir);
                            }
                            filter = null;
                            break;
                        }
                        case 0x111848: 
                        case 2074112677: {
                            filter = new ASCIIHex(DecodeParms);
                            break;
                        }
                        case 1112096855: {
                            filter = null;
                            break;
                        }
                        default: {
                            filter = null;
                        }
                    }
                    if (filter != null) {
                        try {
                            if (data != null) {
                                data = filter.decode(data);
                            } else if (this.bis != null) {
                                filter.decode(this.bis, this.streamCache, cacheName, this.cachedObjects);
                            }
                            if (!this.hasError && filter.hasError()) {
                                this.hasError = true;
                            }
                        }
                        catch (Exception ee) {
                            LogWriter.writeLog("Exception " + ee + " in " + PdfFilteredReader.getFilterName(filterType) + " decompression");
                            if (!resetDataToNull) break block32;
                            data = null;
                        }
                    }
                }
                if (isCached) {
                    if (this.bis != null) {
                        this.bis.close();
                    }
                    if (this.streamCache != null) {
                        this.streamCache.flush();
                        this.streamCache.close();
                    }
                }
                ++counter;
            }
        }
        return data;
    }

    private static String getFilterName(int filterType) {
        switch (filterType) {
            case 1116165: {
                return "A85";
            }
            case 0x111848: {
                return "AHx";
            }
            case 1582784916: {
                return "ASCII85Decode";
            }
            case 2074112677: {
                return "ASCIIHexDecode";
            }
            case 2108391315: {
                return "CCITTFaxDecode";
            }
            case 0x131316: {
                return "CCF";
            }
            case 1112096855: {
                return "Crypt";
            }
            case 1180911742: {
                return "DCTDecode";
            }
            case 5692: {
                return "Fl";
            }
            case 2005566619: {
                return "FlateDecode";
            }
            case 1247500931: {
                return "JBIG2Decode";
            }
            case 1399277700: {
                return "";
            }
            case 1845799: {
                return "";
            }
            case 1566984326: {
                return "";
            }
            case 8732: {
                return "";
            }
            case -1815163937: {
                return "";
            }
        }
        return "Unknown";
    }

    private void setupCachedObjectForDecoding(String cacheName) throws IOException {
        File tempFile2 = File.createTempFile("jpedal", ".raw", new File(ObjectStore.temp_dir));
        this.cachedObjects.put(tempFile2.getAbsolutePath(), "x");
        ObjectStore.copy(cacheName, tempFile2.getAbsolutePath());
        File rawFile = new File(cacheName);
        rawFile.delete();
        this.streamCache = new BufferedOutputStream(new FileOutputStream(cacheName));
        this.bis = new BufferedInputStream(new FileInputStream(tempFile2));
    }

    public boolean hasError() {
        return this.hasError;
    }
}

