/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.exception.PdfException;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.EncryptionUsed;
import org.jpedal.io.ImageInputStreamFileBuffer;
import org.jpedal.io.NameLookup;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.RandomAccessDataBuffer;
import org.jpedal.io.RandomAccessFileBuffer;
import org.jpedal.io.RandomAccessMemoryMapBuffer;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PageLookup;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class PdfObjectReader {
    private PdfFileReader objectReader = new PdfFileReader();
    final Map pagesReferences = new HashMap();
    private PageLookup pageLookup = new PageLookup();
    private String tempFileName;
    private NameLookup nameLookup;
    RandomAccessBuffer pdf_datafile;
    private Javascript javascript;

    public PdfObjectReader() {
    }

    public PdfObjectReader(String password) {
        if (password == null) {
            password = "";
        }
        this.objectReader.setPassword(password);
    }

    public PdfObjectReader(Certificate certificate, PrivateKey key) {
        this.objectReader.setCertificate(certificate, key);
    }

    public String getReferenceforPage(int page) {
        return (String)this.pagesReferences.get(page);
    }

    public final void closePdfFile() {
        try {
            this.objectReader.closeFile();
            if (this.pdf_datafile != null) {
                this.pdf_datafile.close();
            }
            if (this.tempFileName != null) {
                File fileToDelete = new File(this.tempFileName);
                fileToDelete.delete();
                this.tempFileName = null;
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " closing file");
        }
    }

    public PdfObject getPDFObject(int key) {
        if (key == 1113489015) {
            return this.objectReader.encyptionObj;
        }
        throw new RuntimeException("Access to " + key + " not supported");
    }

    public PdfFileReader getObjectReader() {
        return this.objectReader;
    }

    public String convertNameToRef(String value) {
        if (this.nameLookup == null) {
            return null;
        }
        return (String)this.nameLookup.get(value);
    }

    public NameLookup getNamesLookup() {
        if (this.nameLookup == null) {
            return null;
        }
        return this.nameLookup;
    }

    public void readNames(PdfObject nameObject, Javascript javascript, boolean isKid) {
        this.nameLookup = new NameLookup(this.objectReader);
        this.nameLookup.readNames(nameObject, javascript, isKid);
    }

    public int convertObjectToPageNumber(String ref) {
        return this.pageLookup.convertObjectToPageNumber(ref);
    }

    public void setLookup(String currentPageOffset, int tempPageCount) {
        this.pageLookup.put(currentPageOffset, tempPageCount);
        this.pagesReferences.put(tempPageCount, currentPageOffset);
    }

    public void dispose() {
        this.nameLookup = null;
        if (this.objectReader != null) {
            this.objectReader.dispose();
        }
        this.objectReader = null;
        if (this.pageLookup != null) {
            this.pageLookup.dispose();
        }
        this.pageLookup = null;
    }

    public final void openPdfFile(InputStream in) throws PdfException {
        try {
            this.pdf_datafile = new RandomAccessMemoryMapBuffer(in);
            this.objectReader.init(this.pdf_datafile);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " accessing file");
            throw new PdfException("Exception " + e + " accessing file");
        }
    }

    public final void openPdfFile(ImageInputStream iis) throws PdfException {
        try {
            ImageInputStreamFileBuffer pdf_datafile = new ImageInputStreamFileBuffer(iis);
            this.objectReader.init(pdf_datafile);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " accessing file");
            throw new PdfException("Exception " + e + " accessing file");
        }
    }

    public void checkParentForResources(PdfObject pdfObject) {
        String parent;
        if (pdfObject.getDictionary(2004251818) == null && (parent = pdfObject.getStringKey(1110793845)) != null) {
            PageObject parentObj = new PageObject(parent);
            this.readObject(parentObj);
            PdfObject resObj = ((PdfObject)parentObj).getDictionary(2004251818);
            if (resObj != null) {
                pdfObject.setDictionary(2004251818, resObj);
            }
        }
    }

    public final void openPdfFile(String filename) throws PdfException {
        try {
            RandomAccessFileBuffer pdf_datafile = new RandomAccessFileBuffer(filename, "r");
            this.objectReader.init(pdf_datafile);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " accessing file");
            throw new PdfException("Exception " + e + " accessing file");
        }
    }

    public final void openPdfFile(byte[] data) throws PdfException {
        try {
            RandomAccessBuffer pdf_datafile;
            if (PdfFileReader.alwaysCacheInMemory == -1 || data.length < PdfFileReader.alwaysCacheInMemory) {
                pdf_datafile = new RandomAccessDataBuffer(data);
            } else {
                try {
                    File file = File.createTempFile("page", ".bin", new File(ObjectStore.temp_dir));
                    this.tempFileName = file.getAbsolutePath();
                    FileOutputStream a = new FileOutputStream(file);
                    a.write(data);
                    a.flush();
                    a.close();
                    pdf_datafile = new RandomAccessFileBuffer(this.tempFileName, "r");
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to create temporary file in " + ObjectStore.temp_dir + ' ' + e);
                }
            }
            this.objectReader.init(pdf_datafile);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " accessing file");
            throw new PdfException("Exception " + e + " accessing file");
        }
    }

    public void setJavaScriptObject(Javascript javascript) {
        this.javascript = javascript;
    }

    public void checkResolved(PdfObject pdfObject) {
        ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
        objectDecoder.checkResolved(pdfObject);
    }

    public void setJavascriptForObject(FormObject formObject, int parentType, int actionType) {
        PdfObject additionalObject = formObject.getDictionary(parentType);
        ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
        objectDecoder.checkResolved(additionalObject);
        if (additionalObject == null) {
            return;
        }
        PdfObject actionObj = actionType == parentType ? additionalObject : (actionType == 4866 ? additionalObject.getDictionary(19) : additionalObject.getDictionary(actionType));
        if (actionObj != null) {
            String JSscript;
            objectDecoder.checkResolved(actionObj);
            PdfObject JSobj = actionObj.getDictionary(6691);
            if (JSobj != null) {
                byte[] data = JSobj.getDecodedStream();
                JSscript = StringUtils.getTextString(data, true);
            } else {
                JSscript = actionObj.getTextStreamValue(6691);
            }
            if (JSscript != null) {
                String name = formObject.getTextStreamValue(36);
                if (name == null) {
                    name = formObject.getObjectRefAsString();
                }
                this.javascript.storeJavascript(name, JSscript, actionType);
            }
        }
    }

    public byte[] readStream(PdfObject obj, boolean cacheValue, boolean decompress, boolean keepRaw, boolean isMetaData, boolean isCompressedStream, String cacheFile) {
        return this.objectReader.readStream(obj, cacheValue, decompress, keepRaw, isMetaData, isCompressedStream, cacheFile);
    }

    public void readObject(PdfObject pdfObject) {
        this.objectReader.readObject(pdfObject);
    }

    public EncryptionUsed getEncryptionType() {
        PdfFileReader objectReader = this.objectReader;
        DecryptionFactory decryption = objectReader.getDecryptionObject();
        if (decryption == null) {
            return EncryptionUsed.NO_ENCRYPTION;
        }
        if (decryption.hasPassword()) {
            return EncryptionUsed.PASSWORD;
        }
        return EncryptionUsed.CERTIFICATE;
    }
}

