/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.utils.LogWriter;

public class RandomAccessFCTest
implements RandomAccessBuffer {
    private long pointer;
    private int length;
    private FileChannel fc;
    private MappedByteBuffer mb;

    public RandomAccessFCTest(FileInputStream inFile) {
        try {
            this.length = inFile.available();
            this.fc = inFile.getChannel();
            this.mb = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.fc.size());
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.pointer;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (!this.checkPos(pos)) {
            throw new IOException("Position out of bounds");
        }
        this.pointer = pos;
    }

    @Override
    public void close() throws IOException {
        if (this.fc != null) {
            this.fc.close();
            this.fc = null;
        }
        if (this.mb != null) {
            this.mb = null;
        }
        this.pointer = -1L;
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        try {
            this.close();
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }

    @Override
    public long length() throws IOException {
        if (this.mb != null) {
            return this.length;
        }
        throw new IOException("Data buffer not initialized.");
    }

    @Override
    public int read() throws IOException {
        if (this.checkPos(this.pointer)) {
            this.mb.position((int)this.pointer);
            ++this.pointer;
            return this.mb.get();
        }
        return -1;
    }

    private int peek() throws IOException {
        if (this.checkPos(this.pointer)) {
            this.mb.position((int)this.pointer);
            return this.mb.get();
        }
        return -1;
    }

    @Override
    public String readLine() throws IOException {
        int c;
        if (this.pointer >= (long)(this.length - 1)) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        while ((c = this.read()) >= 0) {
            if (c == 10 || c == 13) {
                if (this.peek() != 10 && this.peek() != 13 || this.peek() == c) break;
                this.read();
                break;
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.mb == null) {
            throw new IOException("Data buffer not initialized.");
        }
        if (this.pointer < 0L || this.pointer >= (long)this.length) {
            return -1;
        }
        int length = this.length - (int)this.pointer;
        if (length > b.length) {
            length = b.length;
        }
        for (int i = 0; i < length; ++i) {
            this.mb.position((int)this.pointer);
            ++this.pointer;
            b[i] = this.mb.get();
        }
        return length;
    }

    private boolean checkPos(long pos) throws IOException {
        return pos >= 0L && pos < this.length();
    }

    @Override
    public byte[] getPdfBuffer() {
        byte[] bytes = new byte[this.length];
        this.mb.position(0);
        this.mb.get(bytes);
        return bytes;
    }
}

