/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class BaseFilter {
    final PdfObject decodeParms;
    BufferedInputStream bis;
    BufferedOutputStream streamCache;
    Map<String, String> cachedObjects;

    BaseFilter(PdfObject decodeParms) {
        this.decodeParms = decodeParms;
    }

    public boolean hasError() {
        return false;
    }

    void setupCachedObjectForDecoding(String cacheName) throws IOException {
        File tempFile2 = File.createTempFile("jpedal", ".raw", new File(ObjectStore.temp_dir));
        this.cachedObjects.put(tempFile2.getAbsolutePath(), "x");
        ObjectStore.copy(cacheName, tempFile2.getAbsolutePath());
        File rawFile = new File(cacheName);
        rawFile.delete();
        this.streamCache = new BufferedOutputStream(new FileOutputStream(cacheName));
        this.bis = new BufferedInputStream(new FileInputStream(tempFile2));
    }

    byte[] applyPredictor(int predictor, byte[] data, int colors, int bitsPerComponent, int columns) throws Exception {
        boolean isCached;
        if (predictor == 1) {
            return data;
        }
        boolean bl = isCached = data == null;
        if (isCached) {
            BaseFilter.applyPredictorFunction(predictor, this.bis, this.streamCache, colors, bitsPerComponent, columns);
            return null;
        }
        ByteArrayInputStream byis = new ByteArrayInputStream(data);
        BufferedInputStream bis = new BufferedInputStream(byis);
        int count = BaseFilter.applyPredictorFunction2(predictor, bis, null, colors, bitsPerComponent, columns);
        byis.close();
        bis.close();
        byte[] bos = new byte[count];
        byis = new ByteArrayInputStream(data);
        bis = new BufferedInputStream(byis);
        BaseFilter.applyPredictorFunction2(predictor, bis, bos, colors, bitsPerComponent, columns);
        byis.close();
        bis.close();
        return bos;
    }

    private static void applyPredictorFunction(int mainPred, BufferedInputStream bis, OutputStream bos, int colors, int bitsPerComponent, int columns) throws Exception {
        int bytesAvailable = bis.available();
        int bpp = (colors * bitsPerComponent + 7) / 8;
        int rowLength = (columns * colors * bitsPerComponent + 7) / 8 + bpp;
        byte[] thisLine = new byte[rowLength];
        byte[] lastLine = new byte[rowLength];
        try {
            int byteCount = 0;
            while (bytesAvailable > byteCount) {
                int curPred;
                int predictor = mainPred;
                int i = 0;
                int offset = bpp;
                if (predictor >= 10) {
                    curPred = bis.read();
                    if (curPred == -1) break;
                    curPred += 10;
                } else {
                    curPred = predictor;
                }
                while (offset < rowLength && (i = bis.read(thisLine, offset, rowLength - offset)) != -1) {
                    offset += i;
                    byteCount += i;
                }
                if (i == -1) break;
                switch (curPred) {
                    case 2: {
                        int raw;
                        int sub;
                        int i1;
                        for (i1 = bpp; i1 < rowLength; ++i1) {
                            sub = thisLine[i1] & 0xFF;
                            raw = thisLine[i1 - bpp] & 0xFF;
                            thisLine[i1] = (byte)(sub + raw & 0xFF);
                            bos.write(thisLine[i1]);
                        }
                        break;
                    }
                    case 10: {
                        int i1;
                        for (i1 = bpp; i1 < rowLength; ++i1) {
                            bos.write(thisLine[i1]);
                        }
                        break;
                    }
                    case 11: {
                        int raw;
                        int sub;
                        int i1;
                        for (i1 = bpp; i1 < rowLength; ++i1) {
                            sub = thisLine[i1] & 0xFF;
                            raw = thisLine[i1 - bpp] & 0xFF;
                            thisLine[i1] = (byte)(sub + raw);
                            bos.write(thisLine[i1]);
                        }
                        break;
                    }
                    case 12: {
                        int sub;
                        int i1;
                        for (i1 = bpp; i1 < rowLength; ++i1) {
                            sub = (lastLine[i1] & 0xFF) + (thisLine[i1] & 0xFF);
                            thisLine[i1] = (byte)sub;
                            bos.write(thisLine[i1]);
                        }
                        break;
                    }
                    case 13: {
                        int i1;
                        for (i1 = bpp; i1 < rowLength; ++i1) {
                            int av = thisLine[i1] & 0xFF;
                            int floor = (thisLine[i1 - bpp] & 0xFF) + (lastLine[i1] & 0xFF) >> 1;
                            thisLine[i1] = (byte)(av + floor);
                            bos.write(thisLine[i1]);
                        }
                        break;
                    }
                    case 14: {
                        int i1;
                        for (i1 = bpp; i1 < rowLength; ++i1) {
                            int a = thisLine[i1 - bpp] & 0xFF;
                            int b = lastLine[i1] & 0xFF;
                            int c = lastLine[i1 - bpp] & 0xFF;
                            int p = a + b - c;
                            int pa = p - a;
                            int pb = p - b;
                            int pc = p - c;
                            if (pa < 0) {
                                pa = -pa;
                            }
                            if (pb < 0) {
                                pb = -pb;
                            }
                            if (pc < 0) {
                                pc = -pc;
                            }
                            thisLine[i1] = pa <= pb && pa <= pc ? (byte)(thisLine[i1] + a) : (pb <= pc ? (byte)(thisLine[i1] + b) : (byte)(thisLine[i1] + c));
                            bos.write(thisLine[i1]);
                        }
                        break;
                    }
                }
                System.arraycopy(thisLine, 0, lastLine, 0, lastLine.length);
            }
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " accessing Predictor");
        }
    }

    private static int applyPredictorFunction2(int mainPred, BufferedInputStream bis, byte[] bos, int colors, int bitsPerComponent, int columns) throws Exception {
        int count = 0;
        int bytesAvailable = bis.available();
        int bpp = (colors * bitsPerComponent + 7) / 8;
        int rowLength = (columns * colors * bitsPerComponent + 7) / 8 + bpp;
        byte[] thisLine = new byte[rowLength];
        byte[] lastLine = new byte[rowLength];
        try {
            int byteCount = 0;
            while (bytesAvailable > byteCount) {
                int curPred;
                int predictor = mainPred;
                int i = 0;
                int offset = bpp;
                if (predictor >= 10) {
                    curPred = bis.read();
                    if (curPred == -1) break;
                    curPred += 10;
                } else {
                    curPred = predictor;
                }
                while (offset < rowLength && (i = bis.read(thisLine, offset, rowLength - offset)) != -1) {
                    offset += i;
                    byteCount += i;
                }
                if (i != -1) {
                    switch (curPred) {
                        case 2: {
                            int raw;
                            int sub;
                            int i1;
                            for (i1 = bpp; i1 < rowLength; ++i1) {
                                sub = thisLine[i1] & 0xFF;
                                raw = thisLine[i1 - bpp] & 0xFF;
                                thisLine[i1] = (byte)(sub + raw & 0xFF);
                                if (bos != null) {
                                    bos[count] = thisLine[i1];
                                }
                                ++count;
                            }
                            break;
                        }
                        case 10: {
                            int i1;
                            for (i1 = bpp; i1 < rowLength; ++i1) {
                                if (bos != null) {
                                    bos[count] = thisLine[i1];
                                }
                                ++count;
                            }
                            break;
                        }
                        case 11: {
                            int raw;
                            int sub;
                            int i1;
                            for (i1 = bpp; i1 < rowLength; ++i1) {
                                sub = thisLine[i1] & 0xFF;
                                raw = thisLine[i1 - bpp] & 0xFF;
                                thisLine[i1] = (byte)(sub + raw);
                                if (bos != null) {
                                    bos[count] = thisLine[i1];
                                }
                                ++count;
                            }
                            break;
                        }
                        case 12: {
                            int sub;
                            int i1;
                            for (i1 = bpp; i1 < rowLength; ++i1) {
                                sub = (lastLine[i1] & 0xFF) + (thisLine[i1] & 0xFF);
                                thisLine[i1] = (byte)sub;
                                if (bos != null) {
                                    bos[count] = thisLine[i1];
                                }
                                ++count;
                            }
                            break;
                        }
                        case 13: {
                            int i1;
                            for (i1 = bpp; i1 < rowLength; ++i1) {
                                int av = thisLine[i1] & 0xFF;
                                int floor = (thisLine[i1 - bpp] & 0xFF) + (lastLine[i1] & 0xFF) >> 1;
                                thisLine[i1] = (byte)(av + floor);
                                if (bos != null) {
                                    bos[count] = thisLine[i1];
                                }
                                ++count;
                            }
                            break;
                        }
                        case 14: {
                            int i1;
                            for (i1 = bpp; i1 < rowLength; ++i1) {
                                int a = thisLine[i1 - bpp] & 0xFF;
                                int b = lastLine[i1] & 0xFF;
                                int c = lastLine[i1 - bpp] & 0xFF;
                                int p = a + b - c;
                                int pa = p - a;
                                int pb = p - b;
                                int pc = p - c;
                                if (pa < 0) {
                                    pa = -pa;
                                }
                                if (pb < 0) {
                                    pb = -pb;
                                }
                                if (pc < 0) {
                                    pc = -pc;
                                }
                                thisLine[i1] = pa <= pb && pa <= pc ? (byte)(thisLine[i1] + a) : (pb <= pc ? (byte)(thisLine[i1] + b) : (byte)(thisLine[i1] + c));
                                if (bos != null) {
                                    bos[count] = thisLine[i1];
                                }
                                ++count;
                            }
                            break;
                        }
                    }
                    System.arraycopy(thisLine, 0, lastLine, 0, lastLine.length);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " accessing Predictor");
        }
        return count;
    }
}

