/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.ArrayUtils;
import org.jpedal.objects.raw.OCObject;
import org.jpedal.objects.raw.ObjectFactory;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class Array
extends ObjectDecoder {
    private float[] floatValues;
    private int[] intValues;
    private double[] doubleValues;
    private byte[][] mixedValues;
    private byte[][] keyValues;
    private byte[][] stringValues;
    private boolean[] booleanValues;
    private Object[] objectValues;
    private String ref;
    private int i;
    private final int endPoint;
    private final int type;
    private int keyReached = -1;
    private Object[] objectValuesArray;

    public Array(PdfFileReader pdfFileReader, int i, int endPoint, int type) {
        super(pdfFileReader);
        this.i = i;
        this.endPoint = endPoint;
        this.type = type;
    }

    public Array(PdfFileReader pdfFileReader, int i, int endPoint, int type, Object[] objectValuesArray, int keyReached) {
        super(pdfFileReader);
        this.i = i;
        this.endPoint = endPoint;
        this.type = type;
        this.objectValuesArray = objectValuesArray;
        this.keyReached = keyReached;
    }

    public int readArray(boolean ignoreRecursion, byte[] raw, PdfObject pdfObject, int PDFkeyInt) {
        boolean isIndirect;
        boolean alwaysRead;
        this.ref = pdfObject.getObjectRefAsString();
        if ((this.type != 14 || raw[this.i] != 60) && raw[this.i] != 91 && raw[this.i] != 60) {
            ++this.i;
        }
        if (raw[this.i] == 91 && raw[this.i + 1] == 93) {
            return this.i + 1;
        }
        HashMap<Integer, String> isRef = new HashMap<Integer, String>();
        boolean bl = alwaysRead = PDFkeyInt == 456733763 || PDFkeyInt == 1044338049;
        if (debugFastCode) {
            System.out.println(padding + "Reading array type=" + PdfDictionary.showArrayType(this.type) + " into " + pdfObject + ' ' + (char)raw[this.i] + ' ' + (char)raw[this.i + 1] + ' ' + (char)raw[this.i + 2] + ' ' + (char)raw[this.i + 3] + ' ' + (char)raw[this.i + 4]);
        }
        boolean currentElement = false;
        int elementCount = 0;
        while (raw[this.i] == 10 || raw[this.i] == 13 || raw[this.i] == 32) {
            ++this.i;
        }
        if (raw[this.i] == 37) {
            this.i = ArrayUtils.skipComment(raw, this.i);
        }
        int keyStart = this.i;
        int j2 = this.i;
        byte[] arrayData = raw;
        boolean bl2 = isIndirect = raw[this.i] != 91 && raw[this.i] != 40 && PDFkeyInt != 489767739 && PDFkeyInt != 9250 && raw[0] != 0;
        if (raw[this.i] == 110 && raw[this.i + 1] == 117 && raw[this.i + 2] == 108) {
            isIndirect = false;
            elementCount = 1;
        }
        if (isIndirect) {
            isIndirect = ArrayUtils.handleIndirect(this.endPoint, raw, this.i);
        }
        if (debugFastCode && isIndirect) {
            System.out.println(padding + "Indirect ref");
        }
        boolean isSingleKey = false;
        boolean isSingleDirectValue = false;
        boolean isSingleNull = true;
        int endPtr = -1;
        if ((raw[this.i] == 47 || raw[this.i] == 40 || raw[this.i] == 60 || raw[this.i] == 60 && raw[this.i + 1] == 102 && raw[this.i + 2] == 101 && raw[this.i + 3] == 102 && raw[this.i + 4] == 102) && this.type != 20 && PDFkeyInt != 9250) {
            elementCount = 1;
            isSingleKey = true;
            if (debugFastCode) {
                System.out.println(padding + "Direct single value with /");
            }
        } else {
            int endI = -1;
            if (isIndirect) {
                if (debugFastCode) {
                    System.out.println(padding + "------reading data----");
                }
                int startI = this.i;
                if (debugFastCode) {
                    System.out.print(padding + "Indirect object ref=");
                }
                this.i = ArrayUtils.skipToEndOfRef(this.i, raw);
                int ref = NumberUtils.parseInt(keyStart, this.i, raw);
                while (raw[this.i] == 10 || raw[this.i] == 13 || raw[this.i] == 32 || raw[this.i] == 47 || raw[this.i] == 60) {
                    ++this.i;
                }
                keyStart = this.i;
                this.i = ArrayUtils.skipToEndOfRef(this.i, raw);
                int generation = NumberUtils.parseInt(keyStart, this.i, raw);
                if (debugFastCode) {
                    System.out.print(padding + " ref=" + ref + " generation=" + generation + '\n');
                }
                while (raw[this.i] == 10 || raw[this.i] == 13 || raw[this.i] == 32 || raw[this.i] == 47 || raw[this.i] == 60) {
                    ++this.i;
                }
                if (raw[this.i] != 82) {
                    throw new RuntimeException(padding + "4. Unexpected value " + (char)raw[this.i] + " in file - please send to IDRsolutions for analysis");
                }
                if (ignoreRecursion && !alwaysRead) {
                    if (debugFastCode) {
                        System.out.println(padding + "Ignore sublevels");
                    }
                    return this.i;
                }
                arrayData = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(ref, generation), ref, generation);
                if (arrayData == null) {
                    pdfObject.setFullyResolved(false);
                    LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (14)");
                    return raw.length;
                }
                j2 = 0;
                while (arrayData[j2] != 91) {
                    if (arrayData[j2] == 37) {
                        j2 = ArrayUtils.skipComment(arrayData, j2);
                        --j2;
                    }
                    if (arrayData[j2] == 110 && arrayData[j2 + 1] == 117 && arrayData[j2 + 2] == 108 && arrayData[j2 + 3] == 108 || arrayData[j2] == 101 && arrayData[j2 + 1] == 110 && arrayData[j2 + 2] == 100 && arrayData[j2 + 3] == 111) break;
                    if (arrayData[j2] == 47) {
                        --j2;
                        isSingleDirectValue = true;
                        break;
                    }
                    if (arrayData[j2] == 60 && arrayData[j2 + 1] == 60 || j2 + 4 < arrayData.length && arrayData[j2 + 3] == 60 && arrayData[j2 + 4] == 60) {
                        endI = this.i;
                        j2 = startI;
                        arrayData = raw;
                        if (!debugFastCode) break;
                        System.out.println(padding + "Single value, not indirect");
                        break;
                    }
                    ++j2;
                }
            }
            if (j2 < 0) {
                j2 = 0;
            }
            boolean startFound = false;
            while (arrayData[j2] == 10 || arrayData[j2] == 13 || arrayData[j2] == 32 || arrayData[j2] == 91 && !startFound) {
                if (arrayData[j2] == 91) {
                    startFound = true;
                }
                ++j2;
            }
            endPtr = j2;
            boolean lastCharIsSpace = true;
            int arrayEnd = arrayData.length;
            if (debugFastCode) {
                System.out.println(padding + "----counting elements----arrayData[endPtr]=" + arrayData[endPtr] + " type=" + this.type);
            }
            while (endPtr < arrayEnd && arrayData[endPtr] != 93 && (arrayData[j2] != 101 || arrayData[j2 + 1] != 110 || arrayData[j2 + 2] != 100 || arrayData[j2 + 3] != 111)) {
                boolean isRecursive = false;
                while (arrayData[endPtr] == 60 && arrayData[endPtr + 1] == 60) {
                    int levels = 1;
                    ++elementCount;
                    if (debugFastCode) {
                        System.out.println(padding + "Direct value elementCount=" + elementCount);
                    }
                    while (levels > 0) {
                        if (arrayData[++endPtr] == 60 && arrayData[endPtr + 1] == 60) {
                            ++endPtr;
                            ++levels;
                            continue;
                        }
                        if (arrayData[endPtr] != 62 || arrayData[endPtr - 1] != 62) continue;
                        ++endPtr;
                        --levels;
                    }
                    if (this.type != 14) continue;
                    --endPtr;
                }
                if (this.type != 18 && arrayData[endPtr] == 110 && arrayData[endPtr + 1] == 117 && arrayData[endPtr + 2] == 108 && arrayData[endPtr + 3] == 108) {
                    int nextChar = 93;
                    if (PDFkeyInt == 826881374 || PDFkeyInt == 1110717793) {
                        for (int aa = endPtr + 3; aa < arrayData.length; ++aa) {
                            if (arrayData[aa] == 10 || arrayData[aa] == 13 || arrayData[aa] == 32 || arrayData[aa] == 9) continue;
                            nextChar = arrayData[aa];
                            aa = arrayData.length;
                        }
                    }
                    if (nextChar == 93) {
                        isSingleNull = true;
                        elementCount = 1;
                        break;
                    }
                    isSingleNull = false;
                    endPtr += 4;
                    lastCharIsSpace = true;
                    if (!debugFastCode) continue;
                    System.out.println("ignore null");
                    continue;
                }
                if (isSingleDirectValue && (arrayData[endPtr] == 32 || arrayData[endPtr] == 13 || arrayData[endPtr] == 10) || endI != -1 && endPtr > endI) break;
                if (this.type == 14) {
                    if (arrayData[endPtr] == 82 || (PDFkeyInt == 9250 || PDFkeyInt == 1248888446) && arrayData[endPtr] == 47) {
                        ++elementCount;
                    }
                } else {
                    switch (arrayData[endPtr]) {
                        case 40: {
                            ++elementCount;
                            if (debugFastCode) {
                                System.out.println(padding + "string");
                            }
                            while (arrayData[endPtr] != 41 || ObjectUtils.isEscaped(arrayData, endPtr)) {
                                ++endPtr;
                                lastCharIsSpace = true;
                            }
                            break;
                        }
                        case 60: {
                            ++elementCount;
                            if (debugFastCode) {
                                System.out.println(padding + "direct");
                            }
                            while (arrayData[endPtr] != 62) {
                                ++endPtr;
                                lastCharIsSpace = true;
                            }
                            break;
                        }
                        case 91: {
                            ++elementCount;
                            if (debugFastCode) {
                                System.out.println(padding + "recursion");
                            }
                            endPtr = Array.skipThroughRecursiveLevels(arrayData, endPtr);
                            isRecursive = true;
                            lastCharIsSpace = true;
                            break;
                        }
                        default: {
                            boolean charIsSpace = arrayData[endPtr] == 10 || arrayData[endPtr] == 13 || arrayData[endPtr] == 32 || arrayData[endPtr] == 47;
                            elementCount = this.handleSpace(isRef, elementCount, arrayData, endPtr, charIsSpace, lastCharIsSpace);
                            lastCharIsSpace = charIsSpace;
                        }
                    }
                }
                if (!isRecursive && endPtr < arrayEnd && arrayData[endPtr] == 93 && this.type != 14) {
                    int ptr = endPtr - 1;
                    while (arrayData[ptr] == 13 || arrayData[ptr] == 10 || arrayData[ptr] == 32) {
                        --ptr;
                    }
                    if (arrayData[ptr] != 91) break;
                    elementCount = 0;
                    break;
                }
                ++endPtr;
            }
            if (debugFastCode) {
                System.out.println(padding + "Number of elements=" + elementCount + " rawCount=");
            }
            if (elementCount == 0 && debugFastCode) {
                System.out.println(padding + "zero elements found!!!!!!");
            }
        }
        if (ignoreRecursion && !alwaysRead) {
            return endPtr;
        }
        this.initObjectArray(elementCount);
        this.setValues(ignoreRecursion, raw, pdfObject, PDFkeyInt, isRef, 0, elementCount, j2, arrayData, isIndirect, isSingleKey, isSingleNull, endPtr);
        if (debugFastCode) {
            this.showValues();
        }
        if (this.i < raw.length && (raw[this.i] == 47 || raw[this.i] == 62 || raw[this.i] >= 48 && raw[this.i] <= 57)) {
            --this.i;
        }
        return this.i;
    }

    static int skipThroughRecursiveLevels(byte[] arrayData, int endPtr) {
        int level = 1;
        while (++endPtr != arrayData.length) {
            if (arrayData[endPtr] == 93) {
                --level;
            } else if (arrayData[endPtr] == 91) {
                ++level;
            }
            if (level != 0) continue;
            break;
        }
        return endPtr;
    }

    private int handleSpace(Map<Integer, String> isRef, int elementCount, byte[] arrayData, int endPtr, boolean charIsSpace, boolean lastCharIsSpace) {
        if (lastCharIsSpace && !charIsSpace) {
            if ((this.type == 18 || this.type == 22) && arrayData[endPtr] == 82 && arrayData[endPtr - 1] != 47) {
                isRef.put(--elementCount - 1, "x");
                if (debugFastCode) {
                    System.out.println(padding + "aref " + (char)arrayData[endPtr]);
                }
            } else {
                ++elementCount;
            }
        }
        return elementCount;
    }

    private void setValues(boolean ignoreRecursion, byte[] raw, PdfObject pdfObject, int PDFkeyInt, Map<Integer, String> isRef, int currentElement, int elementCount, int j2, byte[] arrayData, boolean isIndirect, boolean isSingleKey, boolean isSingleNull, int endPtr) {
        if (arrayData[j2] == 110 && arrayData[j2 + 1] == 117 && arrayData[j2 + 2] == 108 && arrayData[j2 + 3] == 108 && isSingleNull && (this.type != 22 || elementCount == 1)) {
            j2 += 3;
            switch (this.type) {
                case 18: {
                    this.mixedValues[currentElement] = null;
                    break;
                }
                case 14: {
                    this.keyValues[currentElement] = null;
                    break;
                }
                case 20: {
                    this.stringValues[currentElement] = null;
                    break;
                }
                case 22: {
                    this.objectValues[currentElement] = null;
                }
            }
        } else {
            j2 = this.setValue(ignoreRecursion, raw, pdfObject, PDFkeyInt, isRef, currentElement, elementCount, j2, arrayData, isSingleKey, endPtr);
        }
        if (!isIndirect) {
            this.i = j2;
        }
        switch (this.type) {
            case 10: {
                pdfObject.setFloatArray(PDFkeyInt, this.floatValues);
                break;
            }
            case 9: {
                pdfObject.setIntArray(PDFkeyInt, this.intValues);
                break;
            }
            case 12: {
                pdfObject.setBooleanArray(PDFkeyInt, this.booleanValues);
                break;
            }
            case 16: {
                pdfObject.setDoubleArray(PDFkeyInt, this.doubleValues);
                break;
            }
            case 18: {
                pdfObject.setMixedArray(PDFkeyInt, this.mixedValues);
                break;
            }
            case 14: {
                this.setKeyArrayValue(pdfObject, PDFkeyInt, elementCount);
                break;
            }
            case 20: {
                pdfObject.setStringArray(PDFkeyInt, this.stringValues);
                break;
            }
            case 22: {
                this.setObjectArrayValue(pdfObject, PDFkeyInt, this.objectValuesArray, this.keyReached);
            }
        }
    }

    private int setValue(boolean ignoreRecursion, byte[] raw, PdfObject pdfObject, int PDFkeyInt, Map<Integer, String> ref, int currentElement, int elementCount, int j2, byte[] arrayData, boolean singleKey, int endPtr) {
        while (arrayData[j2] != 93) {
            boolean hexString = false;
            if (endPtr > -1 && j2 >= endPtr) break;
            while (arrayData[j2] == 10 || arrayData[j2] == 13 || arrayData[j2] == 32 || arrayData[j2] == 47) {
                ++j2;
            }
            if (arrayData[j2] == 37) {
                while (j2 < arrayData.length && arrayData[++j2] != 10) {
                }
                while (arrayData[j2] == 10 || arrayData[j2] == 13 || arrayData[j2] == 32 || arrayData[j2] == 47) {
                    ++j2;
                }
            }
            int keyStart = j2;
            if (debugFastCode) {
                System.out.print("j2=" + j2 + " value=" + (char)arrayData[j2]);
            }
            boolean isKey = arrayData[j2 - 1] == 47;
            boolean isRecursiveValue = false;
            if (this.type == 14 || (this.type == 18 || this.type == 22) && (ref.containsKey(currentElement) || PDFkeyInt == 1110717793 && arrayData[j2] >= 48 && arrayData[j2] <= 57 || arrayData[j2] == 60 && arrayData[j2 + 1] == 60)) {
                if (debugFastCode) {
                    System.out.println("ref currentElement=" + currentElement);
                }
                while (arrayData[j2] != 82 && arrayData[j2] != 93) {
                    if (arrayData[j2] == 60 && arrayData[j2 + 1] == 60) {
                        int levels = 1;
                        if (debugFastCode) {
                            System.out.println(padding + "Reading Direct value");
                        }
                        while (levels > 0) {
                            if (arrayData[++j2] == 60 && arrayData[j2 + 1] == 60) {
                                ++j2;
                                ++levels;
                                continue;
                            }
                            if (arrayData[j2] != 62 || arrayData[j2 + 1] != 62) continue;
                            ++j2;
                            --levels;
                        }
                        break;
                    }
                    if (isKey && PDFkeyInt == 9250 && arrayData[j2 + 1] == 32) break;
                    ++j2;
                }
                ++j2;
            } else if (arrayData[j2] == 40) {
                keyStart = j2 + 1;
                while (arrayData[j2] != 41 || ObjectUtils.isEscaped(arrayData, j2)) {
                    ++j2;
                }
                hexString = false;
            } else if (arrayData[j2] == 91 && this.type == 18 && PDFkeyInt == 826094945) {
                keyStart = j2;
                while (arrayData[j2] != 93) {
                    ++j2;
                }
                ++j2;
            } else if (arrayData[j2] == 60) {
                hexString = true;
                keyStart = j2 + 1;
                while (arrayData[j2] != 62) {
                    if (arrayData[j2] == 47) {
                        hexString = false;
                    }
                    ++j2;
                }
            } else if (arrayData[j2] == 91 && this.type == 22) {
                int len;
                int j3 = j2 + 1;
                int level = 1;
                while (++j3 != arrayData.length) {
                    if (arrayData[j3] == 93) {
                        --level;
                    } else if (arrayData[j3] == 91) {
                        ++level;
                    }
                    if (level != 0) continue;
                }
                ++j3;
                if (debugFastCode) {
                    padding = padding + "   ";
                }
                Array objDecoder = new Array(this.objectReader, j2, j3, this.type, this.objectValues, currentElement);
                j2 = objDecoder.readArray(ignoreRecursion, arrayData, pdfObject, PDFkeyInt);
                if (debugFastCode && (len = padding.length()) > 3) {
                    padding = padding.substring(0, len - 3);
                }
                if (arrayData[j2] != 91) {
                    ++j2;
                }
                isRecursiveValue = true;
                while (j2 < arrayData.length && arrayData[j2] == 93) {
                    ++j2;
                }
            } else if (!isKey && elementCount - currentElement == 1 && this.type == 18) {
                while (arrayData[j2] != 93 && arrayData[j2] != 47 && (arrayData[j2] != 62 || arrayData[j2 + 1] != 62)) {
                    ++j2;
                }
            } else {
                if (this.type == 22 && arrayData[j2] == 110 && arrayData[j2 + 1] == 117 && arrayData[j2 + 2] == 108 && arrayData[j2 + 3] == 108) {
                    j2 += 4;
                    this.objectValues[currentElement] = null;
                    ++currentElement;
                    continue;
                }
                while (arrayData[j2] != 10 && arrayData[j2] != 13 && arrayData[j2] != 32 && arrayData[j2] != 93 && arrayData[j2] != 47 && (arrayData[j2] != 62 || arrayData[j2 + 1] != 62) && ++j2 != arrayData.length) {
                }
            }
            if (this.type == 10) {
                this.floatValues[currentElement] = NumberUtils.parseFloat(keyStart, j2, arrayData);
            } else if (this.type == 9) {
                this.intValues[currentElement] = NumberUtils.parseInt(keyStart, j2, arrayData);
            } else if (this.type == 12) {
                if (raw[keyStart] == 116 && raw[keyStart + 1] == 114 && raw[keyStart + 2] == 117 && raw[keyStart + 3] == 101) {
                    this.booleanValues[currentElement] = true;
                }
            } else if (this.type == 16) {
                this.doubleValues[currentElement] = NumberUtils.parseFloat(keyStart, j2, arrayData);
            } else if (!isRecursiveValue) {
                j2 = this.setObjectArrayValue(pdfObject, PDFkeyInt, hexString, currentElement, elementCount, j2, arrayData, singleKey, keyStart);
            }
            ++currentElement;
            if (debugFastCode) {
                System.out.println(padding + "roll onto ==================================>" + currentElement + '/' + elementCount);
            }
            if (currentElement != elementCount) continue;
            break;
        }
        return j2;
    }

    private int setObjectArrayValue(PdfObject pdfObject, int PDFkeyInt, boolean hexString, int currentElement, int elementCount, int j2, byte[] arrayData, boolean singleKey, int keyStart) {
        byte[] newValues;
        boolean isID;
        boolean bl = isID = PDFkeyInt == 6420;
        if (keyStart > 0 && arrayData[keyStart - 1] == 47) {
            --keyStart;
        }
        if (keyStart > 0 && arrayData[keyStart] == 91 && PDFkeyInt != 826094945 && PDFkeyInt != 6420) {
            ++keyStart;
        }
        if (PDFkeyInt == 1110717793 || PDFkeyInt == 826881374) {
            while (arrayData[keyStart] == 110 && arrayData[keyStart + 1] == 117 && arrayData[keyStart + 2] == 108 && arrayData[keyStart + 3] == 108) {
                keyStart += 4;
                while (keyStart >= 0 && (arrayData[keyStart] == 32 || arrayData[keyStart] == 10 || arrayData[keyStart] == 13 || arrayData[keyStart] == 9)) {
                    ++keyStart;
                }
            }
        }
        while (keyStart >= 0 && (arrayData[keyStart] == 10 || arrayData[keyStart] == 13 || arrayData[keyStart] == 9)) {
            ++keyStart;
        }
        if (this.decryption != null && !isID && !pdfObject.isInCompressedStream() && pdfObject.getObjectType() == 540096309 && arrayData[j2] == 60 && arrayData[j2 + 1] == 60) {
            newValues = ObjectUtils.readRawValue(j2, arrayData, keyStart);
            if (newValues[0] == 60 && newValues[1] == 60) {
                newValues = Array.appendObjectRef(pdfObject, newValues);
            }
        } else {
            newValues = ObjectUtils.readEscapedValue(j2, arrayData, keyStart, isID);
        }
        if (debugFastCode) {
            System.out.println(padding + "<1.Element -----" + currentElement + '/' + elementCount + "( j2=" + j2 + " ) value=" + new String(newValues) + '<');
        }
        if (j2 != arrayData.length) {
            if (arrayData[j2] == 62) {
                ++j2;
            } else if (arrayData[j2] == 41) {
                ++j2;
                try {
                    if (!isID && !pdfObject.isInCompressedStream() && this.decryption != null) {
                        newValues = this.decryption.decrypt(newValues, pdfObject.getObjectRefAsString(), false, null, false, false);
                    }
                }
                catch (PdfSecurityException e) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
                if (PDFkeyInt == 1110717793) {
                    newValues = StringUtils.toBytes(StringUtils.getTextString(newValues, false));
                }
            }
        }
        if (singleKey) {
            this.i = j2;
        }
        switch (this.type) {
            case 18: {
                if (hexString) {
                    this.mixedValues[currentElement] = ArrayUtils.handleHexString(newValues, this.decryption, this.ref);
                    break;
                }
                this.mixedValues[currentElement] = newValues;
                break;
            }
            case 14: {
                this.keyValues[currentElement] = ObjectUtils.convertReturnsToSpaces(newValues);
                break;
            }
            case 20: {
                if (hexString) {
                    this.stringValues[currentElement] = ArrayUtils.handleHexString(newValues, this.decryption, this.ref);
                    break;
                }
                this.stringValues[currentElement] = newValues;
                break;
            }
            case 22: {
                this.objectValues[currentElement] = hexString ? (Object)ArrayUtils.handleHexString(newValues, this.decryption, this.ref) : (Object)newValues;
                if (!debugFastCode) break;
                System.out.println(padding + "objectValues[" + currentElement + "]=" + Arrays.toString(this.objectValues) + ' ');
                break;
            }
        }
        return j2;
    }

    private static byte[] appendObjectRef(PdfObject pdfObject, byte[] newValues) {
        String s = pdfObject.getObjectRefAsString();
        int len = newValues.length;
        int strLen = s.length() - 1;
        int newLength = strLen + 4 + newValues.length;
        byte[] adjustedArray = new byte[newLength];
        System.arraycopy(s.getBytes(), 0, adjustedArray, 0, strLen);
        System.arraycopy("obj ".getBytes(), 0, adjustedArray, strLen, 4);
        System.arraycopy(newValues, 0, adjustedArray, strLen + 4, len);
        newValues = adjustedArray;
        return newValues;
    }

    private void initObjectArray(int elementCount) {
        switch (this.type) {
            case 10: {
                this.floatValues = new float[elementCount];
                break;
            }
            case 9: {
                this.intValues = new int[elementCount];
                break;
            }
            case 12: {
                this.booleanValues = new boolean[elementCount];
                break;
            }
            case 16: {
                this.doubleValues = new double[elementCount];
                break;
            }
            case 18: {
                this.mixedValues = new byte[elementCount][];
                break;
            }
            case 14: {
                this.keyValues = new byte[elementCount][];
                break;
            }
            case 20: {
                this.stringValues = new byte[elementCount][];
                break;
            }
            case 22: {
                this.objectValues = new Object[elementCount];
            }
        }
    }

    private void setKeyArrayValue(PdfObject pdfObject, int PDFkeyInt, int elementCount) {
        if (this.type == 14 && elementCount == 1 && PDFkeyInt == 1044338049) {
            PdfObject obj;
            byte[] newData;
            int size;
            byte[] objData = this.keyValues[0];
            if (objData != null && objData[(size = objData.length) - 1] == 82 && (newData = this.objectReader.readObjectData(obj = new PdfObject(new String(objData)))) != null) {
                int jj = 0;
                int newLen = newData.length;
                boolean hasArray = false;
                while (jj < newLen && ++jj != newData.length) {
                    if (newData[jj] == 91) {
                        hasArray = true;
                        break;
                    }
                    if (newData[jj - 1] != 60 || newData[jj] != 60) continue;
                    hasArray = false;
                    break;
                }
                if (hasArray) {
                    Array objDecoder = new Array(this.objectReader, jj, newLen, 14);
                    objDecoder.readArray(false, newData, pdfObject, PDFkeyInt);
                } else {
                    pdfObject.setKeyArray(PDFkeyInt, this.keyValues);
                }
            }
        } else {
            pdfObject.setKeyArray(PDFkeyInt, this.keyValues);
        }
    }

    private void setObjectArrayValue(PdfObject pdfObject, int PDFkeyInt, Object[] objectValuesArray, int keyReached) {
        int size;
        byte[] objData;
        if (PDFkeyInt == 1110717793 && this.objectValues != null && this.objectValues.length == 1 && this.objectValues[0] instanceof byte[] && (objData = (byte[])this.objectValues[0])[(size = objData.length) - 1] == 82) {
            OCObject obj = new OCObject(new String(objData));
            byte[] newData = this.objectReader.readObjectData(obj);
            int jj = 0;
            int newLen = newData.length;
            boolean hasArray = false;
            while (jj < newLen && ++jj != newData.length) {
                if (newData[jj] != 91) continue;
                hasArray = true;
                break;
            }
            if (hasArray) {
                Array objDecoder = new Array(this.objectReader, jj, newLen, 22);
                objDecoder.readArray(false, newData, pdfObject, PDFkeyInt);
            }
            this.objectValues = null;
        }
        if (objectValuesArray != null) {
            objectValuesArray[keyReached] = this.objectValues;
            if (debugFastCode) {
                System.out.println(padding + "set Object objectValuesArray[" + keyReached + "]=" + Arrays.toString(this.objectValues));
            }
        } else if (this.objectValues != null) {
            pdfObject.setObjectArray(PDFkeyInt, this.objectValues);
            if (debugFastCode) {
                System.out.println(padding + PDFkeyInt + " set Object value=" + Arrays.toString(this.objectValues));
            }
        }
    }

    private void showValues() {
        StringBuilder values = new StringBuilder("[");
        switch (this.type) {
            case 10: {
                for (float floatValue : this.floatValues) {
                    values.append(floatValue).append(' ');
                }
                break;
            }
            case 16: {
                for (double doubleValue : this.doubleValues) {
                    values.append(doubleValue).append(' ');
                }
                break;
            }
            case 9: {
                for (int intValue : this.intValues) {
                    values.append(intValue).append(' ');
                }
                break;
            }
            case 12: {
                for (boolean booleanValue : this.booleanValues) {
                    values.append(booleanValue).append(' ');
                }
                break;
            }
            case 18: {
                for (byte[] mixedValue : this.mixedValues) {
                    if (mixedValue == null) {
                        values.append("null ");
                        continue;
                    }
                    values.append(new String(mixedValue)).append(' ');
                }
                break;
            }
            case 14: {
                for (byte[] keyValue : this.keyValues) {
                    if (keyValue == null) {
                        values.append("null ");
                        continue;
                    }
                    values.append(new String(keyValue)).append(' ');
                }
                break;
            }
            case 20: {
                for (byte[] stringValue : this.stringValues) {
                    if (stringValue == null) {
                        values.append("null ");
                        continue;
                    }
                    values.append(new String(stringValue)).append(' ');
                }
                break;
            }
            case 22: {
                values.append(ObjectUtils.showMixedValuesAsString(this.objectValues, ""));
            }
        }
        values.append(" ]");
        System.out.println(padding + "values=" + values);
    }

    public static int processArray(PdfObject pdfObject, byte[] raw, int PDFkeyInt, int possibleArrayStart, PdfFileReader objectReader) {
        int endPoint;
        for (endPoint = possibleArrayStart; raw[endPoint] != 93 && endPoint <= raw.length; ++endPoint) {
        }
        PdfObject valueObj = ObjectFactory.createObject(PDFkeyInt, null, pdfObject.getObjectType(), pdfObject.getID());
        valueObj.setID(PDFkeyInt);
        pdfObject.setDictionary(PDFkeyInt, valueObj);
        valueObj.ignoreRecursion(pdfObject.ignoreRecursion());
        if (valueObj.isDataExternal()) {
            valueObj.isDataExternal(true);
            if (!Array.resolveFully(valueObj, objectReader)) {
                pdfObject.setFullyResolved(false);
            }
        }
        int type = 9;
        if (PDFkeyInt == 9250) {
            type = 14;
        }
        Array objDecoder = new Array(objectReader, possibleArrayStart, endPoint, type);
        int i = objDecoder.readArray(pdfObject.ignoreRecursion(), raw, valueObj, PDFkeyInt);
        return i;
    }
}

