/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.Array;
import org.jpedal.io.types.ArrayUtils;
import org.jpedal.io.types.ColorObjectDecoder;
import org.jpedal.io.types.DirectDictionaryToObject;
import org.jpedal.io.types.TextStream;
import org.jpedal.objects.raw.ColorSpaceObject;
import org.jpedal.objects.raw.NamesObject;
import org.jpedal.objects.raw.ObjectFactory;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class Dictionary {
    public static int readDictionary(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, boolean ignoreRecursion, PdfFileReader objectReader, boolean isInlineImage) {
        String objectRef = pdfObject.getObjectRefAsString();
        if (raw[i] != 60) {
            ++i;
        }
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32) {
            ++i;
        }
        if (raw[i] == 47) {
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "Indirect");
            }
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            int keyStart = i;
            int keyLength = 0;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
                ++keyLength;
            }
            --i;
            if (!ignoreRecursion) {
                PdfObject valueObj = ObjectFactory.createObject(PDFkeyInt, objectRef, pdfObject.getObjectType(), pdfObject.getID());
                valueObj.setID(PDFkeyInt);
                int constant = valueObj.setConstant(PDFkeyInt, keyStart, keyLength, raw);
                if (constant == -1 || isInlineImage) {
                    byte[] newStr = new byte[keyLength];
                    System.arraycopy(raw, keyStart, newStr, 0, keyLength);
                    String s = new String(newStr);
                    valueObj.setGeneralStringValue(s);
                    if (ObjectDecoder.debugFastCode) {
                        System.out.println(ObjectDecoder.padding + "Set Dictionary as String=" + s + "  in " + pdfObject + " to " + valueObj);
                    }
                } else if (ObjectDecoder.debugFastCode) {
                    System.out.println(ObjectDecoder.padding + "Set Dictionary as constant=" + constant + "  in " + pdfObject + " to " + valueObj);
                }
                pdfObject.setDictionary(PDFkeyInt, valueObj);
                if (pdfObject.isDataExternal()) {
                    valueObj.isDataExternal(true);
                    if (!ObjectDecoder.resolveFully(valueObj, objectReader)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
            }
        } else if (raw[i] == 101 && raw[i + 1] == 110 && raw[i + 2] == 100 && raw[i + 3] == 111 && raw[i + 4] == 98) {
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "Empty object" + new String(raw) + "<<");
            }
        } else if (raw[i] == 40 && PDFkeyInt == 6691) {
            int start = ++i;
            while (i < raw.length && (raw[++i] != 41 || ObjectUtils.isEscaped(raw, i))) {
            }
            byte[] data = ObjectUtils.readEscapedValue(i, raw, start, false);
            NamesObject JS = new NamesObject(objectRef);
            JS.setDecodedStream(data);
            pdfObject.setDictionary(6691, JS);
        } else {
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "1.About to read ref orDirect i=" + i + " char=" + (char)raw[i] + " ignoreRecursion=" + ignoreRecursion);
            }
            if (ignoreRecursion) {
                while (raw[i] == 91 || raw[i] == 32 || raw[i] == 13 || raw[i] == 10) {
                    ++i;
                }
                if (raw[i] == 60 && raw[i + 1] == 60) {
                    i += 2;
                    int reflevel = 1;
                    while (reflevel > 0) {
                        if (raw[i] == 60 && raw[i + 1] == 60) {
                            i += 2;
                            ++reflevel;
                            continue;
                        }
                        if (raw[i] == 62 && raw[i + 1] == 62) {
                            i += 2;
                            --reflevel;
                            continue;
                        }
                        ++i;
                    }
                    --i;
                } else {
                    i = Dictionary.readDictionaryFromRefOrDirect(PDFkeyInt, pdfObject, objectRef, i, raw, PDFkeyInt, objectReader);
                }
                if (i < raw.length && raw[i] == 47) {
                    --i;
                }
            } else {
                i = Dictionary.readDictionaryFromRefOrDirect(PDFkeyInt, pdfObject, objectRef, i, raw, PDFkeyInt, objectReader);
            }
        }
        return i;
    }

    public static int getPairedValues(PdfObject pdfObject, int i, byte[] raw, int pdfKeyType, int length, int keyLength, int keyStart) {
        boolean isPair = false;
        int jj = i;
        while (jj < length) {
            while (jj < length && (raw[jj] == 32 || raw[jj] == 13 || raw[jj] == 10)) {
                ++jj;
            }
            if (jj < length && raw[jj] >= 48 && raw[jj] <= 57) {
                while (jj < length && raw[jj] >= 48 && raw[jj] <= 57) {
                    ++jj;
                }
                while (jj < length && (raw[jj] == 32 || raw[jj] == 10 || raw[jj] == 13)) {
                    ++jj;
                }
                while (jj < length && (raw[jj] >= 48 && raw[jj] <= 57 || raw[jj] == 32 || raw[jj] == 10 || raw[jj] == 13)) {
                    ++jj;
                }
                if (jj >= length || raw[jj] != 82) break;
                ++jj;
            }
            while (jj < length && (raw[jj] == 32 || raw[jj] == 13 || raw[jj] == 10)) {
                ++jj;
            }
            if (raw[jj] == 62 && raw[jj + 1] == 62) {
                isPair = true;
                break;
            }
            if (raw[jj] != 47) break;
            ++jj;
            while (jj < length && raw[jj] != 32 && raw[jj] != 13 && raw[jj] != 10) {
                ++jj;
            }
        }
        if (isPair) {
            pdfObject.setCurrentKey(PdfDictionary.getKey(keyStart, keyLength, raw));
            return 5;
        }
        return pdfKeyType;
    }

    public static boolean isStringPair(int i, byte[] raw, boolean stringPair) {
        int len = raw.length;
        for (int aa = i; aa < len; ++aa) {
            if (raw[aa] == 40) {
                aa = len;
                stringPair = true;
                continue;
            }
            if (raw[aa] == 47 || raw[aa] == 62 || raw[aa] == 60 || raw[aa] == 91 || raw[aa] == 82) {
                aa = len;
                continue;
            }
            if (raw[aa] != 77 || raw[aa + 1] != 67 || raw[aa + 2] != 73 || raw[aa + 3] != 68) continue;
            aa = len;
        }
        return stringPair;
    }

    public static int findDictionaryEnd(int jj, byte[] raw, int length) {
        int keyLength = 0;
        while (raw[jj] != 32 && raw[jj] != 13 && raw[jj] != 9 && raw[jj] != 10 && raw[jj] != 91 && raw[jj] != 47 && raw[jj] != 40 && raw[jj] != 60 && raw[jj] != 62) {
            ++keyLength;
            if (++jj != length) continue;
            break;
        }
        return keyLength;
    }

    public static int setDictionaryValue(PdfObject pdfObject, int i, byte[] raw, int length, boolean ignoreRecursion, PdfFileReader objectReader, int PDFkeyInt) {
        boolean isRef;
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + ">>>Reading Dictionary Pairs i=" + i + ' ' + (char)raw[i] + (char)raw[i + 1] + (char)raw[i + 2] + (char)raw[i + 3] + (char)raw[i + 4] + (char)raw[i + 5] + (char)raw[i + 6]);
        }
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47) {
            ++i;
        }
        byte[] data = raw;
        int j = i;
        boolean bl = isRef = data[j] != 60;
        if (isRef) {
            int keyStart2 = i;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
            }
            int number = NumberUtils.parseInt(keyStart2, i, raw);
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            keyStart2 = i;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
            }
            int generation = NumberUtils.parseInt(keyStart2, i, raw);
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            if (raw[i] != 82) {
                throw new RuntimeException("3. Unexpected value in file " + raw[i] + " - please send to IDRsolutions for analysis");
            }
            if (!ignoreRecursion) {
                data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(number, generation), number, generation);
                if (data == null) {
                    pdfObject.setFullyResolved(false);
                    if (ObjectDecoder.debugFastCode) {
                        System.out.println(ObjectDecoder.padding + "Data not yet loaded");
                    }
                    i = length;
                    return i;
                }
                if (data[0] == 60 && data[1] == 60) {
                    j = 0;
                } else {
                    j = 3;
                    while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111) {
                        if (data[j] == 47) {
                            j = 0;
                            break;
                        }
                        if (++j != data.length) continue;
                        j = 0;
                        break;
                    }
                    while (data[j] == 10 || data[j] == 13 || data[j] == 32) {
                        ++j;
                    }
                }
            }
        }
        int endJ = j;
        while (data[endJ] == 60 || data[endJ] == 32 || data[endJ] == 13 || data[endJ] == 10) {
            ++endJ;
        }
        if (data[endJ] == 62) {
            j = endJ + 1;
        } else {
            PdfObject valueObj = ObjectFactory.createObject(PDFkeyInt, pdfObject.getObjectRefAsString(), pdfObject.getObjectType(), pdfObject.getID());
            valueObj.setID(PDFkeyInt);
            if (ignoreRecursion) {
                j = Dictionary.readKeyPairs(PDFkeyInt, data, j, -2, null, objectReader);
            } else {
                int count = Dictionary.readKeyPairs(PDFkeyInt, data, j, -1, null, objectReader);
                j = Dictionary.readKeyPairs(PDFkeyInt, data, j, count, valueObj, objectReader);
                pdfObject.setDictionary(PDFkeyInt, valueObj);
                if (ObjectDecoder.debugFastCode) {
                    System.out.println(ObjectDecoder.padding + "Set Dictionary " + count + " pairs type in " + pdfObject + " to " + valueObj);
                }
            }
        }
        if (!isRef) {
            i = j;
            if (ObjectDecoder.debugFastCode) {
                System.out.println(i + ">>>>" + data[i - 2] + ' ' + data[i - 1] + " >" + data[i] + "< " + data[i + 1] + ' ' + data[i + 2]);
            }
        }
        return i;
    }

    static int readKeyPairs(int id, byte[] data, int j, int pairs, PdfObject pdfObject, PdfFileReader objectReader) {
        boolean debug = false;
        int start = j;
        int numberOfPairs = pairs;
        boolean isCountOnly = false;
        boolean skipToEnd = false;
        Object keys = null;
        Object values = null;
        PdfObject[] objs = null;
        if (pairs == -1) {
            isCountOnly = true;
        } else if (pairs == -2) {
            isCountOnly = true;
            skipToEnd = true;
        } else {
            keys = new byte[numberOfPairs][];
            values = new byte[numberOfPairs][];
            objs = new PdfObject[numberOfPairs];
        }
        pairs = 0;
        while (true) {
            PdfObject valueObj;
            byte[] dictData;
            boolean isDirect;
            if (data[start = Dictionary.getStart(data, start)] == 37) {
                start = ArrayUtils.skipComment(data, start);
            }
            if (data[start] == 62) break;
            if (data[start] == 47) {
                ++pairs;
            } else {
                throw new RuntimeException("Unexpected value " + data[start] + " - not key pair");
            }
            int tokenStart = ++start;
            while (data[start] != 32 && data[start] != 10 && data[start] != 13 && data[start] != 91 && data[start] != 60 && data[start] != 47) {
                ++start;
            }
            int tokenLength = start - tokenStart;
            byte[] tokenKey = new byte[tokenLength];
            System.arraycopy(data, tokenStart, tokenKey, 0, tokenLength);
            if (!isCountOnly) {
                keys[pairs - 1] = tokenKey;
            }
            boolean bl = isDirect = data[start = ArrayUtils.skipSpaces(data, start)] == 60 || data[start] == 91 || data[start] == 47;
            if (isDirect) {
                int level;
                while (data[start - 1] != 60 && data[start] != 60 && data[start] != 91 && data[start] != 47) {
                    ++start;
                }
                int streamStart = start;
                boolean isObject = true;
                if (data[start] == 60) {
                    start += 2;
                    level = 1;
                    while (level > 0) {
                        if (data[start] == 60 && data[start + 1] == 60) {
                            start += 2;
                            ++level;
                            continue;
                        }
                        if (data[start] == 62 && data[start + 1] == 62) {
                            start += 2;
                            --level;
                            continue;
                        }
                        ++start;
                    }
                } else if (data[start] == 91) {
                    level = 1;
                    ++start;
                    boolean inStream = false;
                    while (level > 0) {
                        if (!inStream && data[start] == 40) {
                            inStream = true;
                        } else if (inStream && data[start] == 41 && (data[start - 1] != 92 || data[start - 2] == 92)) {
                            inStream = false;
                        }
                        if (!inStream) {
                            if (data[start] == 91) {
                                ++level;
                            } else if (data[start] == 93) {
                                --level;
                            }
                        }
                        ++start;
                    }
                    isObject = false;
                } else if (data[start] == 47) {
                    ++start;
                    while (data[start] != 47 && data[start] != 10 && data[start] != 13 && data[start] != 32 && (++start >= data.length - 1 || data[start] != 62 || data[start + 1] != 62)) {
                    }
                }
                if (isCountOnly) continue;
                int len = start - streamStart;
                dictData = new byte[len];
                System.arraycopy(data, streamStart, dictData, 0, len);
                values[pairs - 1] = dictData;
                String ref = pdfObject.getObjectRefAsString();
                if (pdfObject.getObjectType() == 2087749783) {
                    if (isObject && !isDirect) {
                        ColorObjectDecoder.handleColorSpaces(pdfObject, 0, dictData, objectReader);
                        objs[pairs - 1] = pdfObject;
                        continue;
                    }
                    ColorSpaceObject colObject = new ColorSpaceObject(ref);
                    if (isDirect) {
                        colObject.setRef(-1, 0);
                    }
                    ColorObjectDecoder.handleColorSpaces(colObject, 0, dictData, objectReader);
                    objs[pairs - 1] = colObject;
                    continue;
                }
                if (!isObject) continue;
                PdfObject valueObj2 = ObjectFactory.createObject(id, ref, pdfObject.getObjectType(), pdfObject.getID());
                valueObj2.setID(id);
                Dictionary.readDictionaryFromRefOrDirect(id, valueObj2, ref, 0, dictData, -1, objectReader);
                objs[pairs - 1] = valueObj2;
                continue;
            }
            int refStart = start;
            int keyStart2 = start;
            if (data[start] == 110 && data[start + 1] == 117 && data[start + 2] == 108 && data[start + 3] == 108) {
                start += 4;
                continue;
            }
            while (data[start] != 10 && data[start] != 13 && data[start] != 32 && data[start] != 47 && data[start] != 60 && data[start] != 62) {
                ++start;
            }
            int number = NumberUtils.parseInt(keyStart2, start, data);
            while (data[start] == 10 || data[start] == 13 || data[start] == 32 || data[start] == 47 || data[start] == 60) {
                ++start;
            }
            keyStart2 = start;
            while (data[start] != 10 && data[start] != 13 && data[start] != 32 && data[start] != 47 && data[start] != 60 && data[start] != 62) {
                ++start;
            }
            int generation = NumberUtils.parseInt(keyStart2, start, data);
            while (data[start] == 10 || data[start] == 13 || data[start] == 32 || data[start] == 47 || data[start] == 60) {
                ++start;
            }
            if (data[start] != 82) {
                throw new RuntimeException((char)data[start - 1] + " " + (char)data[start] + ' ' + (char)data[start + 1] + " 3. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            ++start;
            if (isCountOnly) continue;
            if (PdfDictionary.getKeyType(id, pdfObject.getObjectType()) == 5) {
                String ref = new String(data, refStart, start - refStart);
                PdfObject valueObj3 = ObjectFactory.createObject(id, ref, pdfObject.getObjectType(), pdfObject.getID());
                valueObj3.setStatus(1);
                valueObj3.setUnresolvedData(StringUtils.toBytes(ref), id);
                objs[pairs - 1] = valueObj3;
                continue;
            }
            byte[] rawDictData = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(number, generation), number, generation);
            if (rawDictData == null) {
                pdfObject.setFullyResolved(false);
                return data.length;
            }
            int jj = 0;
            while ((jj < 3 || rawDictData[jj - 1] != 106 && rawDictData[jj - 2] != 98 && rawDictData[jj - 3] != 111) && rawDictData[jj] != 47 && rawDictData[jj] != 91 && rawDictData[jj] != 60) {
                if (++jj != rawDictData.length) continue;
                jj = 0;
                break;
            }
            while (rawDictData[jj] == 10 || rawDictData[jj] == 13 || rawDictData[jj] == 32) {
                ++jj;
            }
            int len = rawDictData.length - jj;
            dictData = new byte[len];
            System.arraycopy(rawDictData, jj, dictData, 0, len);
            values[pairs - 1] = dictData;
            String ref = number + " " + generation + " R";
            if (pdfObject.getObjectType() == 373243460 && id == 373243460) {
                objs[pairs - 1] = null;
                values[pairs - 1] = StringUtils.toBytes(ref);
                continue;
            }
            if (pdfObject.getObjectType() == 979194486) {
                valueObj = ObjectFactory.createObject(id, ref, 979194486, 979194486);
                valueObj.setStatus(1);
                valueObj.setUnresolvedData(StringUtils.toBytes(ref), id);
                objs[pairs - 1] = valueObj;
                continue;
            }
            valueObj = ObjectFactory.createObject(id, ref, pdfObject.getObjectType(), pdfObject.getID());
            valueObj.setID(id);
            if (valueObj.getObjectType() == 2087749783) {
                ColorObjectDecoder.handleColorSpaces(valueObj, 0, dictData, objectReader);
            } else {
                Dictionary.readDictionaryFromRefOrDirect(id, valueObj, ref, 0, dictData, -1, objectReader);
            }
            objs[pairs - 1] = valueObj;
        }
        if (!isCountOnly) {
            pdfObject.setDictionaryPairs((byte[][])keys, (byte[][])values, objs);
        }
        if (skipToEnd || !isCountOnly) {
            return start;
        }
        return pairs;
    }

    private static int getStart(byte[] data, int start) {
        byte b = data[start];
        while (b == 9 || b == 10 || b == 13 || b == 32 || b == 60) {
            b = data[++start];
        }
        return start;
    }

    public static int readDictionaryFromRefOrDirect(int id, PdfObject pdfObject, String objectRef, int i, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        block44: {
            int generation;
            int ref;
            int keyStart;
            byte[] data;
            int j;
            block0: while (true) {
                int possibleArrayStart = -1;
                while (raw[i] == 91 || raw[i] == 32 || raw[i] == 13 || raw[i] == 10) {
                    if (raw[i] == 91) {
                        possibleArrayStart = i;
                    }
                    ++i;
                }
                if (PDFkeyInt == 2087749783 || id == 2087749783 || pdfObject.getPDFkeyInt() == 2087749783) {
                    return ColorObjectDecoder.processColorSpace(pdfObject, pdfObject.getObjectRefAsString(), i, raw, objectReader);
                }
                if (possibleArrayStart != -1 && (PDFkeyInt == 489767739 || PDFkeyInt == 9250 || PDFkeyInt == 2037870513)) {
                    return Array.processArray(pdfObject, raw, PDFkeyInt, possibleArrayStart, objectReader);
                }
                if (raw[i] == 37) {
                    while (raw[i] != 13 && raw[i] != 10) {
                        ++i;
                    }
                    while (raw[i] == 91 || raw[i] == 32 || raw[i] == 13 || raw[i] == 10) {
                        ++i;
                    }
                }
                if (raw[i] == 60) {
                    i = DirectDictionaryToObject.convert(pdfObject, objectRef, i, raw, PDFkeyInt, objectReader);
                    break block44;
                }
                if (raw[i] == 47) {
                    i = ObjectUtils.setDirectValue(pdfObject, i, raw, PDFkeyInt);
                    break block44;
                }
                j = i;
                data = raw;
                while (true) {
                    block45: {
                        if (data[j] == 91 || data[j] == 32 || data[j] == 13 || data[j] == 10) {
                            ++j;
                            continue;
                        }
                        if (data[j] == 93) {
                            return j;
                        }
                        boolean hasNull = false;
                        do {
                            if (hasNull && data[j] == 93) {
                                return j;
                            }
                            keyStart = j;
                            while (data[j] != 10 && data[j] != 13 && data[j] != 32 && data[j] != 47 && data[j] != 60 && data[j] != 62) {
                                if (data[j] == 108 && data[j - 1] == 108 && data[j - 2] == 117 && data[j - 3] == 110) {
                                    hasNull = true;
                                }
                                if (hasNull && data[j] == 93) {
                                    return j;
                                }
                                ++j;
                            }
                            ref = NumberUtils.parseInt(keyStart, j, data);
                            while (data[j] == 10 || data[j] == 13 || data[j] == 32) {
                                ++j;
                            }
                            if (ref != 69560 || data[keyStart] != 110) break block45;
                            hasNull = true;
                        } while (data[j] != 60);
                        i = j;
                        continue block0;
                    }
                    keyStart = j;
                    while (data[j] != 10 && data[j] != 13 && data[j] != 32 && data[j] != 47 && data[j] != 60 && data[j] != 62) {
                        ++j;
                    }
                    generation = NumberUtils.parseInt(keyStart, j, data);
                    while (data[j] == 10 || data[j] == 13 || data[j] == 32 || data[j] == 47 || data[j] == 60) {
                        ++j;
                    }
                    if (data[j] != 82) {
                        throw new RuntimeException("ref=" + ref + " gen=" + ref + " 1. Unexpected value " + data[j] + " in file - please send to IDRsolutions for analysis char=" + (char)data[j]);
                    }
                    data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(ref, generation), ref, generation);
                    if (data == null) {
                        pdfObject.setFullyResolved(false);
                        return raw.length;
                    }
                    if (data != null && data.length > 4 && data[0] == 37 && data[1] == 80 && data[2] == 68 && data[3] == 70) {
                        data = null;
                    }
                    if (data == null) break block0;
                    int j2 = 0;
                    if (data[j2] != 91 && data[0] != 60 && data[1] != 60) {
                        while ((j2 < 3 || j2 > 2 && data[j2 - 1] != 106 && data[j2 - 2] != 98 && data[j2 - 3] != 111) && data[j2] != 47) {
                            ++j2;
                        }
                        while (data[j2] != 91 && (data[j2] == 10 || data[j2] == 13 || data[j2] == 32)) {
                            ++j2;
                        }
                    }
                    if (data[j2] != 91) {
                        j = 0;
                        break block0;
                    }
                    if (data[j2] == 91 && data[j2 + 1] == 60) {
                        j = ++j2;
                        break block0;
                    }
                    j = j2;
                }
                break;
            }
            if (data != null) {
                boolean isMissingValue;
                while (data[j] == 10 || data[j] == 13 || data[j] == 32) {
                    ++j;
                }
                boolean bl = isMissingValue = j < raw.length && raw[j] == 60;
                if (isMissingValue) {
                    int xx;
                    for (xx = j; xx < data.length && (raw[xx] == 60 || raw[xx] == 10 || raw[xx] == 13 || raw[xx] == 32); ++xx) {
                    }
                    if (raw[xx] == 47) {
                        isMissingValue = false;
                    }
                }
                if (isMissingValue) {
                    keyStart = j;
                    while (data[j] != 10 && data[j] != 13 && data[j] != 32 && data[j] != 47 && data[j] != 60 && data[j] != 62) {
                        ++j;
                    }
                    ref = NumberUtils.parseInt(keyStart, j, data);
                    while (data[j] == 10 || data[j] == 13 || data[j] == 32 || data[j] == 47 || data[j] == 60) {
                        ++j;
                    }
                    keyStart = j;
                    while (data[j] != 10 && data[j] != 13 && data[j] != 32 && data[j] != 47 && data[j] != 60 && data[j] != 62) {
                        ++j;
                    }
                    generation = NumberUtils.parseInt(keyStart, j, data);
                    while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111 && data[j] != 60) {
                        ++j;
                    }
                }
                while (data[j] == 10 || data[j] == 13 || data[j] == 32 || data[j] == 9) {
                    ++j;
                }
                if (data[0] != 60) {
                    while (data[j] != 60 && data[j + 1] != 60) {
                        if (data[j] == 110 && data[j + 1] == 117 && data[j + 2] == 108 && data[j + 3] == 108) {
                            return i;
                        }
                        if (data[j] == 47) break;
                        if (data[j] == 40) {
                            j = TextStream.readTextStream(pdfObject, j, data, PDFkeyInt, true, objectReader);
                            break;
                        }
                        ++j;
                    }
                }
                i = ObjectDecoder.handleValue(pdfObject, i, PDFkeyInt, j, ref, generation, data, objectReader);
            }
        }
        return i;
    }
}

