/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.io.IOException;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_boolean;

public class Offsets
extends Vector_Int {
    private boolean refTableInvalid;
    private Vector_boolean isCompressed = new Vector_boolean(2000);
    private Vector_Int generation = new Vector_Int(2000);
    private Vector_Int xref = new Vector_Int(100);

    public Offsets(int i) {
        super(i);
    }

    public void addXref(int pointer) {
        this.xref.addElement(pointer);
    }

    public int[] calculateObjectLength(int eof) {
        int i;
        if (this.refTableInvalid) {
            return null;
        }
        this.xref.addElement(eof);
        int[] xrefs = this.xref.get();
        int xrefCount = xrefs.length;
        int[] xrefID = new int[xrefCount];
        for (int i2 = 0; i2 < xrefCount; ++i2) {
            xrefID[i2] = i2;
        }
        xrefID = Sorts.quicksort(xrefs, xrefID);
        int objectCount = this.getCapacity();
        int[] id = new int[objectCount];
        int[] offsets = new int[objectCount];
        int[] off = this.get();
        boolean[] isComp = this.isCompressed.get();
        for (i = 0; i < objectCount; ++i) {
            if (isComp[i]) continue;
            offsets[i] = off[i];
            id[i] = i;
        }
        id = Sorts.quicksort(offsets, id);
        i = 0;
        while (offsets[id[i]] == 0) {
            ++i;
        }
        int start = offsets[id[i]];
        int j = 0;
        while (xrefs[xrefID[j]] < start + 1) {
            ++j;
        }
        int[] ObjLengthTable = new int[objectCount];
        while (i < objectCount - 1) {
            int end = offsets[id[i + 1]];
            int objLength = end - start - 1;
            if (xrefs[xrefID[j]] < end) {
                objLength = xrefs[xrefID[j]] - start - 1;
                while (xrefs[xrefID[j]] < end + 1) {
                    ++j;
                }
            }
            ObjLengthTable[id[i]] = objLength;
            start = end;
            while (xrefs[xrefID[j]] < start + 1) {
                ++j;
            }
            ++i;
        }
        ObjLengthTable[id[i]] = xrefs[xrefID[j]] - start - 1;
        return ObjLengthTable;
    }

    public void dispose() {
        this.xref = null;
        this.generation = null;
        this.isCompressed = null;
    }

    public int readXRefs(int current, byte[] Bytes, int endTable, int i, long eof, RandomAccessBuffer pdf_datafile) {
        boolean skipNext = false;
        boolean isFirstValue = true;
        int[] breaks = new int[5];
        int[] starts = new int[5];
        while (i < endTable) {
            int startLine = i;
            int endLine = -1;
            while (Bytes[i] != 10 && Bytes[i] != 13) {
                if (endLine == -1 && Bytes[i] == 37) {
                    endLine = i - 1;
                }
                ++i;
            }
            if (endLine == -1) {
                endLine = i - 1;
            }
            while (Bytes[startLine] == 32) {
                ++startLine;
            }
            while (Bytes[endLine] == 32) {
                --endLine;
            }
            ++i;
            int tokenCount = 0;
            int lineLen = endLine - startLine + 1;
            if (lineLen <= 0) continue;
            int lastChar = 1;
            for (int j = 1; j < lineLen; ++j) {
                int currentChar = Bytes[startLine + j];
                if (currentChar == 32 && lastChar != 32) {
                    breaks[tokenCount] = j;
                    ++tokenCount;
                } else if (currentChar != 32 && lastChar == 32) {
                    starts[tokenCount] = j;
                }
                lastChar = currentChar;
            }
            breaks[tokenCount] = lineLen;
            if (++tokenCount == 1) {
                if (skipNext) {
                    skipNext = false;
                    continue;
                }
                current = NumberUtils.parseInt(startLine, startLine + breaks[0], Bytes);
                skipNext = true;
                continue;
            }
            if (tokenCount == 2) {
                current = NumberUtils.parseInt(startLine, startLine + breaks[0], Bytes);
                continue;
            }
            int id = NumberUtils.parseInt(startLine, startLine + breaks[0], Bytes);
            int generation = NumberUtils.parseInt(startLine + starts[1], startLine + breaks[1], Bytes);
            char flag = (char)Bytes[startLine + starts[2]];
            if (flag == 'n') {
                boolean isValid = false;
                int bufSize = 20;
                if ((long)(id + bufSize) > eof) {
                    bufSize = (int)(eof - (long)id);
                }
                if (bufSize > 0) {
                    byte[] buffer = Offsets.getBytes(id, bufSize, pdf_datafile);
                    for (int ii = 4; ii < bufSize; ++ii) {
                        if (buffer[ii - 3] != 32 && buffer[ii - 3] != 10 || buffer[ii - 2] != 111 || buffer[ii - 1] != 98 || buffer[ii] != 106) continue;
                        isValid = true;
                        ii = bufSize;
                    }
                    if (isValid && isFirstValue) {
                        isFirstValue = false;
                        if (buffer[0] == 48 && buffer[1] != 48 && current == 1) {
                            current = 0;
                        } else if (buffer[0] == 49 && buffer[1] == 32) {
                            current = 1;
                        }
                    }
                    if (isValid) {
                        this.storeObjectOffset(current, id, generation, false, false);
                        this.xref.addElement(id);
                    } else if (LogWriter.isRunningFromIDE) {
                        LogWriter.writeLog(current + " " + id + " is bum reference");
                    }
                }
                ++current;
                continue;
            }
            if (flag != 'f') continue;
            ++current;
        }
        return current;
    }

    static byte[] getBytes(long start, int count, RandomAccessBuffer pdf_datafile) {
        byte[] buffer = new byte[count];
        try {
            pdf_datafile.seek(start);
            pdf_datafile.read(buffer);
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return buffer;
    }

    void storeObjectOffset(int current_number, int current_offset, int current_generation, boolean isEntryCompressed, boolean isBumData) {
        int existing_generation = 0;
        int offsetNumber = 0;
        if (current_number < this.generation.getCapacity()) {
            existing_generation = this.generation.elementAt(current_number);
            offsetNumber = this.elementAt(current_number);
        }
        if (existing_generation < current_generation || offsetNumber == 0 || isBumData && current_offset > this.elementAt(current_number)) {
            this.setElementAt(current_offset, current_number);
            this.generation.setElementAt(current_generation, current_number);
            this.isCompressed.setElementAt(isEntryCompressed, current_number);
        }
    }

    public final boolean isCompressed(int ref) {
        return this.isCompressed.elementAt(ref);
    }

    public boolean isRefTableInvalid() {
        return this.refTableInvalid;
    }

    public void setRefTableInvalid(boolean value) {
        this.refTableInvalid = value;
    }
}

