/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.ArrayUtils;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class TextStream {
    public static int readTextStream(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, boolean ignoreRecursion, PdfFileReader objectReader) {
        if (PDFkeyInt == 39 || PDFkeyInt == 9986) {
            return TextStream.readCIDWidths(pdfObject, i, raw, PDFkeyInt, ignoreRecursion, objectReader);
        }
        try {
            if (raw[i] != 60 && raw[i] != 40) {
                ++i;
            }
            if (raw[i = ArrayUtils.skipSpaces(raw, i)] == 47) {
                pdfObject.setTextStreamValue(PDFkeyInt, new byte[1]);
                return --i;
            }
            boolean isRef = raw[i] != 60 && raw[i] != 40;
            int j = i;
            byte[] data = raw;
            if (isRef) {
                int keyStart2 = i;
                while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                    ++i;
                }
                int number = NumberUtils.parseInt(keyStart2, i, raw);
                while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                    ++i;
                }
                keyStart2 = i;
                while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                    ++i;
                }
                int generation = NumberUtils.parseInt(keyStart2, i, raw);
                while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                    ++i;
                }
                if (raw[i] != 82) {
                    return raw.length;
                }
                if (!ignoreRecursion) {
                    data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(number, generation), number, generation);
                    if (data == null) {
                        pdfObject.setFullyResolved(false);
                        if (ObjectDecoder.debugFastCode) {
                            System.out.println(ObjectDecoder.padding + "Data not yet loaded");
                        }
                        LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (7)");
                        return raw.length;
                    }
                    if (data[0] == 40) {
                        j = 0;
                    } else {
                        j = 3;
                        while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111) {
                            ++j;
                        }
                        j = ArrayUtils.skipSpaces(data, j);
                    }
                }
            }
            int start = 0;
            if (!isRef || !ignoreRecursion) {
                while (data[j] != 40 && data[j] != 60) {
                    ++j;
                }
                byte startChar = data[j];
                start = j;
                int bracketCount = 1;
                while (j < data.length) {
                    if (!(startChar != 40 || data[++j] != 41 && data[j] != 40 || ObjectUtils.isEscaped(data, j))) {
                        if (data[j] == 40) {
                            ++bracketCount;
                        } else if (data[j] == 41) {
                            --bracketCount;
                        }
                        if (bracketCount == 0) break;
                    }
                    if (startChar != 60 || data[j] != 62 && data[j] != 0) continue;
                }
            }
            if (!ignoreRecursion) {
                byte[] newString;
                if (data[start] == 60) {
                    int byteCount = j - ++start >> 1;
                    newString = new byte[byteCount];
                    int byteReached = 0;
                    while (start != j) {
                        int topHex = data[start = ArrayUtils.skipSpaces(data, start)];
                        if (topHex >= 65 && topHex <= 70) {
                            topHex -= 55;
                        } else if (topHex >= 97 && topHex <= 102) {
                            topHex -= 87;
                        } else if (topHex >= 48 && topHex <= 57) {
                            topHex -= 48;
                        }
                        ++start;
                        start = ArrayUtils.skipSpaces(data, start);
                        int bottomHex = data[start];
                        if (bottomHex >= 65 && bottomHex <= 70) {
                            bottomHex -= 55;
                        } else if (bottomHex >= 97 && bottomHex <= 102) {
                            bottomHex -= 87;
                        } else if (bottomHex >= 48 && bottomHex <= 57) {
                            bottomHex -= 48;
                        } else {
                            LogWriter.writeLog("Unexpected number " + (char)data[start]);
                            return i;
                        }
                        ++start;
                        int finalValue = bottomHex + (topHex << 4);
                        newString[byteReached] = (byte)finalValue;
                        ++byteReached;
                    }
                } else {
                    if (data[start] == 40) {
                        ++start;
                    }
                    boolean lbKeepReturns = false;
                    switch (PDFkeyInt) {
                        case 6420: {
                            lbKeepReturns = true;
                            break;
                        }
                        case 31: 
                        case 37: {
                            lbKeepReturns = pdfObject.getObjectType() == 1113489015;
                        }
                    }
                    newString = ObjectUtils.readEscapedValue(j, data, start, lbKeepReturns);
                }
                if (pdfObject.getObjectType() != 1113489015) {
                    try {
                        DecryptionFactory decryption;
                        if (!(pdfObject.isInCompressedStream() && PDFkeyInt != 506543413 && PDFkeyInt != 826499443 && PDFkeyInt != 1618506351 && PDFkeyInt != 29 || (decryption = objectReader.getDecryptionObject()) == null)) {
                            newString = decryption.decryptString(newString, pdfObject.getObjectRefAsString());
                        }
                    }
                    catch (PdfSecurityException e) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
                pdfObject.setTextStreamValue(PDFkeyInt, newString);
                if (ObjectDecoder.debugFastCode) {
                    System.out.println(ObjectDecoder.padding + "TextStream=" + new String(newString) + " in pdfObject=" + pdfObject);
                }
            }
            if (!isRef) {
                i = j;
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return i;
    }

    private static int readCIDWidths(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, boolean ignoreRecursion, PdfFileReader objectReader) {
        if (PDFkeyInt == 9986) {
            ++i;
        }
        boolean isRef = false;
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "Reading W or W2");
        }
        while (raw[i] != 91) {
            if (raw[i] == 40) {
                isRef = false;
                break;
            }
            if (raw[i] >= 48 && raw[i] <= 57) {
                isRef = true;
                break;
            }
            ++i;
        }
        byte[] data = raw;
        int start = i;
        int j = i;
        int count = 0;
        if (isRef) {
            int keyStart2 = i;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
            }
            int number = NumberUtils.parseInt(keyStart2, i, raw);
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            keyStart2 = i;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
            }
            int generation = NumberUtils.parseInt(keyStart2, i, raw);
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            if (raw[i] != 82) {
                throw new RuntimeException("3. Unexpected value in file " + raw[i] + " - please send to IDRsolutions for analysis");
            }
            if (!ignoreRecursion) {
                data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(number, generation), number, generation);
                if (data == null) {
                    pdfObject.setFullyResolved(false);
                    if (ObjectDecoder.debugFastCode) {
                        System.out.println(ObjectDecoder.padding + "Data not yet loaded");
                    }
                    return raw.length;
                }
                j = 3;
                if (data.length < 3) {
                    j = 0;
                } else {
                    while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111) {
                        if (++j != data.length) continue;
                        j = 0;
                        break;
                    }
                }
                while (data[j] == 10 || data[j] == 13 || data[j] == 32) {
                    ++j;
                }
                start = j;
            }
        }
        while (j < data.length) {
            if (data[j] == 91 || data[j] == 40) {
                ++count;
            } else if (data[j] == 93 || data[j] == 41) {
                --count;
            }
            if (count == 0) break;
            ++j;
        }
        if (!ignoreRecursion) {
            int stringLength = j - start + 1;
            byte[] newString = new byte[stringLength];
            System.arraycopy(data, start, newString, 0, stringLength);
            if (PDFkeyInt != 6691) {
                for (int aa = 0; aa < stringLength; ++aa) {
                    if (newString[aa] != 10 && newString[aa] != 13) continue;
                    newString[aa] = 32;
                }
            }
            pdfObject.setTextStreamValue(PDFkeyInt, newString);
            if (ObjectDecoder.debugFastCode) {
                if (PDFkeyInt == 39) {
                    System.out.println(ObjectDecoder.padding + pdfObject + " W=" + new String(newString));
                } else {
                    System.out.println(ObjectDecoder.padding + pdfObject + " W2=" + new String(newString));
                }
            }
        }
        if (!isRef) {
            i = j;
        }
        return i;
    }

    public static int setTextStreamValue(PdfObject pdfObject, int i, byte[] raw, boolean ignoreRecursion, int PDFkeyInt, PdfFileReader objectReader) {
        if (raw[i + 1] == 40 && raw[i + 2] == 41) {
            pdfObject.setTextStreamValue(PDFkeyInt, new byte[1]);
            if (raw[i += 3] == 47) {
                --i;
            }
        } else {
            i = TextStream.readTextStream(pdfObject, i, raw, PDFkeyInt, ignoreRecursion, objectReader);
        }
        return i;
    }
}

