/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.Segment;
import org.jpedal.jbig2.segment.pageinformation.PageInformationSegment;

public class JBIG2Decoder {
    private JBIG2StreamDecoder streamDecoder = new JBIG2StreamDecoder();

    public void setGlobalData(byte[] data) throws IOException, JBIG2Exception {
        this.streamDecoder.setGlobalData(data);
    }

    public void decodeJBIG2(File file) throws IOException, JBIG2Exception {
        this.decodeJBIG2(file.getAbsolutePath());
    }

    public void decodeJBIG2(String file) throws IOException, JBIG2Exception {
        this.decodeJBIG2(new FileInputStream(file));
    }

    public void decodeJBIG2(InputStream inputStream) throws IOException, JBIG2Exception {
        int availiable = inputStream.available();
        byte[] bytes = new byte[availiable];
        inputStream.read(bytes);
        this.decodeJBIG2(bytes);
    }

    public void decodeJBIG2(DataInput dataInput) throws IOException, JBIG2Exception {
    }

    public void decodeJBIG2(byte[] data) throws IOException, JBIG2Exception {
        this.streamDecoder.decodeJBIG2(data);
    }

    public BufferedImage getPageAsBufferedImage(int page) {
        JBIG2Bitmap pageBitmap;
        byte[] bytes;
        if ((bytes = (pageBitmap = this.streamDecoder.findPageSegement(++page).getPageBitmap()).getData(true)) == null) {
            return null;
        }
        int len = bytes.length;
        byte[] copy = new byte[len];
        System.arraycopy(bytes, 0, copy, 0, len);
        int width = pageBitmap.getWidth();
        int height = pageBitmap.getHeight();
        BufferedImage image = new BufferedImage(width, height, 12);
        DataBufferByte db = new DataBufferByte(copy, copy.length);
        WritableRaster raster = Raster.createPackedRaster(db, width, height, 1, null);
        image.setData(raster);
        return image;
    }

    public boolean isNumberOfPagesKnown() {
        return this.streamDecoder.isNumberOfPagesKnown();
    }

    public int getNumberOfPages() {
        int pages = this.streamDecoder.getNumberOfPages();
        if (this.streamDecoder.isNumberOfPagesKnown() && pages != 0) {
            return pages;
        }
        int noOfPages = 0;
        List segments = this.getAllSegments();
        for (Segment segment : segments) {
            if (segment.getSegmentHeader().getSegmentType() != 48) continue;
            ++noOfPages;
        }
        return noOfPages;
    }

    public List getAllSegments() {
        return this.streamDecoder.getAllSegments();
    }

    public PageInformationSegment findPageSegement(int page) {
        return this.streamDecoder.findPageSegement(++page);
    }

    public Segment findSegment(int segmentNumber) {
        return this.streamDecoder.findSegment(segmentNumber);
    }

    public JBIG2Bitmap getPageAsJBIG2Bitmap(int page) {
        return this.streamDecoder.findPageSegement(++page).getPageBitmap();
    }

    public boolean isRandomAccessOrganisationUsed() {
        return this.streamDecoder.isRandomAccessOrganisationUsed();
    }
}

