/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.linear;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jpedal.FileAccess;
import org.jpedal.io.LinearizedHintTable;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class LinearThread
extends Thread {
    public int percentageDone;
    final FileChannel fos;
    final PdfObject linearObj;
    final InputStream is;
    final File tempURLFile;
    final LinearizedHintTable linHintTable;
    final byte[] startObj = new byte[]{111, 98, 106};
    final byte[] endObj = new byte[]{101, 110, 100, 111, 98, 106};
    int startCharReached;
    int endCharReached;
    int startObjPtr;
    int endObjPtr;
    private static final int bufSize = 8192;
    int ref;
    final int firstObjLength;
    final FileAccess fileAccess;
    final byte[] linearBytes;

    public LinearThread(InputStream is, FileChannel fos, File tempURLFile, PdfObject linearObj, byte[] linearBytes, LinearizedHintTable linHintTable, FileAccess fileAccess) {
        this.fos = fos;
        this.linearObj = linearObj;
        this.is = is;
        this.tempURLFile = tempURLFile;
        this.linHintTable = linHintTable;
        this.linearBytes = linearBytes;
        this.fileAccess = fileAccess;
        this.firstObjLength = linearBytes.length;
        this.scanStreamForObjects(0, null, linearBytes);
        this.setDaemon(true);
    }

    public int getPercentageLoaded() {
        return this.percentageDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int linearfileLength = this.linearObj.getInt(28);
        try {
            int read;
            int bytesRead = 0;
            byte[] lastBuffer = this.linearBytes;
            byte[] buffer = new byte[8192];
            while ((read = this.is.read(buffer)) != -1 && !this.isInterrupted() && this.isAlive()) {
                if (read > 0) {
                    FileChannel fileChannel = this.fos;
                    synchronized (fileChannel) {
                        byte[] b = new byte[read];
                        System.arraycopy(buffer, 0, b, 0, read);
                        buffer = b;
                        ByteBuffer f = ByteBuffer.wrap(b);
                        this.fos.write(f);
                    }
                }
                if (read > 0) {
                    this.scanStreamForObjects(this.firstObjLength + bytesRead, lastBuffer, buffer);
                    bytesRead += read;
                    int aa = 30;
                    int size1 = buffer.length;
                    if (aa > size1 - 1) {
                        aa = size1 - 1;
                    }
                    lastBuffer = new byte[aa];
                    System.arraycopy(buffer, size1 - aa, lastBuffer, 0, aa);
                }
                this.percentageDone = (int)(100.0f * ((float)bytesRead / (float)linearfileLength));
            }
            this.linHintTable.setFinishedReading();
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        finally {
            try {
                this.is.close();
                this.fileAccess.waitForDecodingToFinish();
                this.fileAccess.setIO(new PdfObjectReader());
                if (this.isAlive() && !this.isInterrupted()) {
                    this.fileAccess.openPdfFile(this.tempURLFile.getAbsolutePath());
                    this.fileAccess.getObjectStore().storeFileName(this.tempURLFile.getName().substring(0, this.tempURLFile.getName().lastIndexOf(46)));
                }
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    private void scanStreamForObjects(int bytesRead, byte[] lastBuffer, byte[] buffer) {
        int bufSize = buffer.length;
        for (int i = 0; i < bufSize; ++i) {
            if (this.startCharReached == 0) {
                if (buffer[i] != 32 && buffer[i] != 0 && buffer[i] != 10 && buffer[i] != 32) continue;
                ++this.startCharReached;
                continue;
            }
            if (this.startCharReached < 4) {
                if (buffer[i] == this.startObj[this.startCharReached - 1]) {
                    if (this.startCharReached == 3) {
                        byte[] data;
                        this.startObjPtr = bytesRead + i - 4;
                        int ii = i - 4;
                        if (lastBuffer != null && ii < 30) {
                            int size1 = lastBuffer.length;
                            int size2 = buffer.length;
                            data = new byte[size1 + size2];
                            System.arraycopy(lastBuffer, 0, data, 0, size1);
                            System.arraycopy(buffer, 0, data, size1, size2);
                            ii += size1;
                        } else {
                            data = buffer;
                        }
                        int keyEnd = ii;
                        while (data[ii] != 10 && data[ii] != 13 && data[ii] != 32 && data[ii] != 9) {
                            --ii;
                            --this.startObjPtr;
                        }
                        NumberUtils.parseInt(ii + 1, keyEnd, data);
                        while (data[ii] == 10 || data[ii] == 13 || data[ii] == 32 || data[ii] == 47 || data[ii] == 60) {
                            --ii;
                            --this.startObjPtr;
                        }
                        keyEnd = ii + 1;
                        while (data[ii] != 10 && data[ii] != 13 && data[ii] != 32 && data[ii] != 47 && data[ii] != 60 && data[ii] != 62) {
                            --ii;
                            --this.startObjPtr;
                        }
                        this.ref = NumberUtils.parseInt(ii + 1, keyEnd, data);
                    }
                    ++this.startCharReached;
                    continue;
                }
                this.startCharReached = 0;
                continue;
            }
            if (buffer[i] == this.endObj[this.endCharReached]) {
                ++this.endCharReached;
                if (this.endCharReached != 6) continue;
                this.endObjPtr = bytesRead + i;
                this.linHintTable.storeOffset(this.ref, this.startObjPtr, this.endObjPtr);
                this.startCharReached = 0;
                this.endCharReached = 0;
                continue;
            }
            this.endCharReached = 0;
        }
    }
}

