/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.javascript.DefaultParser;
import org.jpedal.objects.javascript.ExpressionEngine;
import org.jpedal.objects.javascript.GenericParser;
import org.jpedal.objects.javascript.RhinoParser;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_String;

public class Javascript {
    private ExpressionEngine jsParser;
    private static boolean useNewJSParser;
    private static boolean disableJavascript;
    private final Map javascriptCommands = new HashMap();
    private final Map javascriptTypesUsed = new HashMap();
    private final Map linkedjavascriptCommands = new HashMap();
    private final Map javascriptNamesObjects = new HashMap();

    public Javascript(ExpressionEngine userExpressionEngine, AcroRenderer acro) {
        if (disableJavascript) {
            return;
        }
        if (System.getProperty("org.jpedal.newJS") != null) {
            useNewJSParser = true;
        }
        if (userExpressionEngine != null) {
            this.jsParser = userExpressionEngine;
        } else {
            try {
                if (!useNewJSParser) {
                    InputStream in = DefaultParser.class.getClassLoader().getResourceAsStream("org/mozilla/javascript/Context.class");
                    this.jsParser = in != null ? new RhinoParser(this) : new DefaultParser();
                } else {
                    GenericParser genericParser = new GenericParser(this);
                    this.jsParser = genericParser;
                    genericParser.setupPDFObjects(this);
                }
            }
            catch (Error err) {
                LogWriter.writeLog("Error: " + err.getMessage());
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        this.jsParser.setAcroRenderer(acro);
    }

    public void executeAction(String jsCode) {
        if (disableJavascript) {
            return;
        }
        this.jsParser.executeFunctions(jsCode, null);
    }

    public int execute(FormObject ref, int type, int eventType, char keyPressed) {
        String refName;
        Vector_String linkedObj;
        int returnCode = this.executeCommand(ref, type, eventType, keyPressed);
        boolean executeChangedCode = false;
        if (eventType == 6 && (type != 4866 || type == 4866 && (returnCode == 0 || returnCode == 3))) {
            executeChangedCode = true;
        }
        if (executeChangedCode && (linkedObj = (Vector_String)this.linkedjavascriptCommands.get(refName = ref.getTextStreamValue(36))) != null) {
            String[] value;
            linkedObj.trim();
            for (String nextVal : value = linkedObj.get()) {
                if (nextVal.equals(refName) && type != 4866) continue;
            }
        }
        return returnCode;
    }

    public Object getJavascriptCommand(String ref, int type) {
        return this.javascriptCommands.get(ref + '-' + type);
    }

    private int executeCommand(FormObject ref, int type, int eventType, char keyPressed) {
        int message = 0;
        if (disableJavascript) {
            return message;
        }
        if (ref == null) {
            return message;
        }
        Object js = this.javascriptCommands.get(ref.getObjectRefAsString() + '-' + type);
        if (js == null) {
            js = this.javascriptCommands.get(ref.getTextStreamValue(36) + '-' + type);
        }
        if (js == null) {
            return 0;
        }
        if (message != 2) {
            message = this.jsParser.execute(ref, type, js, eventType, keyPressed);
        }
        return message;
    }

    public void setCode(String name, String value) {
        if (disableJavascript) {
            return;
        }
        this.javascriptNamesObjects.put(name, value);
        this.jsParser.addCode(value);
    }

    public String getJavaScript(String key) {
        String str;
        if (key == null) {
            Collection c = this.javascriptNamesObjects.values();
            Iterator itr = c.iterator();
            StringBuilder s = new StringBuilder();
            while (itr.hasNext()) {
                s.append(itr.next());
            }
            str = s.toString();
        } else {
            str = (String)this.javascriptNamesObjects.get(key);
        }
        return str;
    }

    public void closeFile() {
        this.javascriptTypesUsed.clear();
        this.javascriptCommands.clear();
        this.linkedjavascriptCommands.clear();
        if (disableJavascript) {
            return;
        }
        this.jsParser.closeFile();
    }

    public void storeJavascript(String name, String script, int type) {
        this.javascriptCommands.put(name + '-' + type, script);
        this.javascriptTypesUsed.put(type, "x");
        if (type == 4866) {
            int ptr = 0;
            while (true) {
                int escapedptr = script.indexOf("\\\"", ptr);
                while ((ptr = script.indexOf(34, ptr)) != -1 && escapedptr != -1 && ptr - 1 <= escapedptr) {
                }
                if (ptr == -1) break;
                int start = ++ptr;
                escapedptr = script.indexOf("\\\"", ptr);
                while ((ptr = script.indexOf(34, ptr)) != -1 && escapedptr != -1 && ptr - 1 <= escapedptr) {
                }
                if (ptr == -1) break;
                String obj = script.substring(start, ptr);
                if (obj != null) {
                    Vector_String existingList = (Vector_String)this.linkedjavascriptCommands.get(obj);
                    if (existingList == null) {
                        existingList = new Vector_String();
                        existingList.addElement(name);
                    } else if (!existingList.contains(name)) {
                        existingList.addElement(name);
                    }
                    this.linkedjavascriptCommands.put(obj, existingList);
                }
                ++ptr;
            }
        }
    }

    public void dispose() {
        if (disableJavascript) {
            return;
        }
        this.jsParser.dispose();
    }

    public static void disableJavascript() {
        disableJavascript = true;
    }
}

