/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.io.Serializable;
import org.jpedal.objects.PageOrigins;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;

public class PdfPageData
implements Serializable {
    private int lastPage = -1;
    private int pagesRead = -1;
    private int pageCount = 1;
    private int maxPageCount = -1;
    private int rotation;
    private final Vector_Object mediaBoxes = new Vector_Object(500);
    private final Vector_Object cropBoxes = new Vector_Object(500);
    private Vector_Int rotations;
    private float cropBoxX = -99999.0f;
    private float cropBoxY = -1.0f;
    private float cropBoxW = -1.0f;
    private float cropBoxH = -1.0f;
    private float mediaBoxX = -1.0f;
    private float mediaBoxY;
    private float mediaBoxW;
    private float mediaBoxH;
    private boolean hasMultipleSizes;
    private boolean hasMultipleSizesSet;
    private float scalingValue = 1.0f;
    private float[] mediaBox;
    private float[] cropBox;
    private PageOrigins pageOrigin = PageOrigins.BOTTOM_LEFT;

    public void checkSizeSet(int pageNumber) {
        if (pageNumber > this.pageCount) {
            this.pageCount = pageNumber;
        }
        if (this.cropBox != null && (this.cropBox[0] != this.mediaBox[0] || this.cropBox[1] != this.mediaBox[1] || this.cropBox[2] != this.mediaBox[2] || this.cropBox[3] != this.mediaBox[3])) {
            this.mediaBoxes.setElementAt(this.mediaBox, pageNumber);
            if (this.cropBox[0] >= this.mediaBox[0] && this.cropBox[1] >= this.mediaBox[1] && this.cropBox[2] - this.cropBox[0] <= this.mediaBox[2] - this.mediaBox[0] && this.cropBox[3] - this.cropBox[1] <= this.mediaBox[3] - this.mediaBox[1]) {
                this.cropBoxes.setElementAt(this.cropBox, pageNumber);
            }
        } else if (this.mediaBox != null) {
            this.mediaBoxes.setElementAt(this.mediaBox, pageNumber);
        }
        if (this.pagesRead < pageNumber) {
            this.pagesRead = pageNumber;
        }
        this.lastPage = -1;
        this.mediaBox = null;
        this.cropBox = null;
    }

    public final int getMediaBoxHeight(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return (int)this.mediaBoxH;
    }

    public final int getMediaBoxY(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return (int)this.mediaBoxY;
    }

    public final int getMediaBoxX(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return (int)this.mediaBoxX;
    }

    public void setMediaBox(float[] mediaBox) {
        this.mediaBox = mediaBox;
        this.cropBox = null;
    }

    public void setCropBox(float[] cropBox) {
        this.cropBox = cropBox != null ? cropBox : this.mediaBox;
        boolean testAlteredCrop = true;
        if (this.mediaBox != null && this.mediaBox.length >= 4) {
            if (this.cropBox[0] < this.mediaBox[0]) {
                this.cropBox[0] = this.mediaBox[0];
            }
            if (this.cropBox[1] < this.mediaBox[1]) {
                this.cropBox[1] = this.mediaBox[1];
            }
            if (this.cropBox[2] > this.mediaBox[2]) {
                this.cropBox[2] = this.mediaBox[2];
            }
            if (this.cropBox[3] > this.mediaBox[3]) {
                this.cropBox[3] = this.mediaBox[3];
            }
        }
    }

    public void setPageRotation(int value, int pageNumber) {
        int raw_rotation = value;
        if (raw_rotation < 0) {
            raw_rotation = 360 + raw_rotation;
        }
        if (raw_rotation != 0 || this.rotations != null) {
            if (this.rotations == null) {
                this.rotations = pageNumber < 2000 ? new Vector_Int(2000) : new Vector_Int(pageNumber * 2);
            }
            this.rotations.setElementAt(raw_rotation, pageNumber);
        }
    }

    public final int getMediaBoxWidth(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return (int)this.mediaBoxW;
    }

    public String getMediaValue(int currentPage) {
        StringBuilder returnValue = new StringBuilder();
        float[] mediaBox = null;
        if (this.mediaBoxes != null) {
            mediaBox = (float[])this.mediaBoxes.elementAt(currentPage);
        }
        if (mediaBox != null) {
            for (int j = 0; j < 4; ++j) {
                returnValue.append(mediaBox[j]);
                returnValue.append(' ');
            }
        }
        return returnValue.toString();
    }

    public String getCropValue(int currentPage) {
        float[] cropBox = null;
        if (this.cropBoxes != null) {
            cropBox = (float[])this.cropBoxes.elementAt(currentPage);
        }
        if (cropBox == null) {
            cropBox = (float[])this.mediaBoxes.elementAt(currentPage);
        }
        StringBuilder returnValue = new StringBuilder();
        for (int j = 0; j < 4; ++j) {
            returnValue.append(cropBox[j]);
            returnValue.append(' ');
        }
        return returnValue.toString();
    }

    public int getScaledCropBoxX(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return PdfPageData.roundFloat(this.cropBoxX * this.scalingValue);
    }

    public int getScaledCropBoxWidth(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return PdfPageData.roundFloat(this.cropBoxW * this.scalingValue);
    }

    public int getScaledCropBoxY(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return PdfPageData.roundFloat(this.cropBoxY * this.scalingValue);
    }

    public int getScaledCropBoxHeight(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return PdfPageData.roundFloat(this.cropBoxH * this.scalingValue);
    }

    public int getCropBoxX(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return (int)this.cropBoxX;
    }

    public float getCropBoxX2D(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return this.cropBoxX;
    }

    public int getCropBoxWidth(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return (int)this.cropBoxW;
    }

    public float getCropBoxWidth2D(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return this.cropBoxW;
    }

    public int getCropBoxY(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return (int)this.cropBoxY;
    }

    public float getCropBoxY2D(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return this.cropBoxY;
    }

    public int getCropBoxHeight(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return (int)this.cropBoxH;
    }

    public float getCropBoxHeight2D(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return this.cropBoxH;
    }

    private synchronized void setSizeForPage(int pageNumber) throws Exception {
        if (pageNumber == this.lastPage) {
            return;
        }
        if (pageNumber > this.pageCount) {
            this.pageCount = pageNumber;
        }
        if (pageNumber > this.pagesRead) {
            this.mediaBoxX = 0.0f;
            this.mediaBoxY = 0.0f;
            this.mediaBoxW = 0.0f;
            this.mediaBoxH = 0.0f;
            this.cropBoxX = 0.0f;
            this.cropBoxY = 0.0f;
            this.cropBoxW = 0.0f;
            this.cropBoxH = 0.0f;
            this.lastPage = pageNumber;
        } else if (pageNumber > 0 && this.lastPage != pageNumber && (this.maxPageCount == -1 || pageNumber <= this.maxPageCount)) {
            this.lastPage = pageNumber;
            float[] cropBox = (float[])this.cropBoxes.elementAt(pageNumber);
            float[] mediaBox = (float[])this.mediaBoxes.elementAt(pageNumber);
            if (this.rotations != null) {
                this.rotation = this.rotations.elementAt(pageNumber);
            }
            while (this.rotation >= 360) {
                this.rotation -= 360;
            }
            this.mediaBoxX = 0.0f;
            this.mediaBoxY = 0.0f;
            this.mediaBoxW = 800.0f;
            this.mediaBoxH = 800.0f;
            if (mediaBox != null) {
                this.mediaBoxX = mediaBox[0];
                this.mediaBoxY = mediaBox[1];
                this.mediaBoxW = mediaBox[2] - this.mediaBoxX;
                this.mediaBoxH = mediaBox[3] - this.mediaBoxY;
                if (this.mediaBoxY > 0.0f && this.mediaBoxH == -this.mediaBoxY) {
                    this.mediaBoxH = -this.mediaBoxH;
                    this.mediaBoxY = 0.0f;
                }
            }
            if (cropBox != null) {
                float temp;
                this.cropBoxX = cropBox[0];
                this.cropBoxY = cropBox[1];
                this.cropBoxW = cropBox[2];
                this.cropBoxH = cropBox[3];
                if (this.cropBoxX > this.cropBoxW) {
                    temp = this.cropBoxX;
                    this.cropBoxX = this.cropBoxW;
                    this.cropBoxW = temp;
                }
                if (this.cropBoxY > this.cropBoxH) {
                    temp = this.cropBoxY;
                    this.cropBoxY = this.cropBoxH;
                    this.cropBoxH = temp;
                }
                this.cropBoxW -= this.cropBoxX;
                this.cropBoxH -= this.cropBoxY;
                if (this.cropBoxY > 0.0f && this.cropBoxH == -this.cropBoxY) {
                    this.cropBoxH = -this.cropBoxH;
                    this.cropBoxY = 0.0f;
                }
            } else {
                this.cropBoxX = this.mediaBoxX;
                this.cropBoxY = this.mediaBoxY;
                this.cropBoxW = this.mediaBoxW;
                this.cropBoxH = this.mediaBoxH;
            }
            if (this.cropBoxH < 0.0f) {
                this.cropBoxY += this.cropBoxH;
                this.cropBoxH = -this.cropBoxH;
            }
            if (this.cropBoxW < 0.0f) {
                this.cropBoxX += this.cropBoxW;
                this.cropBoxW = -this.cropBoxW;
            }
        } else if (pageNumber <= 0 || this.maxPageCount != -1 && pageNumber > this.maxPageCount) {
            throw new Exception("Attempted to find page outside of page range 1 - " + this.maxPageCount + "  Page number requested:" + pageNumber);
        }
    }

    public float getScalingValue() {
        return this.scalingValue;
    }

    public void setScalingValue(float scalingValue) {
        this.scalingValue = scalingValue;
    }

    private static int roundFloat(float origValue) {
        int roundedValue = (int)origValue;
        boolean useCustomRounding = true;
        float frac = origValue - (float)roundedValue;
        if ((double)frac > 0.3) {
            ++roundedValue;
        }
        return roundedValue;
    }

    public final int getPageCount() {
        return this.pageCount;
    }

    public final int getRotation(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return this.rotation;
    }

    public final int getScaledMediaBoxHeight(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return PdfPageData.roundFloat(this.mediaBoxH * this.scalingValue);
    }

    public final int getScaledMediaBoxWidth(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return PdfPageData.roundFloat(this.mediaBoxW * this.scalingValue);
    }

    public final int getScaledMediaBoxX(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return PdfPageData.roundFloat(this.mediaBoxX * this.scalingValue);
    }

    public final int getScaledMediaBoxY(int pageNumber) {
        try {
            this.setSizeForPage(pageNumber);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return PdfPageData.roundFloat(this.mediaBoxY * this.scalingValue);
    }

    public boolean hasMultipleSizes() {
        if (this.hasMultipleSizesSet) {
            return this.hasMultipleSizes;
        }
        int pageCount = this.pageCount;
        int pageW = this.getCropBoxWidth(1);
        int pageH = this.getCropBoxHeight(1);
        int pageR = this.getRotation(1);
        if (pageCount > 1) {
            for (int jj = 2; jj < pageCount + 1; ++jj) {
                if (pageW == this.getCropBoxWidth(jj) && pageH == this.getCropBoxHeight(jj) && pageR == this.getRotation(jj)) continue;
                jj = pageCount;
                this.hasMultipleSizes = true;
            }
        }
        this.hasMultipleSizesSet = true;
        return this.hasMultipleSizes;
    }

    public void setOrigin(PageOrigins newPageOrigin) {
        this.pageOrigin = newPageOrigin;
    }

    public PageOrigins getOrigin() {
        return this.pageOrigin;
    }

    public void setPageCount(int count) {
        this.maxPageCount = count;
    }
}

