/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms;

import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.jpedal.external.CustomFormPrint;
import org.jpedal.objects.acroforms.FormRenderUtilsG2;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.creation.JPedalBorderFactory;
import org.jpedal.objects.acroforms.overridingImplementations.FixImageIcon;
import org.jpedal.objects.acroforms.overridingImplementations.ReadOnlyTextIcon;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.utils.LogWriter;

public class SwingData
extends GUIData {
    public static boolean JVMBugRightAlignFix;
    CustomFormPrint customFormPrint;
    JFrame dummyPanel;
    boolean g2SwingRenderComplete;
    private JPanel panel;
    public static int readOnlyScaling;
    int maxLengthForTextOnPage;

    @Override
    public void dispose() {
        super.dispose();
        if (this.dummyPanel != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.dummyPanel.dispose();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            SwingData.this.dummyPanel.dispose();
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void renderComponent(final Graphics2D g2, FormObject formObject, final Component comp, int rotation, boolean printcombo, int indent, boolean isPrinting) {
        if (comp != null) {
            boolean editable = false;
            int page = formObject.getPageNumber();
            if (!printcombo && comp instanceof JComboBox) {
                Object selected;
                JComboBox combo = (JComboBox)comp;
                if (combo.isEditable()) {
                    editable = true;
                    combo.setEditable(false);
                }
                if (combo.getComponentCount() > 0 && (selected = combo.getSelectedItem()) != null) {
                    JTextField text = new JTextField();
                    text.setText(selected.toString());
                    text.setBackground(combo.getBackground());
                    text.setForeground(combo.getForeground());
                    text.setFont(combo.getFont());
                    text.setBorder(combo.getBorder());
                    this.renderComponent(g2, formObject, text, rotation, false, indent, isPrinting);
                }
                printcombo = true;
            }
            if (!printcombo) {
                AffineTransform ax = g2.getTransform();
                if (isPrinting) {
                    this.scaleComponent(formObject, 1.0f, rotation, comp, false, indent, isPrinting);
                    switch (360 - rotation) {
                        case 270: {
                            AffineTransform at = AffineTransform.getRotateInstance(4.71238898038469, 0.0, 0.0);
                            g2.translate(comp.getBounds().y + this.cropOtherY[page] - this.insetH, this.pageData.getCropBoxHeight(page) - comp.getBounds().x + this.insetW);
                            g2.transform(at);
                            g2.translate(-this.insetW, 0);
                            break;
                        }
                        case 90: {
                            AffineTransform at = AffineTransform.getRotateInstance(1.5707963267948966, 0.0, 0.0);
                            g2.translate(comp.getBounds().y + this.cropOtherY[page] - this.insetH, comp.getBounds().x + this.insetW);
                            g2.transform(at);
                            g2.translate(0, -this.insetH);
                            break;
                        }
                        case 180: {
                            AffineTransform at = AffineTransform.getRotateInstance(Math.PI, 0.0, 0.0);
                            g2.translate(comp.getBounds().x - this.insetW, comp.getBounds().y + this.cropOtherY[page]);
                            g2.transform(at);
                            g2.translate(-this.insetW, -this.insetH);
                            break;
                        }
                        default: {
                            g2.translate(comp.getBounds().x - this.insetW, comp.getBounds().y + this.cropOtherY[page]);
                            break;
                        }
                    }
                } else {
                    this.scaleComponent(formObject, 1.0f, rotation, comp, false, indent, isPrinting);
                    Rectangle rect = comp.getBounds();
                    g2.translate(rect.x - this.insetW, rect.y + this.cropOtherY[page]);
                    if (comp instanceof JTextComponent) {
                        int rotate;
                        if (this.pageData.getRotation(page) == 90 || this.pageData.getRotation(page) == 270) {
                            comp.setBounds(rect.x, rect.y, rect.height, rect.width);
                            rect = comp.getBounds();
                        }
                        if ((rotate = rotation - this.pageData.getRotation(0)) < 0) {
                            rotate = 360 + rotate;
                        }
                        switch (rotate) {
                            case 270: {
                                AffineTransform at = AffineTransform.getRotateInstance((double)rotate * Math.PI / 180.0, 0.0, 0.0);
                                g2.transform(at);
                                g2.translate(-rect.width, 0);
                                break;
                            }
                            case 90: {
                                AffineTransform at = AffineTransform.getRotateInstance((double)rotate * Math.PI / 180.0, 0.0, 0.0);
                                g2.transform(at);
                                g2.translate(0, -rect.height);
                                break;
                            }
                            case 180: {
                                AffineTransform at = AffineTransform.getRotateInstance((double)rotate * Math.PI / 180.0, 0.0, 0.0);
                                g2.transform(at);
                                g2.translate(-rect.width, -rect.height);
                            }
                        }
                    }
                }
                boolean isPainted = false;
                if (JVMBugRightAlignFix && comp instanceof JTextField) {
                    JTextField field = new JTextField();
                    JTextField source = (JTextField)comp;
                    if (source.getHorizontalAlignment() == 4) {
                        String newText;
                        field.setFont(source.getFont());
                        field.setLocation(source.getLocation());
                        field.setSize(source.getSize());
                        field.setBorder(source.getBorder());
                        field.setHorizontalAlignment(4);
                        int additionalBlanks = 0;
                        int width = g2.getFontMetrics(comp.getFont()).stringWidth(new String(SwingData.createCharArray(' ', this.maxLengthForTextOnPage - source.getText().length())) + source.getText());
                        int eightPointWidth = g2.getFontMetrics(comp.getFont().deriveFont(7.0f)).stringWidth(new String(SwingData.createCharArray(' ', this.maxLengthForTextOnPage - source.getText().length())) + source.getText());
                        int difference = width - eightPointWidth;
                        if (difference > 0) {
                            additionalBlanks = difference / g2.getFontMetrics(comp.getFont().deriveFont(7.0f)).stringWidth(" ");
                        }
                        String originalTest = source.getText();
                        int bunchOfSpaces = this.maxLengthForTextOnPage + additionalBlanks - source.getText().length();
                        field.setText(new String(SwingData.createCharArray(' ', bunchOfSpaces)) + originalTest);
                        width = g2.getFontMetrics(comp.getFont()).stringWidth(field.getText());
                        int insets = 0;
                        if (field.getBorder() != null) {
                            insets = field.getBorder().getBorderInsets((Component)field).left + field.getBorder().getBorderInsets((Component)field).right;
                        }
                        boolean needsChange = false;
                        while (bunchOfSpaces > 0 && width > field.getWidth() - insets) {
                            bunchOfSpaces = this.maxLengthForTextOnPage + additionalBlanks - source.getText().length();
                            newText = new String(SwingData.createCharArray(' ', bunchOfSpaces)) + originalTest;
                            field.setText(newText);
                            --additionalBlanks;
                            width = g2.getFontMetrics(comp.getFont().deriveFont(7.0f)).stringWidth(field.getText());
                            needsChange = true;
                        }
                        if (needsChange) {
                            bunchOfSpaces = this.maxLengthForTextOnPage + --additionalBlanks - source.getText().length();
                            newText = new String(SwingData.createCharArray(' ', bunchOfSpaces)) + originalTest;
                            field.setText(newText);
                        }
                        field.paint(g2);
                        isPainted = true;
                    }
                }
                if (!isPainted) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        comp.paint(g2);
                    } else {
                        this.g2SwingRenderComplete = false;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                comp.paint(g2);
                                SwingData.this.g2SwingRenderComplete = true;
                            }
                        });
                        while (!this.g2SwingRenderComplete) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                LogWriter.writeLog("Exception " + e.getMessage());
                            }
                        }
                        this.g2SwingRenderComplete = false;
                    }
                }
                if (isPrinting && comp instanceof JInternalFrame) {
                    this.scaleComponent(formObject, this.displayScaling, rotation, comp, false, indent, false);
                }
                g2.setTransform(ax);
            }
            if (editable) {
                ((JComboBox)comp).setEditable(true);
            }
        }
    }

    private void renderComponent(Graphics2D g2, FormObject formObject, boolean isPrinting) {
        String name;
        int page = formObject.getPageNumber();
        AffineTransform ax = g2.getTransform();
        Font backup = g2.getFont();
        Stroke st = g2.getStroke();
        Color old = g2.getColor();
        Shape oldClip = g2.getClip();
        Composite oldCom = g2.getComposite();
        g2.translate(0, this.pageData.getMediaBoxHeight(page) - this.pageData.getCropBoxHeight(page));
        if (formObject.getParameterConstant(1147962727) == 607471684 && (name = formObject.getTextStreamValue(506543413)) != null && name.equals("Comment")) {
            try {
                BufferedImage commentIcon = ImageIO.read(this.getClass().getResource("/org/jpedal/objects/acroforms/res/comment.png"));
                g2.drawImage(commentIcon, formObject.getBoundingRectangle().x, this.pageData.getCropBoxHeight(page) - formObject.getBoundingRectangle().y, formObject.getBoundingRectangle().width, formObject.getBoundingRectangle().height, null);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        if (formObject.getFloatArray(19) == null) {
            formObject.setFloatArray(19, new float[]{255.0f, 255.0f, 0.0f});
        }
        float[] col = formObject.getFloatArray(19);
        Color bgColor = null;
        if (col != null) {
            bgColor = col[0] > 1.0f || col[1] > 1.0f || col[2] > 1.0f ? new Color((int)col[0], (int)col[1], (int)col[2]) : new Color(col[0], col[1], col[2]);
        }
        if (formObject.getParameterConstant(1147962727) == 1061176672 && formObject.getBoolean(524301630)) {
            FormRenderUtilsG2.renderPopupWindow(g2, formObject, bgColor, isPrinting, this.pageData.getCropBoxHeight(page));
        }
        g2.setFont(backup);
        int borderWidth = FormRenderUtilsG2.renderBorder(g2, formObject, page, this.pageData.getCropBoxHeight(page));
        g2.setStroke(st);
        String textValue = formObject.getValue();
        if (textValue != null) {
            FontMetrics metrics = FormRenderUtilsG2.renderFont(g2, formObject, textValue, borderWidth);
            int justification = formObject.getAlignment();
            Rectangle2D r = metrics.getStringBounds(textValue, g2);
            if (formObject.getFieldFlags()[17]) {
                justification = 0;
            }
            if (formObject.getObjectArray(2048068) != null && !formObject.getFieldFlags()[18]) {
                FormRenderUtilsG2.renderComboForms(g2, formObject, metrics, r, borderWidth, justification, this.pageData.getCropBoxHeight(page));
            } else if (!textValue.isEmpty()) {
                g2.setClip(new Rectangle(formObject.getBoundingRectangle().x + borderWidth - 1, this.pageData.getCropBoxHeight(page) - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) + borderWidth - 1, formObject.getBoundingRectangle().width - borderWidth * 2 + 2, formObject.getBoundingRectangle().height - borderWidth * 2 + 2));
                if (formObject.getFieldFlags()[13]) {
                    FormRenderUtilsG2.renderMultilineTextField(g2, formObject, metrics, r, textValue, borderWidth, justification, this.pageData.getCropBoxHeight(page));
                } else {
                    FormRenderUtilsG2.renderSingleLineTextField(g2, formObject, metrics, r, textValue, borderWidth, justification, this.pageData.getCropBoxHeight(page));
                }
            }
        }
        FormRenderUtilsG2.renderQuadPoint(g2, formObject, bgColor, this.pageData.getCropBoxHeight(page));
        g2.setTransform(ax);
        g2.setFont(backup);
        g2.setStroke(st);
        g2.setColor(old);
        g2.setClip(oldClip);
        g2.setComposite(oldCom);
    }

    private static char[] createCharArray(char c, int count) {
        if (count <= 0) {
            return new char[0];
        }
        char[] result = new char[count];
        Arrays.fill(result, 0, result.length, c);
        return result;
    }

    @Override
    public void renderFormsOntoG2(Object raw, int pageIndex, int currentIndent, int currentRotation, Map componentsToIgnore, FormFactory formFactory, int pageHeight) {
        if (this.formsUnordered != null && !this.rasterizeForms) {
            if (this.formFactory.getType() == 3 || this.formFactory.getType() == 4) {
                this.renderFormsOntoG2WithHTML(pageIndex, componentsToIgnore);
            } else if (GraphicsEnvironment.isHeadless() || formFactory == null) {
                this.renderFormsOntoG2InHeadless(raw, pageIndex, currentRotation, componentsToIgnore, formFactory, pageHeight);
            } else {
                this.renderFormsOntoG2WithSwing(raw, pageIndex, currentIndent, currentRotation, componentsToIgnore, formFactory, pageHeight);
            }
        }
    }

    @Override
    public void renderFormsOntoG2InHeadless(Object raw, int pageIndex, int currentRotation, Map componentsToIgnore, FormFactory formFactory, int pageHeight) {
        if (this.formsOrdered == null || this.formsOrdered[pageIndex] == null) {
            return;
        }
        this.componentsToIgnore = componentsToIgnore;
        boolean isPrinting = formFactory != null;
        Graphics2D g2 = (Graphics2D)raw;
        AffineTransform defaultAf = g2.getTransform();
        AffineTransform aff = g2.getTransform();
        aff.scale(1.0, 1.0);
        g2.setTransform(aff);
        for (Object nextVal : this.formsOrdered[pageIndex]) {
            FormObject formObject;
            boolean[] flags;
            if (nextVal == null || (flags = (formObject = (FormObject)nextVal).getCharacteristics())[1] || isPrinting && !flags[2]) continue;
            this.renderComponent(g2, formObject, isPrinting);
        }
        g2.setTransform(defaultAf);
    }

    private void renderFormsOntoG2WithSwing(Object raw, int pageIndex, int currentIndent, int currentRotation, Map componentsToIgnore, FormFactory formFactory, int pageHeight) {
        FormObject formObject;
        Component comp;
        boolean isPrinting;
        this.componentsToIgnore = componentsToIgnore;
        boolean bl = isPrinting = formFactory != null;
        if (JVMBugRightAlignFix && isPrinting) {
            this.maxLengthForTextOnPage = 0;
            for (Object o : this.formsOrdered[pageIndex]) {
                JTextField text;
                int newLength;
                if (o == null || !((comp = (Component)this.checkGUIObjectResolved(formObject = (FormObject)o)) instanceof JTextField) || (newLength = (text = (JTextField)comp).getText().length()) <= this.maxLengthForTextOnPage || text.getHorizontalAlignment() != 4) continue;
                this.maxLengthForTextOnPage = newLength;
            }
        }
        Graphics2D g2 = (Graphics2D)raw;
        AffineTransform defaultAf = g2.getTransform();
        AffineTransform aff = g2.getTransform();
        aff.scale(1.0, -1.0);
        aff.translate(0.0, -pageHeight - this.insetH);
        g2.setTransform(aff);
        if (this.dummyPanel == null) {
            this.dummyPanel = new JFrame();
            this.dummyPanel.setDefaultCloseOperation(2);
            this.dummyPanel.pack();
        }
        for (Object nextVal : this.formsOrdered[pageIndex]) {
            Icon obj;
            boolean[] flags;
            if (nextVal == null || (flags = (formObject = (FormObject)nextVal).getCharacteristics())[1] || isPrinting && !flags[2]) continue;
            this.checkGUIObjectResolved(formObject);
            comp = (Component)formObject.getGUIComponent();
            if (comp == null || !comp.isVisible()) continue;
            Rectangle bounds = formObject.getBoundingRectangle();
            float boundHeight = bounds.height;
            int swingHeight = comp.getPreferredSize().height + 6;
            if (this.componentsToIgnore != null && (this.componentsToIgnore.containsKey(formObject.getParameterConstant(1147962727)) || this.componentsToIgnore.containsKey(formObject.getParameterConstant(608780341)))) continue;
            if (comp instanceof JList && ((JList)comp).getSelectedIndex() != -1 && boundHeight < (float)swingHeight) {
                JList comp2 = (JList)comp;
                this.dummyPanel.add(comp);
                ListModel model = comp2.getModel();
                Object[] array = new Object[model.getSize()];
                int selectedIndex = comp2.getSelectedIndex();
                int c = 0;
                array[c++] = model.getElementAt(selectedIndex);
                for (int i = 0; i < array.length; ++i) {
                    if (i == selectedIndex) continue;
                    array[c++] = model.getElementAt(i);
                }
                comp2.setListData(array);
                comp2.setSelectedIndex(0);
                this.renderComponent(g2, formObject, comp2, currentRotation, false, currentIndent, isPrinting);
                this.dummyPanel.remove(comp2);
                continue;
            }
            boolean customPrintoverRide = false;
            if (this.customFormPrint != null) {
                this.scaleComponent(formObject, 1.0f, this.rotation, comp, false, this.indent, isPrinting);
                customPrintoverRide = this.customFormPrint.print(g2, formObject, this);
            }
            if (customPrintoverRide) continue;
            if (comp instanceof AbstractButton && (obj = ((AbstractButton)comp).getIcon()) != null) {
                if (obj instanceof FixImageIcon) {
                    ((FixImageIcon)obj).setPrinting(true, 1);
                } else if (readOnlyScaling > 0 && obj instanceof ReadOnlyTextIcon) {
                    ((ReadOnlyTextIcon)obj).setPrinting(true, readOnlyScaling);
                }
            }
            this.dummyPanel.add(comp);
            this.renderComponent(g2, formObject, comp, currentRotation, false, currentIndent, isPrinting);
            this.dummyPanel.remove(comp);
            if (!(comp instanceof AbstractButton)) continue;
            obj = ((AbstractButton)comp).getIcon();
            if (obj instanceof FixImageIcon) {
                ((FixImageIcon)obj).setPrinting(false, 1);
                continue;
            }
            if (!(obj instanceof ReadOnlyTextIcon)) continue;
            ((ReadOnlyTextIcon)obj).setPrinting(false, 1);
        }
        g2.setTransform(defaultAf);
        if (this.currentPage == pageIndex && this.panel != null) {
            this.resetScaledLocation(this.displayScaling, this.rotation, this.indent);
        }
    }

    private void renderFormsOntoG2WithHTML(int pageIndex, Map componentsToIgnore) {
        this.componentsToIgnore = componentsToIgnore;
        for (Object nextVal : this.formsOrdered[pageIndex]) {
            if (nextVal == null) continue;
            FormObject formObject = (FormObject)nextVal;
            this.checkGUIObjectResolved(formObject);
        }
    }

    private void scaleComponent(FormObject formObject, float scale, int rotate, Component curComp, boolean redraw, int indent, boolean isPrinting) {
        String layerName;
        if (curComp == null || formObject.getPageNumber() == -1) {
            return;
        }
        int curPage = formObject.getPageNumber();
        if (this.layers != null && (layerName = formObject.getLayerName()) != null && this.layers.isLayerName(layerName)) {
            boolean isVisible = this.layers.isVisible(layerName);
            curComp.setVisible(isVisible);
        }
        int[] bounds = formObject.getParameterConstant(1147962727) == 1061176672 && !isPrinting ? this.cropComponent(formObject, scale, rotate, redraw, true) : this.cropComponent(formObject, scale, rotate, redraw, false);
        Font resetFont = curComp.getFont();
        if (resetFont != null) {
            if (formObject.getParameterConstant(1147962727) != 1061176672) {
                SwingData.recalcFontSize(scale, rotate, formObject, curComp);
            } else if (isPrinting) {
                curComp.setFont(curComp.getFont().deriveFont(formObject.getFontSize() * 0.75f));
            } else {
                curComp.setFont(curComp.getFont().deriveFont(formObject.getFontSize()));
            }
        }
        if (curComp instanceof JComponent && ((JComponent)curComp).getBorder() != null && formObject != null) {
            ((JComponent)curComp).setBorder((Border)SwingData.generateBorderfromForm(formObject, scale));
        }
        if (this.xReached != null) {
            bounds[0] = bounds[0] + this.xReached[curPage];
            bounds[1] = bounds[1] + this.yReached[curPage];
        }
        int pageWidth = (this.pageData.getRotation(curPage) + rotate) % 180 == 90 ? this.pageData.getCropBoxHeight(curPage) : this.pageData.getCropBoxWidth(curPage);
        if (this.displayView == 2) {
            double newIndent = rotate == 0 || rotate == 180 ? (double)((this.widestPageNR - pageWidth) / 2) : (double)((this.widestPageR - pageWidth) / 2);
            indent = (int)((double)indent + newIndent * (double)scale);
        }
        int totalOffsetX = this.userX + indent + this.insetW;
        int totalOffsetY = this.userY + this.insetH;
        Rectangle boundRect = new Rectangle(totalOffsetX + bounds[0], totalOffsetY + bounds[1], bounds[2], bounds[3]);
        curComp.setBounds(boundRect);
        if (curComp instanceof AbstractButton) {
            AbstractButton but = (AbstractButton)curComp;
            Icon curIcon = but.getIcon();
            boolean displaySingle = false;
            if (this.displayView == 1 || this.displayView == 0) {
                displaySingle = true;
            }
            if (curIcon instanceof FixImageIcon) {
                ((FixImageIcon)curIcon).setAttributes(curComp.getWidth(), curComp.getHeight(), rotate, displaySingle);
            } else if (curIcon instanceof ReadOnlyTextIcon) {
                ((ReadOnlyTextIcon)curIcon).setAttributes(curComp.getWidth(), curComp.getHeight(), rotate, displaySingle);
            }
            curIcon = but.getPressedIcon();
            if (curIcon instanceof FixImageIcon) {
                ((FixImageIcon)curIcon).setAttributes(curComp.getWidth(), curComp.getHeight(), rotate, displaySingle);
            }
            if ((curIcon = but.getSelectedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)curIcon).setAttributes(curComp.getWidth(), curComp.getHeight(), rotate, displaySingle);
            }
            if ((curIcon = but.getRolloverIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)curIcon).setAttributes(curComp.getWidth(), curComp.getHeight(), rotate, displaySingle);
            }
            if ((curIcon = but.getRolloverSelectedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)curIcon).setAttributes(curComp.getWidth(), curComp.getHeight(), rotate, displaySingle);
            }
        }
    }

    private static void recalcFontSize(float scale, int rotate, FormObject formObject, Component curComp) {
        int size = GUIData.getFontSize(formObject, rotate, scale);
        Font resetFont = curComp.getFont();
        Font newFont = new Font(resetFont.getFontName(), resetFont.getStyle(), size);
        curComp.setFont(newFont);
    }

    @Override
    public void setAutoFontSize(FormObject formObject) {
        SwingData.recalcFontSize(this.displayScaling, this.rotation, formObject, (Component)formObject.getGUIComponent());
    }

    public static Object generateBorderfromForm(FormObject form, float scaling) {
        float[] BC = form.getDictionary(7451).getFloatArray(4627);
        if (BC == null && form.getParameterConstant(1147962727) == 1110792305) {
            BC = form.getFloatArray(19);
        }
        Border newBorder = JPedalBorderFactory.createBorderStyle(form.getDictionary(4643), FormObject.generateColor(BC), Color.white, scaling);
        if (form.isXFAObject()) {
            int[] t = form.getMatteBorderDetails();
            newBorder = BorderFactory.createMatteBorder(t[0], t[3], t[2], t[1], Color.black);
        }
        return newBorder;
    }

    private int[] cropComponent(FormObject formObject, float s, int r, boolean redraw, boolean positionOnly) {
        int h;
        int w;
        Rectangle rect = formObject.getBoundingRectangle();
        int curPage = formObject.getPageNumber();
        float[] box = new float[]{rect.x, rect.y, rect.width + rect.x, rect.height + rect.y};
        if (this.displayView != 1 && this.displayView != 0) {
            r = (r + this.pageData.getRotation(curPage)) % 360;
        }
        int cropX = this.pageData.getCropBoxX(curPage);
        int cropY = this.pageData.getCropBoxY(curPage);
        int cropW = this.pageData.getCropBoxWidth(curPage);
        int mediaW = this.pageData.getMediaBoxWidth(curPage);
        int mediaH = this.pageData.getMediaBoxHeight(curPage);
        int cropOtherX = mediaW - cropW - cropX;
        float x100 = 0.0f;
        float y100 = 0.0f;
        float w100 = 0.0f;
        float h100 = 0.0f;
        switch (r) {
            case 0: {
                x100 = box[0];
                if (redraw) {
                    x100 -= (float)cropX;
                }
                y100 = (float)mediaH - box[3] - (float)this.cropOtherY[curPage] + 1.0f;
                w100 = box[2] - box[0];
                h100 = box[3] - box[1];
                break;
            }
            case 90: {
                x100 = box[1] - (float)cropY;
                y100 = box[0] - (float)cropX + 1.0f;
                if (!positionOnly) {
                    w100 = box[3] - box[1];
                    h100 = box[2] - box[0];
                    break;
                }
                w100 = box[2] - box[0];
                h100 = box[3] - box[1];
                break;
            }
            case 180: {
                w100 = box[2] - box[0];
                h100 = box[3] - box[1];
                if (!positionOnly) {
                    y100 = box[1] - (float)cropY + 1.0f;
                    x100 = (float)mediaW - box[2] - (float)cropOtherX;
                    break;
                }
                w100 = box[2] - box[0];
                h100 = box[3] - box[1];
                break;
            }
            case 270: {
                if (!positionOnly) {
                    w100 = box[3] - box[1];
                    h100 = box[2] - box[0];
                } else {
                    w100 = box[2] - box[0];
                    h100 = box[3] - box[1];
                }
                x100 = (float)mediaH - box[3] - (float)this.cropOtherY[curPage];
                y100 = (float)mediaW - box[2] - (float)cropOtherX + 1.0f;
            }
        }
        int x = (int)(x100 * s);
        int y = (int)(y100 * s);
        if (!positionOnly) {
            w = (int)(w100 * s);
            h = (int)(h100 * s);
        } else {
            w = (int)(w100 * this.dpi / 72.0f);
            h = (int)(h100 * this.dpi / 72.0f);
        }
        return new int[]{x, y, w, h};
    }

    @Override
    protected void removeAllComponentsFromScreen() {
        if (this.panel != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.panel.removeAll();
            } else {
                Runnable doPaintComponent = new Runnable(){

                    @Override
                    public void run() {
                        SwingData.this.panel.removeAll();
                    }
                };
                SwingUtilities.invokeLater(doPaintComponent);
            }
        }
    }

    @Override
    public void setRootDisplayComponent(final Object rootComp) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.panel = (JPanel)rootComp;
        } else {
            Runnable doPaintComponent = new Runnable(){

                @Override
                public void run() {
                    SwingData.this.panel = (JPanel)rootComp;
                }
            };
            SwingUtilities.invokeLater(doPaintComponent);
        }
    }

    @Override
    public void setGUIComp(FormObject formObject, Object rawField) {
        Component retComponent = (Component)rawField;
        String name2 = formObject.getTextStreamValue(36);
        if (name2 != null) {
            String stateToCheck = formObject.getNormalOnState();
            if (stateToCheck != null && !stateToCheck.isEmpty()) {
                name2 = name2 + "-(" + stateToCheck + ')';
            }
            retComponent.setName(name2);
        }
        this.scaleComponent(formObject, this.displayScaling, this.rotation, retComponent, true, this.indent, false);
    }

    @Override
    public void resetScaledLocation(final float currentScaling, final int currentRotation, int currentIndent) {
        if (this.formsUnordered == null || this.panel == null || this.startPage == 0) {
            return;
        }
        if (this.forceRedraw || currentScaling != this.lastScaling || (float)currentRotation != this.oldRotation || (float)currentIndent != this.oldIndent) {
            this.oldRotation = currentRotation;
            this.lastScaling = currentScaling;
            this.oldIndent = currentIndent;
            this.forceRedraw = false;
            for (int currentPage = this.startPage; currentPage < this.endPage; ++currentPage) {
                int count = this.formsOrdered[currentPage] == null ? 0 : this.formsOrdered[currentPage].size();
                for (int j = 0; j < count; ++j) {
                    FormObject formObject = (FormObject)this.formsOrdered[currentPage].get(j);
                    formObject.setCurrentScaling(currentScaling);
                    Component rawComp = (Component)formObject.getGUIComponent();
                    if (rawComp != null && formObject.getBoundingRectangle().height < rawComp.getPreferredSize().height && rawComp instanceof JList) {
                        JList comp = (JList)rawComp;
                        rawComp = SwingData.wrapComponentInScrollPane(comp);
                        formObject.setGUIComponent(comp, 1);
                        int index = comp.getSelectedIndex();
                        if (index > -1) {
                            comp.ensureIndexIsVisible(index);
                        }
                    }
                    if (SwingUtilities.isEventDispatchThread()) {
                        if (rawComp == null) continue;
                        this.panel.remove(rawComp);
                        this.scaleComponent(formObject, currentScaling, currentRotation, rawComp, true, this.indent, false);
                        this.panel.add(rawComp);
                        continue;
                    }
                    final Component finalComp = rawComp;
                    final FormObject fo = formObject;
                    Runnable doPaintComponent = new Runnable(){

                        @Override
                        public void run() {
                            SwingData.this.panel.remove(finalComp);
                            SwingData.this.scaleComponent(fo, currentScaling, currentRotation, finalComp, true, SwingData.this.indent, false);
                            SwingData.this.panel.add(finalComp);
                        }
                    };
                    SwingUtilities.invokeLater(doPaintComponent);
                }
            }
        }
    }

    @Override
    void removeHiddenForms(int startPage, int endPage) {
        for (int page = startPage; page < endPage; ++page) {
            if (this.formsOrdered[page] == null) continue;
            for (Object o : this.formsOrdered[page]) {
                FormObject formObject;
                Object comp;
                if (o == null || (comp = (formObject = (FormObject)o).getGUIComponent()) == null) continue;
                this.panel.remove((JComponent)comp);
            }
        }
    }

    private static Component wrapComponentInScrollPane(JList comp) {
        JScrollPane scroll = new JScrollPane(comp);
        scroll.setVerticalScrollBarPolicy(20);
        scroll.setHorizontalScrollBarPolicy(30);
        scroll.setLocation(comp.getLocation());
        scroll.setPreferredSize(comp.getPreferredSize());
        scroll.setSize(comp.getSize());
        return scroll;
    }

    @Override
    protected void displayComponent(final FormObject formObject, final Object comp) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.scaleComponent(formObject, this.displayScaling, this.rotation, (Component)comp, true, this.indent, false);
        } else {
            Runnable doPaintComponent = new Runnable(){

                @Override
                public void run() {
                    SwingData.this.scaleComponent(formObject, SwingData.this.displayScaling, SwingData.this.rotation, (Component)comp, true, SwingData.this.indent, false);
                }
            };
            SwingUtilities.invokeLater(doPaintComponent);
        }
    }

    @Override
    public void setCustomPrintInterface(CustomFormPrint customFormPrint) {
        this.customFormPrint = customFormPrint;
    }

    static {
        readOnlyScaling = -1;
    }
}

