/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.actions.JavaFX;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;

public class JavaFXControlListener {
    private static final boolean debug = false;
    private final Control comp;
    private final EventHandler<MouseEvent> mouseHandler;
    private final EventHandler<TouchEvent> touchHandler;
    private final EventHandler<KeyEvent> keyHandler;
    private final ChangeListener<Boolean> focusHandler;
    private List<EventHandler<MouseEvent>> pressed;
    private List<EventHandler<MouseEvent>> clicked;
    private List<EventHandler<MouseEvent>> released;
    private List<EventHandler<MouseEvent>> entered;
    private List<EventHandler<MouseEvent>> exited;
    private List<EventHandler<MouseEvent>> dragged;
    private List<EventHandler<MouseEvent>> moved;
    private List<EventHandler<TouchEvent>> touchPressed;
    private List<EventHandler<TouchEvent>> touchReleased;
    private List<EventHandler<KeyEvent>> keyReleased;
    private List<EventHandler<KeyEvent>> keyPressed;
    private List<ChangeListener<Boolean>> focusEvents;

    public JavaFXControlListener(Control comp) {
        this.comp = comp;
        this.mouseHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                JavaFXControlListener.this.handleMouseEvent(event);
            }
        };
        this.touchHandler = new EventHandler<TouchEvent>(){

            public void handle(TouchEvent event) {
                JavaFXControlListener.this.handleTouchEvent(event);
            }
        };
        this.keyHandler = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                JavaFXControlListener.this.handleKeyEvent(event);
            }
        };
        this.focusHandler = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                JavaFXControlListener.this.handleFocusEvent((ObservableValue<? extends Boolean>)observable, oldValue, newValue);
            }
        };
    }

    private void handleMouseEvent(MouseEvent event) {
        if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
            JavaFXControlListener.executeMouseEvent(this.clicked, event);
        } else if (event.getEventType().equals(MouseEvent.MOUSE_ENTERED)) {
            JavaFXControlListener.executeMouseEvent(this.entered, event);
        } else if (event.getEventType().equals(MouseEvent.MOUSE_EXITED)) {
            JavaFXControlListener.executeMouseEvent(this.exited, event);
        } else if (event.getEventType().equals(MouseEvent.MOUSE_PRESSED)) {
            JavaFXControlListener.executeMouseEvent(this.pressed, event);
        } else if (event.getEventType().equals(MouseEvent.MOUSE_RELEASED)) {
            JavaFXControlListener.executeMouseEvent(this.released, event);
        } else if (event.getEventType().equals(MouseEvent.MOUSE_DRAGGED)) {
            JavaFXControlListener.executeMouseEvent(this.dragged, event);
        } else if (event.getEventType().equals(MouseEvent.MOUSE_MOVED)) {
            JavaFXControlListener.executeMouseEvent(this.moved, event);
        }
    }

    private static void executeMouseEvent(List<EventHandler<MouseEvent>> events, MouseEvent mouseEvent) {
        if (events != null) {
            for (EventHandler<MouseEvent> event : events) {
                event.handle((Event)mouseEvent);
            }
        }
    }

    private void handleTouchEvent(TouchEvent event) {
        if (event.getEventType().equals(TouchEvent.TOUCH_PRESSED)) {
            JavaFXControlListener.executeTouchEvent(this.touchPressed, event);
        } else if (event.getEventType().equals(TouchEvent.TOUCH_RELEASED)) {
            JavaFXControlListener.executeTouchEvent(this.touchReleased, event);
        }
    }

    private static void executeTouchEvent(List<EventHandler<TouchEvent>> events, TouchEvent touchEvent) {
        if (events != null) {
            for (EventHandler<TouchEvent> event : events) {
                event.handle((Event)touchEvent);
            }
        }
    }

    private void handleKeyEvent(KeyEvent event) {
        if (event.getEventType().equals(KeyEvent.KEY_PRESSED)) {
            JavaFXControlListener.executeKeyEvent(this.keyPressed, event);
        } else if (event.getEventType().equals(KeyEvent.KEY_RELEASED)) {
            JavaFXControlListener.executeKeyEvent(this.keyReleased, event);
        }
    }

    private static void executeKeyEvent(List<EventHandler<KeyEvent>> events, KeyEvent keyEvent) {
        if (events != null) {
            for (EventHandler<KeyEvent> event : events) {
                event.handle((Event)keyEvent);
            }
        }
    }

    private void handleFocusEvent(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (this.focusEvents != null) {
            for (ChangeListener<Boolean> event : this.focusEvents) {
                event.changed(observable, (Object)oldValue, (Object)newValue);
            }
        }
    }

    public void addMouseListener(EventHandler<MouseEvent> handler) {
        this.addOnMouseClickedListener(handler);
        this.addOnMouseEnteredListener(handler);
        this.addOnMouseExitedListener(handler);
        this.addOnMousePressedListener(handler);
        this.addOnMouseReleasedListener(handler);
        this.addOnMouseDraggedListener(handler);
        this.addOnMouseMovedListener(handler);
    }

    public void addOnMouseClickedListener(EventHandler<MouseEvent> handler) {
        if (this.clicked == null) {
            this.clicked = new ArrayList<EventHandler<MouseEvent>>();
            this.comp.setOnMouseClicked(this.mouseHandler);
        }
        this.clicked.add(handler);
    }

    public void addOnMousePressedListener(EventHandler<MouseEvent> handler) {
        if (this.pressed == null) {
            this.pressed = new ArrayList<EventHandler<MouseEvent>>();
            this.comp.setOnMousePressed(this.mouseHandler);
        }
        this.pressed.add(handler);
    }

    public void addOnMouseReleasedListener(EventHandler<MouseEvent> handler) {
        if (this.released == null) {
            this.released = new ArrayList<EventHandler<MouseEvent>>();
            this.comp.setOnMouseReleased(this.mouseHandler);
        }
        this.released.add(handler);
    }

    public void addOnMouseEnteredListener(EventHandler<MouseEvent> handler) {
        if (this.entered == null) {
            this.entered = new ArrayList<EventHandler<MouseEvent>>();
            this.comp.setOnMouseEntered(this.mouseHandler);
        }
        this.entered.add(handler);
    }

    public void addOnMouseExitedListener(EventHandler<MouseEvent> handler) {
        if (this.exited == null) {
            this.exited = new ArrayList<EventHandler<MouseEvent>>();
            this.comp.setOnMouseExited(this.mouseHandler);
        }
        this.exited.add(handler);
    }

    public void addOnMouseDraggedListener(EventHandler<MouseEvent> handler) {
        if (this.dragged == null) {
            this.dragged = new ArrayList<EventHandler<MouseEvent>>();
            this.comp.setOnMouseExited(this.mouseHandler);
        }
        this.dragged.add(handler);
    }

    public void addOnMouseMovedListener(EventHandler<MouseEvent> handler) {
        if (this.moved == null) {
            this.moved = new ArrayList<EventHandler<MouseEvent>>();
            this.comp.setOnMouseExited(this.mouseHandler);
        }
        this.moved.add(handler);
    }

    public void addOnTouchPressedListener(EventHandler<TouchEvent> handler) {
        if (this.touchPressed == null) {
            this.touchPressed = new ArrayList<EventHandler<TouchEvent>>();
            this.comp.setOnTouchPressed(this.touchHandler);
        }
        this.touchPressed.add(handler);
    }

    public void addOnTouchReleasedListener(EventHandler<TouchEvent> handler) {
        if (this.touchReleased == null) {
            this.touchReleased = new ArrayList<EventHandler<TouchEvent>>();
            this.comp.setOnTouchReleased(this.touchHandler);
        }
        this.touchReleased.add(handler);
    }

    public void addKeyListener(EventHandler<KeyEvent> handler) {
        this.addOnKeyPressedListener(handler);
        this.addOnKeyReleasedListener(handler);
    }

    public void addOnKeyReleasedListener(EventHandler<KeyEvent> handler) {
        if (this.keyReleased == null) {
            this.keyReleased = new ArrayList<EventHandler<KeyEvent>>();
            this.comp.setOnKeyReleased(this.keyHandler);
        }
        this.keyReleased.add(handler);
    }

    public void addOnKeyPressedListener(EventHandler<KeyEvent> handler) {
        if (this.keyPressed == null) {
            this.keyPressed = new ArrayList<EventHandler<KeyEvent>>();
            this.comp.setOnKeyPressed(this.keyHandler);
        }
        this.keyPressed.add(handler);
    }

    public void addFocusEvent(ChangeListener<Boolean> handler) {
        if (this.focusEvents == null) {
            this.focusEvents = new ArrayList<ChangeListener<Boolean>>();
            this.comp.focusedProperty().addListener(this.focusHandler);
        }
        this.focusEvents.add(handler);
    }
}

