/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.actions;

import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import org.jpedal.PdfDecoderFX;
import org.jpedal.display.GUIDisplay;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.JavaFxGUI;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.actions.SharedActionHandler;
import org.jpedal.objects.acroforms.javafx.JavaFXSummary;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class JavaFXDefaultActionHandler
extends SharedActionHandler {
    public JavaFXDefaultActionHandler(GUIFactory currentGUI) {
        super(currentGUI);
    }

    @Override
    public void changeTo(String file, int page, Object location, Integer type, boolean storeView) {
        JavaFxGUI javaFXGUI;
        PdfDecoderFX decode_pdf;
        Object gui;
        if (file != null) {
            try {
                gui = (GUI)this.decode_pdf.getExternalHandler(11);
                if (gui != null) {
                    gui.stopThumbnails();
                }
                if (file.startsWith("http://") || file.startsWith("ftp://") || file.startsWith("https:")) {
                    if (gui != null) {
                        gui.getCommand().executeCommand(14, new Object[]{file});
                    } else {
                        this.decode_pdf.openPdfFileFromURL(file, true);
                    }
                } else if (gui != null) {
                    gui.getCommand().executeCommand(10, new Object[]{file});
                } else {
                    this.decode_pdf.openPdfFile(file);
                }
                if (page == -1) {
                    page = 1;
                }
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        if (page != -1 && this.decode_pdf.getPageCount() != 1 && (this.decode_pdf.getDisplayView() != 1 || this.decode_pdf.getDisplayView() == 1 && this.decode_pdf.getlastPageDecoded() != page) && page > 0 && page < this.decode_pdf.getPageCount() + 1) {
            try {
                decode_pdf = (PdfDecoderFX)this.decode_pdf;
                if (decode_pdf.getDisplayView() == 2 || decode_pdf.getDisplayView() == 3) {
                    // empty if block
                }
                this.decode_pdf.decodePage(page);
                if (page != -1) {
                    this.gui.setPage(page);
                }
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            this.decode_pdf.setPageParameters(-1.0f, page);
        }
        if (type != null && (gui = this.decode_pdf.getExternalHandler(11)) != null) {
            if (type < 0) {
                ((GUI)gui).setSelectedComboIndex(252, type + 3);
            } else {
                ((GUI)gui).setSelectedComboItem(252, type.toString());
            }
        }
        decode_pdf = (PdfDecoderFX)this.decode_pdf;
        if (location != null) {
            // empty if block
        }
        if ((javaFXGUI = (JavaFxGUI)decode_pdf.getExternalHandler(11)) != null) {
            javaFXGUI.scaleAndRotate();
            if (storeView) {
                javaFXGUI.getCommand().executeCommand(700, new Object[]{page, location, type});
            }
        }
    }

    @Override
    public Object setHoverCursor() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getEventType().equals(MouseEvent.MOUSE_ENTERED)) {
                    JavaFXDefaultActionHandler.this.setCursor(4);
                } else if (event.getEventType().equals(MouseEvent.MOUSE_EXITED)) {
                    JavaFXDefaultActionHandler.this.setCursor(5);
                }
            }
        };
    }

    @Override
    protected void setCursor(int eventType) {
        PdfDecoderFX decode_pdf = (PdfDecoderFX)this.decode_pdf;
        if (decode_pdf != null) {
            if (eventType == 4) {
                if (GUIDisplay.allowChangeCursor) {
                    decode_pdf.setCursor(Cursor.HAND);
                }
            } else if (eventType == 5 && GUIDisplay.allowChangeCursor) {
                decode_pdf.setCursor(Cursor.DEFAULT);
            }
        }
    }

    @Override
    protected void popup(Object raw, FormObject formObj, PdfObjectReader currentPdfFile) {
        if (((MouseEvent)raw).getClickCount() == 2) {
            FormObject popupObj = (FormObject)formObj.getDictionary(1061176672);
            currentPdfFile.checkResolved(popupObj);
            FormObject decodedObj = this.acrorend.getFormObject(popupObj.getObjectRefAsString());
            Object comp = decodedObj.getGUIComponent();
            if (comp != null) {
                Node popup = (Node)comp;
                if (popup.isVisible()) {
                    popup.setVisible(false);
                } else {
                    popup.setVisible(true);
                }
            }
        }
    }

    @Override
    public void V(Object ex, FormObject formObj, int actionID) {
        this.javascript.execute(formObj, 38, actionID, JavaFXDefaultActionHandler.getKeyPressed(ex));
    }

    @Override
    public int K(Object ex, FormObject formObj, int actionID) {
        return this.javascript.execute(formObj, 27, actionID, JavaFXDefaultActionHandler.getKeyPressed(ex));
    }

    public static char getKeyPressed(Object raw) {
        try {
            if (raw instanceof KeyEvent) {
                return ((KeyEvent)raw).getCharacter().charAt(0);
            }
            return ' ';
        }
        catch (Exception ee) {
            System.out.println("Exception " + ee);
            return ' ';
        }
    }

    @Override
    protected void showSig(PdfObject sigObject) {
        Stage frame = new Stage();
        JavaFXSummary summary = new JavaFXSummary(frame, sigObject);
        summary.setValues(sigObject.getTextStreamValue(506543413), sigObject.getTextStreamValue(826499443), sigObject.getTextStreamValue(1618506351));
        System.out.println("Name : " + sigObject.getTextStreamValue(506543413));
        System.out.println("Reason :" + sigObject.getTextStreamValue(826499443));
        System.out.println("Location :" + sigObject.getTextStreamValue(1618506351));
        Scene scene = new Scene((Parent)summary);
        frame.setScene(scene);
        frame.setScene(scene);
        frame.show();
    }
}

