/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import org.jpedal.utils.LogWriter;

public class SoundHandler {
    private static final int EXTERNAL_BUFFER_SIZE = 128000;
    private static int frameSize;
    private static float sampleRate;
    private static int sampleSizeInBits;
    private static int channels;
    private static AudioFormat.Encoding encoding;

    public static void setAudioFormat(int audioFormat, int b, float r, int c) {
        sampleSizeInBits = b;
        sampleRate = r;
        channels = c;
        if (audioFormat != 926832749) {
            if (audioFormat == 1551661165) {
                encoding = AudioFormat.Encoding.PCM_UNSIGNED;
            } else {
                throw new RuntimeException("AudioFormat currently unsupported! - ");
            }
        }
    }

    private static AudioFormat getAudioFormat() {
        frameSize = sampleSizeInBits / 8 * channels;
        int frameRate = (int)sampleRate;
        return new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, true);
    }

    public static AudioInputStream getAudioInputStream(byte[] data) {
        AudioFormat audioFormat = SoundHandler.getAudioFormat();
        long length = data.length / frameSize;
        return new AudioInputStream(new ByteArrayInputStream(data), audioFormat, length);
    }

    public static void PlaySound(byte[] data) throws Exception {
        AudioFormat audioFormat = SoundHandler.getAudioFormat();
        long length = data.length / frameSize;
        AudioInputStream ais = new AudioInputStream(new ByteArrayInputStream(data), audioFormat, length);
        SoundHandler.playSoundFromStream(ais);
    }

    private static void playSoundFromStream(AudioInputStream ais) {
        SourceDataLine line = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, ais.getFormat());
        try {
            line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(ais.getFormat());
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        line.start();
        int nBytesRead = 0;
        byte[] abData = new byte[128000];
        while (nBytesRead != -1) {
            try {
                nBytesRead = ais.read(abData, 0, abData.length);
            }
            catch (IOException e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            if (nBytesRead < 0) continue;
            line.write(abData, 0, nBytesRead);
        }
        line.drain();
        line.close();
    }

    static {
        sampleRate = 44100.0f;
        sampleSizeInBits = 16;
        channels = 2;
        encoding = AudioFormat.Encoding.PCM_SIGNED;
    }
}

