/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.creation;

import java.awt.BasicStroke;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.jpedal.objects.acroforms.creation.DashBorder;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;

public class JPedalBorderFactory {
    private static final boolean printouts = false;

    public static Border createBorderStyle(PdfObject BS, Color borderColor, Color borderBackgroundColor, float scaling) {
        int xfaBorderStyle;
        if (borderBackgroundColor == null) {
            // empty if block
        }
        if (borderColor == null) {
            return null;
        }
        Border insideBorder = null;
        int w = -1;
        if (BS != null) {
            w = BS.getInt(39);
        }
        if (w < 0) {
            w = 1;
        }
        float ws = (float)w * scaling;
        w = (int)((double)ws + 0.5);
        int style = 35;
        if (BS != null) {
            int xfaBorderStyle2;
            style = BS.getNameAsConstant(35);
            if (style == -1) {
                style = 35;
            }
            if ((xfaBorderStyle2 = BS.getNameAsConstant(40)) != -1) {
                w /= 2;
            }
        }
        switch (style) {
            case 37: {
                insideBorder = BorderFactory.createMatteBorder(0, 0, w, 0, borderColor);
                break;
            }
            case 25: {
                insideBorder = BorderFactory.createEtchedBorder(borderColor, borderBackgroundColor);
                break;
            }
            case 18: {
                insideBorder = BorderFactory.createBevelBorder(1, borderColor, borderBackgroundColor);
                break;
            }
            case 35: {
                insideBorder = BorderFactory.createLineBorder(borderColor, w);
                break;
            }
            case 20: {
                PdfArrayIterator dashPattern = BS.getMixedArray(20);
                int current_line_dash_phase = 0;
                float[] current_line_dash_array = new float[1];
                int count = dashPattern.getTokenCount();
                if (count > 0) {
                    current_line_dash_array = dashPattern.getNextValueAsFloatArray();
                }
                if (count > 1) {
                    current_line_dash_phase = dashPattern.getNextValueAsInteger();
                }
                if (w < 0) {
                    w = 1;
                }
                BasicStroke current_stroke = new BasicStroke(w, 0, 0, 1.0f, current_line_dash_array, current_line_dash_phase);
                insideBorder = new DashBorder(current_stroke, borderColor);
            }
        }
        Border outsideBorder = new EmptyBorder(0, 0, 0, 0);
        if (BS != null && (xfaBorderStyle = BS.getNameAsConstant(40)) != -1) {
            Border xfaBorder = BorderFactory.createLineBorder(borderColor, w);
            switch (xfaBorderStyle) {
                case 34: {
                    outsideBorder = xfaBorder;
                }
            }
        }
        return new CompoundBorder(outsideBorder, insideBorder);
    }
}

