/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.gui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jpedal.objects.acroforms.gui.certificates.CertificateHolder;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class Summary
extends JPanel {
    private final JDialog frame;
    private final PdfObject sigObject;
    private JTextField dateBox;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField locationBox;
    private JTextField reasonBox;
    private JButton showCertificateButton;
    private JTextField signedByBox;

    public void setValues(String signName, String reason, String location) {
        this.signedByBox.setText(signName);
        this.reasonBox.setText(reason);
        String rawDate = this.sigObject.getTextStreamValue(29);
        StringBuilder date = new StringBuilder(rawDate);
        date.delete(0, 2);
        date.insert(4, '/');
        date.insert(7, '/');
        date.insert(10, ' ');
        date.insert(13, ':');
        date.insert(16, ':');
        date.insert(19, ' ');
        this.dateBox.setText(date.toString());
        this.locationBox.setText(location);
    }

    public Summary(JDialog frame, PdfObject sig) {
        this.frame = frame;
        this.sigObject = sig;
        this.initComponents();
        byte[] bytes = this.sigObject.getTextStreamValueAsByte(322257476);
        if (bytes == null) {
            this.showCertificateButton.setEnabled(false);
        } else {
            this.showCertificateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Summary.this.showCertificate();
                }
            });
            this.add(this.showCertificateButton);
            this.showCertificateButton.setBounds(380, 10, 150, 23);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.locationBox = new JTextField();
        this.showCertificateButton = new JButton();
        this.signedByBox = new JTextField();
        this.reasonBox = new JTextField();
        this.jLabel4 = new JLabel();
        this.dateBox = new JTextField();
        this.jButton1 = new JButton();
        this.setLayout(null);
        this.jLabel1.setText("Location:");
        this.add(this.jLabel1);
        this.jLabel1.setBounds(310, 70, 70, 20);
        this.jLabel2.setText("Signed by:");
        this.add(this.jLabel2);
        this.jLabel2.setBounds(10, 10, 70, 20);
        this.jLabel3.setText("Reason:");
        this.add(this.jLabel3);
        this.jLabel3.setBounds(10, 40, 70, 20);
        this.locationBox.setEditable(false);
        this.add(this.locationBox);
        this.locationBox.setBounds(360, 70, 170, 20);
        this.showCertificateButton.setText("Show Certificate...");
        this.showCertificateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Summary.this.showCertificate();
            }
        });
        this.add(this.showCertificateButton);
        this.showCertificateButton.setBounds(380, 10, 150, 23);
        this.signedByBox.setEditable(false);
        this.add(this.signedByBox);
        this.signedByBox.setBounds(70, 10, 300, 20);
        this.reasonBox.setEditable(false);
        this.add(this.reasonBox);
        this.reasonBox.setBounds(70, 40, 460, 20);
        this.jLabel4.setText("Date:");
        this.add(this.jLabel4);
        this.jLabel4.setBounds(10, 70, 70, 20);
        this.dateBox.setEditable(false);
        this.add(this.dateBox);
        this.dateBox.setBounds(70, 70, 230, 20);
        this.jButton1.setText("Close");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Summary.this.close();
            }
        });
        this.add(this.jButton1);
        this.jButton1.setBounds(433, 140, 90, 23);
    }

    private void close() {
        this.frame.setVisible(false);
    }

    private void showCertificate() {
        JDialog frame = new JDialog((Frame)null, "Certificate Viewer", true);
        CertificateHolder ch = new CertificateHolder(frame);
        try {
            byte[] bytes = this.sigObject.getTextStreamValueAsByte(322257476);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate signingCertificate = (X509Certificate)cf.generateCertificate(bais);
            ((InputStream)bais).close();
            SimpleDateFormat format1 = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
            Date notBefore = signingCertificate.getNotBefore();
            Date notAfter = signingCertificate.getNotAfter();
            String publicKey = Summary.byteToHex(signingCertificate.getPublicKey().getEncoded());
            String x509Data = Summary.byteToHex(signingCertificate.getEncoded());
            String sha1Digest = Summary.byteToHex(Summary.getDigest(bytes, "SHA1"));
            String md5Digest = Summary.byteToHex(Summary.getDigest(bytes, "MD5"));
            String keyDescription = signingCertificate.getPublicKey().toString();
            int keyDescriptionEnd = keyDescription.indexOf(10);
            if (keyDescriptionEnd != -1) {
                keyDescription = keyDescription.substring(0, keyDescriptionEnd);
            }
            ch.setValues(this.sigObject.getTextStreamValue(506543413), signingCertificate.getVersion(), signingCertificate.getSigAlgName(), signingCertificate.getSubjectX500Principal().toString(), signingCertificate.getIssuerX500Principal().toString(), signingCertificate.getSerialNumber(), format1.format(notBefore), format1.format(notAfter), keyDescription, publicKey, x509Data, sha1Digest, md5Digest);
            frame.getContentPane().add(ch);
            frame.setSize(440, 450);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }

    private static byte[] getDigest(byte[] bytes, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest sha1 = MessageDigest.getInstance(algorithm);
        sha1.update(bytes);
        return sha1.digest();
    }

    private static String byteToHex(byte[] bytes) {
        StringBuilder hex = new StringBuilder();
        for (byte aByte : bytes) {
            String singleByte = Integer.toHexString(aByte);
            if (singleByte.startsWith("ffffff")) {
                singleByte = singleByte.substring(6, singleByte.length());
            } else if (singleByte.length() == 1) {
                singleByte = '0' + singleByte;
            }
            singleByte = singleByte.toUpperCase();
            hex.append(singleByte).append(' ');
        }
        return hex.toString();
    }
}

