/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.javafx;

import java.awt.Rectangle;
import javafx.application.Platform;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.transform.Transform;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.raw.FormObject;

public class JavaFXData
extends GUIData {
    private Pane panel;

    private void scaleComponent(FormObject formObject, int rotate, Region curComp, boolean redraw, int indent, boolean isPrinting) {
        int pageHeight;
        int pageWidth;
        String layerName;
        float scale = 1.0f;
        if (curComp == null || formObject.getPageNumber() == -1) {
            return;
        }
        int curPage = formObject.getPageNumber();
        if (this.layers != null && (layerName = formObject.getLayerName()) != null && this.layers.isLayerName(layerName)) {
            boolean isVisible = this.layers.isVisible(layerName);
            curComp.setVisible(isVisible);
        }
        int[] bounds = formObject.getParameterConstant(1147962727) == 1061176672 && !isPrinting ? this.cropComponent(formObject, scale, rotate, redraw, true) : this.cropComponent(formObject, scale, rotate, redraw, false);
        if (this.xReached != null) {
            bounds[0] = bounds[0] + this.xReached[curPage];
            bounds[1] = bounds[1] + this.yReached[curPage];
        }
        if ((this.pageData.getRotation(curPage) + rotate) % 180 == 90) {
            pageWidth = this.pageData.getCropBoxHeight(curPage);
            pageHeight = this.pageData.getCropBoxWidth(curPage);
        } else {
            pageWidth = this.pageData.getCropBoxWidth(curPage);
            pageHeight = this.pageData.getCropBoxHeight(curPage);
        }
        if (this.displayView == 2) {
            double newIndent = rotate == 0 || rotate == 180 ? (double)((this.widestPageNR - pageWidth) / 2) : (double)((this.widestPageR - pageWidth) / 2);
            indent = (int)((double)indent + newIndent * (double)scale);
        }
        int totalOffsetX = this.userX + indent;
        int totalOffsetY = this.userY;
        curComp.setPrefWidth((double)bounds[2]);
        curComp.setPrefHeight((double)bounds[3]);
        curComp.setTranslateX((double)(totalOffsetX + bounds[0]));
        curComp.setTranslateY((double)(pageHeight - (totalOffsetY + bounds[1])));
        curComp.getTransforms().clear();
        curComp.getTransforms().add((Object)Transform.affine((double)1.0, (double)0.0, (double)0.0, (double)-1.0, (double)0.0, (double)0.0));
    }

    private int[] cropComponent(FormObject formObject, float s, int r, boolean redraw, boolean positionOnly) {
        int h;
        int w;
        Rectangle rect = formObject.getBoundingRectangle();
        int curPage = formObject.getPageNumber();
        float[] box = new float[]{rect.x, rect.y, rect.width + rect.x, rect.height + rect.y};
        if (this.displayView != 1 && this.displayView != 0) {
            r = (r + this.pageData.getRotation(curPage)) % 360;
        }
        int cropX = this.pageData.getCropBoxX(curPage);
        int cropY = this.pageData.getCropBoxY(curPage);
        int cropW = this.pageData.getCropBoxWidth(curPage);
        int mediaW = this.pageData.getMediaBoxWidth(curPage);
        int mediaH = this.pageData.getMediaBoxHeight(curPage);
        int cropOtherX = mediaW - cropW - cropX;
        float x100 = 0.0f;
        float y100 = 0.0f;
        float w100 = 0.0f;
        float h100 = 0.0f;
        switch (r) {
            case 0: {
                x100 = box[0];
                if (redraw) {
                    x100 -= (float)cropX;
                }
                y100 = (float)mediaH - box[3] - (float)this.cropOtherY[curPage];
                w100 = box[2] - box[0];
                h100 = box[3] - box[1];
                break;
            }
            case 90: {
                x100 = box[1] - (float)cropY;
                y100 = box[0] - (float)cropX;
                w100 = box[3] - box[1];
                h100 = box[2] - box[0];
                break;
            }
            case 180: {
                w100 = box[2] - box[0];
                h100 = box[3] - box[1];
                y100 = box[1] - (float)cropY;
                x100 = (float)mediaW - box[2] - (float)cropOtherX;
                break;
            }
            case 270: {
                w100 = box[3] - box[1];
                h100 = box[2] - box[0];
                x100 = (float)mediaH - box[3] - (float)this.cropOtherY[curPage];
                y100 = (float)mediaW - box[2] - (float)cropOtherX;
            }
        }
        int x = (int)(x100 * s);
        int y = (int)(y100 * s);
        if (!positionOnly) {
            w = (int)(w100 * s);
            h = (int)(h100 * s);
        } else {
            w = (int)(w100 * this.dpi / 72.0f);
            h = (int)(h100 * this.dpi / 72.0f);
        }
        return new int[]{x, y, w, h};
    }

    @Override
    protected void removeAllComponentsFromScreen() {
        if (this.panel != null) {
            if (Platform.isFxApplicationThread()) {
                this.panel.getChildren().clear();
            } else {
                Runnable doPaintComponent = new Runnable(){

                    @Override
                    public void run() {
                        JavaFXData.this.panel.getChildren().clear();
                    }
                };
                Platform.runLater((Runnable)doPaintComponent);
            }
        }
    }

    @Override
    public void setRootDisplayComponent(Object rootComp) {
        this.panel = (Pane)rootComp;
    }

    @Override
    public void setGUIComp(FormObject formObject, Object rawField) {
        Region retComponent = (Region)rawField;
        String name2 = formObject.getTextStreamValue(36);
        if (name2 != null) {
            String stateToCheck = formObject.getNormalOnState();
            if (stateToCheck != null && !stateToCheck.isEmpty()) {
                name2 = name2 + "-(" + stateToCheck + ')';
            }
            retComponent.setId(name2);
        }
        this.scaleComponent(formObject, this.rotation, retComponent, true, this.indent, false);
    }

    @Override
    public void resetScaledLocation(float currentScaling, int currentRotation, int currentIndent) {
        if (this.formsUnordered == null || this.panel == null || this.startPage == 0) {
            return;
        }
        this.oldRotation = currentRotation;
        this.lastScaling = currentScaling;
        this.oldIndent = currentIndent;
        this.forceRedraw = false;
        for (int currentPage = this.startPage; currentPage < this.endPage; ++currentPage) {
            int count = this.formsOrdered[currentPage] == null ? 0 : this.formsOrdered[currentPage].size();
            for (int j = 0; j < count; ++j) {
                FormObject formObject = (FormObject)this.formsOrdered[currentPage].get(count - 1 - j);
                formObject.setCurrentScaling(currentScaling);
                Region rawComp = (Region)formObject.getGUIComponent();
                if (Platform.isFxApplicationThread()) {
                    if (rawComp == null) continue;
                    this.panel.getChildren().remove((Object)rawComp);
                    this.panel.getChildren().add((Object)rawComp);
                    continue;
                }
                final Region finalComp = rawComp;
                Runnable addControl = new Runnable(){

                    @Override
                    public void run() {
                        JavaFXData.this.panel.getChildren().remove((Object)finalComp);
                        JavaFXData.this.panel.getChildren().add((Object)finalComp);
                    }
                };
                Platform.runLater((Runnable)addControl);
            }
        }
    }

    @Override
    protected void displayComponent(final FormObject formObject, final Object comp) {
        if (Platform.isFxApplicationThread()) {
            this.scaleComponent(formObject, this.rotation, (Region)comp, true, this.indent, false);
        } else {
            Runnable doPaintComponent = new Runnable(){

                @Override
                public void run() {
                    JavaFXData.this.scaleComponent(formObject, JavaFXData.this.rotation, (Region)comp, true, JavaFXData.this.indent, false);
                }
            };
            Platform.runLater((Runnable)doPaintComponent);
        }
    }
}

