/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.javafx;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.jpedal.objects.acroforms.javafx.CertificateHolderFX;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class JavaFXSummary
extends Pane {
    private final Stage frame;
    private final PdfObject sigObject;
    private static TextField signedByBox = new TextField();
    private static TextField reasonBox = new TextField();
    private static TextField dateBox = new TextField();
    private static TextField locationBox = new TextField();

    public void setValues(String signName, String reason, String location) {
        signedByBox.setText(signName);
        reasonBox.setText(reason);
        String rawDate = this.sigObject.getTextStreamValue(29);
        StringBuilder date = new StringBuilder(rawDate);
        date.delete(0, 2);
        date.insert(4, '/');
        date.insert(7, '/');
        date.insert(10, ' ');
        date.insert(13, ':');
        date.insert(16, ':');
        date.insert(19, ' ');
        dateBox.setText(date.toString());
        locationBox.setText(location);
    }

    public JavaFXSummary(Stage stage, PdfObject sig) {
        this.frame = stage;
        this.sigObject = sig;
        this.initComponents();
    }

    private void initComponents() {
        Label locationLbl = new Label();
        Label signedByLbl = new Label();
        Label reasonLbl = new Label();
        Label dateLbl = new Label();
        Button showCertificateButton = new Button();
        Button closeButton = new Button();
        locationBox = new TextField();
        signedByBox = new TextField();
        reasonBox = new TextField();
        dateBox = new TextField();
        locationLbl.setText("Location: ");
        signedByLbl.setText("Signed by: ");
        reasonLbl.setText("Reason: ");
        dateLbl.setText("Date: ");
        closeButton.setText("Close");
        showCertificateButton.setText("Show Certificate...");
        locationBox.setEditable(false);
        reasonBox.setEditable(false);
        dateBox.setEditable(false);
        signedByBox.setEditable(false);
        reasonBox.setPrefWidth(400.0);
        byte[] bytes = this.sigObject.getTextStreamValueAsByte(322257476);
        if (bytes == null) {
            showCertificateButton.setDisable(true);
        } else {
            showCertificateButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    JavaFXSummary.this.showCertificate();
                }
            });
        }
        closeButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                JavaFXSummary.this.frame.close();
            }
        });
        VBox left = new VBox(20.0);
        left.getChildren().addAll((Object[])new Node[]{signedByLbl, reasonLbl, dateLbl, locationLbl});
        VBox middle = new VBox(8.0);
        middle.getChildren().addAll((Object[])new Node[]{signedByBox, reasonBox, dateBox, locationBox});
        middle.setPadding(new Insets(3.0, 0.0, 3.0, 0.0));
        HBox location = new HBox();
        location.getChildren().addAll((Object[])new Node[]{locationLbl, locationBox});
        locationBox.setAlignment(Pos.BOTTOM_CENTER);
        location.setAlignment(Pos.BOTTOM_CENTER);
        location.setPadding(new Insets(0.0, 0.0, 3.0, 0.0));
        StackPane right = new StackPane();
        right.getChildren().addAll((Object[])new Node[]{showCertificateButton, closeButton});
        StackPane.setAlignment((Node)closeButton, (Pos)Pos.BOTTOM_RIGHT);
        StackPane.setAlignment((Node)showCertificateButton, (Pos)Pos.TOP_RIGHT);
        HBox box = new HBox(3.0);
        box.getChildren().addAll((Object[])new Node[]{left, middle, location, right});
        this.getChildren().add((Object)box);
    }

    private void showCertificate() {
        Stage certificateStage = new Stage();
        CertificateHolderFX ch = new CertificateHolderFX(certificateStage);
        try {
            byte[] bytes = this.sigObject.getTextStreamValueAsByte(322257476);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate signingCertificate = (X509Certificate)cf.generateCertificate(bais);
            ((InputStream)bais).close();
            SimpleDateFormat format1 = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
            Date notBefore = signingCertificate.getNotBefore();
            Date notAfter = signingCertificate.getNotAfter();
            String publicKey = JavaFXSummary.byteToHex(signingCertificate.getPublicKey().getEncoded());
            String x509Data = JavaFXSummary.byteToHex(signingCertificate.getEncoded());
            String sha1Digest = JavaFXSummary.byteToHex(JavaFXSummary.getDigest(bytes, "SHA1"));
            String md5Digest = JavaFXSummary.byteToHex(JavaFXSummary.getDigest(bytes, "MD5"));
            String keyDescription = signingCertificate.getPublicKey().toString();
            int keyDescriptionEnd = keyDescription.indexOf(10);
            if (keyDescriptionEnd != -1) {
                keyDescription = keyDescription.substring(0, keyDescriptionEnd);
            }
            ch.setValues(this.sigObject.getTextStreamValue(506543413), signingCertificate.getVersion(), signingCertificate.getSigAlgName(), signingCertificate.getSubjectX500Principal().toString(), signingCertificate.getIssuerX500Principal().toString(), signingCertificate.getSerialNumber(), format1.format(notBefore), format1.format(notAfter), keyDescription, publicKey, x509Data, sha1Digest, md5Digest);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }

    private static byte[] getDigest(byte[] bytes, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest sha1 = MessageDigest.getInstance(algorithm);
        sha1.update(bytes);
        return sha1.digest();
    }

    private static String byteToHex(byte[] bytes) {
        StringBuilder hex = new StringBuilder();
        for (byte aByte : bytes) {
            String singleByte = Integer.toHexString(aByte);
            if (singleByte.startsWith("ffffff")) {
                singleByte = singleByte.substring(6, singleByte.length());
            } else if (singleByte.length() == 1) {
                singleByte = '0' + singleByte;
            }
            singleByte = singleByte.toUpperCase();
            hex.append(singleByte).append(' ');
        }
        return hex.toString();
    }
}

