/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.javafx;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.jpedal.objects.raw.FormObject;

public class PdfJavaFXPopup
extends Pane {
    private final FormObject form;
    private VBox content;
    private Rectangle dragBar;
    private double offX;
    private double offY;

    PdfJavaFXPopup(FormObject form) {
        this.form = form;
        this.createContent();
        this.setupListeners();
        this.getChildren().add((Object)this.content);
    }

    private void createContent() {
        String t;
        String contents;
        this.content = new VBox();
        this.content.getStyleClass().add((Object)"popupAnnot");
        String m = "";
        if (this.form.getParentPdfObj() != null) {
            contents = PdfJavaFXPopup.checkString(this.form.getParentPdfObj().getTextStreamValue(1216184967));
            m = PdfJavaFXPopup.formatDate(this.form);
            t = PdfJavaFXPopup.checkString(this.form.getParentPdfObj().getTextStreamValue(36));
        } else {
            contents = PdfJavaFXPopup.checkString(this.form.getTextStreamValue(1216184967));
            t = PdfJavaFXPopup.checkString(this.form.getTextStreamValue(36));
        }
        this.content.setPrefWidth(200.0);
        this.content.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        this.dragBar = new Rectangle();
        Label author = new Label(t);
        Label date = new Label(m);
        TextArea text = new TextArea(contents);
        this.dragBar.setHeight(15.0);
        this.dragBar.widthProperty().bind((ObservableValue)this.content.prefWidthProperty());
        this.dragBar.getStyleClass().add((Object)"dragbar");
        VBox.setVgrow((Node)text, (Priority)Priority.ALWAYS);
        author.setWrapText(true);
        date.setWrapText(true);
        text.setWrapText(true);
        author.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)16.0));
        float[] col = this.form.getFloatArray(19);
        String color = col != null ? (col[0] > 1.0f || col[1] > 1.0f || col[2] > 1.0f ? "rgb(" + col[0] + ", " + col[1] + ", " + col[2] + ')' : "rgb(" + col[0] * 255.0f + ", " + col[1] * 255.0f + ", " + col[2] * 255.0f + ')') : "rgb(255,255,0)";
        this.content.setStyle("-fx-border-color:" + color + ';');
        this.dragBar.setStyle("-fx-fill:" + color + ';');
        this.content.getChildren().addAll((Object[])new Node[]{this.dragBar, author, date, text});
    }

    private static String formatDate(FormObject form) {
        String m = form.getParentPdfObj().getTextStreamValue(29);
        if (m != null) {
            StringBuilder mDate = new StringBuilder(m);
            mDate.delete(0, 2);
            mDate.insert(10, ':');
            mDate.insert(13, ':');
            mDate.delete(16, mDate.length());
            mDate.insert(16, " GMT");
            String year = mDate.substring(0, 4);
            String day = mDate.substring(6, 8);
            mDate.delete(6, 8);
            mDate.delete(0, 4);
            mDate.insert(0, day);
            mDate.insert(4, year);
            mDate.insert(2, '/');
            mDate.insert(5, '/');
            mDate.insert(10, ' ');
            m = mDate.toString();
        } else {
            m = "";
        }
        return m;
    }

    private static String checkString(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    private void setupListeners() {
        this.dragBar.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    PdfJavaFXPopup.this.setVisible(false);
                }
            }
        });
        this.dragBar.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                PdfJavaFXPopup.this.offX = event.getX();
                PdfJavaFXPopup.this.offY = event.getY();
                PdfJavaFXPopup.this.toFront();
            }
        });
        this.dragBar.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                double newX = PdfJavaFXPopup.this.getTranslateX() + event.getX() - PdfJavaFXPopup.this.offX;
                double newY = PdfJavaFXPopup.this.getTranslateY() - event.getY() + PdfJavaFXPopup.this.offY;
                if (newX < 0.0) {
                    newX = 0.0;
                } else if (newX - PdfJavaFXPopup.this.offX - PdfJavaFXPopup.this.content.getWidth() > PdfJavaFXPopup.this.getScene().getWidth()) {
                    newX = PdfJavaFXPopup.this.getScene().getWidth() + PdfJavaFXPopup.this.content.getWidth();
                }
                if (newY < 0.0) {
                    newY = 0.0;
                }
                PdfJavaFXPopup.this.setTranslateX(newX);
                PdfJavaFXPopup.this.setTranslateY(newY);
                event.consume();
            }
        });
        this.visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean wasVisible, Boolean nowVisibile) {
                if (nowVisibile.booleanValue()) {
                    PdfJavaFXPopup.this.toFront();
                }
            }
        });
    }
}

