/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.overridingImplementations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.overridingImplementations.CustomImageIcon;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfObject;

public class FixImageIcon
extends CustomImageIcon
implements Icon,
SwingConstants {
    private static final long serialVersionUID = 8946195842453749725L;
    final PdfObject formObject;
    private boolean currentlyPrinting;
    private int printMultiplier = 1;
    private int selected = -1;
    private static final int UNSELECTEDICON = 0;
    private static final int SELECTEDICON = 1;
    private BufferedImage rootImageSelected;
    private BufferedImage rootImageUnselected;
    private BufferedImage imageSelected;
    private BufferedImage imageUnselected;
    private PdfObject selObj;
    private PdfObject unSelObj;
    private PdfObjectReader currentpdffile;
    private int subtype;
    private int offsetImage;

    public FixImageIcon(PdfObject formObject, BufferedImage img, int iconRot) {
        super(iconRot);
        this.formObject = formObject;
        this.imageSelected = img != null ? img : FormObject.getOpaqueImage();
        this.selected = -1;
    }

    public FixImageIcon(PdfObject formObject, PdfObject imgObj, int iconRot, PdfObjectReader pdfObjectReader, int type, int offset) {
        super(iconRot);
        this.formObject = formObject;
        this.selObj = imgObj;
        this.selected = -1;
        this.currentpdffile = pdfObjectReader;
        this.subtype = type;
        this.offsetImage = offset;
    }

    public FixImageIcon(PdfObject formObject, PdfObject selObject, PdfObject unselObject, int iconRot, int sel, PdfObjectReader pdfObjectReader, int type, int offset) {
        super(iconRot);
        this.formObject = formObject;
        this.selObj = selObject;
        this.unSelObj = unselObject;
        this.selected = sel;
        this.currentpdffile = pdfObjectReader;
        this.subtype = type;
        this.offsetImage = offset;
    }

    @Override
    public Image getImage() {
        BufferedImage image;
        this.checkAndCreateimage();
        switch (this.selected) {
            case 0: {
                image = this.imageUnselected;
                break;
            }
            default: {
                image = this.imageSelected;
            }
        }
        return image;
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        BufferedImage image = (BufferedImage)this.getImage();
        if (image == null) {
            return;
        }
        if (c.isEnabled()) {
            g.setColor(c.getBackground());
        } else {
            g.setColor(Color.gray);
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.iconWidth > 0 && this.iconHeight > 0) {
            int drawWidth = this.iconWidth;
            int drawHeight = this.iconHeight;
            boolean rotateIcon = false;
            if (this.iconRotation == 270 || this.iconRotation == 90) {
                rotateIcon = true;
                drawWidth = this.iconHeight;
                drawHeight = this.iconWidth;
            }
            if (this.currentpdffile != null) {
                float hs;
                float ws = (float)drawWidth / (float)image.getWidth(null);
                float diff = ws - (hs = (float)drawHeight / (float)image.getHeight(null));
                int diffInt = (int)diff;
                if (diffInt != 0) {
                    rotateIcon = !rotateIcon;
                    int tmp = drawWidth;
                    drawWidth = drawHeight;
                    drawHeight = tmp;
                    ws = (float)drawWidth / (float)image.getWidth(null);
                    hs = (float)drawHeight / (float)image.getHeight(null);
                }
                if (ws < hs) {
                    drawWidth = (int)(ws * (float)image.getWidth(null));
                    drawHeight = (int)(ws * (float)image.getHeight(null));
                } else {
                    drawWidth = (int)(hs * (float)image.getWidth(null));
                    drawHeight = (int)(hs * (float)image.getHeight(null));
                }
            }
            int posX = 0;
            int posY = 0;
            if (this.currentpdffile != null) {
                if (rotateIcon) {
                    posX = (this.iconHeight - drawWidth) / 2;
                    posY = (this.iconWidth - drawHeight) / 2;
                } else {
                    posX = (this.iconWidth - drawWidth) / 2;
                    posY = (this.iconHeight - drawHeight) / 2;
                }
            }
            int finalRotation = this.displaySingle ? FixImageIcon.validateRotationValue(this.pageRotate - this.iconRotation) : this.pageRotate;
            switch (finalRotation) {
                case 270: {
                    g2.rotate(-1.5707963267948966);
                    g2.translate(-drawWidth, 0);
                    g2.drawImage(image, -posX, posY, drawWidth, drawHeight, null);
                    break;
                }
                case 90: {
                    g2.rotate(1.5707963267948966);
                    g2.translate(0, -drawHeight);
                    g2.drawImage(image, posX, -posY, drawWidth, drawHeight, null);
                    break;
                }
                case 180: {
                    g2.rotate(Math.PI);
                    g2.translate(-drawWidth, -drawHeight);
                    g2.drawImage(image, -posX, -posY, drawWidth, drawHeight, null);
                    break;
                }
                default: {
                    g2.drawImage(image, posX, posY, drawWidth, drawHeight, null);
                    break;
                }
            }
        } else {
            g2.drawImage((Image)image, 0, 0, null);
        }
        g2.translate(-x, -y);
    }

    private void checkAndCreateimage() {
        if (this.currentpdffile == null) {
            return;
        }
        int newWidth = this.iconWidth;
        int newHeight = this.iconHeight;
        if (this.currentlyPrinting) {
            newWidth = this.iconWidth * this.printMultiplier;
            newHeight = this.iconHeight * this.printMultiplier;
        }
        switch (this.selected) {
            case 0: {
                if (this.rootImageUnselected != null && newWidth <= this.rootImageUnselected.getWidth(null) && newHeight <= this.rootImageUnselected.getHeight(null) && !((float)newWidth < (float)this.rootImageUnselected.getWidth(null) / MAXSCALEFACTOR) && !((float)newHeight < (float)this.rootImageUnselected.getHeight(null) / MAXSCALEFACTOR)) break;
                this.rootImageUnselected = FormStream.decode(this.formObject, this.currentpdffile, this.unSelObj, this.subtype, newWidth, newHeight, this.offsetImage, 1.0f);
                this.imageUnselected = FormStream.rotate(this.rootImageUnselected, this.iconRotation);
                break;
            }
            default: {
                if (this.rootImageSelected != null && newWidth <= this.rootImageSelected.getWidth(null) && newHeight <= this.rootImageSelected.getHeight(null) && !((float)newWidth < (float)this.rootImageSelected.getWidth(null) / MAXSCALEFACTOR) && !((float)newHeight < (float)this.rootImageSelected.getHeight(null) / MAXSCALEFACTOR)) break;
                this.rootImageSelected = FormStream.decode(this.formObject, this.currentpdffile, this.selObj, this.subtype, newWidth, newHeight, this.offsetImage, 1.0f);
                this.imageSelected = FormStream.rotate(this.rootImageSelected, this.iconRotation);
            }
        }
    }

    public void swapImage(boolean selectedImage) {
        if (this.selected == -1) {
            return;
        }
        this.selected = selectedImage ? 1 : 0;
    }

    public void setPrinting(boolean print, int multiplier) {
        this.currentlyPrinting = print;
        this.printMultiplier = multiplier;
        this.checkAndCreateimage();
    }
}

