/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.overridingImplementations;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.acroforms.overridingImplementations.CustomImageIcon;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.XObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class ReadOnlyTextIcon
extends CustomImageIcon
implements Icon,
SwingConstants {
    private boolean currentlyPrinting;
    private int printMultiplier = 1;
    private int alignment = -1;
    private static final long serialVersionUID = 8946195842453749725L;
    private BufferedImage rootImage;
    private BufferedImage finalImage;
    private PdfObject fakeObj;
    private boolean textChanged;
    private String preFontStream = "";
    private String betweenFontAndTextStream = "";
    private String afterTextStream = "";
    private String text = "";
    private String fontName = "";
    private String fontSize = "12";
    private String fontCommand = "";
    private String fullCommandString;
    private final PdfObjectReader currentpdffile;
    private int subtype = -1;
    private final PdfObject resources;
    private final PdfObject form;

    public ReadOnlyTextIcon(PdfObject form, int iconRot, PdfObjectReader pdfObjectReader, PdfObject res) {
        super(iconRot);
        this.form = form;
        this.currentpdffile = pdfObjectReader;
        this.resources = res;
    }

    @Override
    public Image getImage() {
        this.checkAndCreateimage();
        BufferedImage image = this.finalImage;
        return image;
    }

    public BufferedImage drawToBufferedImage() {
        BufferedImage bufImg = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics g = bufImg.getGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return bufImg;
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        BufferedImage image = (BufferedImage)this.getImage();
        if (image == null) {
            return;
        }
        if (c != null && c.isEnabled()) {
            g.setColor(c.getBackground());
        } else {
            g.setColor(Color.gray);
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.iconWidth > 0 && this.iconHeight > 0) {
            int drawWidth = this.iconWidth;
            int drawHeight = this.iconHeight;
            if (this.displaySingle && (this.iconRotation == 270 || this.iconRotation == 90)) {
                drawWidth = this.iconHeight;
                drawHeight = this.iconWidth;
            }
            if (this.currentpdffile != null) {
                float hs;
                float ws = (float)drawWidth / (float)image.getWidth(null);
                if (ws < (hs = (float)drawHeight / (float)image.getHeight(null))) {
                    drawWidth = (int)(ws * (float)image.getWidth(null));
                    drawHeight = (int)(ws * (float)image.getHeight(null));
                } else {
                    drawWidth = (int)(hs * (float)image.getWidth(null));
                    drawHeight = (int)(hs * (float)image.getHeight(null));
                }
            }
            int posX = 0;
            int posY = 0;
            if (this.currentpdffile != null) {
                if (this.displaySingle && (this.iconRotation == 270 || this.iconRotation == 90)) {
                    posX = (this.iconHeight - drawWidth) / 2;
                    posY = (this.iconWidth - drawHeight) / 2;
                } else {
                    posX = (this.iconWidth - drawWidth) / 2;
                    posY = (this.iconHeight - drawHeight) / 2;
                }
            }
            if (this.alignment == 2) {
                posX = 0;
            }
            int finalRotation = this.displaySingle ? ReadOnlyTextIcon.validateRotationValue(this.pageRotate - this.iconRotation) : this.pageRotate;
            switch (finalRotation) {
                case 270: {
                    g2.rotate(-1.5707963267948966);
                    g2.translate(-drawWidth, 0);
                    g2.drawImage(image, -posX, posY, drawWidth, drawHeight, null);
                    break;
                }
                case 90: {
                    g2.rotate(1.5707963267948966);
                    g2.translate(0, -drawHeight);
                    g2.drawImage(image, posX, -posY, drawWidth, drawHeight, null);
                    break;
                }
                case 180: {
                    g2.rotate(Math.PI);
                    g2.translate(-drawWidth, -drawHeight);
                    g2.drawImage(image, -posX, -posY, drawWidth, drawHeight, null);
                    break;
                }
                default: {
                    g2.drawImage(image, posX, posY, drawWidth, drawHeight, null);
                    break;
                }
            }
        } else {
            g2.drawImage((Image)image, 0, 0, null);
        }
        g2.translate(-x, -y);
    }

    private void checkAndCreateimage() {
        if (this.currentpdffile == null) {
            return;
        }
        int newWidth = this.iconWidth;
        int newHeight = this.iconHeight;
        if (this.currentlyPrinting) {
            newWidth = this.iconWidth * this.printMultiplier;
            newHeight = this.iconHeight * this.printMultiplier;
        }
        if (this.textChanged || this.rootImage == null || newWidth > this.rootImage.getWidth(null) || newHeight > this.rootImage.getHeight(null) || (float)newWidth < (float)this.rootImage.getWidth(null) / MAXSCALEFACTOR || (float)newHeight < (float)this.rootImage.getHeight(null) / MAXSCALEFACTOR) {
            this.rootImage = FormStream.decode(this.form, this.currentpdffile, this.fakeObj, this.subtype, newWidth, newHeight, 0, 1.0f);
            this.finalImage = FormStream.rotate(this.rootImage, this.iconRotation);
            this.textChanged = false;
        }
    }

    public void setText(String str) {
        if (str == null) {
            str = "";
        }
        if (str.equals(this.text)) {
            return;
        }
        this.textChanged = true;
        this.text = str;
        PdfObject xobj = new PdfObject("1 10 X");
        do {
            xobj.setDecodedStream(StringUtils.toBytes(this.afterTextStream));
            String tj = FormStream.decipherTextFromAP(this.currentpdffile, xobj);
            if (tj == null || !this.text.contains(tj)) break;
            int endOfTj = this.afterTextStream.indexOf(" Tj", this.afterTextStream.indexOf(tj)) + 3;
            this.afterTextStream = this.afterTextStream.substring(endOfTj);
        } while (!this.afterTextStream.isEmpty());
        try {
            String textAlignment;
            if (this.text.contains("\n")) {
                StringTokenizer lines = new StringTokenizer(this.text, "\n", false);
                int alignmentX = 2;
                int alignmentY = ((FormObject)this.form).getBoundingRectangle().height;
                textAlignment = " " + alignmentX + ' ' + alignmentY + " Td ";
                this.fullCommandString = this.preFontStream + this.fontName + this.fontSize + this.fontCommand + this.betweenFontAndTextStream + textAlignment;
                int xPoint = 0;
                while (lines.hasMoreTokens()) {
                    String nextLine = lines.nextToken();
                    FontMetrics fm = new Canvas().getFontMetrics(new Font(this.fontName, 0, (int)Float.parseFloat(this.fontSize)));
                    Rectangle2D r = fm.getStringBounds(nextLine, null);
                    if (((FormObject)this.form).getAlignment() != -1) {
                        switch (((FormObject)this.form).getAlignment()) {
                            case 2: {
                                alignmentX = 0;
                                break;
                            }
                            case 0: {
                                alignmentX = (int)((double)((FormObject)this.form).getBoundingRectangle().width - r.getWidth()) / 2;
                                alignmentX -= xPoint;
                                break;
                            }
                            case 4: {
                                alignmentX = (int)((double)((FormObject)this.form).getBoundingRectangle().width - r.getWidth());
                                alignmentX -= xPoint;
                            }
                        }
                    }
                    alignmentY = (int)(-(r.getHeight() + 2.0));
                    textAlignment = " " + alignmentX + ' ' + alignmentY + " Td ";
                    this.fullCommandString = this.fullCommandString + textAlignment + '(' + nextLine + ")Tj ";
                    xPoint += alignmentX;
                }
                this.fullCommandString = this.fullCommandString + this.afterTextStream;
            } else {
                int alignmentX = 2;
                int alignmentY = (int)((float)((FormObject)this.form).getBoundingRectangle().height - Float.parseFloat(this.fontSize)) + 2;
                if (this.form.getParameterConstant(1147962727) != 980909433) {
                    alignmentY = (int)((float)((FormObject)this.form).getBoundingRectangle().height - Float.parseFloat(this.fontSize)) / 2;
                    if (alignmentY < 2) {
                        alignmentY = 2;
                    }
                    if (((FormObject)this.form).getAlignment() != 2) {
                        FontMetrics fm = new Canvas().getFontMetrics(new Font(this.fontName, 0, (int)Float.parseFloat(this.fontSize)));
                        Rectangle2D r = fm.getStringBounds(this.text, null);
                        switch (((FormObject)this.form).getAlignment()) {
                            case 0: {
                                alignmentX = (int)((double)((FormObject)this.form).getBoundingRectangle().width - r.getWidth()) / 2;
                                break;
                            }
                            case 4: {
                                alignmentX = (int)((double)((FormObject)this.form).getBoundingRectangle().width - r.getWidth()) - 2;
                            }
                        }
                    }
                }
                textAlignment = alignmentX + " " + alignmentY + " Td ";
                this.fullCommandString = this.preFontStream + this.fontName + this.fontSize + this.fontCommand + this.betweenFontAndTextStream + textAlignment + '(' + this.text + ")Tj " + this.afterTextStream;
            }
            Color BG = null;
            if (this.form.getDictionary(7451) != null) {
                PdfObject MK = this.form.getDictionary(7451);
                float[] bg = MK.getFloatArray(4631);
                if (bg != null) {
                    int i;
                    boolean colorOutOfBounds = false;
                    for (i = 0; i != bg.length; ++i) {
                        if (!(bg[i] > 1.0f)) continue;
                        colorOutOfBounds = true;
                        break;
                    }
                    if (colorOutOfBounds) {
                        for (i = 0; i != bg.length; ++i) {
                            if (!(bg[i] > 1.0f)) continue;
                            int n = i;
                            bg[n] = bg[n] / 255.0f;
                        }
                    }
                }
                if (bg != null && bg.length > 0) {
                    switch (bg.length) {
                        case 1: {
                            BG = new Color(bg[0], bg[0], bg[0], 1.0f);
                            break;
                        }
                        case 3: {
                            BG = new Color(bg[0], bg[1], bg[2], 1.0f);
                            break;
                        }
                    }
                }
            }
            if (BG != null) {
                this.fullCommandString = BG.getRed() + " " + BG.getGreen() + ' ' + BG.getBlue() + " rg 0 0 " + (((FormObject)this.form).getBoundingRectangle().width - 3) + ' ' + (((FormObject)this.form).getBoundingRectangle().height - 3) + " re f " + this.fullCommandString;
            }
            this.fakeObj.setDecodedStream(this.fullCommandString.getBytes("Cp1252"));
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }

    public boolean decipherAppObject(FormObject form) {
        Rectangle BBox;
        byte[] bytes;
        String fontStr = "";
        PdfObject appObj = form.getDictionary(4384).getDictionary(30);
        if (appObj != null && (bytes = appObj.getDecodedStream()) != null) {
            int startTj;
            int i;
            int startTf = -1;
            int endTf = -1;
            int endTj = -1;
            int end = bytes.length;
            for (i = 0; i < end - 1; ++i) {
                if ((char)bytes[i] != 'T' || (char)bytes[i + 1] != 'f' || i + 2 < end && bytes[i + 2] != 10 && bytes[i + 2] != 13 && bytes[i + 2] != 32) continue;
                endTf = i + 2;
                break;
            }
            if (endTf == -1) {
                startTf = 0;
                endTf = 0;
            } else {
                for (i = endTf - 3; i > startTf; --i) {
                    if (bytes[i] != 47) continue;
                    startTf = i;
                    break;
                }
            }
            for (i = endTf; i < end - 1; ++i) {
                if ((char)bytes[i] != 'T' || (char)bytes[i + 1] != 'j' || i + 2 < end && bytes[i + 2] != 10 && bytes[i + 2] != 13 && bytes[i + 2] != 32) continue;
                endTj = i + 2;
                break;
            }
            if (endTj == -1) {
                startTj = endTf;
                endTj = endTf;
            } else {
                startTj = endTf;
                int brackets = 0;
                boolean strFound = false;
                block8: for (int i2 = endTj - 3; i2 > startTj; --i2) {
                    switch (bytes[i2]) {
                        case 10: 
                        case 13: 
                        case 32: {
                            if (!strFound || brackets != 0) continue block8;
                            startTj = i2 + 1;
                            break block8;
                        }
                        case 41: {
                            ++brackets;
                            continue block8;
                        }
                        case 40: {
                            if (--brackets != 0 || !strFound) continue block8;
                            startTj = i2;
                            break block8;
                        }
                        default: {
                            strFound = true;
                        }
                    }
                }
            }
            for (i = endTf; i < startTj; ++i) {
                if (bytes[i] == 32 || bytes[i] == 10 || bytes[i] == 13 || bytes[i] > 47 && bytes[i] < 58) continue;
                if (bytes[i] == 103 && i + 1 < startTj && (bytes[i + 1] == 32 || bytes[i + 1] == 10 || bytes[i + 1] == 13)) {
                    endTf = i + 1;
                    break;
                }
                if (bytes[i] != 114 || i + 2 >= startTj || bytes[i + 1] != 103 || bytes[i + 2] != 32 && bytes[i + 2] != 10 && bytes[i + 2] != 13) break;
                endTf = i + 2;
                break;
            }
            if (endTj != endTf) {
                if (endTf == 0) {
                    this.preFontStream = new String(bytes, 0, startTj);
                    this.betweenFontAndTextStream = " ";
                } else {
                    this.preFontStream = new String(bytes, 0, startTf);
                    fontStr = new String(bytes, startTf, endTf - startTf);
                    this.betweenFontAndTextStream = new String(bytes, endTf, startTj - endTf);
                }
                this.text = new String(bytes, startTj, endTj - 3 - startTj);
                this.afterTextStream = new String(bytes, endTj, bytes.length - endTj);
            } else if (endTf == 0) {
                this.preFontStream = new String(bytes);
            } else {
                this.preFontStream = new String(bytes, 0, startTf);
                fontStr = new String(bytes, startTf, endTf - startTf);
                this.betweenFontAndTextStream = new String(bytes, endTf, bytes.length - endTf);
            }
        }
        String DA = form.getTextStreamValue(5137);
        this.fakeObj = new XObject(form.getObjectRefAsString());
        if (DA == null || DA.isEmpty()) {
            if (!fontStr.isEmpty()) {
                form.setTextStreamValue(5137, StringUtils.toBytes(fontStr));
                FormStream.decodeFontCommandObj(fontStr, form);
            }
            return false;
        }
        if (fontStr.isEmpty()) {
            int ptr = DA.indexOf(47);
            if (ptr < 0) {
                ptr = 0;
            }
            fontStr = DA.substring(ptr).trim();
        } else {
            String fontname = DA.substring(0, DA.indexOf(32));
            String fontsize = fontStr.substring(fontStr.indexOf(32), fontStr.length());
            fontStr = fontname + fontsize;
            fontStr = fontStr.trim();
        }
        if (this.resources != null) {
            this.fakeObj.setDictionary(2004251818, this.resources);
        }
        if ((BBox = form.getBoundingRectangle()) != null) {
            this.fakeObj.setFloatArray(303185736, new float[]{BBox.width, 0.0f, 0.0f, BBox.height, 0.0f, 0.0f});
        }
        this.subtype = -1;
        if (this.preFontStream.isEmpty() || !this.preFontStream.contains("BT")) {
            this.preFontStream = "BT 0 0 0 RG 1 TFS ";
            this.betweenFontAndTextStream = " 1 0 0 1 0 0 Tm ";
            this.afterTextStream = "";
        }
        int sizeSt = fontStr.indexOf(32);
        int sizeEn = -1;
        boolean strFound = false;
        for (int i = sizeSt; i < fontStr.length(); ++i) {
            char chr = fontStr.charAt(i);
            if (chr == ' ' || chr == '\n' || chr == '\r') {
                if (!strFound) continue;
                sizeEn = i;
                break;
            }
            strFound = true;
        }
        float size = 12.0f;
        if (sizeEn != -1) {
            this.fontName = fontStr.substring(0, sizeSt);
            this.fontCommand = fontStr.substring(sizeEn);
            size = Float.parseFloat(fontStr.substring(sizeSt, sizeEn));
        }
        if (this.fontName.isEmpty()) {
            Font textFont = form.getTextFont();
            this.fontName = '/' + textFont.getFontName();
            this.fontCommand = "Tf ";
        }
        if (size == 0.0f || size == -1.0f) {
            size = GUIData.calculateFontSize(BBox.height, BBox.width, false, this.text);
        }
        this.fontSize = " " + size + ' ';
        return true;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setPrinting(boolean print, int multiplier) {
        this.currentlyPrinting = print;
        this.printMultiplier = multiplier;
        this.checkAndCreateimage();
    }

    public PdfObject getFakeObject() {
        return this.fakeObj;
    }
}

