/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.utils;

import java.awt.Color;
import java.awt.Rectangle;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.output.GenericFontMapper;

public class FormsCSSHelper {
    public static int[] getTextColor(FormObject object) {
        int[] rgb = object != null ? FormsCSSHelper.getColor(object.getTextColor()) : null;
        return rgb;
    }

    public static int[] getBackgroundColor(FormObject object) {
        int[] rgb = object != null ? FormsCSSHelper.getColor(FormObject.generateColor(object.getDictionary(7451).getFloatArray(4631))) : null;
        return rgb;
    }

    public static int[] getBorderColor(FormObject object) {
        int[] rgb = object != null ? FormsCSSHelper.getColor(FormObject.generateColor(object.getDictionary(7451).getFloatArray(4627))) : null;
        return rgb;
    }

    public static int getBorderWidth(FormObject object) {
        PdfObject BS = object.getDictionary(4643);
        int w = -1;
        if (BS != null) {
            w = BS.getInt(39);
        }
        if (w < 0) {
            w = 1;
        }
        return w;
    }

    private static int[] getColor(Color color) {
        int[] rgb;
        if (color != null) {
            int col = color.getRGB();
            int r = col >> 16 & 0xFF;
            int g = col >> 8 & 0xFF;
            int b = col & 0xFF;
            rgb = new int[]{r, g, b};
        } else {
            rgb = null;
        }
        return rgb;
    }

    public static String addFont(FormObject formObject, boolean area, boolean isMultiLine, PdfPageData pageData, int pageNum, float scaling) {
        GenericFontMapper fontMapper = new GenericFontMapper(formObject.getFontName());
        String font = fontMapper.getFont();
        String weight = fontMapper.getWeight();
        float size = formObject.getTextSize();
        if (size == 0.0f || size == -1.0f) {
            int rotation;
            Rectangle pos = formObject.getBoundingRectangle();
            size = isMultiLine ? 12.0f : ((rotation = pageData.getRotation(pageNum)) == 90 || rotation == 270 ? (float)GUIData.calculateFontSize(pos.width, pos.height, area, formObject.getTextStreamValue(38)) : (float)GUIData.calculateFontSize(pos.height, pos.width, area, formObject.getTextStreamValue(38)));
        }
        String fontString = String.format("%s %dpx %s", weight, (int)(size *= scaling), font);
        return fontString;
    }
}

