/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.javascript;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.SwingUtilities;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.javascript.ExpressionEngine;
import org.jpedal.objects.javascript.JSApp;
import org.jpedal.objects.javascript.jsobjects.JSConsole;
import org.jpedal.objects.javascript.jsobjects.JSDoc;
import org.jpedal.objects.javascript.jsobjects.JSField;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.utils.LogWriter;

public class GenericParser
implements ExpressionEngine {
    private static final String[] engineOrder = new String[]{"nashorn", "rhino"};
    private AcroRenderer acroRenderer;
    private ScriptEngine engine;
    private final ScriptContext context;
    private JSDoc docObject;
    private final Javascript jsObject;
    private static final boolean debugEngine = false;
    private static ArrayList<String> erroredCode;

    public GenericParser(Javascript jsObject) throws Exception {
        this.jsObject = jsObject;
        ScriptEngineManager engineManager = new ScriptEngineManager();
        for (int i = 0; this.engine == null && i < engineOrder.length; ++i) {
            this.engine = engineManager.getEngineByName(engineOrder[i]);
        }
        if (this.engine == null) {
            throw new Exception("Could not load a suitable ScriptEngine for parsing JavaScript, are you using a fully fledged JVM?");
        }
        this.context = this.engine.getContext();
    }

    public void setupPDFObjects(Javascript jsObject) {
        try {
            this.docObject = new JSDoc();
            this.docObject.setAcroRenderer(this.acroRenderer);
            this.context.setAttribute("JSDoc", this.docObject, 100);
            this.context.setAttribute("app", new JSApp(), 100);
            JSConsole console = new JSConsole();
            this.context.setAttribute("console", console, 100);
            BufferedReader JSObjectsReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/org/jpedal/objects/javascript/jsobjects/JSObjects.js")));
            this.engine.eval(JSObjectsReader);
            this.engine.eval("var event = new Event();");
            BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/org/jpedal/objects/javascript/aform.js")));
            this.engine.eval(br);
            String onLoadJS = GenericParser.preParseJS(jsObject.getJavaScript(null), true);
            if (onLoadJS != null && !onLoadJS.isEmpty()) {
                try {
                    this.engine.eval(onLoadJS);
                }
                catch (ScriptException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int execute(FormObject ref, int type, Object js, int eventType, char keyPressed) {
        if (keyPressed == '\uffff') {
            return 0;
        }
        if (js instanceof String) {
            js = GenericParser.preParseJS((String)js, false);
            try {
                this.engine.eval("var event = new Event(" + type + ");");
                this.engine.eval("event.target = JSDoc.getFieldByRef('" + ref.getObjectRefAsString() + "');");
                this.engine.eval("event.value = '" + ref.getValue() + "';");
            }
            catch (ScriptException ex) {
                Logger.getLogger(GenericParser.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                Object returnObject = this.engine.eval((String)js, this.context);
                Object eventTarget = this.engine.eval("event.target");
                Object eventValue = this.engine.eval("event.value");
                if (eventTarget != null && eventType == 6) {
                    JSField field = (JSField)eventTarget;
                    field.value = eventValue;
                    boolean isSelected = false;
                    field.syncToGUI(false);
                }
                if (returnObject != null) {
                    // empty if block
                }
                Object event = this.engine.eval("event");
                Object eventName = this.engine.eval("event.name");
                if (event != null && eventName != null && eventName.equals("Format")) {
                    this.calcualteEvent();
                }
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    @Override
    public void closeFile() {
        this.flush();
    }

    @Override
    public boolean reportError(int code, Object[] args) {
        return false;
    }

    @Override
    public int addCode(String value) {
        final String finalValue = value = GenericParser.preParseJS(value, true);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    GenericParser.this.engine.eval(finalValue, GenericParser.this.context);
                }
                catch (ScriptException e) {
                    e.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeLater(r);
        return 0;
    }

    @Override
    public void executeFunctions(String jsCode, FormObject formObject) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setAcroRenderer(AcroRenderer acro) {
        this.acroRenderer = acro;
        this.docObject.setAcroRenderer(acro);
    }

    private void flush() {
        this.docObject.flush();
    }

    private void calcualteEvent() {
        FormObject[] formObjects;
        for (FormObject formObject : formObjects = this.docObject.getFormObjects()) {
            String ref = formObject.getObjectRefAsString();
            String name = formObject.getTextStreamValue(36);
            String command = (String)this.jsObject.getJavascriptCommand(name != null ? name : ref, 4866);
            if (command == null) continue;
            command = GenericParser.preParseJS(command, false);
            try {
                this.engine.eval("var event = new Event(4866);", this.context);
                this.engine.eval("event.target = JSDoc.getFieldByRef('" + ref + "');", this.context);
                this.engine.eval(command, this.context);
                JSField field = (JSField)this.engine.eval("event.target", this.context);
                Boolean rc = (Boolean)this.engine.eval("event.rc", this.context);
                if (field == null || !rc.booleanValue()) continue;
                Object value = this.engine.eval("event.value", this.context);
                field.value = value != null ? value.toString() : null;
                boolean isSelected = false;
                field.syncToGUI(false);
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
        }
    }

    private static String preParseJS(String js, boolean isDocumentLevel) {
        js = GenericParser.addMethodstoObject(GenericParser.makeGlobalVars(js));
        js = GenericParser.fixGetFields(js);
        if (isDocumentLevel) {
            js = "(function() {" + js + "}).call(Doc);";
        }
        return js;
    }

    private static String fixGetFields(String js) {
        Pattern pat = Pattern.compile("[^.]getField\\(");
        Matcher mat = pat.matcher(js);
        while (mat.find()) {
            String s = mat.group();
            js = js.replace(s, s.charAt(0) + "Doc.getField(");
        }
        js = js.replace("this.getField(", "Doc.getField(");
        return js;
    }

    private static String addMethodstoObject(String js) {
        Pattern pat = Pattern.compile("function\\s\\w+\\((\\w+)?\\)");
        Matcher mat = pat.matcher(js);
        HashMap<String, String> mapping = new HashMap<String, String>();
        while (mat.find()) {
            String s = mat.group();
            String methodSig = js.substring(mat.start() + 9, mat.end());
            int firstBracket = methodSig.indexOf(40);
            String methodName = methodSig.substring(0, firstBracket);
            String newMethodSig = "this." + methodName + " = " + "function" + methodSig.substring(firstBracket);
            mapping.put(s, newMethodSig);
        }
        String newJs = js;
        for (String s : mapping.keySet()) {
            newJs = newJs.replace(s, (CharSequence)mapping.get(s));
        }
        return newJs;
    }

    private static String makeGlobalVars(String js) {
        String trimmed = GenericParser.trimToGlobal(js);
        Pattern pat = Pattern.compile("var\\s\\w+\\s?=\\s?");
        Matcher mat = pat.matcher(trimmed);
        HashMap<String, String> mapping = new HashMap<String, String>();
        while (mat.find()) {
            int nameEndPos;
            String s = mat.group();
            String sig = trimmed.substring(mat.start() + 4, mat.end());
            for (nameEndPos = 0; sig.charAt(nameEndPos) != ' ' && sig.charAt(nameEndPos) != '=' && nameEndPos < sig.length(); ++nameEndPos) {
            }
            String name = sig.substring(0, nameEndPos);
            mapping.put(s.substring(0, 4 + name.length()), "this." + name);
        }
        String newJs = js;
        for (String s : mapping.keySet()) {
            newJs = newJs.replace(s, (CharSequence)mapping.get(s));
        }
        return newJs;
    }

    private static String trimToGlobal(String js) {
        StringBuilder sb = new StringBuilder();
        boolean inCurlyBrackets = false;
        boolean inBrackets = false;
        boolean inQuotes = false;
        boolean inDblQuotes = false;
        for (int index = 0; index < js.length(); ++index) {
            char c = js.charAt(index);
            if (!inDblQuotes) {
                if (c == '\"') {
                    inDblQuotes = true;
                    continue;
                }
                if (!inQuotes) {
                    if (c == '\'') {
                        inQuotes = true;
                        continue;
                    }
                    if (!inCurlyBrackets) {
                        if (c == '{') {
                            inCurlyBrackets = true;
                            continue;
                        }
                        if (!inBrackets) {
                            if (c == '(') {
                                inBrackets = true;
                                continue;
                            }
                            if (c == ')' || c == '}') continue;
                            sb.append(c);
                            continue;
                        }
                        if (c != ')') continue;
                        inBrackets = false;
                        continue;
                    }
                    if (c != '}') continue;
                    inCurlyBrackets = false;
                    continue;
                }
                if (c != '\'') continue;
                inQuotes = false;
                continue;
            }
            if (c != '\"') continue;
            inDblQuotes = false;
        }
        js = sb.toString();
        return js;
    }

    public static void debugLog(String log) {
        File logfile = new File("JSErrorLog.txt");
        try {
            if (logfile.createNewFile()) {
                System.err.println("Javascript error log file created: " + logfile.getAbsolutePath());
            }
            if (erroredCode == null) {
                erroredCode = new ArrayList();
            }
            if (erroredCode.contains(log)) {
                return;
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(logfile, true));
            out.write(log);
            out.close();
            erroredCode.add(log);
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }
}

