/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.javascript;

import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.javascript.AformDefaultJSscript;
import org.jpedal.objects.javascript.DefaultParser;
import org.jpedal.objects.javascript.ExpressionEngine;
import org.jpedal.objects.javascript.PDF2JS;
import org.jpedal.objects.javascript.defaultactions.DisplayJavascriptActions;
import org.jpedal.objects.javascript.defaultactions.JpedalDefaultJavascript;
import org.jpedal.objects.javascript.functions.JSFunction;
import org.jpedal.objects.layers.Layer;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RhinoParser
extends DefaultParser
implements ExpressionEngine {
    private static final String viewerSettings = AformDefaultJSscript.getViewerSettings() + AformDefaultJSscript.getstaticScript();
    private Context cx;
    private Scriptable scope;
    private String functions = "";
    private boolean javascriptRunning;
    private final Javascript JSObj;

    public RhinoParser(Javascript js) {
        this.JSObj = js;
    }

    @Override
    public void flush() {
        if (this.acro != null && this.acro.getFormFactory() != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.flushJS();
            } else {
                Runnable doPaintComponent = new Runnable(){

                    @Override
                    public void run() {
                        RhinoParser.this.flushJS();
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(doPaintComponent);
                }
                catch (Exception e) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
    }

    public void flushJS() {
        this.functions = "";
        if (this.cx != null) {
            try {
                Context.exit();
                this.cx = null;
            }
            catch (IllegalStateException e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    public void setJavaScriptEnded() {
        this.javascriptRunning = false;
    }

    public void executeFunctions(final String code, final FormObject ref, final AcroRenderer acro) {
        this.javascriptRunning = true;
        if (acro.getFormFactory().getType() == 1) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.executeJS(code, ref, acro);
            } else {
                Runnable doPaintComponent = new Runnable(){

                    @Override
                    public void run() {
                        RhinoParser.this.executeJS(code, ref, acro);
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(doPaintComponent);
                }
                catch (Exception e) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            while (this.javascriptRunning) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeJS(String code, FormObject ref, AcroRenderer acro) {
        try {
            if (code.isEmpty() && this.functions.isEmpty()) {
                return;
            }
            String func = "";
            int index1 = code.indexOf("function ");
            while (index1 != -1) {
                int i = index1 + 8;
                int bracket = 0;
                char chr = code.charAt(i);
                while (true) {
                    if (chr == '{') {
                        ++bracket;
                    }
                    if (chr == '}' && --bracket == 0) break;
                    chr = code.charAt(i++);
                }
                int indR = code.lastIndexOf(13, index1);
                int indN = code.lastIndexOf(10, index1);
                int indS = (indN < indR ? indR : indN) + 1;
                indR = code.indexOf(13, i);
                if (indR == -1) {
                    indR = code.length();
                }
                if ((indN = code.indexOf(10, i)) == -1) {
                    indN = code.length();
                }
                int indE = (indN < indR ? indN : indR) + 1;
                func = func + code.substring(indS, indE);
                code = code.substring(0, indS) + code.substring(indE);
                index1 = code.indexOf("function ");
            }
            if (!func.isEmpty()) {
                this.addCode(func);
            }
            code = RhinoParser.preParseCode(code);
            if (this.cx == null) {
                this.cx = Context.enter();
                this.scope = this.cx.initStandardObjects();
                this.addStdObject(acro);
            }
            if (ref != null) {
                String name = ref.getTextStreamValue(36);
                Object formObj = Context.javaToJS((Object)new PDF2JS(ref), (Scriptable)this.scope);
                ScriptableObject.putProperty((Scriptable)this.scope, (String)"event", (Object)formObj);
                if (name != null) {
                    ScriptableObject.putProperty((Scriptable)this.scope, (String)name, (Object)formObj);
                }
            }
            String defSetCode = viewerSettings + this.functions;
            this.cx.evaluateString(this.scope, defSetCode, "<JS viewer Settings>", 1, null);
            this.cx.evaluateString(this.scope, code, "<javascript>", 1, null);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        finally {
            PdfLayerList layersObj = acro.getActionHandler().getLayerHandler();
            if (layersObj != null && layersObj.getChangesMade()) {
                if (Layer.debugLayer) {
                    System.out.println("changed");
                }
                try {
                    acro.getActionHandler().getPDFDecoder().decodePage(-1);
                }
                catch (Exception e) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            this.javascriptRunning = false;
        }
    }

    private static String preParseCode(String script) {
        String[] searchFor = new String[]{"= (\"%.2f\",", "this.ADBE", " getField(", "\ngetField(", "\rgetField(", "(getField(", "this.getField(", "this.resetForm(", "this.pageNum", " this.getOCGs(", "\nthis.getOCGs(", "\rthis.getOCGs(", " getOCGs(", "\ngetOCGs(", "\rgetOCGs(", ".state="};
        String[] replaceWith = new String[]{"= util.z(\"%.2f\",", "ADBE", " acro.getField(", "\nacro.getField(", "\racro.getField(", "(acro.getField(", "acro.getField(", "acro.resetForm(", "acro.pageNum", " layers.getOCGs(", "\nlayers.getOCGs(", "\rlayers.getOCGs(", " layers.getOCGs(", "\nlayers.getOCGs(", "\rlayers.getOCGs(", "\rlayers.getOCGs("};
        for (int i = 0; i < searchFor.length; ++i) {
            script = RhinoParser.checkAndReplaceCode(searchFor[i], replaceWith[i], script);
        }
        int indexs = script.indexOf("printf");
        if (indexs != -1) {
            int endArgs;
            StringBuilder buf = new StringBuilder();
            int indexStart = script.lastIndexOf(59, indexs);
            int indextmp = script.lastIndexOf(123, indexs);
            if (indexStart == -1 || indextmp != -1 && indextmp > indexStart) {
                indexStart = indextmp;
            }
            buf.append(script.substring(0, indexStart + 1));
            int speech = script.indexOf(34, indexs);
            speech = script.indexOf(34, speech + 1);
            while (script.charAt(speech - 1) == '\\') {
                speech = script.indexOf(34, speech);
            }
            int startArgs = script.indexOf(44, speech);
            String arguments = script.substring(startArgs + 1, endArgs = script.indexOf(41, startArgs));
            if (!arguments.equals("printfArgs")) {
                StringTokenizer tok = new StringTokenizer(arguments, ", ");
                buf.append("var printfArgs=new Array();\n");
                int i = 0;
                while (tok.hasMoreTokens()) {
                    buf.append("printfArgs[");
                    buf.append(i++);
                    buf.append("]=");
                    buf.append(tok.nextToken());
                    buf.append(";\n");
                }
                buf.append(script.substring(indexStart + 1, startArgs + 1));
                buf.append("printfArgs");
                buf.append(script.substring(endArgs));
                script = buf.toString();
            }
        }
        script = RhinoParser.checkAndReplaceCode("event.value=AFMakeNumber(acro.getField(\"sum\").value)(8)", "", script);
        script = RhinoParser.checkAndReplaceCode("calculate = false", "calculate = 0", script);
        script = RhinoParser.checkAndReplaceCode("calculate = true", "calculate = 1", script);
        script = RhinoParser.checkAndReplaceCode("calculate=false", "calculate=0", script);
        script = RhinoParser.checkAndReplaceCode("calculate=true", "calculate=1", script);
        return script;
    }

    private static String checkAndReplaceCode(String searchFor, String replaceWith, String script) {
        int index = script.indexOf(searchFor);
        if (index != -1) {
            StringBuilder buf = new StringBuilder(script.length());
            buf.append(script.substring(0, index));
            buf.append(replaceWith);
            buf.append(RhinoParser.checkAndReplaceCode(searchFor, replaceWith, script.substring(index + searchFor.length(), script.length())));
            script = buf.toString();
        }
        return script;
    }

    private void addStdObject(AcroRenderer acro) {
        Object objToJS = Context.javaToJS((Object)new JpedalDefaultJavascript(this.scope, this.cx), (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"util", (Object)objToJS);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"app", (Object)objToJS);
        Scriptable globalObj = this.cx.newObject(this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"global", (Object)globalObj);
        Scriptable ADBE = this.cx.newObject(this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"ADBE", (Object)ADBE);
        objToJS = Context.javaToJS((Object)new DisplayJavascriptActions(), (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"display", (Object)objToJS);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"color", (Object)objToJS);
        PdfLayerList layerList = acro.getActionHandler().getLayerHandler();
        if (layerList != null) {
            objToJS = Context.javaToJS((Object)layerList, (Scriptable)this.scope);
            ScriptableObject.putProperty((Scriptable)this.scope, (String)"layers", (Object)objToJS);
        }
        objToJS = Context.javaToJS((Object)acro, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"acro", (Object)objToJS);
    }

    @Override
    public int addCode(String value) {
        this.functions = this.functions + RhinoParser.preParseCode(value);
        return 0;
    }

    public Object generateJStype(String textString, boolean returnAsString) {
        if (returnAsString) {
            return this.cx.newObject(this.scope, "String", new Object[]{textString});
        }
        if (textString != null && !textString.isEmpty() && StringUtils.isNumber(textString) && (textString.length() != 1 || textString.indexOf(46) == -1)) {
            Double retNum = Double.valueOf(textString);
            return this.cx.newObject(this.scope, "Number", new Object[]{retNum});
        }
        return this.cx.newObject(this.scope, "String", new Object[]{textString});
    }

    @Override
    public int execute(FormObject form, int type, Object code, int eventType, char keyPressed) {
        int messageCode;
        String js = (String)code;
        String[] args = JSFunction.convertToArray(js);
        String command = args[0];
        if (command.startsWith("AF")) {
            messageCode = this.handleAFCommands(form, command, js, args, eventType, keyPressed);
        } else {
            this.executeFunctions(js, form, this.acro);
            messageCode = 3;
        }
        if (type == 22) {
            this.calcualteEvent();
            messageCode = 3;
        }
        return messageCode;
    }

    private void calcualteEvent() {
        Object[] formObjects;
        List obs = this.acro.getCompData().getFormComponents(null, ReturnValues.FORMOBJECTS_FROM_REF, -1);
        for (Object o : formObjects = obs.toArray()) {
            FormObject formObject = (FormObject)o;
            String ref = formObject.getObjectRefAsString();
            String name = formObject.getTextStreamValue(36);
            String command = (String)this.JSObj.getJavascriptCommand(name != null ? name : ref, 4866);
            if (command == null) continue;
            this.execute(formObject, 4866, command, 6, ' ');
        }
    }
}

