/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.javascript.defaultactions;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;

public class JpedalDefaultJavascript {
    public static boolean testingStopAlertBoxes;
    public static boolean testingSetStaticDate;
    private static final boolean DebugDefaultJavascript = false;
    private static final String[] format;
    private final Scriptable scope;
    private final Context context;
    public static final String viewerType = "Exchange-Pro";
    public static final int viewerVersion = 10;
    public static int calculate;
    public boolean runtimeHighlight;

    public JpedalDefaultJavascript(Scriptable scopeItem, Context contextItem) {
        this.scope = scopeItem;
        this.context = contextItem;
    }

    public Object printd(String format, Scriptable obj) {
        Date jsDate = null;
        if (NativeJavaObject.canConvert((Object)obj, Date.class)) {
            jsDate = (Date)Context.jsToJava((Object)obj, Date.class);
        }
        if (jsDate == null) {
            Context.throwAsScriptRuntimeEx((Throwable)new RuntimeException("Not a Date()"));
        }
        Calendar date = Calendar.getInstance();
        date.setTime(jsDate);
        if (testingSetStaticDate) {
            Calendar yesterday = Calendar.getInstance();
            yesterday.roll(6, false);
            if (date.get(1) > yesterday.get(1) || date.get(1) == yesterday.get(1) && date.get(6) > yesterday.get(6)) {
                date = Calendar.getInstance();
                date.set(2010, 10, 10, 10, 10, 10);
            }
        }
        char[] formatVal = format.toCharArray();
        StringBuffer retVal = new StringBuffer();
        for (int i = 0; i < formatVal.length; ++i) {
            if (formatVal[i] == 'm') {
                retVal.append('M');
                continue;
            }
            if (formatVal[i] == 't') {
                if (formatVal[i + 1] == 't') {
                    retVal.append('a');
                    ++i;
                    continue;
                }
                if (date.get(11) > 12) {
                    retVal.append("'P'");
                    continue;
                }
                retVal.append("'A'");
                continue;
            }
            if (formatVal[i] == 'M') {
                retVal.append('m');
                continue;
            }
            if (formatVal[i] == 'd' && formatVal[i + 1] == 'd' && formatVal[i + 2] == 'd') {
                if (formatVal[i + 3] == 'd') {
                    retVal.append("EEEE");
                    i += 3;
                    continue;
                }
                retVal.append("EEE");
                i += 2;
                continue;
            }
            if (formatVal[i] == '\\') {
                retVal.append('\'');
                retVal.append(formatVal[++i]);
                retVal.append('\'');
                continue;
            }
            retVal.append(formatVal[i]);
        }
        SimpleDateFormat df = new SimpleDateFormat(new String(retVal));
        String newDate = df.format(date.getTime());
        return this.context.newObject(this.scope, "String", new Object[]{newDate});
    }

    public Object printd(int index, Scriptable obj) {
        Calendar date = null;
        if (NativeJavaObject.canConvert((Object)obj, Calendar.class)) {
            date = (Calendar)Context.jsToJava((Object)obj, Calendar.class);
        }
        if (date == null) {
            Context.throwAsScriptRuntimeEx((Throwable)new RuntimeException("Not a Date()"));
        }
        if (testingSetStaticDate) {
            Calendar yesterday = Calendar.getInstance();
            yesterday.roll(5, false);
            if (date.get(1) > yesterday.get(1) || date.get(1) == yesterday.get(1) && date.get(6) > yesterday.get(6)) {
                date = Calendar.getInstance();
                date.set(2010, 10, 10, 10, 10, 10);
            }
        }
        SimpleDateFormat df = new SimpleDateFormat(format[index]);
        return this.context.newObject(this.scope, "String", new Object[]{df.format(date)});
    }

    public Object printf(String cFormat, String[] args) {
        StringBuilder buf = new StringBuilder();
        int PERCENT = 37;
        int tokenCount = 0;
        int stringLoct = 0;
        int tokenPos = cFormat.indexOf(37);
        while (tokenPos != -1) {
            buf.append(cFormat.substring(stringLoct, tokenPos));
            char[] endTokens = new char[]{'d', 'f', 's', 'x'};
            int c = 0;
            stringLoct = cFormat.indexOf(endTokens[c++], tokenPos);
            while (c < endTokens.length) {
                int end2Pos = cFormat.indexOf(endTokens[c], tokenPos);
                if (stringLoct == -1 || end2Pos != -1 && end2Pos < stringLoct) {
                    stringLoct = end2Pos;
                }
                ++c;
            }
            String tok = cFormat.substring(tokenPos, ++stringLoct);
            String obj = args[tokenCount++];
            int comma = obj.indexOf(44);
            int stop = obj.indexOf(46);
            if (comma != -1 && stop != -1 && comma < stop) {
                StringBuilder str = new StringBuilder();
                for (int i = 0; i < obj.length(); ++i) {
                    char next = obj.charAt(i);
                    if (next == ',') continue;
                    str.append(next);
                }
                obj = str.toString();
            }
            String val = JpedalDefaultJavascript.convertToken(tok, obj);
            buf.append(val);
            tokenPos = cFormat.indexOf(37, tokenPos + 1);
        }
        if (stringLoct < cFormat.length()) {
            buf.append(cFormat.substring(stringLoct));
        }
        return this.context.newObject(this.scope, "String", new Object[]{buf.toString()});
    }

    private static String convertToken(String token, String arg1) {
        if (!StringUtils.isNumber(arg1)) {
            return "";
        }
        double value = Double.parseDouble(arg1);
        int decimalPoints = -1;
        int minWidth = 0;
        char decimal = '.';
        boolean padd = false;
        boolean floatDecimal = false;
        StringBuilder sValue = new StringBuilder();
        StringBuilder returnString = new StringBuilder();
        char[] tokArray = token.toCharArray();
        if (tokArray[0] == '%') {
            int size = tokArray.length;
            block18: for (int i = 1; i < size; ++i) {
                switch (tokArray[i]) {
                    case ',': {
                        switch (tokArray[++i]) {
                            case '0': {
                                decimal = '.';
                                break;
                            }
                            case '1': {
                                decimal = '.';
                                break;
                            }
                            case '2': {
                                decimal = ',';
                                break;
                            }
                            case '3': {
                                decimal = ',';
                            }
                        }
                        continue block18;
                    }
                    case '+': {
                        if (value > 0.0) {
                            returnString.append('+');
                            continue block18;
                        }
                        returnString.append('-');
                        continue block18;
                    }
                    case ' ': {
                        if (value > 0.0) {
                            returnString.append(' ');
                            continue block18;
                        }
                        returnString.append('-');
                        continue block18;
                    }
                    case '0': {
                        padd = true;
                        continue block18;
                    }
                    case '#': {
                        floatDecimal = true;
                        continue block18;
                    }
                    case '.': {
                        decimalPoints = Integer.parseInt(String.valueOf(tokArray[++i]));
                        continue block18;
                    }
                    case 'd': {
                        int stringlen;
                        sValue.append((int)value);
                        if (padd && (stringlen = returnString.length() + sValue.length()) < minWidth) {
                            for (int p = 0; p < minWidth - stringlen; ++p) {
                                returnString.append('0');
                            }
                        }
                        returnString.append((CharSequence)sValue);
                        break block18;
                    }
                    case 'f': {
                        int stringlen;
                        if (decimalPoints != -1) {
                            if (decimalPoints == 0) {
                                sValue.append((int)value);
                            } else {
                                NumberFormat nf = NumberFormat.getInstance();
                                nf.setMinimumFractionDigits(decimalPoints);
                                nf.setMaximumFractionDigits(decimalPoints);
                                sValue.append(nf.format(value));
                            }
                        } else {
                            sValue.append((float)value);
                        }
                        if (floatDecimal && sValue.indexOf(".") != -1) {
                            sValue.append('.');
                        }
                        if (padd && (stringlen = returnString.length() + sValue.length()) < minWidth) {
                            for (int p = 0; p < minWidth - stringlen; ++p) {
                                returnString.append('0');
                            }
                        }
                        String ssVal = sValue.toString();
                        ssVal = ssVal.replace('.', decimal);
                        returnString.append(ssVal);
                        break block18;
                    }
                    case 's': {
                        int stringlen;
                        sValue.append(value);
                        if (padd && (stringlen = returnString.length() + sValue.length()) < minWidth) {
                            for (int p = 0; p < minWidth - stringlen; ++p) {
                                returnString.append('0');
                            }
                        }
                        returnString.append((CharSequence)sValue);
                        break block18;
                    }
                    case 'x': {
                        int stringlen;
                        int valI = (int)value;
                        String retValS = Integer.toHexString(valI);
                        sValue.append(retValS);
                        if (padd && (stringlen = returnString.length() + sValue.length()) < minWidth) {
                            for (int p = 0; p < minWidth - stringlen; ++p) {
                                returnString.append('0');
                            }
                        }
                        returnString.append((CharSequence)sValue);
                        break block18;
                    }
                    default: {
                        minWidth = NumberUtils.parseInt(0, 1, new byte[]{(byte)tokArray[i]});
                    }
                }
            }
        }
        return returnString.toString();
    }

    public static Map crackURL(String cURL) {
        if (!(cURL.startsWith("file") || cURL.startsWith("http") || cURL.startsWith("https"))) {
            return null;
        }
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        int index1 = cURL.indexOf("://");
        propertiesMap.put("cScheme", cURL.substring(0, index1));
        if (cURL.contains("@")) {
            int userInd = cURL.indexOf(58, index1 + 3);
            int atInd = cURL.indexOf(64);
            int index2 = cURL.indexOf(47, atInd + 1);
            propertiesMap.put("cHost", cURL.substring(atInd + 1, index2));
            propertiesMap.put("cUser", cURL.substring(index1 + 3, userInd));
            propertiesMap.put("cPassword", cURL.substring(userInd + 1, atInd));
            propertiesMap.put("cPath", cURL.substring(index2 + 1));
        } else {
            int splitInd = cURL.indexOf(58, index1);
            int index2 = cURL.indexOf(47, splitInd);
            propertiesMap.put("cHost", cURL.substring(index1 + 3, splitInd));
            propertiesMap.put("nPort", cURL.substring(splitInd + 1, index2));
            propertiesMap.put("cPath", cURL.substring(index2 + 1));
        }
        return propertiesMap;
    }

    public static double z(String format, double value) {
        double val1 = value * 100.0;
        double val2 = Math.round(val1);
        return val2 / 100.0;
    }

    public static void beep(int type) {
        Toolkit.getDefaultToolkit().beep();
    }

    static {
        format = new String[]{"'D':yyyyMMddHHmmssZ", "'D':yyyyMMddHHmmssZ'Z", "yyyy/MM/dd HH:mm:ss"};
        calculate = 1;
    }
}

