/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.javascript.jsobjects;

import java.util.HashMap;
import java.util.List;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.javascript.jsobjects.JSField;
import org.jpedal.objects.raw.FormObject;

public class JSDoc {
    private AcroRenderer acroRenderer;
    private HashMap<String, JSField> nameTofields = new HashMap();
    private HashMap<String, JSField> refTofields = new HashMap();

    public void setAcroRenderer(AcroRenderer acro) {
        this.acroRenderer = acro;
        if (acro != null) {
            this.loadFormObjects();
        }
    }

    public void loadFormObjects() {
        if (this.acroRenderer == null) {
            throw new RuntimeException("No acrorender object set for Doc object.");
        }
        List obs = this.acroRenderer.getCompData().getFormComponents(null, ReturnValues.FORMOBJECTS_FROM_REF, -1);
        for (FormObject formObject : obs) {
            JSField field = new JSField(formObject);
            this.refTofields.put(formObject.getObjectRefAsString(), field);
            this.nameTofields.put(formObject.getTextStreamValue(36), field);
        }
    }

    public JSField getField(String name) {
        if (this.nameTofields.size() <= 0) {
            this.loadFormObjects();
        }
        if (this.nameTofields.containsKey(name)) {
            return this.nameTofields.get(name);
        }
        return null;
    }

    public JSField getFieldByRef(String ref) {
        if (this.refTofields.size() <= 0) {
            this.loadFormObjects();
        }
        if (this.refTofields.containsKey(ref)) {
            return this.refTofields.get(ref);
        }
        return null;
    }

    public void flush() {
        this.nameTofields = new HashMap();
        this.refTofields = new HashMap();
    }

    public FormObject[] getFormObjects() {
        FormObject[] formObjects = new FormObject[this.refTofields.size()];
        int i = 0;
        for (String S2 : this.refTofields.keySet()) {
            formObjects[i] = this.refTofields.get((Object)S2).target;
            ++i;
        }
        return formObjects;
    }
}

