/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.T3Display;
import org.jpedal.utils.LogWriter;

public class FormStream {
    public static final boolean debugUnimplemented = false;
    public static final boolean debug = false;
    private static boolean showFontMessage;
    public static final boolean exitOnError = false;
    protected PdfObjectReader currentPdfFile;
    public boolean isXFA;
    public static final int[] id;

    public void createAppearanceString(FormObject formObj, PdfObjectReader inCurrentPdfFile) {
        this.currentPdfFile = inCurrentPdfFile;
        this.init(formObj);
    }

    private void init(FormObject formObject) {
        String textStream;
        boolean debug = false;
        int Ff = formObject.getInt(5686);
        if (Ff != -1) {
            formObject.commandFf(Ff);
        }
        this.resolveAdditionalAction(formObject);
        FormStream.setupAPimages(formObject);
        int key = formObject.getNameAsConstant(24);
        if (key != -1) {
            if (key == 36 || key == 32) {
                if (!formObject.hasDownImage()) {
                    formObject.setOffsetDownApp();
                }
            } else if (key == 30) {
                formObject.setNoDownIcon();
            } else if (key == 25) {
                formObject.setInvertForDownIcon();
            }
        }
        if ((textStream = formObject.getTextStreamValue(5137)) != null) {
            FormStream.decodeFontCommandObj(textStream, formObject);
        }
    }

    public static void setupAPimages(FormObject formObject) {
        PdfObject APobjN = formObject.getDictionary(4384).getDictionary(30);
        if (APobjN != null) {
            formObject.setAppreancesUsed(true);
            formObject.setNormalOnState(formObject.getName(4387));
            if (APobjN.getDictionary(7998) != null) {
                formObject.setNormalOnState("On");
            } else {
                Map otherValues = APobjN.getOtherDictionaries();
                if (otherValues != null && !otherValues.isEmpty()) {
                    for (String key : otherValues.keySet()) {
                        formObject.setNormalOnState(key);
                    }
                }
            }
            String defaultState = formObject.getName(4387);
            if (defaultState != null && defaultState.equals(formObject.getNormalOnState())) {
                formObject.setSelected(true);
            }
        }
    }

    private void resolveAdditionalAction(FormObject formObject) {
        int[] nArray = id;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int anId;
            int idValue = anId = nArray[i];
            this.currentPdfFile.setJavascriptForObject(formObject, 4369, idValue);
            this.currentPdfFile.setJavascriptForObject(formObject, 17, idValue);
        }
    }

    public static BufferedImage decode(PdfObject formObj, PdfObjectReader currentPdfFile, PdfObject XObject2, int subtype, int width, int height, int offsetImage, float pageScaling) {
        if (XObject2.getObjectType() == 129) {
            return ExternalHandlers.decode(formObj, currentPdfFile, XObject2, subtype, width, height, offsetImage, pageScaling);
        }
        boolean useHires = true;
        currentPdfFile.checkResolved(XObject2);
        try {
            Graphics2D g2;
            BufferedImage aa;
            float scaling;
            ObjectStore localStore = new ObjectStore();
            T3Display glyphDisplay = new T3Display(0, false, 20, localStore);
            glyphDisplay.setHiResImageForDisplayMode(true);
            PdfStreamDecoder glyphDecoder = new PdfStreamDecoder(currentPdfFile, true, null);
            glyphDecoder.setParameters(false, true, 15, 0, false, false);
            glyphDecoder.setStreamType(1);
            glyphDecoder.setObjectValue(-8, localStore);
            glyphDecoder.setRenderer(glyphDisplay);
            try {
                PdfObject Resources = XObject2.getDictionary(2004251818);
                if (Resources == null) {
                    Resources = (PdfObject)XObject2.getOtherDictionaries().get("Resources");
                }
                if (Resources != null) {
                    glyphDecoder.readResources(Resources, false);
                }
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            byte[] commands = XObject2.getDecodedStream();
            float[] matrix = XObject2.getFloatArray(1145198201);
            float[] BBox = XObject2.getFloatArray(303185736);
            glyphDecoder.setBBox(BBox);
            if (commands != null) {
                glyphDecoder.decodeStreamIntoObjects(commands, false);
            }
            boolean ignoreColors = glyphDecoder.ignoreColors;
            localStore.flush();
            T3Glyph form = new T3Glyph(glyphDisplay, 0, 0, ignoreColors);
            float rectX1 = 0.0f;
            float rectY1 = 0.0f;
            if (BBox != null) {
                float hs;
                float ws;
                float diff;
                int diffInt;
                int boxHeight;
                int ii = 0;
                while (ii < 4) {
                    int n = ii++;
                    BBox[n] = BBox[n] * pageScaling;
                }
                rectX1 = BBox[0];
                rectY1 = BBox[1];
                int boxWidth = (int)(BBox[2] + 0.5f - BBox[0]);
                if (boxWidth < 0) {
                    boxWidth = -boxWidth;
                }
                if ((boxHeight = (int)(BBox[3] + 0.5f - BBox[1])) < 0) {
                    boxHeight = -boxHeight;
                }
                if (boxWidth == 0 && boxHeight > 0) {
                    boxWidth = 1;
                }
                if (boxWidth > 0 && boxHeight == 0) {
                    boxHeight = 1;
                }
                if ((diffInt = (int)(diff = (ws = (float)width / (float)boxWidth) - (hs = (float)height / (float)boxHeight))) != 0) {
                    int tmpI = width;
                    width = height;
                    height = tmpI;
                    ws = (float)width / (float)boxWidth;
                    hs = (float)height / (float)boxHeight;
                }
                if (ws < 1.0f || hs < 1.0f) {
                    scaling = 1.0f;
                    width = boxWidth;
                    height = boxHeight;
                } else {
                    if (ws > hs) {
                        scaling = ws;
                        height = (int)((float)boxHeight * scaling);
                    } else {
                        scaling = hs;
                        width = (int)((float)boxWidth * scaling);
                    }
                    rectX1 *= scaling;
                    rectY1 *= scaling;
                }
            } else {
                float hs;
                float ws;
                float defaultSize = 20.0f;
                if ((float)height < 20.0f) {
                    height = 20;
                }
                if ((float)width < 20.0f) {
                    width = 20;
                }
                if ((ws = (float)width / 20.0f) > (hs = (float)height / 20.0f)) {
                    scaling = ws;
                    height = (int)(20.0f * scaling);
                } else {
                    scaling = hs;
                    width = (int)(20.0f * scaling);
                }
                rectX1 *= scaling;
                rectY1 *= scaling;
            }
            if (width == 0 || height == 0) {
                return null;
            }
            if (offsetImage == 1) {
                width += 2;
                height += 2;
            }
            int offset = height;
            if (matrix != null) {
                float f;
                float e;
                float d;
                float c;
                float b;
                float a;
                if (pageScaling == 1.0f && matrix[4] > 0.0f && matrix[5] > 0.0f) {
                    float t;
                    float[] BBox2 = formObj.getFloatArray(573911876);
                    if (BBox2[1] > BBox2[3]) {
                        t = BBox2[1];
                        BBox2[1] = BBox2[3];
                        BBox2[3] = t;
                    }
                    if (BBox2[0] > BBox2[2]) {
                        t = BBox2[0];
                        BBox2[0] = BBox2[2];
                        BBox2[2] = t;
                    }
                    matrix[0] = (BBox2[2] - BBox2[0]) / (BBox[2] - BBox[0]);
                    matrix[1] = 0.0f;
                    matrix[2] = 0.0f;
                    matrix[3] = (BBox2[3] - BBox2[1]) / (BBox[3] - BBox[1]);
                    matrix[4] = BBox2[0] - BBox[0];
                    matrix[5] = BBox2[1] - BBox[1];
                    a = matrix[0];
                    b = matrix[1];
                    c = matrix[2];
                    d = matrix[3];
                    e = matrix[4];
                    f = matrix[5];
                } else {
                    a = matrix[0];
                    b = matrix[1];
                    c = matrix[2];
                    d = matrix[3];
                    e = matrix[4] * scaling * pageScaling;
                    f = matrix[5] * scaling * pageScaling;
                }
                if (c != 0.0f) {
                    aa = new BufferedImage(height, width, 2);
                    offset = width;
                } else {
                    aa = new BufferedImage(width, height, 2);
                    if (!(b < 0.0f)) {
                        if (e != 0.0f) {
                            e = -rectX1;
                        }
                        if (f != 0.0f) {
                            f = -rectY1;
                        }
                    }
                }
                g2 = (Graphics2D)aa.getGraphics();
                AffineTransform flip = new AffineTransform();
                flip.translate(0.0, offset);
                flip.scale(1.0, -1.0);
                g2.setTransform(flip);
                AffineTransform affineTransform = new AffineTransform(a, b, c, d, e, f);
                g2.transform(affineTransform);
            } else {
                aa = new BufferedImage(width, height, 2);
                g2 = (Graphics2D)aa.getGraphics();
                AffineTransform flip = new AffineTransform();
                flip.translate(0.0, offset);
                flip.scale(1.0, -1.0);
                g2.setTransform(flip);
            }
            if (offsetImage == 2) {
                g2.scale(-1.0, -1.0);
            } else if (offsetImage == 1) {
                g2.translate(1, 1);
            }
            if (subtype == 1919840408) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            form.render(0, g2, scaling * pageScaling, true);
            g2.dispose();
            return aa;
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
            return null;
        }
        catch (Error e) {
            LogWriter.writeLog("Error: " + e.getMessage());
            if (ExternalHandlers.throwMissingCIDError && e.getMessage() != null && e.getMessage().contains("kochi")) {
                throw e;
            }
            return null;
        }
    }

    public static String decipherTextFromAP(PdfObjectReader currentPdfFile, PdfObject Xobject) {
        try {
            ObjectStore localStore = new ObjectStore();
            T3Display glyphDisplay = new T3Display(0, false, 20, localStore);
            PdfStreamDecoder glyphDecoder = new PdfStreamDecoder(currentPdfFile, false, null);
            glyphDecoder.setParameters(false, true, 15, 0, false, false);
            glyphDecoder.setObjectValue(-8, localStore);
            glyphDecoder.setRenderer(glyphDisplay);
            try {
                PdfObject Resources = Xobject.getDictionary(2004251818);
                if (Resources != null) {
                    glyphDecoder.readResources(Resources, false);
                }
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            byte[] commands = Xobject.getDecodedStream();
            String textString = "";
            if (commands != null) {
                textString = glyphDecoder.decodeStreamIntoObjects(commands, true);
            }
            if (textString == null || textString.isEmpty()) {
                textString = null;
            }
            localStore.flush();
            return textString;
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
            return null;
        }
        catch (Error e) {
            LogWriter.writeLog("Error: " + e.getMessage());
            if (ExternalHandlers.throwMissingCIDError && e.getMessage() != null && e.getMessage().contains("kochi")) {
                throw e;
            }
            return null;
        }
    }

    public static BufferedImage rotate(BufferedImage src, int rotation) {
        if (src == null) {
            return null;
        }
        if (rotation == 0) {
            return src;
        }
        double angle = (double)rotation * Math.PI / 180.0;
        int w = src.getWidth();
        int h = src.getHeight();
        int newW = (int)Math.round((double)h * Math.abs(Math.sin(angle)) + (double)w * Math.abs(Math.cos(angle)));
        int newH = (int)Math.round((double)h * Math.abs(Math.cos(angle)) + (double)w * Math.abs(Math.sin(angle)));
        AffineTransform at = AffineTransform.getTranslateInstance((newW - w) / 2, (newH - h) / 2);
        at.rotate(angle, w / 2, h / 2);
        BufferedImage dst = new BufferedImage(newW, newH, 2);
        Graphics2D g2 = dst.createGraphics();
        g2.drawRenderedImage(src, at);
        g2.dispose();
        return dst;
    }

    public boolean hasXFADataSet() {
        return false;
    }

    public static void decodeFontCommandObj(String fontStream, FormObject formObject) {
        StringTokenizer tokens = new StringTokenizer(fontStream, "() []");
        int tokenCount = tokens.countTokens();
        String[] tokenValues = new String[tokenCount];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            tokenValues[i] = tokens.nextToken();
            ++i;
        }
        for (i = tokenCount - 1; i > -1; --i) {
            if (tokenValues[i].equals("g")) {
                --i;
                float col = 0.0f;
                try {
                    col = Float.parseFloat(FormStream.handleComma(tokenValues[i]));
                }
                catch (Exception e) {
                    LogWriter.writeLog("Error in generating g value " + tokenValues[i] + ' ' + e);
                }
                formObject.setTextColor(new float[]{col});
                continue;
            }
            if (tokenValues[i].equals("Tf")) {
                --i;
                int textSize = 8;
                try {
                    textSize = (int)Float.parseFloat(FormStream.handleComma(tokenValues[i]));
                }
                catch (Exception e) {
                    LogWriter.writeLog("Error in generating Tf size " + tokenValues[i] + ' ' + e);
                }
                --i;
                String font = null;
                try {
                    font = tokenValues[i];
                    if (font.startsWith("/")) {
                        font = font.substring(1);
                    }
                }
                catch (Exception e) {
                    LogWriter.writeLog("Error in generating Tf font " + tokenValues[i] + "  " + e);
                }
                PdfFont currentFont = new PdfFont();
                currentFont.setFont(font, textSize);
                String fontName = StandardFonts.expandName(font);
                String altName = (String)FontMappings.fontSubstitutionAliasTable.get(fontName.toLowerCase());
                if (altName != null) {
                    fontName = altName;
                }
                formObject.setFontName(fontName);
                formObject.setTextFont(currentFont.getGlyphData().getUnscaledFont());
                formObject.setTextSize(textSize);
                continue;
            }
            if (tokenValues[i].equals("rg") || tokenValues[i].equals("r")) {
                float b = Float.parseFloat(FormStream.handleComma(tokenValues[--i]));
                float g = Float.parseFloat(FormStream.handleComma(tokenValues[--i]));
                float r = Float.parseFloat(FormStream.handleComma(tokenValues[--i]));
                formObject.setTextColor(new float[]{r, g, b});
                continue;
            }
            if (tokenValues[i].equals("Sig")) {
                LogWriter.writeFormLog("Sig-  UNIMPLEMENTED=" + fontStream + "< " + i, false);
                continue;
            }
            if (tokenValues[i].equals("\\n") || showFontMessage) continue;
            showFontMessage = true;
            LogWriter.writeFormLog("{stream} Unknown FONT command " + tokenValues[i] + ' ' + i + " string=" + fontStream, false);
        }
    }

    private static String handleComma(String tokenValue) {
        int comma = tokenValue.indexOf(44);
        if (comma != -1) {
            tokenValue = tokenValue.substring(0, comma);
        }
        return tokenValue;
    }

    public byte[] getXFA(int xfaTemplate) {
        throw new RuntimeException("getXFA Should never be called in base class");
    }

    public boolean isXFA() {
        return this.isXFA;
    }

    static {
        id = new int[]{17, 4866, 4668, 21, 40, 20, 37, 5695, 8223, 8211, 8230, 8217, 31, 4865, 27, 22, 38, 4866, 5139, 10019, 5155, 10016, 5152};
    }
}

