/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.structuredtext;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.MCObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.SwingDisplay;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class MarkedContentGenerator {
    private PdfObjectReader currentPdfFile;
    private DocumentBuilder db;
    private Document doc;
    private Element root;
    private final Map pageStreams = new HashMap();
    private PdfResources res;
    private PdfLayerList layers;
    private PdfPageData pdfPageData;
    private boolean isDecoding;
    static boolean debug;
    static String indent;
    final Map reverseLookup = new HashMap();
    boolean isHTML;

    public Document getMarkedContentTree(PdfResources res, PdfPageData pdfPageData, PdfObjectReader currentPdfFile) {
        PdfObject structTreeRootObj = res.getPdfObject(3);
        this.res = res;
        this.layers = res.getPdfLayerList();
        this.pdfPageData = pdfPageData;
        this.currentPdfFile = currentPdfFile;
        this.currentPdfFile.checkResolved(structTreeRootObj);
        if (!this.isHTML) {
            boolean hasTree;
            this.setupTree();
            boolean bl = hasTree = structTreeRootObj != null && structTreeRootObj.getDictionary(1719112618) != null;
            if (debug) {
                System.out.println("hastree=" + hasTree);
            }
            if (hasTree) {
                this.buildTree(structTreeRootObj);
                this.pageStreams.clear();
            } else {
                try {
                    this.decodePageForMarkedContent(1, null, this.doc);
                }
                catch (Exception e) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        return this.doc;
    }

    private void setupTree() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        this.doc = this.db.newDocument();
        this.doc.appendChild(this.doc.createComment(" Created from JPedal "));
        this.doc.appendChild(this.doc.createComment(" http://www.idrsolutions.com "));
    }

    private void buildTree(PdfObject structTreeRootObj) {
        this.root = this.doc.createElement("TaggedPDF-doc");
        this.doc.appendChild(this.root);
        this.traverseContentTree(structTreeRootObj);
    }

    public void traverseContentTree(PdfObject structTreeRootObj) {
        PdfObject K2 = structTreeRootObj.getDictionary(27);
        if (K2 == null) {
            byte[][] Karray = structTreeRootObj.getStringArray(27);
            if (debug) {
                System.out.println("Karray=");
            }
            this.readKarray(Karray, this.root, null, "");
            if (debug) {
                System.out.println("Karray read");
            }
        } else {
            if (debug) {
                System.out.println("read child=" + K2.getObjectRefAsString());
            }
            this.readChildNode(K2, this.root, null, "");
        }
    }

    private void readChildNode(PdfObject K2, Element root, Map pageStream, String fullS) {
        PdfObject Pg;
        if (debug) {
            indent = indent + "   ";
            System.out.println(indent + "read child node " + K2.getObjectRefAsString() + ' ' + K2.getInt(27));
        }
        byte[][] Karray = K2.getStringArray(27);
        int Kint = K2.getInt(27);
        PdfObject Kdict = K2.getDictionary(27);
        String lang = K2.getTextStreamValue(472989239);
        String S2 = K2.getName(35);
        fullS = fullS + '.' + S2;
        Element child = null;
        if (debug) {
            System.out.println(indent + "S= " + S2 + ' ');
            if (S2 == null) {
                System.out.println("S is null in " + K2.getObjectRefAsString());
            }
        }
        if (S2 != null) {
            if (S2.equals("Span")) {
                child = root;
            } else {
                if (this.doc != null) {
                    child = this.doc.createElement(MarkedContentGenerator.cleanName(S2));
                }
                if (lang != null) {
                    child.setAttribute("xml:lang", lang);
                }
                if (root != null) {
                    root.appendChild(child);
                }
            }
        }
        if ((Pg = K2.getDictionary(8247)) != null && pageStream == null && !this.isHTML) {
            if (debug) {
                System.out.println(indent + "decode page ");
            }
            pageStream = new HashMap();
            try {
                this.decodePageForMarkedContent(-1, Pg, pageStream);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        if (debug) {
            System.out.println(indent + "page decoded karray" + Arrays.toString((Object[])Karray) + " Kdict=" + Kdict + " kint=" + Kint);
        }
        if (Karray != null) {
            this.readKarray(Karray, child, pageStream, fullS);
        } else if (Kdict != null) {
            this.readChildNode(Kdict, child, pageStream, fullS);
        } else if (Kint != -1 && !this.isHTML) {
            this.addContentToNode(pageStream, String.valueOf(Kint), child);
        } else if (K2.getTextStreamValue(36) == null && debug) {
            System.out.println("unimplemented " + K2.getObjectRefAsString());
        }
        if (debug) {
            System.out.println(indent + "child node read " + K2.getObjectRefAsString());
            indent = indent.substring(0, indent.length() - 3);
        }
    }

    private void addContentToNode(Map pageStream, String Kint, Element child) {
        if (!this.isHTML) {
            String text = (String)pageStream.get(Kint);
            if (text != null) {
                text = MarkedContentGenerator.handleXMLCharacters(text);
                if (this.doc != null) {
                    Text textNode = this.doc.createTextNode(text);
                    child.appendChild(textNode);
                }
            }
            if (debug) {
                System.out.println(indent + " added " + text);
            }
        }
    }

    private static String handleXMLCharacters(String text) {
        text = text.replaceAll("&lt;", "<");
        text = text.replaceAll("&gt;", ">");
        return text;
    }

    private void readKarray(byte[][] Karray, Element root, Map pageStream, String fullS) {
        int count = Karray.length;
        for (int i = 0; i < count; ++i) {
            String KValue = new String(Karray[i]);
            if (debug) {
                System.out.println(indent + "aK value=" + KValue);
            }
            if (count - i >= 3) {
                byte[] lastChar = Karray[i + 2];
                if (lastChar[0] == 82) {
                    MCObject kidObj = new MCObject(KValue + ' ' + new String(Karray[i + 1]) + " R");
                    this.currentPdfFile.readObject(kidObj);
                    this.readChildNode(kidObj, root, pageStream, fullS);
                    i += 2;
                    continue;
                }
                this.addContentToNode(pageStream, KValue, root);
                continue;
            }
            if (this.isHTML && !this.reverseLookup.containsKey(KValue)) {
                this.reverseLookup.put(KValue, fullS);
            }
            this.addContentToNode(pageStream, KValue, root);
        }
    }

    private static String cleanName(String s) {
        StringBuilder cleanedS = new StringBuilder(10);
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            int c = s.charAt(i);
            if (c == 35) {
                StringBuilder num = new StringBuilder(2);
                for (int j = 0; j < 2; ++j) {
                    num.append(s.charAt(++i));
                }
                c = (char)Integer.parseInt(num.toString(), 16);
                if (!Character.isLetterOrDigit((char)c)) {
                    c = 45;
                }
            }
            if (c == 32) {
                cleanedS.append('-');
                continue;
            }
            if (c == 45) {
                cleanedS.append((char)c);
                continue;
            }
            if (c == 95) {
                cleanedS.append((char)c);
                continue;
            }
            if (!Character.isLetterOrDigit((char)c)) continue;
            cleanedS.append((char)c);
        }
        s = cleanedS.toString();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void decodePageForMarkedContent(int pageNumber, PdfObject pdfObject, Object pageStream) throws Exception {
        if (this.isDecoding) {
            LogWriter.writeLog("[PDF]WARNING - this file is being decoded already");
        } else {
            if (pdfObject == null) {
                String currentPageOffset = this.currentPdfFile.getReferenceforPage(pageNumber);
                pdfObject = new PageObject(currentPageOffset);
                this.currentPdfFile.readObject(pdfObject);
            } else {
                pageNumber = this.currentPdfFile.convertObjectToPageNumber(new String(pdfObject.getUnresolvedData()));
                this.currentPdfFile.checkResolved(pdfObject);
            }
            try {
                this.isDecoding = true;
                ObjectStore objectStoreRef = new ObjectStore();
                PdfStreamDecoder current = new PdfStreamDecoder(this.currentPdfFile, false, this.layers);
                current.setParameters(true, false, 0, 7, false, false);
                current.setXMLExtraction(false);
                current.setObjectValue(-9, "markedContent");
                current.setObjectValue(-8, objectStoreRef);
                current.setObjectValue(-3, null);
                current.setObjectValue(-18, this.pdfPageData);
                current.setIntValue(-10, pageNumber);
                current.setRenderer(new SwingDisplay(pageNumber, objectStoreRef, false));
                this.res.setupResources(current, false, pdfObject.getDictionary(2004251818), pageNumber, this.currentPdfFile);
                current.setObjectValue(-5, pageStream);
                if (debug) {
                    System.out.println(indent + " about to decode page " + pdfObject.getObjectRefAsString());
                }
                current.decodePageContent(pdfObject);
                objectStoreRef.flush();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            finally {
                this.isDecoding = false;
            }
        }
    }

    static {
        indent = "";
    }
}

