/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.TextState;
import org.jpedal.objects.acroforms.creation.PopupFactory;
import org.jpedal.objects.acroforms.overridingImplementations.ReadOnlyTextIcon;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.image.MaskUtils;
import org.jpedal.render.BaseDisplay;

public class FormFlattener {
    private static FormExclusion exclusionOption = FormExclusion.ExcludeNone;

    public void drawFlattenedForm(PdfStreamDecoder pdfStreamDecoder, PdfObject form, boolean isHTML, PdfObject AcroRes) throws PdfException {
        int pageRotation;
        Rectangle rect;
        String str;
        byte[] formData;
        String defaultState;
        if (exclusionOption != FormExclusion.ExcludeNone && !FormFlattener.showForm(form)) {
            return;
        }
        int type = form.getParameterConstant(1147962727);
        if (type == 1919840408) {
            PopupFactory.renderFlattenedAnnotation(form, pdfStreamDecoder.current, pdfStreamDecoder.parserOptions.getPageNumber(), pdfStreamDecoder.pageData.getRotation(pdfStreamDecoder.parserOptions.getPageNumber()));
            return;
        }
        GraphicsState oldGS = pdfStreamDecoder.gs;
        pdfStreamDecoder.gs = new GraphicsState();
        pdfStreamDecoder.parserOptions.setFlattenedForm(true);
        boolean[] characteristic = ((FormObject)form).getCharacteristics();
        if (characteristic[0] || characteristic[1] || characteristic[5] || !form.getBoolean(524301630) && form.getParameterConstant(1147962727) == 1061176672) {
            return;
        }
        PdfObject imgObj = null;
        PdfObject APobjN = form.getDictionary(4384).getDictionary(30);
        Map otherValues = new HashMap();
        if (APobjN != null) {
            otherValues = APobjN.getOtherDictionaries();
        }
        if ((defaultState = form.getName(4387)) != null && defaultState.equals(((FormObject)form).getNormalOnState())) {
            if (APobjN.getDictionary(7998) != null) {
                imgObj = APobjN.getDictionary(7998);
            } else if (APobjN.getDictionary(2045494) != null && defaultState != null && defaultState.equals("Off")) {
                imgObj = APobjN.getDictionary(2045494);
            } else if (otherValues != null && defaultState != null) {
                imgObj = (PdfObject)otherValues.get(defaultState);
            } else if (otherValues != null && !otherValues.isEmpty()) {
                imgObj = (PdfObject)((Object)otherValues.entrySet().iterator().next());
            }
        } else if (APobjN != null || form.getDictionary(7451).getDictionary(25) != null) {
            if (APobjN != null && APobjN.getDictionary(2045494) != null) {
                imgObj = APobjN.getDictionary(2045494);
            } else if (form.getDictionary(7451).getDictionary(25) != null && form.getDictionary(7451).getDictionary(6422) == null) {
                imgObj = form.getDictionary(7451).getDictionary(25);
            } else if (APobjN != null && APobjN.getDecodedStream() != null) {
                imgObj = APobjN;
            }
        }
        if (imgObj != null && (formData = imgObj.getDecodedStream()) != null && (str = new String(formData)).contains("BMC") && !str.contains("BT")) {
            imgObj = null;
        }
        byte[] DA = form.getTextStreamValueAsByte(5137);
        if (imgObj == null) {
            String V = form.getTextStreamValue(38);
            if (V == null && type == 980909433) {
                V = form.getTextStreamValue(1216184967);
            }
            if (DA != null || V != null && !V.isEmpty()) {
                ReadOnlyTextIcon textIcon = new ReadOnlyTextIcon(form, 0, pdfStreamDecoder.currentPdfFile, AcroRes);
                textIcon.decipherAppObject((FormObject)form);
                if (V != null) {
                    textIcon.setText(V);
                    imgObj = textIcon.getFakeObject();
                } else if (DA != null) {
                    imgObj = textIcon.getFakeObject();
                    imgObj.setDecodedStream(DA);
                }
            }
            if (imgObj == null && DA == null) {
                if (type == 607471684) {
                    PopupFactory.renderFlattenedAnnotation(form, pdfStreamDecoder.current, pdfStreamDecoder.parserOptions.getPageNumber(), pdfStreamDecoder.pageData.getRotation(pdfStreamDecoder.parserOptions.getPageNumber()));
                }
                return;
            }
        }
        if (imgObj != null) {
            pdfStreamDecoder.currentPdfFile.checkResolved(imgObj);
        }
        byte[] formData2 = null;
        if (imgObj != null) {
            formData2 = imgObj.getDecodedStream();
        }
        if (imgObj != null) {
            PdfObject resources = imgObj.getDictionary(2004251818);
            pdfStreamDecoder.readResources(resources, false);
        }
        float[] BBox = form.getFloatArray(573911876);
        if (imgObj != null && imgObj.getObjectType() == 129 && (rect = ((FormObject)form).getBoundingRectangle()) != null) {
            BBox = new float[]{rect.x, rect.y, rect.width, rect.height};
        }
        if (BBox == null) {
            BBox = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
        }
        if ((pageRotation = pdfStreamDecoder.pageData.getRotation(pdfStreamDecoder.parserOptions.getPageNumber())) == 0) {
            float t;
            if (BBox[1] > BBox[3]) {
                t = BBox[1];
                BBox[1] = BBox[3];
                BBox[3] = t;
            }
            if (BBox[0] > BBox[2]) {
                t = BBox[0];
                BBox[0] = BBox[2];
                BBox[2] = t;
            }
        }
        if (pdfStreamDecoder.parserOptions.isFlattenedForm()) {
            pdfStreamDecoder.parserOptions.setOffsets(BBox[0], BBox[1]);
        }
        float[] matrix = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        if (imgObj != null) {
            matrix = imgObj.getFloatArray(1145198201);
        }
        float x = BBox[0];
        float y = BBox[1];
        Area newClip = null;
        if (matrix != null) {
            float yScale = 1.0f;
            if (imgObj != null && pageRotation == 0 && matrix[4] > 0.0f && matrix[5] > 0.0f) {
                float t;
                float[] BoundingBox = imgObj.getFloatArray(303185736);
                if (BoundingBox[1] > BoundingBox[3]) {
                    t = BoundingBox[1];
                    BoundingBox[1] = BoundingBox[3];
                    BoundingBox[3] = t;
                }
                if (BoundingBox[0] > BoundingBox[2]) {
                    t = BoundingBox[0];
                    BoundingBox[0] = BoundingBox[2];
                    BoundingBox[2] = t;
                }
                matrix[0] = (BBox[2] - BBox[0]) / (BoundingBox[2] - BoundingBox[0]);
                matrix[1] = 0.0f;
                matrix[2] = 0.0f;
                matrix[3] = (BBox[3] - BBox[1]) / (BoundingBox[3] - BoundingBox[1]);
                matrix[4] = BBox[0] - BoundingBox[0];
                matrix[5] = BBox[1] - BoundingBox[1];
                pdfStreamDecoder.gs.CTM = new float[][]{{matrix[0], matrix[1], 0.0f}, {matrix[2], matrix[3], 0.0f}, {matrix[4], matrix[5], 1.0f}};
                newClip = new Area(new Rectangle((int)BBox[0], (int)BBox[1], (int)(BBox[2] - BBox[0] + 2.0f), (int)(BBox[3] - BBox[1] + 2.0f)));
                x = matrix[4];
                y = matrix[5];
            } else {
                float[] BoundingBox;
                PdfObject temp = form.getDictionary(4384);
                if (temp != null && (temp = temp.getDictionary(30)) != null && (BoundingBox = temp.getFloatArray(303185736)) != null && BBox[0] != BoundingBox[0] && BBox[1] != BoundingBox[1] && BBox[2] != BoundingBox[2] && BBox[3] != BoundingBox[3]) {
                    if (matrix[0] * matrix[3] == 1.0f && matrix[1] * matrix[2] == 0.0f) {
                        float bbh = BBox[3] - BBox[1];
                        float imh = BoundingBox[3] - BoundingBox[1];
                        if ((int)bbh != (int)imh) {
                            yScale = bbh / imh;
                        }
                    } else if (matrix[0] * matrix[3] == 0.0f && matrix[1] * matrix[2] == -1.0f) {
                        float bbh = BBox[2] - BBox[0];
                        switch (pageRotation) {
                            case 90: {
                                bbh = BBox[2] - BBox[0];
                                break;
                            }
                            case 180: {
                                break;
                            }
                            case 270: {
                                bbh = BBox[2] - BBox[0];
                            }
                        }
                        float imh = BoundingBox[3] - BoundingBox[1];
                        if ((int)bbh != (int)imh) {
                            yScale = bbh / imh;
                        }
                    }
                }
                switch (pageRotation) {
                    case 90: {
                        x = BBox[0] < BBox[2] ? BBox[0] + matrix[4] * yScale : BBox[2] + matrix[4] * yScale;
                        if (!(matrix[4] < 0.0f)) break;
                        x = BBox[0] + matrix[4] * yScale;
                        break;
                    }
                    default: {
                        x = BBox[0] + matrix[4] * yScale;
                        newClip = new Area(new Rectangle((int)(BBox[0] - 1.0f), (int)(BBox[1] - 1.0f), (int)(BBox[2] - BBox[0] + 2.0f), (int)(BBox[3] - BBox[1] + 2.0f)));
                    }
                }
                y = BBox[1] + matrix[5] * yScale;
                pdfStreamDecoder.gs.CTM = new float[][]{{matrix[0] * yScale, matrix[1] * yScale, 0.0f}, {matrix[2] * yScale, matrix[3] * yScale, 0.0f}, {x, y, 1.0f}};
            }
        } else {
            pdfStreamDecoder.gs.CTM = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {x, y, 1.0f}};
            newClip = new Area(new Rectangle((int)BBox[0], (int)BBox[1], (int)BBox[2], (int)BBox[3]));
        }
        newClip = BaseDisplay.convertPDFClipToJavaClip(newClip);
        this.drawForm(imgObj, form, pdfStreamDecoder, newClip, isHTML, BBox, x, y, formData2, APobjN, oldGS);
    }

    void drawForm(PdfObject imgObj, PdfObject form, PdfStreamDecoder pdfStreamDecoder, Area newClip, boolean isHTML, float[] BBox, float x, float y, byte[] formData, PdfObject APobjN, GraphicsState oldGS) throws PdfException {
        if (newClip != null) {
            pdfStreamDecoder.gs.updateClip(new Area(newClip));
        }
        pdfStreamDecoder.current.drawClip(pdfStreamDecoder.gs, pdfStreamDecoder.parserOptions.defaultClip, false);
        TextState oldState = pdfStreamDecoder.gs.getTextState();
        pdfStreamDecoder.gs.setTextState(new TextState());
        if (isHTML) {
            int w = (int)(BBox[2] - BBox[0]);
            int h = (int)(BBox[3] - BBox[1]);
            if (w > 0 && h > 0) {
                BufferedImage image = MaskUtils.createTransparentForm(imgObj, 0, w, h, pdfStreamDecoder.currentPdfFile, pdfStreamDecoder.parserOptions, pdfStreamDecoder.formLevel, pdfStreamDecoder.multiplyer);
                pdfStreamDecoder.gs.CTM = new float[][]{{image.getWidth() / 4, 0.0f, 1.0f}, {0.0f, image.getHeight() / 4, 1.0f}, {0.0f, 0.0f, 0.0f}};
                pdfStreamDecoder.gs.x = x;
                pdfStreamDecoder.gs.y = y;
                pdfStreamDecoder.gs.CTM[2][0] = x;
                pdfStreamDecoder.gs.CTM[2][1] = y;
                pdfStreamDecoder.current.drawImage(pdfStreamDecoder.parserOptions.getPageNumber(), image, pdfStreamDecoder.gs, false, form.getObjectRefAsString(), -3);
                if (pdfStreamDecoder.current.getBooleanValue(44)) {
                    pdfStreamDecoder.current.drawImage(pdfStreamDecoder.parserOptions.getPageNumber(), image, pdfStreamDecoder.gs, false, form.getObjectRefAsString(), -2);
                }
            }
        } else if (formData != null) {
            PdfObject res;
            pdfStreamDecoder.BBox = BBox;
            if (APobjN != null && (res = (PdfObject)APobjN.getOtherDictionaries().get("Resources")) != null) {
                pdfStreamDecoder.currentPdfFile.checkResolved(res);
                pdfStreamDecoder.readResources(res, false);
            }
            pdfStreamDecoder.decodeStreamIntoObjects(formData, false);
            pdfStreamDecoder.BBox = null;
        }
        pdfStreamDecoder.gs.updateClip(null);
        pdfStreamDecoder.current.drawClip(pdfStreamDecoder.gs, null, true);
        pdfStreamDecoder.gs = oldGS;
        pdfStreamDecoder.gs.setTextState(oldState);
    }

    private static boolean showForm(PdfObject form) {
        switch (exclusionOption) {
            case ExcludeFormsAndAnnotations: {
                return false;
            }
            case ExcludeAnnotations: {
                if (form.getParameterConstant(608780341) != 1044266837 || form.getNameAsConstant(5668) != -1) break;
                return false;
            }
            case ExcludeForms: {
                if (form.getNameAsConstant(5668) == -1) break;
                return false;
            }
        }
        return true;
    }

    static {
        String value = System.getProperty("org.jpedal.removeForms");
        if (value != null && !value.isEmpty()) {
            exclusionOption = FormExclusion.valueOf(value);
        }
    }

    private static enum FormExclusion {
        ExcludeNone,
        ExcludeForms,
        ExcludeAnnotations,
        ExcludeFormsAndAnnotations;

    }
}

