/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jpedal.display.GUIModes;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.DecoderResults;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.PdfStreamDecoderForSampling;
import org.jpedal.parser.swing.PDFtoImageConvertorSwing;
import org.jpedal.render.DynamicVectorRenderer;

public abstract class PDFtoImageConvertor {
    private final Integer instance_bestQualityMaxScaling;
    final Boolean instance_allowPagesSmallerThanPageSize;
    final DecoderOptions options;
    public float multiplyer = 1.0f;
    public static Boolean allowPagesSmallerThanPageSize = Boolean.FALSE;
    public static Integer bestQualityMaxScaling;
    public DynamicVectorRenderer imageDisplay;
    public AffineTransform imageScaling;
    public int mediaH;
    public int w;
    public int h;
    public int rotation;
    public float crw;
    public float crh;
    public float crx;
    public float cry;
    public boolean rotated;
    protected boolean isFX;

    public PDFtoImageConvertor(float multiplyer, DecoderOptions options) {
        this.multiplyer = multiplyer;
        this.instance_allowPagesSmallerThanPageSize = options.getInstance_allowPagesSmallerThanPageSize();
        this.instance_bestQualityMaxScaling = options.getInstance_bestQualityMaxScaling();
        this.options = options;
    }

    public BufferedImage convert(DecoderResults resultsFromDecode, int displayRotation, PdfResources res, ExternalHandlers externalHandlers, int renderMode, PdfPageData pageData, AcroRenderer formRenderer, float scaling, PdfObjectReader currentPdfFile, int pageIndex, boolean imageIsTransparent, String currentPageOffset) throws PdfException {
        ObjectStore localStore = new ObjectStore();
        PageObject pdfObject = new PageObject(currentPageOffset);
        currentPdfFile.readObject(pdfObject);
        currentPdfFile.checkParentForResources(pdfObject);
        pdfObject.setPageNumber(pageIndex);
        PdfObject Resources = ((PdfObject)pdfObject).getDictionary(2004251818);
        this.imageDisplay = this.getDisplay(pageIndex, localStore, imageIsTransparent);
        if (!this.imageDisplay.isHTMLorSVG()) {
            if (this.options.getPageColor() != null) {
                this.imageDisplay.setValue(1, this.options.getPageColor().getRGB());
            }
            if (this.options.getTextColor() != null) {
                this.imageDisplay.setValue(2, this.options.getTextColor().getRGB());
                if (this.options.getChangeTextAndLine()) {
                    this.imageDisplay.setValue(3, 1);
                } else {
                    this.imageDisplay.setValue(3, 0);
                }
                this.imageDisplay.setValue(4, this.options.getReplacementColorThreshold());
            }
            if (this.options.isEnhanceFractionalLines()) {
                this.imageDisplay.setValue(5, 1);
            } else {
                this.imageDisplay.setValue(5, 0);
            }
        } else {
            this.imageDisplay.setValue(5, 0);
        }
        PdfStreamDecoder currentImageDecoder = formRenderer.getStreamDecoder(currentPdfFile, true, null, true);
        currentImageDecoder.setParameters(true, true, renderMode, 1, false, externalHandlers.getMode().equals((Object)GUIModes.JAVAFX));
        externalHandlers.addHandlers(currentImageDecoder);
        currentImageDecoder.setObjectValue(-8, localStore);
        currentImageDecoder.setMultiplyer(this.multiplyer);
        currentImageDecoder.setObjectValue(-18, pageData);
        currentImageDecoder.setIntValue(-10, pageIndex);
        currentImageDecoder.setRenderer(this.imageDisplay);
        externalHandlers.addHandlers(currentImageDecoder);
        res.setupResources(currentImageDecoder, true, Resources, pageIndex, currentPdfFile);
        if (this.multiplyer == -2.0f) {
            this.multiplyer = -1.0f;
            currentImageDecoder.setMultiplyer(this.multiplyer);
            PdfStreamDecoderForSampling currentImageDecoder2 = new PdfStreamDecoderForSampling(currentPdfFile);
            currentImageDecoder2.setParameters(true, true, renderMode, 0, false, externalHandlers.getMode().equals((Object)GUIModes.JAVAFX));
            currentImageDecoder2.setObjectValue(-8, localStore);
            currentImageDecoder2.setMultiplyer(this.multiplyer);
            currentImageDecoder2.setObjectValue(-18, pageData);
            currentImageDecoder2.setIntValue(-10, pageIndex);
            currentImageDecoder2.setRenderer(this.imageDisplay);
            res.setupResources(currentImageDecoder2, true, Resources, pageIndex, currentPdfFile);
            externalHandlers.addHandlers(currentImageDecoder2);
            this.multiplyer = currentImageDecoder2.decodePageContentForImageSampling(pdfObject);
            int bestQualityMaxScalingToUse = 0;
            if (this.instance_bestQualityMaxScaling != null) {
                bestQualityMaxScalingToUse = this.instance_bestQualityMaxScaling;
            } else if (bestQualityMaxScaling != null) {
                bestQualityMaxScalingToUse = bestQualityMaxScaling;
            }
            if (bestQualityMaxScalingToUse > 0 && this.multiplyer > (float)bestQualityMaxScalingToUse) {
                this.multiplyer = bestQualityMaxScalingToUse;
            }
            currentImageDecoder2.setMultiplyer(this.multiplyer);
            currentImageDecoder.setMultiplyer(this.multiplyer);
        }
        if (!allowPagesSmallerThanPageSize.booleanValue() && !this.instance_allowPagesSmallerThanPageSize.booleanValue() && this.multiplyer < 1.0f && this.multiplyer > 0.0f) {
            this.multiplyer = 1.0f;
        }
        if (this.multiplyer == -1.0f) {
            this.multiplyer = 1.0f;
        }
        this.imageScaling = PDFtoImageConvertorSwing.setPageParametersForImage(scaling * this.multiplyer, pageIndex, pageData);
        this.setParams(scaling, pageData, pageIndex);
        BufferedImage image = this.pageToImage(imageIsTransparent, currentImageDecoder, scaling, pdfObject, formRenderer);
        resultsFromDecode.update(currentImageDecoder, false);
        if (formRenderer != null && formRenderer.hasFormsOnPage(pageIndex) && !formRenderer.ignoreForms()) {
            resultsFromDecode.resetColorSpaces();
            if (!formRenderer.getCompData().hasformsOnPageDecoded(pageIndex)) {
                formRenderer.createDisplayComponentsForPage(pageIndex, currentImageDecoder);
            }
            if (!this.isFX) {
                if (!formRenderer.getCompData().formsRasterizedForDisplay()) {
                    if (!formRenderer.useXFA()) {
                        List[] formsOrdered = formRenderer.getCompData().getFormList(true);
                        for (Object nextVal : formsOrdered[pageIndex]) {
                            if (nextVal == null) continue;
                            formRenderer.getFormFlattener().drawFlattenedForm(currentImageDecoder, (FormObject)nextVal, false, (PdfObject)formRenderer.getFormResources()[0]);
                        }
                    } else {
                        formRenderer.getCompData().renderFormsOntoG2(image.getGraphics(), pageIndex, 0, displayRotation, null, null, pageData.getMediaBoxHeight(pageIndex));
                    }
                } else {
                    List[] formsOrdered = formRenderer.getCompData().getFormList(true);
                    for (Object nextVal : formsOrdered[pageIndex]) {
                        if (nextVal == null) continue;
                        formRenderer.getFormFlattener().drawFlattenedForm(currentImageDecoder, (FormObject)nextVal, false, (PdfObject)formRenderer.getFormResources()[0]);
                    }
                }
            }
        }
        if (currentImageDecoder != null) {
            currentImageDecoder.dispose();
        }
        localStore.flush();
        return image;
    }

    public float getMultiplyer() {
        return this.multiplyer;
    }

    public DynamicVectorRenderer getDisplay(int pageIndex, ObjectStore localStore, boolean isTransparent) {
        throw new UnsupportedOperationException(this + " Code should never be called ");
    }

    public BufferedImage pageToImage(boolean imageIsTransparent, PdfStreamDecoder currentImageDecoder, float scaling, PdfObject pdfObject, AcroRenderer formRenderer) throws PdfException {
        throw new UnsupportedOperationException(this + " Code should never be called ");
    }

    public void setParams(float scaling, PdfPageData pageData, int pageIndex) {
        this.mediaH = (int)(scaling * (float)pageData.getMediaBoxHeight(pageIndex));
        this.rotation = pageData.getRotation(pageIndex);
        this.crw = scaling * pageData.getCropBoxWidth2D(pageIndex);
        this.crh = scaling * pageData.getCropBoxHeight2D(pageIndex);
        this.crx = scaling * (float)pageData.getCropBoxX(pageIndex);
        this.cry = scaling * (float)pageData.getCropBoxY(pageIndex);
        if (this.rotation == 90 || this.rotation == 270) {
            this.h = (int)(this.crw * this.multiplyer);
            this.w = (int)(this.crh * this.multiplyer);
            this.rotated = true;
        } else {
            this.w = (int)(this.crw * this.multiplyer);
            this.h = (int)(this.crh * this.multiplyer);
        }
    }
}

